/*
 * Decompiled with CFR 0.152.
 */
package org.thshsh.vaadin;

import com.vaadin.flow.component.BlurNotifier;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.FocusNotifier;
import com.vaadin.flow.component.HasComponents;
import com.vaadin.flow.component.HasStyle;
import com.vaadin.flow.component.orderedlayout.HorizontalLayout;
import com.vaadin.flow.component.orderedlayout.VerticalLayout;
import java.io.Serializable;
import java.util.LinkedList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NestedOrderedLayout<T extends Component>
extends VerticalLayout {
    public static final Logger LOGGER = LoggerFactory.getLogger(NestedOrderedLayout.class);
    LinkedList<T> hierarchy = new LinkedList();
    T currentLayout;

    public NestedOrderedLayout() {
        this.hierarchy.add((T)((Object)this));
        this.currentLayout = this;
    }

    public void addLayout(T layout) {
        this.hierarchy.add(layout);
        ((HasComponents)this.currentLayout).add(new Component[]{layout});
        this.currentLayout = layout;
    }

    public void poll() {
        this.hierarchy.pollLast();
        this.currentLayout = (Component)this.hierarchy.getLast();
    }

    public HorizontalLayout startHorizontalLayout() {
        HorizontalLayout newLayout = this.createHorizontalLayout();
        this.addLayout(newLayout);
        return newLayout;
    }

    public VerticalLayout startVerticalLayout() {
        VerticalLayout newLayout = this.createVerticalLayout();
        this.addLayout(newLayout);
        return newLayout;
    }

    public HorizontalLayout createHorizontalLayout() {
        HorizontalLayout newLayout = new HorizontalLayout();
        newLayout.setMargin(false);
        return newLayout;
    }

    public VerticalLayout createVerticalLayout() {
        VerticalLayout newLayout = new VerticalLayout();
        newLayout.setMargin(false);
        return newLayout;
    }

    public void endLayout() {
        this.poll();
    }

    public void add(Component ... cs) {
        for (Component c : cs) {
            this.add(c);
        }
    }

    public void add(Component c) {
        FocusNotifier fn;
        if (this.currentLayout == this) {
            super.add(new Component[]{c});
        } else {
            ((HasComponents)this.currentLayout).add(new Component[]{c});
        }
        if (c instanceof FocusNotifier && c instanceof HasStyle) {
            fn = (FocusNotifier)c;
            fn.addFocusListener((ComponentEventListener & Serializable)focus -> ((HasStyle)c).addClassName("focus"));
        }
        if (c instanceof BlurNotifier && c instanceof HasStyle) {
            fn = (BlurNotifier)c;
            fn.addBlurListener((ComponentEventListener & Serializable)blur -> ((HasStyle)c).removeClassName("focus"));
        }
    }
}

