/*
 * Decompiled with CFR 0.152.
 */
package org.thshsh.vaadin;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.HasElement;
import com.vaadin.flow.component.UI;
import com.vaadin.flow.dom.DomEventListener;
import java.io.Serializable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UIUtils {
    public static final Logger LOGGER = LoggerFactory.getLogger(UIUtils.class);

    public static <T> T getFirstComponent(Component parent, Class<T> c) {
        return parent.getChildren().filter(component -> {
            LOGGER.info("component: {}", component);
            return c.isAssignableFrom(component.getClass());
        }).findFirst().orElse(null);
    }

    public static <T> T getFirstComponent(Class<T> c) {
        return UI.getCurrent().getChildren().filter(component -> {
            LOGGER.info("component: {}", component);
            return c.isAssignableFrom(component.getClass());
        }).findFirst().orElse(null);
    }

    public static void setTitle(HasElement he, String text) {
        UIUtils.setElementProperty(he, "title", text);
    }

    public static void setElementProperty(HasElement he, String prop, String text) {
        he.getElement().setProperty(prop, text);
    }

    public static void stopEventPropagation(HasElement he, String event) {
        he.getElement().addEventListener(event, (DomEventListener & Serializable)click -> {}).addEventData("event.stopPropagation()");
    }
}

