/*
 * Decompiled with CFR 0.152.
 */
package org.thshsh.vaadin;

import com.google.common.primitives.Ints;
import com.vaadin.flow.data.provider.BackEndDataProvider;
import com.vaadin.flow.data.provider.CallbackDataProvider;
import com.vaadin.flow.data.provider.ConfigurableFilterDataProvider;
import com.vaadin.flow.data.provider.DataProvider;
import com.vaadin.flow.data.provider.DataProviderListener;
import com.vaadin.flow.data.provider.Query;
import com.vaadin.flow.data.provider.QuerySortOrder;
import com.vaadin.flow.function.SerializableBiFunction;
import com.vaadin.flow.function.SerializableFunction;
import com.vaadin.flow.shared.Registration;
import java.io.Serializable;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.repository.PagingAndSortingRepository;
import org.thshsh.vaadin.ChunkRequest;
import org.thshsh.vaadin.ExampleFilterDataProvider;
import org.thshsh.vaadin.StringSearchRepository;

public class StringSearchDataProvider<T, ID extends Serializable>
implements ConfigurableFilterDataProvider<T, String, String>,
BackEndDataProvider<T, String> {
    public static final Logger LOGGER = LoggerFactory.getLogger(ExampleFilterDataProvider.class);
    private PagingAndSortingRepository<T, ID> repository;
    private List<QuerySortOrder> defaultSort;
    private ConfigurableFilterDataProvider<T, String, String> delegate;
    protected Function<Pageable, Page<T>> findAllFunction;
    protected BiFunction<String, Pageable, Page<T>> findFilteredFunction;
    protected Supplier<Long> countAllFunction;
    protected Function<String, Long> countFilteredFunction;

    public StringSearchDataProvider(PagingAndSortingRepository<T, ID> r, List<QuerySortOrder> defaultSort) {
        this.repository = r;
        this.defaultSort = defaultSort;
        this.delegate = this.buildDataProvider();
        this.findAllFunction = arg_0 -> this.repository.findAll(arg_0);
        this.countAllFunction = () -> this.repository.count();
        if (this.repository instanceof StringSearchRepository) {
            StringSearchRepository ssr = (StringSearchRepository)this.repository;
            this.findFilteredFunction = ssr::findByStringSearch;
            this.countFilteredFunction = ssr::countByStringSearch;
        }
    }

    private ConfigurableFilterDataProvider<T, String, String> buildDataProvider() {
        CallbackDataProvider dataProvider = DataProvider.fromFilteringCallbacks((CallbackDataProvider.FetchCallback & Serializable)q -> q.getFilter().map(filter -> this.findFilteredFunction.apply((String)filter, ChunkRequest.of(q, this.defaultSort)).getContent()).orElseGet(() -> this.findAllFunction.apply(ChunkRequest.of(q, this.defaultSort)).getContent()).stream(), (CallbackDataProvider.CountCallback & Serializable)q -> Ints.checkedCast((long)q.getFilter().map(document -> this.countFilteredFunction.apply((String)document)).orElseGet(this.countAllFunction)));
        return dataProvider.withConfigurableFilter((SerializableBiFunction & Serializable)(q, c) -> c);
    }

    public Long countAll() {
        return this.countAllFunction.get();
    }

    public void setFilter(String filter) {
        this.delegate.setFilter((Object)filter);
    }

    public boolean isInMemory() {
        return this.delegate.isInMemory();
    }

    public int size(Query<T, String> query) {
        return this.delegate.size(query);
    }

    public Stream<T> fetch(Query<T, String> query) {
        return this.delegate.fetch(query);
    }

    public void refreshItem(T item) {
        this.delegate.refreshItem(item);
    }

    public void refreshAll() {
        this.delegate.refreshAll();
    }

    public Object getId(T item) {
        return this.delegate.getId(item);
    }

    public Registration addDataProviderListener(DataProviderListener<T> listener) {
        return this.delegate.addDataProviderListener(listener);
    }

    public <C> DataProvider<T, C> withConvertedFilter(SerializableFunction<C, String> filterConverter) {
        return this.delegate.withConvertedFilter(filterConverter);
    }

    public <Q, C> ConfigurableFilterDataProvider<T, Q, C> withConfigurableFilter(SerializableBiFunction<Q, C, String> filterCombiner) {
        return this.delegate.withConfigurableFilter(filterCombiner);
    }

    public ConfigurableFilterDataProvider<T, Void, String> withConfigurableFilter() {
        return this.delegate.withConfigurableFilter();
    }

    public void setFindAllFunction(Function<Pageable, Page<T>> findAllFunction) {
        this.findAllFunction = findAllFunction;
    }

    public void setFindFilteredFunction(BiFunction<String, Pageable, Page<T>> findFilteredFunction) {
        this.findFilteredFunction = findFilteredFunction;
    }

    public void setCountAllFunction(Supplier<Long> countAllFunction) {
        this.countAllFunction = countAllFunction;
    }

    public void setCountFilteredFunction(Function<String, Long> countFilteredFunction) {
        this.countFilteredFunction = countFilteredFunction;
    }

    public void setSortOrders(List<QuerySortOrder> sortOrders) {
        throw new IllegalStateException("Not implemented!");
    }
}

