/*
 * Decompiled with CFR 0.152.
 */
package org.thshsh.vaadin;

import com.google.common.base.Preconditions;
import com.vaadin.flow.data.provider.Query;
import com.vaadin.flow.data.provider.QuerySortOrder;
import com.vaadin.flow.data.provider.SortDirection;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;

public class ChunkRequest<T>
implements Pageable {
    public static final Logger LOGGER = LoggerFactory.getLogger(ChunkRequest.class);
    private final Sort sort;
    private int limit = 0;
    private int offset = 0;

    public static <T, F> ChunkRequest<T> of(Query<T, F> q, List<QuerySortOrder> defaultSort) {
        return new ChunkRequest<T>(q.getOffset(), q.getLimit(), ChunkRequest.mapSort(q.getSortOrders(), defaultSort));
    }

    private static Sort mapSort(List<QuerySortOrder> sortOrders, List<QuerySortOrder> defaultSort) {
        if (sortOrders == null || sortOrders.isEmpty()) {
            return Sort.by((Sort.Order[])ChunkRequest.mapSortCriteria(defaultSort));
        }
        return Sort.by((Sort.Order[])ChunkRequest.mapSortCriteria(sortOrders));
    }

    private static Sort.Order[] mapSortCriteria(List<QuerySortOrder> sortOrders) {
        return (Sort.Order[])sortOrders.stream().map(s -> new Sort.Order(s.getDirection() == SortDirection.ASCENDING ? Sort.Direction.ASC : Sort.Direction.DESC, (String)s.getSorted())).toArray(Sort.Order[]::new);
    }

    private ChunkRequest(int offset, int limit, Sort sort) {
        Preconditions.checkArgument((offset >= 0 ? 1 : 0) != 0, (Object)"Offset must not be less than zero!");
        Preconditions.checkArgument((limit > 0 ? 1 : 0) != 0, (Object)"Limit must be greater than zero!");
        this.sort = sort;
        this.offset = offset;
        this.limit = limit;
    }

    public int getPageNumber() {
        return 0;
    }

    public int getPageSize() {
        return this.limit;
    }

    public long getOffset() {
        return this.offset;
    }

    public Sort getSort() {
        return this.sort;
    }

    public Pageable next() {
        return null;
    }

    public Pageable previousOrFirst() {
        return this;
    }

    public Pageable first() {
        return this;
    }

    public boolean hasPrevious() {
        return false;
    }
}

