/*
 * Decompiled with CFR 0.152.
 */
package org.thshsh.vaadin;

import com.google.common.base.Preconditions;
import com.google.common.primitives.Ints;
import com.vaadin.flow.data.provider.BackEndDataProvider;
import com.vaadin.flow.data.provider.CallbackDataProvider;
import com.vaadin.flow.data.provider.ConfigurableFilterDataProvider;
import com.vaadin.flow.data.provider.DataProvider;
import com.vaadin.flow.data.provider.DataProviderListener;
import com.vaadin.flow.data.provider.Query;
import com.vaadin.flow.data.provider.QuerySortOrder;
import com.vaadin.flow.function.SerializableBiFunction;
import com.vaadin.flow.function.SerializableFunction;
import com.vaadin.flow.shared.Registration;
import java.io.Serializable;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.Example;
import org.springframework.data.domain.ExampleMatcher;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.repository.PagingAndSortingRepository;
import org.thshsh.vaadin.ChunkRequest;
import org.thshsh.vaadin.ExampleFilterRepository;

public class ExampleFilterDataProvider<T, ID extends Serializable>
implements ConfigurableFilterDataProvider<T, T, T>,
BackEndDataProvider<T, T> {
    public static final Logger LOGGER = LoggerFactory.getLogger(ExampleFilterDataProvider.class);
    private ExampleFilterRepository<T, ID> repository;
    private ExampleMatcher matcher;
    private List<QuerySortOrder> defaultSort;
    private ConfigurableFilterDataProvider<T, T, T> delegate;
    protected Function<Pageable, Page<T>> findAllFunction;
    protected BiFunction<Example<T>, Pageable, Page<T>> findFilteredFunction;
    protected Supplier<Long> countAllFunction;
    protected Function<Example<T>, Long> countFilteredFunction;

    public ExampleFilterDataProvider(ExampleFilterRepository<T, ID> r, ExampleMatcher matcher, List<QuerySortOrder> defaultSort) {
        Preconditions.checkNotNull(defaultSort);
        Preconditions.checkArgument((defaultSort.size() > 0 ? 1 : 0) != 0, (Object)"At least one sort property must be specified!");
        this.repository = r;
        this.matcher = matcher;
        this.defaultSort = defaultSort;
        this.delegate = this.buildDataProvider();
        this.findAllFunction = arg_0 -> this.repository.findAll(arg_0);
        this.countAllFunction = () -> this.repository.count();
        this.findFilteredFunction = (arg_0, arg_1) -> this.repository.findAll(arg_0, arg_1);
        this.countFilteredFunction = arg_0 -> this.repository.count(arg_0);
    }

    private ConfigurableFilterDataProvider<T, T, T> buildDataProvider() {
        CallbackDataProvider dataProvider = DataProvider.fromFilteringCallbacks((CallbackDataProvider.FetchCallback & Serializable)q -> q.getFilter().map(filter -> this.findFilteredFunction.apply(this.buildExample(filter), ChunkRequest.of(q, this.defaultSort)).getContent()).orElseGet(() -> this.findAllFunction.apply(ChunkRequest.of(q, this.defaultSort)).getContent()).stream(), (CallbackDataProvider.CountCallback & Serializable)q -> Ints.checkedCast((long)q.getFilter().map(filter -> this.countFilteredFunction.apply(this.buildExample(filter))).orElseGet(this.countAllFunction)));
        return dataProvider.withConfigurableFilter((SerializableBiFunction & Serializable)(q, c) -> c);
    }

    protected Example<T> buildExample(T probe) {
        return Example.of(probe, (ExampleMatcher)this.matcher);
    }

    public void setFilter(T filter) {
        this.delegate.setFilter(filter);
    }

    public boolean isInMemory() {
        return this.delegate.isInMemory();
    }

    public int size(Query<T, T> query) {
        return this.delegate.size(query);
    }

    public Stream<T> fetch(Query<T, T> query) {
        return this.delegate.fetch(query);
    }

    public void refreshItem(T item) {
        this.delegate.refreshItem(item);
    }

    public void refreshAll() {
        this.delegate.refreshAll();
    }

    public Object getId(T item) {
        return this.delegate.getId(item);
    }

    public Registration addDataProviderListener(DataProviderListener<T> listener) {
        return this.delegate.addDataProviderListener(listener);
    }

    public <C> DataProvider<T, C> withConvertedFilter(SerializableFunction<C, T> filterConverter) {
        return this.delegate.withConvertedFilter(filterConverter);
    }

    public <Q, C> ConfigurableFilterDataProvider<T, Q, C> withConfigurableFilter(SerializableBiFunction<Q, C, T> filterCombiner) {
        return this.delegate.withConfigurableFilter(filterCombiner);
    }

    public ConfigurableFilterDataProvider<T, Void, T> withConfigurableFilter() {
        return this.delegate.withConfigurableFilter();
    }

    public void setSortOrders(List<QuerySortOrder> sortOrders) {
        throw new IllegalStateException("Not implemented!");
    }

    public static interface Finder<T, ID> {
        public Page<T> find(PagingAndSortingRepository<T, ID> var1, Example<T> var2, Pageable var3);

        public Page<T> find(PagingAndSortingRepository<T, ID> var1, Pageable var2);

        public Long count(PagingAndSortingRepository<T, ID> var1, Example<T> var2);
    }
}

