<?xml version="1.0" encoding="ISO-8859-1"?>
<xsl:stylesheet version="2.0" 
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
	xmlns:mdsol="http://www.mdsol.com/ns/odm/metadata"
	xmlns:odm="http://www.cdisc.org/ns/odm/v1.3" 
	xmlns:subject="http://www.cdisc.org/ns/odm/v1.3/subject"
	xmlns:query="http://www.cdisc.org/ns/odm/v1.3/query"
	xmlns:status="http://www.cdisc.org/ns/odm/v1.3/status"
	xmlns:review="http://www.cdisc.org/ns/odm/v1.3/review"  
	xmlns="http://www.cdisc.org/ns/odm/v1.3">


	<!-- copy all nodes -->
	<xsl:template match="@*|node()">
		<xsl:copy>
			<xsl:apply-templates select="@*|node()" />
		</xsl:copy>
	</xsl:template>

	<xsl:template match="/*">
		<xsl:copy>
            <!-- Add namespace to prevent redeclaration on every child element using it -->
			<xsl:namespace name="subject" select="'http://www.cdisc.org/ns/odm/v1.3/subject'" />
			<xsl:namespace name="query" select="'http://www.cdisc.org/ns/odm/v1.3/query'" />
			<xsl:namespace name="status" select="'http://www.cdisc.org/ns/odm/v1.3/status'" />
			<xsl:namespace name="review" select="'http://www.cdisc.org/ns/odm/v1.3/review'" />
			<xsl:namespace name="odm" select="'http://www.cdisc.org/ns/odm/v1.3'" />

			<xsl:if test="odm:ClinicalData">
				<xsl:attribute name="Granularity">AllClinicalData</xsl:attribute>
			</xsl:if>

			<xsl:if test="odm:AdminData">
				<xsl:attribute name="Granularity">AdminData</xsl:attribute>
			</xsl:if>

			<xsl:if test="not(exists(odm:AdminData)) and not(exists(odm:Study))">
				<xsl:attribute name="Granularity">AllClinicalData</xsl:attribute>
			</xsl:if>
			
            <!-- Copy attributes and child elements -->
			<xsl:apply-templates select="@*|node()" />
		</xsl:copy>

	</xsl:template>
	
	<!-- Add schema prefixes -->
	
	<!-- <xsl:template match="ODM">
		<xsl:attribute name="xmlns:subject">http://www.cdisc.org/ns/odm/v1.3/subject
      		<xsl:value-of select="{http://www.cdisc.org/ns/odm/v1.3/subject}" />
   		</xsl:attribute>
	</xsl:template>
	 -->
	<!-- Metadata stuff -->
	
	<!-- Order number is part of the 1.3.2 standard -->
	<xsl:template match="odm:CodeListItem/@mdsol:OrderNumber">
		<xsl:attribute name="OrderNumber">
      		<xsl:value-of select="." />
   		</xsl:attribute>
	</xsl:template>
	
	<!-- remove empty study event refs -->
	
	<xsl:template match="odm:StudyEventRef">
		<xsl:if test="@StudyEventOID != ''">
			<StudyEventRef>
				<xsl:apply-templates select="@*" />
			</StudyEventRef>
		</xsl:if>
	</xsl:template>
	
	<!-- Remove empty measurement unit refs -->
	
	<xsl:template match="odm:MeasurementUnitRef">
		<xsl:if test="@MeasurementUnitOID != ''">
			<MeasurementUnitRef>
				<xsl:apply-templates select="@*" />
			</MeasurementUnitRef>
		</xsl:if>
	</xsl:template>
	
	
	<!-- always add common SUBJECT study event def if it does not exist -->

	<xsl:template match="odm:MetaDataVersion">
		<MetaDataVersion>
			<!-- copy all attributes from MetaDataVersion -->
			<xsl:apply-templates select="@*" />

			<!-- use OID as order number -->
			<xsl:attribute name="OrderNumber" select="@OID" />

			<xsl:choose>
				<xsl:when test="odm:StudyEventDef[@OID = 'SUBJECT']">
					<!-- already exists, just copy everthing -->
					<xsl:apply-templates select="odm:Protocol" />
					<xsl:call-template name="copy-refs" />
					<xsl:apply-templates select="* except odm:Protocol" />
				</xsl:when>
				<xsl:otherwise>

					<xsl:apply-templates select="odm:Protocol" />
					
					<StudyEventDef OID="SUBJECT" Name="Subject" Type="Common" Repeating="No">
					</StudyEventDef>
					<xsl:call-template name="copy-refs" />
					<xsl:apply-templates select="* except odm:Protocol" />

				</xsl:otherwise>
			</xsl:choose>
		</MetaDataVersion>
	</xsl:template>  

	<!-- Turns rave matrices refs into real study defs, called under the template above , dont copy empty refs -->

	<xsl:template name="copy-refs">
		<xsl:for-each select="odm:Protocol/odm:StudyEventRef[@mdsol:StudyEventDefName]">
			<xsl:if test="@StudyEventOID != ''">
				<StudyEventDef>
				<xsl:attribute name="OID" select="@StudyEventOID" />
				<xsl:attribute name="Name" select="@mdsol:StudyEventDefName" />
				<xsl:attribute name="Type" select="@mdsol:StudyEventDefType" />
				<xsl:attribute name="Repeating" select="@mdsol:StudyEventDefRepeating" />
				</StudyEventDef>
			</xsl:if>
		</xsl:for-each>
	</xsl:template>

	
	<!-- Clinical data -->

	<!-- split subject number out from subject name combined string -->
	<xsl:template match="odm:SubjectData/@mdsol:SubjectName">
	
		<xsl:variable name="token" select="." />

		<xsl:variable name="tokens" select="tokenize($token, ' ')" />
	
		<xsl:attribute name="SubjectName">
      		<xsl:value-of select="." />
   		</xsl:attribute>

   		<xsl:choose>
   			<xsl:when test="count($tokens) &gt; 1">
   				<xsl:attribute name="SubjectNumber">
      				<xsl:value-of select="$tokens[1]" />
   				</xsl:attribute>
   			</xsl:when>
   			<xsl:otherwise>
   				<xsl:attribute name="SubjectNumber">
      				<xsl:value-of select="." />
   				</xsl:attribute>
   			</xsl:otherwise>
   		</xsl:choose>

   		
	</xsl:template>
	
	<!-- if we need to modify the event repeat key -->
	<xsl:template match="odm:StudyEventData/@odm:StudyEventRepeatKey">
	</xsl:template>
	
	<!-- 
	<mdsol:Query  QueryRepeatKey="13786"   Value="Future date has been entered.  Please correct." Status="Open" Recipient="Site from System"/>
	 -->

	<xsl:template match="mdsol:Query">
		<query:QueryData>


			<xsl:attribute name="QueryKey">
				<xsl:value-of select="@QueryRepeatKey" />
			</xsl:attribute>
			<xsl:attribute name="Text">
				<xsl:value-of select="@Value" />
			</xsl:attribute>

			<xsl:attribute name="Status">
				<xsl:choose>
					<xsl:when test="@Status = 'Forwarded'">Open</xsl:when>
					<xsl:otherwise>
						<xsl:value-of select="@Status" />
					</xsl:otherwise>
				</xsl:choose>
			</xsl:attribute>

			<xsl:attribute name="Recipient" select="@Recipient" />

			<xsl:attribute name="Response" select="@Response" />

		</query:QueryData>
	</xsl:template>

	<!-- Use source id as order -->

	<xsl:template match="odm:AuditRecord">
		<AuditRecord OrderNumber="{odm:SourceID}">
			<xsl:attribute name="SourceType">
				<xsl:value-of select="./ancestor::odm:ClinicalData/@mdsol:AuditSubCategoryName" />
			</xsl:attribute>
			<xsl:apply-templates select="@*|node()" />
		</AuditRecord>
	</xsl:template>

	<!-- set transaction type to revert on activated status because the "inactivated" status sends a Remove transaction, which sets the value to null -->

	<xsl:template match="odm:ItemData">
		<ItemData>
			<xsl:apply-templates select="@*" />
			<xsl:if test="../../../../../@mdsol:AuditSubCategoryName = 'Activated'">
				<xsl:attribute name="TransactionType">Revert</xsl:attribute>
			</xsl:if>
			<xsl:apply-templates select="node()" />
			
			<!-- statuses -->
			
			
			  <xsl:element name="status:StatusData" >
				<xsl:if test="@mdsol:Freeze">
					<xsl:attribute name="Frozen" select="@mdsol:Freeze"/>
				</xsl:if>
				<xsl:if test="@mdsol:Verify">
					<xsl:attribute name="Verified" select="@mdsol:Verify"/>
				</xsl:if>
				<xsl:attribute name="Conformant">
					<xsl:choose>
						<xsl:when test="contains(../../../../../@mdsol:AuditSubCategoryName, 'NonConformant')">No</xsl:when>
						<xsl:otherwise>Yes</xsl:otherwise>
					</xsl:choose>
				</xsl:attribute> 
			</xsl:element>

		</ItemData>
	</xsl:template>
	
	<!-- 
	move study site number to location , 
	we only grab the first one since it looks like Rave sends a duplicate in each version ref 
	-->
	
	<xsl:template match="odm:Location">
		<Location>
			<xsl:apply-templates select="@*" />
			<xsl:attribute name="Number">
				<xsl:value-of select="./odm:MetaDataVersionRef[1]/@mdsol:StudySiteNumber" />
			</xsl:attribute>
			<xsl:apply-templates select="node()" />
		</Location>
	</xsl:template>
	
	
	<!-- Convert User group names to references -->	
	
	<xsl:template match="/odm:ODM/odm:AdminData/odm:User/mdsol:UserGroups">
		<xsl:for-each select="mdsol:UserGroupName">
		 	<UserGroupRef>
				<xsl:attribute name="UserGroupOID" select="text()"/>
			</UserGroupRef>
		</xsl:for-each>
	</xsl:template>
	
	<!-- combine all group names into a unique list -->

	 <xsl:template match="odm:AdminData">
		<AdminData>
			<xsl:apply-templates select="@*" />
			<xsl:apply-templates select="node()" />
			<xsl:for-each-group
				select="/odm:ODM/odm:AdminData/odm:User/mdsol:UserGroups/mdsol:UserGroupName"
				group-by="text()">
				<UserGroup>
					<xsl:attribute name="OID" select="text()" />
					<xsl:attribute name="Name" select="text()" />
				</UserGroup>
			</xsl:for-each-group>
		</AdminData>
	</xsl:template>

	<!--  convert Reviews into ReviewData -->
	
	<xsl:template match="mdsol:Review">
		<xsl:element name="review:ReviewData" >
			<xsl:attribute name="Reviewed" select="@Reviewed" />
			<xsl:attribute name="UserGroupOID" select="@GroupName" />
		</xsl:element>
	</xsl:template>


	<!-- clean up -->
	
	<!-- remove all mdsol attributes -->
	<xsl:template match="@mdsol:*">
	</xsl:template>
	
	<!-- remove all mdsol tags -->
	<xsl:template match="mdsol:*">
	</xsl:template>


</xsl:stylesheet>