/*
 * Decompiled with CFR 0.152.
 */
package com.mdsol.rave;

import com.mdsol.rave.RaveClientException;
import com.mdsol.rave.RaveClientUnauthorizedException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import net.sf.saxon.TransformerFactoryImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.buffer.DataBuffer;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.reactive.function.client.ClientRequest;
import org.springframework.web.reactive.function.client.ExchangeFilterFunction;
import org.springframework.web.reactive.function.client.WebClient;
import org.springframework.web.util.UriBuilder;
import reactor.core.publisher.Mono;

public class RaveOdmClient {
    protected static Logger LOGGER = LoggerFactory.getLogger(RaveOdmClient.class);
    protected static final String METADATA_VERSION_URI = "RaveWebServices/metadata/studies/{study}/versions/{oid}";
    protected static final String METADATA_MATRIX_URI = "RaveWebServices/datasets/VersionFolders.odm";
    protected static final String METADATA_VERSIONS_URI = "RaveWebServices/metadata/studies/{study}/versions";
    protected static final String SIGNATURES_URI = "RaveWebServices/datasets/Signatures.odm";
    protected static final String SITES_URI = "RaveWebServices/datasets/Sites.odm";
    protected static final String STUDIES_URI = "RaveWebServices/studies/";
    protected static final String CLINICAL_RECORDS_URI = "RaveWebServices/datasets/ClinicalAuditRecords.odm";
    public static final String XSLT_RESOURCE = "transform-mdsol.xsl";
    protected static String linkHeader = "Link";
    protected static String studyOidParameter = "studyoid";
    protected static String studyIdParameter = "studyid";
    protected static String startIdParameter = "startid";
    protected static String locationOidParameter = "LocationOID";
    protected static String pageSizeParameter = "per_page";
    protected static String startIdRegex = "startid=([0-9]+)";
    protected static String studyOidEnvironmentRegex = "\\(.*?\\)\\z";
    protected static Pattern startIdPattern = Pattern.compile(startIdRegex);
    protected Boolean ssl = true;
    protected Transformer transformer;
    protected String encodedCredentials;
    protected String host;
    protected WebClient webClient;

    public void setBasicAuth(String user, String pass) {
        this.encodedCredentials = user != null || pass != null ? HttpHeaders.encodeBasicAuth((String)user, (String)pass, null) : null;
    }

    public WebClient getClient() {
        if (this.webClient == null) {
            WebClient.Builder builder = WebClient.builder();
            ExchangeFilterFunction func = (request, next) -> {
                if (this.encodedCredentials == null) {
                    return next.exchange(request);
                }
                return next.exchange(ClientRequest.from((ClientRequest)request).headers(headers -> headers.setBasicAuth(this.encodedCredentials)).build());
            };
            builder = builder.filter(func);
            this.webClient = builder.codecs(config -> config.defaultCodecs().maxInMemorySize(0xA00000)).build();
        }
        return this.webClient;
    }

    protected UriBuilder setupUriBuilder(UriBuilder builder) {
        builder.scheme(this.ssl != false ? "https" : "http");
        builder.host(this.host);
        return builder;
    }

    public ResponseEntity<DataBuffer> getResponseEntity(WebClient.ResponseSpec spec) {
        Mono mono = spec.onStatus(HttpStatus::isError, response -> {
            if (response.statusCode() == HttpStatus.UNAUTHORIZED) {
                return Mono.error((Throwable)new RaveClientUnauthorizedException(response.statusCode().toString()));
            }
            return Mono.error((Throwable)new RaveClientException(response.statusCode().toString()));
        }).toEntity(DataBuffer.class);
        ResponseEntity db = (ResponseEntity)mono.block();
        return db;
    }

    protected RaveResponse handleResponseSpec(WebClient.ResponseSpec spec, ResponseHandler handler) {
        Long startTime = System.currentTimeMillis();
        ResponseEntity<DataBuffer> response = this.getResponseEntity(spec);
        RaveResponse r = new RaveResponse(response, startTime);
        if (handler != null) {
            handler.handle(r);
        }
        return r;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public RaveResponse getClinicalData(String study, Long startId, Integer pageSize, ResponseHandler handler) {
        LOGGER.info("getClinicalData: {} , {} -> {}", new Object[]{study, startId, pageSize});
        WebClient.ResponseSpec spec = this.getClient().get().uri(urib -> this.setupUriBuilder((UriBuilder)urib).path(CLINICAL_RECORDS_URI).queryParam(studyOidParameter, new Object[]{study}).queryParam(startIdParameter, new Object[]{startId != null ? startId.toString() : Integer.valueOf(0)}).queryParam(pageSizeParameter, new Object[]{pageSize.toString()}).build(new Object[0])).retrieve();
        return this.handleResponseSpec(spec, handler);
    }

    public RaveResponse getStudies(ResponseHandler handler) {
        WebClient.ResponseSpec spec = this.getClient().get().uri(urib -> this.setupUriBuilder((UriBuilder)urib).path(STUDIES_URI).build(new Object[0])).retrieve();
        return this.handleResponseSpec(spec, handler);
    }

    public RaveResponse getSites(String studyOid, ResponseHandler handler) {
        WebClient.ResponseSpec spec = this.getClient().get().uri(urib -> {
            URI uri = this.setupUriBuilder((UriBuilder)urib).path(SITES_URI).queryParam(studyOidParameter, new Object[]{studyOid}).build(new Object[0]);
            return uri;
        }).retrieve();
        return this.handleResponseSpec(spec, handler);
    }

    public RaveResponse getSignatures(String studyOid, ResponseHandler handler) {
        WebClient.ResponseSpec spec = this.getClient().get().uri(urib -> this.setupUriBuilder((UriBuilder)urib).path(SIGNATURES_URI).queryParam(studyIdParameter, new Object[]{studyOid}).build(new Object[0])).retrieve();
        return this.handleResponseSpec(spec, handler);
    }

    public RaveResponse getMetaDataListOdm(String study, ResponseHandler handler) {
        String studyOidNoEnv = RaveOdmClient.removeStudyEnvironment(study);
        WebClient.ResponseSpec spec = this.getClient().get().uri(urib -> this.setupUriBuilder((UriBuilder)urib).path(METADATA_VERSIONS_URI).build(new Object[]{studyOidNoEnv})).retrieve();
        return this.handleResponseSpec(spec, handler);
    }

    public RaveResponse getMetaDataMatricesOdm(String studyOid, ResponseHandler handler) {
        WebClient.ResponseSpec spec = this.getClient().get().uri(urib -> this.setupUriBuilder((UriBuilder)urib).path(METADATA_MATRIX_URI).queryParam(studyOidParameter, new Object[]{studyOid}).build(new Object[0])).retrieve();
        return this.handleResponseSpec(spec, handler);
    }

    public RaveResponse getMetaDataVersionOdm(String study, String oid, ResponseHandler handler) {
        String studyOidNoEnv = RaveOdmClient.removeStudyEnvironment(study);
        WebClient.ResponseSpec spec = this.getClient().get().uri(urib -> this.setupUriBuilder((UriBuilder)urib).path(METADATA_VERSION_URI).build(new Object[]{studyOidNoEnv, oid})).retrieve();
        return this.handleResponseSpec(spec, handler);
    }

    public static String removeStudyEnvironment(String study) {
        return study.replaceAll(studyOidEnvironmentRegex, "");
    }

    public static String makeStudyParameter(String study, String environment) {
        StringBuilder sb = new StringBuilder(study);
        sb.append("(");
        sb.append(environment);
        sb.append(")");
        return sb.toString();
    }

    public void transform(InputStream input, OutputStream output) throws TransformerException {
        StreamSource sourcestream = new StreamSource(input);
        Transformer transformer = this.getTransformer();
        transformer.transform(sourcestream, new StreamResult(output));
    }

    public InputStream transform(InputStream input) {
        try {
            StreamSource sourcestream = new StreamSource(input);
            Transformer transformer = this.getTransformer();
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            transformer.transform(sourcestream, new StreamResult(baos));
            return new ByteArrayInputStream(baos.toByteArray());
        }
        catch (TransformerException e) {
            throw new RaveClientException(e);
        }
    }

    public Transformer getTransformer() {
        if (this.transformer == null) {
            try {
                TransformerFactoryImpl tf = new TransformerFactoryImpl();
                StreamSource stylesource = new StreamSource(RaveOdmClient.class.getResourceAsStream(XSLT_RESOURCE));
                this.transformer = tf.newTransformer(stylesource);
            }
            catch (TransformerConfigurationException e) {
                throw new IllegalStateException(e);
            }
        }
        return this.transformer;
    }

    public class RaveResponse {
        protected ResponseEntity<DataBuffer> response;
        protected Long start;

        public RaveResponse(ResponseEntity<DataBuffer> r, Long start) {
            this.response = r;
            this.start = start;
        }

        public InputStream getStream() {
            return ((DataBuffer)this.response.getBody()).asInputStream();
        }

        public Long getNextPage() {
            String link;
            Matcher m;
            Long next = null;
            if (this.response.getHeaders().containsKey((Object)linkHeader) && (m = startIdPattern.matcher(link = (String)this.response.getHeaders().get((Object)linkHeader).get(0))).find()) {
                next = Long.valueOf(m.group(1));
            }
            return next;
        }

        public Long getStart() {
            return this.start;
        }
    }

    public static interface ResponseHandler {
        public void handle(RaveResponse var1);
    }
}

