/*
 * Decompiled with CFR 0.152.
 */
package org.thshsh.tuples;

import java.util.Arrays;

public abstract class Tuple {
    Object[] objects;

    public Tuple(int length) {
        this.objects = new Object[length];
    }

    public <A extends Tuple> A toTuple(Class<A> clazz) {
        try {
            Tuple tuple = (Tuple)clazz.newInstance();
            Object[] ar = Arrays.copyOf(this.objects, tuple.getLength());
            tuple.set(ar);
            return (A)tuple;
        }
        catch (InstantiationException e) {
            throw new IllegalArgumentException(e);
        }
        catch (IllegalAccessException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public void set(Object ... setObjects) {
        for (int i = 0; i < setObjects.length && i < this.objects.length; ++i) {
            this.objects[i] = setObjects[i];
        }
    }

    public Object get(int i) {
        return this.objects[i];
    }

    public void set(int i, Object o) {
        this.objects[i] = o;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Arrays.hashCode(this.objects);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Tuple other = (Tuple)obj;
        return Arrays.equals(this.objects, other.objects);
    }

    public int getLength() {
        return this.objects.length;
    }

    public String toString() {
        return " [objects=" + Arrays.toString(this.objects) + "]";
    }
}

