/*
 * Decompiled with CFR 0.152.
 */
package org.tinfour.gwr;

import java.io.PrintStream;
import java.util.Arrays;
import org.apache.commons.math3.distribution.TDistribution;
import org.apache.commons.math3.linear.BlockRealMatrix;
import org.apache.commons.math3.linear.DecompositionSolver;
import org.apache.commons.math3.linear.DiagonalMatrix;
import org.apache.commons.math3.linear.QRDecomposition;
import org.apache.commons.math3.linear.RealMatrix;
import org.apache.commons.math3.linear.SingularMatrixException;
import org.tinfour.gwr.SurfaceModel;

public class SurfaceGwr {
    private static final double log2PI = Math.log(Math.PI * 2);
    private double xOffset;
    private double yOffset;
    int nSamples = 0;
    double[][] samples;
    double[] weights;
    double[][] sampleWeightsMatrix;
    double[] residuals;
    int nVariables;
    int nDegOfFreedom;
    double[] beta = new double[0];
    boolean areVarianceAndHatPrepped;
    double sigma2 = Double.NaN;
    double mlSigma2;
    double rss;
    double effectiveDegOfF;
    RealMatrix hat;
    double traceHat;
    double traceHat2;
    double delta1;
    double delta2;
    private SurfaceModel model;

    public double[] computeRegression(SurfaceModel model, double xQuery, double yQuery, int nSamples, double[][] samples, double[] weights, double[][] sampleWeightsMatrix) {
        double xy;
        double xy2;
        double y4;
        double x4;
        double y3;
        double x3;
        double y2;
        double x2;
        double w;
        double z;
        double y;
        double x;
        int i;
        double[][] input;
        double[][] g;
        this.areVarianceAndHatPrepped = false;
        this.model = model;
        this.sigma2 = Double.NaN;
        this.rss = Double.NaN;
        this.beta = null;
        this.hat = null;
        if (nSamples < model.getCoefficientCount()) {
            throw new IllegalArgumentException("Insufficient number of samples for regression: found " + nSamples + ", need " + model.getCoefficientCount());
        }
        this.nSamples = nSamples;
        this.samples = samples;
        this.weights = weights;
        this.sampleWeightsMatrix = sampleWeightsMatrix;
        this.xOffset = xQuery;
        this.yOffset = yQuery;
        if (model == SurfaceModel.CubicWithCrossTerms) {
            this.nVariables = 9;
            g = new double[10][1];
            input = new double[10][10];
            for (i = 0; i < nSamples; ++i) {
                x = samples[i][0] - xQuery;
                y = samples[i][1] - yQuery;
                z = samples[i][2];
                w = weights[i];
                x2 = x * x;
                y2 = y * y;
                x3 = x * x2;
                y3 = y * y2;
                x4 = x2 * x2;
                y4 = y2 * y2;
                xy2 = x * y;
                double[] dArray = input[0];
                dArray[0] = dArray[0] + w;
                double[] dArray2 = input[0];
                dArray2[1] = dArray2[1] + w * x;
                double[] dArray3 = input[0];
                dArray3[2] = dArray3[2] + w * y;
                double[] dArray4 = input[0];
                dArray4[3] = dArray4[3] + w * x2;
                double[] dArray5 = input[0];
                dArray5[4] = dArray5[4] + w * y2;
                double[] dArray6 = input[0];
                dArray6[5] = dArray6[5] + w * xy2;
                double[] dArray7 = input[0];
                dArray7[6] = dArray7[6] + w * x2 * y;
                double[] dArray8 = input[0];
                dArray8[7] = dArray8[7] + w * x * y2;
                double[] dArray9 = input[0];
                dArray9[8] = dArray9[8] + w * x3;
                double[] dArray10 = input[0];
                dArray10[9] = dArray10[9] + w * y3;
                double[] dArray11 = input[1];
                dArray11[1] = dArray11[1] + w * x2;
                double[] dArray12 = input[1];
                dArray12[2] = dArray12[2] + w * xy2;
                double[] dArray13 = input[1];
                dArray13[3] = dArray13[3] + w * x3;
                double[] dArray14 = input[1];
                dArray14[4] = dArray14[4] + w * x * y2;
                double[] dArray15 = input[1];
                dArray15[5] = dArray15[5] + w * x2 * y;
                double[] dArray16 = input[1];
                dArray16[6] = dArray16[6] + w * x * x2 * y;
                double[] dArray17 = input[1];
                dArray17[7] = dArray17[7] + w * x * x * y2;
                double[] dArray18 = input[1];
                dArray18[8] = dArray18[8] + w * x * x3;
                double[] dArray19 = input[1];
                dArray19[9] = dArray19[9] + w * x * y3;
                double[] dArray20 = input[2];
                dArray20[2] = dArray20[2] + w * y2;
                double[] dArray21 = input[2];
                dArray21[3] = dArray21[3] + w * x2 * y;
                double[] dArray22 = input[2];
                dArray22[4] = dArray22[4] + w * y3;
                double[] dArray23 = input[2];
                dArray23[5] = dArray23[5] + w * x * y2;
                double[] dArray24 = input[2];
                dArray24[6] = dArray24[6] + w * y * x2 * y;
                double[] dArray25 = input[2];
                dArray25[7] = dArray25[7] + w * y * x * y2;
                double[] dArray26 = input[2];
                dArray26[8] = dArray26[8] + w * y * x3;
                double[] dArray27 = input[2];
                dArray27[9] = dArray27[9] + w * y * y3;
                double[] dArray28 = input[3];
                dArray28[3] = dArray28[3] + w * x4;
                double[] dArray29 = input[3];
                dArray29[4] = dArray29[4] + w * x2 * y2;
                double[] dArray30 = input[3];
                dArray30[5] = dArray30[5] + w * x3 * y;
                double[] dArray31 = input[3];
                dArray31[6] = dArray31[6] + w * x2 * x2 * y;
                double[] dArray32 = input[3];
                dArray32[7] = dArray32[7] + w * x2 * x * y2;
                double[] dArray33 = input[3];
                dArray33[8] = dArray33[8] + w * x2 * x3;
                double[] dArray34 = input[3];
                dArray34[9] = dArray34[9] + w * x2 * y3;
                double[] dArray35 = input[4];
                dArray35[4] = dArray35[4] + w * y4;
                double[] dArray36 = input[4];
                dArray36[5] = dArray36[5] + w * x * y3;
                double[] dArray37 = input[4];
                dArray37[6] = dArray37[6] + w * y2 * x2 * y;
                double[] dArray38 = input[4];
                dArray38[7] = dArray38[7] + w * y2 * x * y2;
                double[] dArray39 = input[4];
                dArray39[8] = dArray39[8] + w * y2 * x3;
                double[] dArray40 = input[4];
                dArray40[9] = dArray40[9] + w * y2 * y3;
                double[] dArray41 = input[5];
                dArray41[5] = dArray41[5] + w * x2 * y2;
                double[] dArray42 = input[5];
                dArray42[6] = dArray42[6] + w * xy2 * x2 * y;
                double[] dArray43 = input[5];
                dArray43[7] = dArray43[7] + w * xy2 * x * y2;
                double[] dArray44 = input[5];
                dArray44[8] = dArray44[8] + w * xy2 * x3;
                double[] dArray45 = input[5];
                dArray45[9] = dArray45[9] + w * xy2 * y3;
                double[] dArray46 = input[6];
                dArray46[6] = dArray46[6] + w * x2 * y * x2 * y;
                double[] dArray47 = input[6];
                dArray47[7] = dArray47[7] + w * x2 * y * x * y2;
                double[] dArray48 = input[6];
                dArray48[8] = dArray48[8] + w * x2 * y * x3;
                double[] dArray49 = input[6];
                dArray49[9] = dArray49[9] + w * x2 * y * y3;
                double[] dArray50 = input[7];
                dArray50[7] = dArray50[7] + w * y2 * x * x * y2;
                double[] dArray51 = input[7];
                dArray51[8] = dArray51[8] + w * y2 * x * x3;
                double[] dArray52 = input[7];
                dArray52[9] = dArray52[9] + w * y2 * x * y3;
                double[] dArray53 = input[8];
                dArray53[8] = dArray53[8] + w * x3 * x3;
                double[] dArray54 = input[8];
                dArray54[9] = dArray54[9] + w * x3 * y3;
                double[] dArray55 = input[9];
                dArray55[9] = dArray55[9] + w * y3 * y3;
                double[] dArray56 = g[0];
                dArray56[0] = dArray56[0] + w * z;
                double[] dArray57 = g[1];
                dArray57[0] = dArray57[0] + w * x * z;
                double[] dArray58 = g[2];
                dArray58[0] = dArray58[0] + w * y * z;
                double[] dArray59 = g[3];
                dArray59[0] = dArray59[0] + w * x2 * z;
                double[] dArray60 = g[4];
                dArray60[0] = dArray60[0] + w * y2 * z;
                double[] dArray61 = g[5];
                dArray61[0] = dArray61[0] + w * xy2 * z;
                double[] dArray62 = g[6];
                dArray62[0] = dArray62[0] + w * x2 * y * z;
                double[] dArray63 = g[7];
                dArray63[0] = dArray63[0] + w * x * y2 * z;
                double[] dArray64 = g[8];
                dArray64[0] = dArray64[0] + w * x3 * z;
                double[] dArray65 = g[9];
                dArray65[0] = dArray65[0] + w * y3 * z;
            }
            input[1][0] = input[0][1];
            input[2][0] = input[0][2];
            input[2][1] = input[1][2];
            input[3][0] = input[0][3];
            input[3][1] = input[1][3];
            input[3][2] = input[2][3];
            input[4][0] = input[0][4];
            input[4][1] = input[1][4];
            input[4][2] = input[2][4];
            input[4][3] = input[3][4];
            input[5][0] = input[0][5];
            input[5][1] = input[1][5];
            input[5][2] = input[2][5];
            input[5][3] = input[3][5];
            input[5][4] = input[4][5];
            input[6][0] = input[0][6];
            input[6][1] = input[1][6];
            input[6][2] = input[2][6];
            input[6][3] = input[3][6];
            input[6][4] = input[4][6];
            input[6][5] = input[5][6];
            input[7][0] = input[0][7];
            input[7][1] = input[1][7];
            input[7][2] = input[2][7];
            input[7][3] = input[3][7];
            input[7][4] = input[4][7];
            input[7][5] = input[5][7];
            input[7][6] = input[6][7];
            input[8][0] = input[0][8];
            input[8][1] = input[1][8];
            input[8][2] = input[2][8];
            input[8][3] = input[3][8];
            input[8][4] = input[4][8];
            input[8][5] = input[5][8];
            input[8][6] = input[6][8];
            input[8][7] = input[7][8];
            input[9][0] = input[0][9];
            input[9][1] = input[1][9];
            input[9][2] = input[2][9];
            input[9][3] = input[3][9];
            input[9][4] = input[4][9];
            input[9][5] = input[5][9];
            input[9][6] = input[6][9];
            input[9][7] = input[7][9];
            input[9][8] = input[8][9];
        } else if (model == SurfaceModel.QuadraticWithCrossTerms) {
            this.nVariables = 5;
            g = new double[6][1];
            input = new double[6][6];
            for (i = 0; i < nSamples; ++i) {
                x = samples[i][0] - xQuery;
                y = samples[i][1] - yQuery;
                z = samples[i][2];
                w = weights[i];
                x2 = x * x;
                y2 = y * y;
                x3 = x * x2;
                y3 = y * y2;
                x4 = x2 * x2;
                y4 = y2 * y2;
                xy2 = x * y;
                double[] dArray = input[0];
                dArray[0] = dArray[0] + w;
                double[] dArray66 = input[0];
                dArray66[1] = dArray66[1] + w * x;
                double[] dArray67 = input[0];
                dArray67[2] = dArray67[2] + w * y;
                double[] dArray68 = input[0];
                dArray68[3] = dArray68[3] + w * x2;
                double[] dArray69 = input[0];
                dArray69[4] = dArray69[4] + w * y2;
                double[] dArray70 = input[0];
                dArray70[5] = dArray70[5] + w * xy2;
                double[] dArray71 = input[1];
                dArray71[1] = dArray71[1] + w * x2;
                double[] dArray72 = input[1];
                dArray72[2] = dArray72[2] + w * xy2;
                double[] dArray73 = input[1];
                dArray73[3] = dArray73[3] + w * x * x2;
                double[] dArray74 = input[1];
                dArray74[4] = dArray74[4] + w * x * y2;
                double[] dArray75 = input[1];
                dArray75[5] = dArray75[5] + w * x * xy2;
                double[] dArray76 = input[2];
                dArray76[2] = dArray76[2] + w * y2;
                double[] dArray77 = input[2];
                dArray77[3] = dArray77[3] + w * x2 * y;
                double[] dArray78 = input[2];
                dArray78[4] = dArray78[4] + w * y3;
                double[] dArray79 = input[2];
                dArray79[5] = dArray79[5] + w * x * y2;
                double[] dArray80 = input[3];
                dArray80[3] = dArray80[3] + w * x4;
                double[] dArray81 = input[3];
                dArray81[4] = dArray81[4] + w * x2 * y2;
                double[] dArray82 = input[3];
                dArray82[5] = dArray82[5] + w * x3 * y;
                double[] dArray83 = input[4];
                dArray83[4] = dArray83[4] + w * y4;
                double[] dArray84 = input[4];
                dArray84[5] = dArray84[5] + w * x * y3;
                double[] dArray85 = input[5];
                dArray85[5] = dArray85[5] + w * x2 * y2;
                double[] dArray86 = g[0];
                dArray86[0] = dArray86[0] + w * z;
                double[] dArray87 = g[1];
                dArray87[0] = dArray87[0] + w * x * z;
                double[] dArray88 = g[2];
                dArray88[0] = dArray88[0] + w * y * z;
                double[] dArray89 = g[3];
                dArray89[0] = dArray89[0] + w * x2 * z;
                double[] dArray90 = g[4];
                dArray90[0] = dArray90[0] + w * y2 * z;
                double[] dArray91 = g[5];
                dArray91[0] = dArray91[0] + w * xy2 * z;
            }
            input[1][0] = input[0][1];
            input[2][0] = input[0][2];
            input[2][1] = input[1][2];
            input[3][0] = input[0][3];
            input[3][1] = input[1][3];
            input[3][2] = input[2][3];
            input[4][0] = input[0][4];
            input[4][1] = input[1][4];
            input[4][2] = input[2][4];
            input[4][3] = input[3][4];
            input[5][0] = input[0][5];
            input[5][1] = input[1][5];
            input[5][2] = input[2][5];
            input[5][3] = input[3][5];
            input[5][4] = input[4][5];
        } else if (model == SurfaceModel.Quadratic) {
            this.nVariables = 4;
            g = new double[5][1];
            input = new double[5][5];
            for (i = 0; i < nSamples; ++i) {
                x = samples[i][0] - xQuery;
                y = samples[i][1] - yQuery;
                z = samples[i][2];
                w = weights[i];
                x2 = x * x;
                y2 = y * y;
                x3 = x * x2;
                y3 = y * y2;
                x4 = x2 * x2;
                y4 = y2 * y2;
                xy2 = x * y;
                double[] dArray = input[0];
                dArray[0] = dArray[0] + w;
                double[] dArray92 = input[0];
                dArray92[1] = dArray92[1] + w * x;
                double[] dArray93 = input[0];
                dArray93[2] = dArray93[2] + w * y;
                double[] dArray94 = input[0];
                dArray94[3] = dArray94[3] + w * x2;
                double[] dArray95 = input[0];
                dArray95[4] = dArray95[4] + w * y2;
                double[] dArray96 = input[1];
                dArray96[1] = dArray96[1] + w * x2;
                double[] dArray97 = input[1];
                dArray97[2] = dArray97[2] + w * xy2;
                double[] dArray98 = input[1];
                dArray98[3] = dArray98[3] + w * x3;
                double[] dArray99 = input[1];
                dArray99[4] = dArray99[4] + w * x * y2;
                double[] dArray100 = input[2];
                dArray100[2] = dArray100[2] + w * y2;
                double[] dArray101 = input[2];
                dArray101[3] = dArray101[3] + w * x2 * y;
                double[] dArray102 = input[2];
                dArray102[4] = dArray102[4] + w * y3;
                double[] dArray103 = input[3];
                dArray103[3] = dArray103[3] + w * x4;
                double[] dArray104 = input[3];
                dArray104[4] = dArray104[4] + w * x2 * y2;
                double[] dArray105 = input[4];
                dArray105[4] = dArray105[4] + w * y4;
                double[] dArray106 = g[0];
                dArray106[0] = dArray106[0] + w * z;
                double[] dArray107 = g[1];
                dArray107[0] = dArray107[0] + w * x * z;
                double[] dArray108 = g[2];
                dArray108[0] = dArray108[0] + w * y * z;
                double[] dArray109 = g[3];
                dArray109[0] = dArray109[0] + w * x2 * z;
                double[] dArray110 = g[4];
                dArray110[0] = dArray110[0] + w * y2 * z;
            }
            input[1][0] = input[0][1];
            input[2][0] = input[0][2];
            input[2][1] = input[1][2];
            input[3][0] = input[0][3];
            input[3][1] = input[1][3];
            input[3][2] = input[2][3];
            input[4][0] = input[0][4];
            input[4][1] = input[1][4];
            input[4][2] = input[2][4];
            input[4][3] = input[3][4];
        } else if (model == SurfaceModel.Planar) {
            this.nVariables = 2;
            g = new double[3][1];
            input = new double[3][3];
            for (i = 0; i < nSamples; ++i) {
                x = samples[i][0] - xQuery;
                y = samples[i][1] - yQuery;
                z = samples[i][2];
                w = weights[i];
                x2 = x * x;
                y2 = y * y;
                double[] dArray = input[0];
                dArray[0] = dArray[0] + w;
                double[] dArray111 = input[0];
                dArray111[1] = dArray111[1] + w * x;
                double[] dArray112 = input[0];
                dArray112[2] = dArray112[2] + w * y;
                double[] dArray113 = input[1];
                dArray113[1] = dArray113[1] + w * x2;
                double[] dArray114 = input[1];
                dArray114[2] = dArray114[2] + w * x * y;
                double[] dArray115 = input[2];
                dArray115[2] = dArray115[2] + w * y2;
                double[] dArray116 = g[0];
                dArray116[0] = dArray116[0] + w * z;
                double[] dArray117 = g[1];
                dArray117[0] = dArray117[0] + w * x * z;
                double[] dArray118 = g[2];
                dArray118[0] = dArray118[0] + w * y * z;
            }
            input[1][0] = input[0][1];
            input[2][0] = input[0][2];
            input[2][1] = input[1][2];
        } else if (model == SurfaceModel.PlanarWithCrossTerms) {
            this.nVariables = 3;
            g = new double[4][1];
            input = new double[4][4];
            for (i = 0; i < nSamples; ++i) {
                x = samples[i][0] - xQuery;
                y = samples[i][1] - yQuery;
                z = samples[i][2];
                w = weights[i];
                x2 = x * x;
                y2 = y * y;
                xy = x * y;
                double[] dArray = input[0];
                dArray[0] = dArray[0] + w;
                double[] dArray119 = input[0];
                dArray119[1] = dArray119[1] + w * x;
                double[] dArray120 = input[0];
                dArray120[2] = dArray120[2] + w * y;
                double[] dArray121 = input[0];
                dArray121[3] = dArray121[3] + w * xy;
                double[] dArray122 = input[1];
                dArray122[1] = dArray122[1] + w * x2;
                double[] dArray123 = input[1];
                dArray123[2] = dArray123[2] + w * xy;
                double[] dArray124 = input[1];
                dArray124[3] = dArray124[3] + w * xy * x;
                double[] dArray125 = input[2];
                dArray125[2] = dArray125[2] + w * y2;
                double[] dArray126 = input[2];
                dArray126[3] = dArray126[3] + w * xy * y;
                double[] dArray127 = input[3];
                dArray127[3] = dArray127[3] + w * xy * xy;
                double[] dArray128 = g[0];
                dArray128[0] = dArray128[0] + w * z;
                double[] dArray129 = g[1];
                dArray129[0] = dArray129[0] + w * x * z;
                double[] dArray130 = g[2];
                dArray130[0] = dArray130[0] + w * y * z;
                double[] dArray131 = g[3];
                dArray131[0] = dArray131[0] + w * xy * z;
            }
            input[1][0] = input[0][1];
            input[2][0] = input[0][2];
            input[2][1] = input[1][2];
            input[3][0] = input[0][3];
            input[3][1] = input[1][3];
            input[3][2] = input[2][3];
        } else {
            this.nVariables = 6;
            g = new double[7][1];
            input = new double[7][7];
            for (i = 0; i < nSamples; ++i) {
                x = samples[i][0] - xQuery;
                y = samples[i][1] - yQuery;
                z = samples[i][2];
                w = weights[i];
                x2 = x * x;
                y2 = y * y;
                xy = x * y;
                double x32 = x * x2;
                double y32 = y * y2;
                double x42 = x2 * x2;
                double y42 = y2 * y2;
                double[] dArray = input[0];
                dArray[0] = dArray[0] + w;
                double[] dArray132 = input[0];
                dArray132[1] = dArray132[1] + w * x;
                double[] dArray133 = input[0];
                dArray133[2] = dArray133[2] + w * y;
                double[] dArray134 = input[0];
                dArray134[3] = dArray134[3] + w * x2;
                double[] dArray135 = input[0];
                dArray135[4] = dArray135[4] + w * y2;
                double[] dArray136 = input[0];
                dArray136[5] = dArray136[5] + w * x32;
                double[] dArray137 = input[0];
                dArray137[6] = dArray137[6] + w * y32;
                double[] dArray138 = input[1];
                dArray138[1] = dArray138[1] + w * x2;
                double[] dArray139 = input[1];
                dArray139[2] = dArray139[2] + w * xy;
                double[] dArray140 = input[1];
                dArray140[3] = dArray140[3] + w * x32;
                double[] dArray141 = input[1];
                dArray141[4] = dArray141[4] + w * y2 * x;
                double[] dArray142 = input[1];
                dArray142[5] = dArray142[5] + w * x42;
                double[] dArray143 = input[1];
                dArray143[6] = dArray143[6] + w * y32 * x;
                double[] dArray144 = input[2];
                dArray144[2] = dArray144[2] + w * y2;
                double[] dArray145 = input[2];
                dArray145[3] = dArray145[3] + w * x2 * y;
                double[] dArray146 = input[2];
                dArray146[4] = dArray146[4] + w * y32;
                double[] dArray147 = input[2];
                dArray147[5] = dArray147[5] + w * x32 * y;
                double[] dArray148 = input[2];
                dArray148[6] = dArray148[6] + w * y42;
                double[] dArray149 = input[3];
                dArray149[3] = dArray149[3] + w * x42;
                double[] dArray150 = input[3];
                dArray150[4] = dArray150[4] + w * y2 * x2;
                double[] dArray151 = input[3];
                dArray151[5] = dArray151[5] + w * x32 * x2;
                double[] dArray152 = input[3];
                dArray152[6] = dArray152[6] + w * y32 * x2;
                double[] dArray153 = input[4];
                dArray153[4] = dArray153[4] + w * y42;
                double[] dArray154 = input[4];
                dArray154[5] = dArray154[5] + w * x32 * y2;
                double[] dArray155 = input[4];
                dArray155[6] = dArray155[6] + w * y32 * y2;
                double[] dArray156 = input[5];
                dArray156[5] = dArray156[5] + w * x32 * x32;
                double[] dArray157 = input[5];
                dArray157[6] = dArray157[6] + w * y32 * x32;
                double[] dArray158 = input[6];
                dArray158[6] = dArray158[6] + w * y32 * y32;
                double[] dArray159 = g[0];
                dArray159[0] = dArray159[0] + w * z;
                double[] dArray160 = g[1];
                dArray160[0] = dArray160[0] + w * x * z;
                double[] dArray161 = g[2];
                dArray161[0] = dArray161[0] + w * y * z;
                double[] dArray162 = g[3];
                dArray162[0] = dArray162[0] + w * x2 * z;
                double[] dArray163 = g[4];
                dArray163[0] = dArray163[0] + w * y2 * z;
                double[] dArray164 = g[5];
                dArray164[0] = dArray164[0] + w * x32 * z;
                double[] dArray165 = g[6];
                dArray165[0] = dArray165[0] + w * y32 * z;
            }
            input[1][0] = input[0][1];
            input[2][0] = input[0][2];
            input[2][1] = input[1][2];
            input[3][0] = input[0][3];
            input[3][1] = input[1][3];
            input[3][2] = input[2][3];
            input[4][0] = input[0][4];
            input[4][1] = input[1][4];
            input[4][2] = input[2][4];
            input[4][3] = input[3][4];
            input[5][0] = input[0][5];
            input[5][1] = input[1][5];
            input[5][2] = input[2][5];
            input[5][3] = input[3][5];
            input[5][4] = input[4][5];
            input[6][0] = input[0][6];
            input[6][1] = input[1][6];
            input[6][2] = input[2][6];
            input[6][3] = input[3][6];
            input[6][4] = input[4][6];
            input[6][5] = input[5][6];
        }
        this.nDegOfFreedom = nSamples - this.nVariables - 1;
        if (this.nDegOfFreedom < 1) {
            throw new IllegalArgumentException("Inadequate sample size " + nSamples + " for " + this.nDegOfFreedom + " degrees of freedom");
        }
        BlockRealMatrix matrixG = new BlockRealMatrix(g);
        BlockRealMatrix matrixA = new BlockRealMatrix(input);
        try {
            QRDecomposition cd = new QRDecomposition((RealMatrix)matrixA);
            DecompositionSolver solver = cd.getSolver();
            RealMatrix solution = solver.solve((RealMatrix)matrixG);
            this.beta = new double[this.nVariables + 1];
            for (int i2 = 0; i2 < this.beta.length; ++i2) {
                this.beta[i2] = solution.getEntry(i2, 0);
            }
        }
        catch (SingularMatrixException npex) {
            return null;
        }
        return this.beta;
    }

    public RealMatrix computeXWX(double xQuery, double yQuery, int nSamples, double[][] samples, double[] weights) {
        double[][] input;
        if (nSamples < this.model.getCoefficientCount()) {
            throw new IllegalArgumentException("Insufficient number of samples for regression: found " + nSamples + ", need " + this.model.getCoefficientCount());
        }
        if (this.model == SurfaceModel.CubicWithCrossTerms) {
            input = new double[10][10];
            for (int i = 0; i < nSamples; ++i) {
                double x = samples[i][0] - xQuery;
                double y = samples[i][1] - yQuery;
                double w = weights[i];
                double x2 = x * x;
                double y2 = y * y;
                double x3 = x * x2;
                double y3 = y * y2;
                double x4 = x2 * x2;
                double y4 = y2 * y2;
                double xy = x * y;
                double[] dArray = input[0];
                dArray[0] = dArray[0] + w;
                double[] dArray2 = input[0];
                dArray2[1] = dArray2[1] + w * x;
                double[] dArray3 = input[0];
                dArray3[2] = dArray3[2] + w * y;
                double[] dArray4 = input[0];
                dArray4[3] = dArray4[3] + w * x2;
                double[] dArray5 = input[0];
                dArray5[4] = dArray5[4] + w * y2;
                double[] dArray6 = input[0];
                dArray6[5] = dArray6[5] + w * xy;
                double[] dArray7 = input[0];
                dArray7[6] = dArray7[6] + w * x2 * y;
                double[] dArray8 = input[0];
                dArray8[7] = dArray8[7] + w * x * y2;
                double[] dArray9 = input[0];
                dArray9[8] = dArray9[8] + w * x3;
                double[] dArray10 = input[0];
                dArray10[9] = dArray10[9] + w * y3;
                double[] dArray11 = input[1];
                dArray11[1] = dArray11[1] + w * x2;
                double[] dArray12 = input[1];
                dArray12[2] = dArray12[2] + w * xy;
                double[] dArray13 = input[1];
                dArray13[3] = dArray13[3] + w * x3;
                double[] dArray14 = input[1];
                dArray14[4] = dArray14[4] + w * x * y2;
                double[] dArray15 = input[1];
                dArray15[5] = dArray15[5] + w * x2 * y;
                double[] dArray16 = input[1];
                dArray16[6] = dArray16[6] + w * x * x2 * y;
                double[] dArray17 = input[1];
                dArray17[7] = dArray17[7] + w * x * x * y2;
                double[] dArray18 = input[1];
                dArray18[8] = dArray18[8] + w * x * x3;
                double[] dArray19 = input[1];
                dArray19[9] = dArray19[9] + w * x * y3;
                double[] dArray20 = input[2];
                dArray20[2] = dArray20[2] + w * y2;
                double[] dArray21 = input[2];
                dArray21[3] = dArray21[3] + w * x2 * y;
                double[] dArray22 = input[2];
                dArray22[4] = dArray22[4] + w * y3;
                double[] dArray23 = input[2];
                dArray23[5] = dArray23[5] + w * x * y2;
                double[] dArray24 = input[2];
                dArray24[6] = dArray24[6] + w * y * x2 * y;
                double[] dArray25 = input[2];
                dArray25[7] = dArray25[7] + w * y * x * y2;
                double[] dArray26 = input[2];
                dArray26[8] = dArray26[8] + w * y * x3;
                double[] dArray27 = input[2];
                dArray27[9] = dArray27[9] + w * y * y3;
                double[] dArray28 = input[3];
                dArray28[3] = dArray28[3] + w * x4;
                double[] dArray29 = input[3];
                dArray29[4] = dArray29[4] + w * x2 * y2;
                double[] dArray30 = input[3];
                dArray30[5] = dArray30[5] + w * x3 * y;
                double[] dArray31 = input[3];
                dArray31[6] = dArray31[6] + w * x2 * x2 * y;
                double[] dArray32 = input[3];
                dArray32[7] = dArray32[7] + w * x2 * x * y2;
                double[] dArray33 = input[3];
                dArray33[8] = dArray33[8] + w * x2 * x3;
                double[] dArray34 = input[3];
                dArray34[9] = dArray34[9] + w * x2 * y3;
                double[] dArray35 = input[4];
                dArray35[4] = dArray35[4] + w * y4;
                double[] dArray36 = input[4];
                dArray36[5] = dArray36[5] + w * x * y3;
                double[] dArray37 = input[4];
                dArray37[6] = dArray37[6] + w * y2 * x2 * y;
                double[] dArray38 = input[4];
                dArray38[7] = dArray38[7] + w * y2 * x * y2;
                double[] dArray39 = input[4];
                dArray39[8] = dArray39[8] + w * y2 * x3;
                double[] dArray40 = input[4];
                dArray40[9] = dArray40[9] + w * y2 * y3;
                double[] dArray41 = input[5];
                dArray41[5] = dArray41[5] + w * x2 * y2;
                double[] dArray42 = input[5];
                dArray42[6] = dArray42[6] + w * xy * x2 * y;
                double[] dArray43 = input[5];
                dArray43[7] = dArray43[7] + w * xy * x * y2;
                double[] dArray44 = input[5];
                dArray44[8] = dArray44[8] + w * xy * x3;
                double[] dArray45 = input[5];
                dArray45[9] = dArray45[9] + w * xy * y3;
                double[] dArray46 = input[6];
                dArray46[6] = dArray46[6] + w * x2 * y * x2 * y;
                double[] dArray47 = input[6];
                dArray47[7] = dArray47[7] + w * x2 * y * x * y2;
                double[] dArray48 = input[6];
                dArray48[8] = dArray48[8] + w * x2 * y * x3;
                double[] dArray49 = input[6];
                dArray49[9] = dArray49[9] + w * x2 * y * y3;
                double[] dArray50 = input[7];
                dArray50[7] = dArray50[7] + w * y2 * x * x * y2;
                double[] dArray51 = input[7];
                dArray51[8] = dArray51[8] + w * y2 * x * x3;
                double[] dArray52 = input[7];
                dArray52[9] = dArray52[9] + w * y2 * x * y3;
                double[] dArray53 = input[8];
                dArray53[8] = dArray53[8] + w * x3 * x3;
                double[] dArray54 = input[8];
                dArray54[9] = dArray54[9] + w * x3 * y3;
                double[] dArray55 = input[9];
                dArray55[9] = dArray55[9] + w * y3 * y3;
            }
            input[1][0] = input[0][1];
            input[2][0] = input[0][2];
            input[2][1] = input[1][2];
            input[3][0] = input[0][3];
            input[3][1] = input[1][3];
            input[3][2] = input[2][3];
            input[4][0] = input[0][4];
            input[4][1] = input[1][4];
            input[4][2] = input[2][4];
            input[4][3] = input[3][4];
            input[5][0] = input[0][5];
            input[5][1] = input[1][5];
            input[5][2] = input[2][5];
            input[5][3] = input[3][5];
            input[5][4] = input[4][5];
            input[6][0] = input[0][6];
            input[6][1] = input[1][6];
            input[6][2] = input[2][6];
            input[6][3] = input[3][6];
            input[6][4] = input[4][6];
            input[6][5] = input[5][6];
            input[7][0] = input[0][7];
            input[7][1] = input[1][7];
            input[7][2] = input[2][7];
            input[7][3] = input[3][7];
            input[7][4] = input[4][7];
            input[7][5] = input[5][7];
            input[7][6] = input[6][7];
            input[8][0] = input[0][8];
            input[8][1] = input[1][8];
            input[8][2] = input[2][8];
            input[8][3] = input[3][8];
            input[8][4] = input[4][8];
            input[8][5] = input[5][8];
            input[8][6] = input[6][8];
            input[8][7] = input[7][8];
            input[9][0] = input[0][9];
            input[9][1] = input[1][9];
            input[9][2] = input[2][9];
            input[9][3] = input[3][9];
            input[9][4] = input[4][9];
            input[9][5] = input[5][9];
            input[9][6] = input[6][9];
            input[9][7] = input[7][9];
            input[9][8] = input[8][9];
        } else if (this.model == SurfaceModel.QuadraticWithCrossTerms) {
            input = new double[6][6];
            for (int i = 0; i < nSamples; ++i) {
                double x = samples[i][0] - xQuery;
                double y = samples[i][1] - yQuery;
                double w = weights[i];
                double x2 = x * x;
                double y2 = y * y;
                double x3 = x * x2;
                double y3 = y * y2;
                double x4 = x2 * x2;
                double y4 = y2 * y2;
                double xy = x * y;
                double[] dArray = input[0];
                dArray[0] = dArray[0] + w;
                double[] dArray56 = input[0];
                dArray56[1] = dArray56[1] + w * x;
                double[] dArray57 = input[0];
                dArray57[2] = dArray57[2] + w * y;
                double[] dArray58 = input[0];
                dArray58[3] = dArray58[3] + w * x2;
                double[] dArray59 = input[0];
                dArray59[4] = dArray59[4] + w * y2;
                double[] dArray60 = input[0];
                dArray60[5] = dArray60[5] + w * xy;
                double[] dArray61 = input[1];
                dArray61[1] = dArray61[1] + w * x2;
                double[] dArray62 = input[1];
                dArray62[2] = dArray62[2] + w * xy;
                double[] dArray63 = input[1];
                dArray63[3] = dArray63[3] + w * x * x2;
                double[] dArray64 = input[1];
                dArray64[4] = dArray64[4] + w * x * y2;
                double[] dArray65 = input[1];
                dArray65[5] = dArray65[5] + w * x * xy;
                double[] dArray66 = input[2];
                dArray66[2] = dArray66[2] + w * y2;
                double[] dArray67 = input[2];
                dArray67[3] = dArray67[3] + w * x2 * y;
                double[] dArray68 = input[2];
                dArray68[4] = dArray68[4] + w * y3;
                double[] dArray69 = input[2];
                dArray69[5] = dArray69[5] + w * x * y2;
                double[] dArray70 = input[3];
                dArray70[3] = dArray70[3] + w * x4;
                double[] dArray71 = input[3];
                dArray71[4] = dArray71[4] + w * x2 * y2;
                double[] dArray72 = input[3];
                dArray72[5] = dArray72[5] + w * x3 * y;
                double[] dArray73 = input[4];
                dArray73[4] = dArray73[4] + w * y4;
                double[] dArray74 = input[4];
                dArray74[5] = dArray74[5] + w * x * y3;
                double[] dArray75 = input[5];
                dArray75[5] = dArray75[5] + w * x2 * y2;
            }
            input[1][0] = input[0][1];
            input[2][0] = input[0][2];
            input[2][1] = input[1][2];
            input[3][0] = input[0][3];
            input[3][1] = input[1][3];
            input[3][2] = input[2][3];
            input[4][0] = input[0][4];
            input[4][1] = input[1][4];
            input[4][2] = input[2][4];
            input[4][3] = input[3][4];
            input[5][0] = input[0][5];
            input[5][1] = input[1][5];
            input[5][2] = input[2][5];
            input[5][3] = input[3][5];
            input[5][4] = input[4][5];
        } else if (this.model == SurfaceModel.Quadratic) {
            input = new double[5][5];
            for (int i = 0; i < nSamples; ++i) {
                double x = samples[i][0] - xQuery;
                double y = samples[i][1] - yQuery;
                double w = weights[i];
                double x2 = x * x;
                double y2 = y * y;
                double x3 = x * x2;
                double y3 = y * y2;
                double x4 = x2 * x2;
                double y4 = y2 * y2;
                double xy = x * y;
                double[] dArray = input[0];
                dArray[0] = dArray[0] + w;
                double[] dArray76 = input[0];
                dArray76[1] = dArray76[1] + w * x;
                double[] dArray77 = input[0];
                dArray77[2] = dArray77[2] + w * y;
                double[] dArray78 = input[0];
                dArray78[3] = dArray78[3] + w * x2;
                double[] dArray79 = input[0];
                dArray79[4] = dArray79[4] + w * y2;
                double[] dArray80 = input[1];
                dArray80[1] = dArray80[1] + w * x2;
                double[] dArray81 = input[1];
                dArray81[2] = dArray81[2] + w * xy;
                double[] dArray82 = input[1];
                dArray82[3] = dArray82[3] + w * x3;
                double[] dArray83 = input[1];
                dArray83[4] = dArray83[4] + w * x * y2;
                double[] dArray84 = input[2];
                dArray84[2] = dArray84[2] + w * y2;
                double[] dArray85 = input[2];
                dArray85[3] = dArray85[3] + w * x2 * y;
                double[] dArray86 = input[2];
                dArray86[4] = dArray86[4] + w * y3;
                double[] dArray87 = input[3];
                dArray87[3] = dArray87[3] + w * x4;
                double[] dArray88 = input[3];
                dArray88[4] = dArray88[4] + w * x2 * y2;
                double[] dArray89 = input[4];
                dArray89[4] = dArray89[4] + w * y4;
            }
            input[1][0] = input[0][1];
            input[2][0] = input[0][2];
            input[2][1] = input[1][2];
            input[3][0] = input[0][3];
            input[3][1] = input[1][3];
            input[3][2] = input[2][3];
            input[4][0] = input[0][4];
            input[4][1] = input[1][4];
            input[4][2] = input[2][4];
            input[4][3] = input[3][4];
        } else if (this.model == SurfaceModel.Planar) {
            input = new double[3][3];
            for (int i = 0; i < nSamples; ++i) {
                double x = samples[i][0] - xQuery;
                double y = samples[i][1] - yQuery;
                double w = weights[i];
                double x2 = x * x;
                double y2 = y * y;
                double[] dArray = input[0];
                dArray[0] = dArray[0] + w;
                double[] dArray90 = input[0];
                dArray90[1] = dArray90[1] + w * x;
                double[] dArray91 = input[0];
                dArray91[2] = dArray91[2] + w * y;
                double[] dArray92 = input[1];
                dArray92[1] = dArray92[1] + w * x2;
                double[] dArray93 = input[1];
                dArray93[2] = dArray93[2] + w * x * y;
                double[] dArray94 = input[2];
                dArray94[2] = dArray94[2] + w * y2;
            }
            input[1][0] = input[0][1];
            input[2][0] = input[0][2];
            input[2][1] = input[1][2];
        } else if (this.model == SurfaceModel.PlanarWithCrossTerms) {
            input = new double[4][4];
            for (int i = 0; i < nSamples; ++i) {
                double x = samples[i][0] - xQuery;
                double y = samples[i][1] - yQuery;
                double w = weights[i];
                double x2 = x * x;
                double y2 = y * y;
                double xy = x * y;
                double[] dArray = input[0];
                dArray[0] = dArray[0] + w;
                double[] dArray95 = input[0];
                dArray95[1] = dArray95[1] + w * x;
                double[] dArray96 = input[0];
                dArray96[2] = dArray96[2] + w * y;
                double[] dArray97 = input[0];
                dArray97[3] = dArray97[3] + w * xy;
                double[] dArray98 = input[1];
                dArray98[1] = dArray98[1] + w * x2;
                double[] dArray99 = input[1];
                dArray99[2] = dArray99[2] + w * xy;
                double[] dArray100 = input[1];
                dArray100[3] = dArray100[3] + w * xy * x;
                double[] dArray101 = input[2];
                dArray101[2] = dArray101[2] + w * y2;
                double[] dArray102 = input[2];
                dArray102[3] = dArray102[3] + w * xy * y;
                double[] dArray103 = input[3];
                dArray103[3] = dArray103[3] + w * xy * xy;
            }
            input[1][0] = input[0][1];
            input[2][0] = input[0][2];
            input[2][1] = input[1][2];
            input[3][0] = input[0][3];
            input[3][1] = input[1][3];
            input[3][2] = input[2][3];
        } else {
            input = new double[7][7];
            for (int i = 0; i < nSamples; ++i) {
                double x = samples[i][0] - xQuery;
                double y = samples[i][1] - yQuery;
                double w = weights[i];
                double x2 = x * x;
                double y2 = y * y;
                double xy = x * y;
                double x3 = x * x2;
                double y3 = y * y2;
                double x4 = x2 * x2;
                double y4 = y2 * y2;
                double[] dArray = input[0];
                dArray[0] = dArray[0] + w;
                double[] dArray104 = input[0];
                dArray104[1] = dArray104[1] + w * x;
                double[] dArray105 = input[0];
                dArray105[2] = dArray105[2] + w * y;
                double[] dArray106 = input[0];
                dArray106[3] = dArray106[3] + w * x2;
                double[] dArray107 = input[0];
                dArray107[4] = dArray107[4] + w * y2;
                double[] dArray108 = input[0];
                dArray108[5] = dArray108[5] + w * x3;
                double[] dArray109 = input[0];
                dArray109[6] = dArray109[6] + w * y3;
                double[] dArray110 = input[1];
                dArray110[1] = dArray110[1] + w * x2;
                double[] dArray111 = input[1];
                dArray111[2] = dArray111[2] + w * xy;
                double[] dArray112 = input[1];
                dArray112[3] = dArray112[3] + w * x3;
                double[] dArray113 = input[1];
                dArray113[4] = dArray113[4] + w * y2 * x;
                double[] dArray114 = input[1];
                dArray114[5] = dArray114[5] + w * x4;
                double[] dArray115 = input[1];
                dArray115[6] = dArray115[6] + w * y3 * x;
                double[] dArray116 = input[2];
                dArray116[2] = dArray116[2] + w * y2;
                double[] dArray117 = input[2];
                dArray117[3] = dArray117[3] + w * x2 * y;
                double[] dArray118 = input[2];
                dArray118[4] = dArray118[4] + w * y3;
                double[] dArray119 = input[2];
                dArray119[5] = dArray119[5] + w * x3 * y;
                double[] dArray120 = input[2];
                dArray120[6] = dArray120[6] + w * y4;
                double[] dArray121 = input[3];
                dArray121[3] = dArray121[3] + w * x4;
                double[] dArray122 = input[3];
                dArray122[4] = dArray122[4] + w * y2 * x2;
                double[] dArray123 = input[3];
                dArray123[5] = dArray123[5] + w * x3 * x2;
                double[] dArray124 = input[3];
                dArray124[6] = dArray124[6] + w * y3 * x2;
                double[] dArray125 = input[4];
                dArray125[4] = dArray125[4] + w * y4;
                double[] dArray126 = input[4];
                dArray126[5] = dArray126[5] + w * x3 * y2;
                double[] dArray127 = input[4];
                dArray127[6] = dArray127[6] + w * y3 * y2;
                double[] dArray128 = input[5];
                dArray128[5] = dArray128[5] + w * x3 * x3;
                double[] dArray129 = input[5];
                dArray129[6] = dArray129[6] + w * y3 * x3;
                double[] dArray130 = input[6];
                dArray130[6] = dArray130[6] + w * y3 * y3;
            }
            input[1][0] = input[0][1];
            input[2][0] = input[0][2];
            input[2][1] = input[1][2];
            input[3][0] = input[0][3];
            input[3][1] = input[1][3];
            input[3][2] = input[2][3];
            input[4][0] = input[0][4];
            input[4][1] = input[1][4];
            input[4][2] = input[2][4];
            input[4][3] = input[3][4];
            input[5][0] = input[0][5];
            input[5][1] = input[1][5];
            input[5][2] = input[2][5];
            input[5][3] = input[3][5];
            input[5][4] = input[4][5];
            input[6][0] = input[0][6];
            input[6][1] = input[1][6];
            input[6][2] = input[2][6];
            input[6][3] = input[3][6];
            input[6][4] = input[4][6];
            input[6][5] = input[5][6];
        }
        return new BlockRealMatrix(input);
    }

    double[][] computeDesignMatrix(SurfaceModel sm, double x0, double y0, int n, double[][] s) {
        double[][] matrix;
        if (sm == SurfaceModel.CubicWithCrossTerms) {
            matrix = new double[n][10];
            for (int i = 0; i < n; ++i) {
                double x = s[i][0] - x0;
                double y = s[i][1] - y0;
                double x2 = x * x;
                double y2 = y * y;
                double x3 = x * x2;
                double y3 = y * y2;
                double xy = x * y;
                matrix[i][0] = 1.0;
                matrix[i][1] = x;
                matrix[i][2] = y;
                matrix[i][3] = x2;
                matrix[i][4] = y2;
                matrix[i][5] = xy;
                matrix[i][6] = x2 * y;
                matrix[i][7] = x * y2;
                matrix[i][8] = x3;
                matrix[i][9] = y3;
            }
        } else if (sm == SurfaceModel.QuadraticWithCrossTerms) {
            matrix = new double[n][6];
            for (int i = 0; i < n; ++i) {
                double x = s[i][0] - x0;
                double y = s[i][1] - y0;
                double x2 = x * x;
                double y2 = y * y;
                double xy = x * y;
                matrix[i][0] = 1.0;
                matrix[i][1] = x;
                matrix[i][2] = y;
                matrix[i][3] = x2;
                matrix[i][4] = y2;
                matrix[i][5] = xy;
            }
        } else if (sm == SurfaceModel.Quadratic) {
            matrix = new double[n][5];
            for (int i = 0; i < n; ++i) {
                double x = s[i][0] - x0;
                double y = s[i][1] - y0;
                double x2 = x * x;
                double y2 = y * y;
                matrix[i][0] = 1.0;
                matrix[i][1] = x;
                matrix[i][2] = y;
                matrix[i][3] = x2;
                matrix[i][4] = y2;
            }
        } else if (sm == SurfaceModel.Planar) {
            matrix = new double[n][3];
            for (int i = 0; i < n; ++i) {
                double x = s[i][0] - x0;
                double y = s[i][1] - y0;
                matrix[i][0] = 1.0;
                matrix[i][1] = x;
                matrix[i][2] = y;
            }
        } else if (sm == SurfaceModel.PlanarWithCrossTerms) {
            matrix = new double[n][4];
            for (int i = 0; i < n; ++i) {
                double x = s[i][0] - x0;
                double y = s[i][1] - y0;
                double xy = x * y;
                matrix[i][0] = 1.0;
                matrix[i][1] = x;
                matrix[i][2] = y;
                matrix[i][3] = xy;
            }
        } else {
            matrix = new double[n][7];
            for (int i = 0; i < n; ++i) {
                double x = s[i][0] - x0;
                double y = s[i][1] - y0;
                double x2 = x * x;
                double y2 = y * y;
                double x3 = x * x2;
                double y3 = y * y2;
                matrix[i][0] = 1.0;
                matrix[i][1] = x;
                matrix[i][2] = y;
                matrix[i][3] = x2;
                matrix[i][4] = y2;
                matrix[i][5] = x3;
                matrix[i][6] = y3;
            }
        }
        return matrix;
    }

    public void computeVarianceAndHat() {
        if (this.areVarianceAndHatPrepped) {
            return;
        }
        this.areVarianceAndHatPrepped = true;
        if (this.sampleWeightsMatrix == null) {
            throw new NullPointerException("Null specification for sampleWeightsMatrix");
        }
        if (this.sampleWeightsMatrix.length != this.nSamples) {
            throw new IllegalArgumentException("Incorrectly specified sampleWeightsMatrix");
        }
        double[][] bigS = new double[this.nSamples][this.nSamples];
        double[][] bigW = this.sampleWeightsMatrix;
        double[][] input = this.computeDesignMatrix(this.model, this.xOffset, this.yOffset, this.nSamples, this.samples);
        BlockRealMatrix mX = new BlockRealMatrix(input);
        RealMatrix mXT = mX.transpose();
        double sTrace = 0.0;
        double sTrace2 = 0.0;
        for (int i = 0; i < this.nSamples; ++i) {
            DiagonalMatrix mW = new DiagonalMatrix(bigW[i]);
            RealMatrix mXTW = mXT.multiply((RealMatrix)mW);
            RealMatrix rx = mX.getRowMatrix(i);
            RealMatrix c = mXTW.multiply((RealMatrix)mX);
            QRDecomposition cd = new QRDecomposition(c);
            DecompositionSolver cdSolver = cd.getSolver();
            RealMatrix cInv = cdSolver.getInverse();
            RealMatrix r = rx.multiply(cInv).multiply(mXTW);
            double[] row = r.getRow(0);
            sTrace += row[i];
            System.arraycopy(row, 0, bigS[i], 0, this.nSamples);
            for (int j = 0; j < this.nSamples; ++j) {
                sTrace2 += row[j] * row[j];
            }
        }
        this.hat = new BlockRealMatrix(bigS);
        this.traceHat = sTrace;
        this.traceHat2 = sTrace2;
        double[][] zArray = new double[this.nSamples][1];
        for (int i = 0; i < this.nSamples; ++i) {
            zArray[i][0] = this.samples[i][2];
        }
        BlockRealMatrix mY = new BlockRealMatrix(zArray);
        RealMatrix mYH = this.hat.multiply((RealMatrix)mY);
        double sse = 0.0;
        for (int i = 0; i < this.nSamples; ++i) {
            double yHat = mYH.getEntry(i, 0);
            double e = zArray[i][0] - yHat;
            sse += e * e;
        }
        this.rss = sse;
        double d1 = (double)this.nSamples - (2.0 * this.traceHat - sTrace2);
        this.sigma2 = this.rss / d1;
        this.mlSigma2 = this.rss / (double)this.nSamples;
        RealMatrix mIL = this.hat.copy();
        for (int i = 0; i < this.nSamples; ++i) {
            double c = 1.0 - mIL.getEntry(i, i);
            mIL.setEntry(i, i, c);
        }
        RealMatrix mILT = mIL.transpose().multiply(mIL);
        this.delta1 = mILT.getTrace();
        this.delta2 = mILT.multiply(mILT).getTrace();
    }

    public void printSummary(PrintStream ps) {
        this.computeVarianceAndHat();
        if (!this.areVarianceAndHatPrepped) {
            ps.format("Regression statistics not available%n", new Object[0]);
            return;
        }
        ps.format("Regression coefficients & variance%n", new Object[0]);
        for (int i = 0; i < this.beta.length; ++i) {
            ps.format("beta[%2d] %12.6f%n", i, this.beta[i]);
        }
        ps.format("Residual standard deviation %f on %d degrees of freedom%n", this.getStandardDeviation(), this.nDegOfFreedom);
        ps.format("Correlation coefficient (r^2): %f%n", this.getR2());
        ps.format("Adusted r^2:                   %f%n", this.getAdjustedR2());
        ps.format("F statistic:  %f%n", this.getF());
    }

    public double[] getCoefficients() {
        double[] b = new double[this.beta.length];
        System.arraycopy(this.beta, 0, b, 0, this.beta.length);
        return b;
    }

    public double getR2() {
        throw new UnsupportedOperationException("R2 statistics not yet implemented");
    }

    public double getAdjustedR2() {
        throw new UnsupportedOperationException("Adjusted R2 statistics not yet implemented");
    }

    public double getF() {
        throw new UnsupportedOperationException("Adjusted R2 statistics not yet implemented");
    }

    public double getVariance() {
        this.computeVarianceAndHat();
        return this.sigma2;
    }

    public double getStandardDeviation() {
        this.computeVarianceAndHat();
        return Math.sqrt(this.sigma2);
    }

    public double getSigmaML() {
        this.computeVarianceAndHat();
        return Math.sqrt(this.mlSigma2);
    }

    public double getResidualSumOfTheSquares() {
        this.computeVarianceAndHat();
        return this.rss;
    }

    public double getLeungDelta1() {
        this.computeVarianceAndHat();
        return this.delta1;
    }

    public double getLeungDelta2() {
        this.computeVarianceAndHat();
        return this.delta2;
    }

    public double getEffectiveDegreesOfFreedom() {
        this.computeVarianceAndHat();
        return this.delta1 * this.delta1 / this.delta2;
    }

    public double getPredictionIntervalHalfRange(double alpha) {
        RealMatrix vcm;
        this.computeVarianceAndHat();
        double[][] input = this.computeDesignMatrix(this.model, this.xOffset, this.yOffset, this.nSamples, this.samples);
        BlockRealMatrix mX = new BlockRealMatrix(input);
        RealMatrix mXT = mX.transpose();
        double[] rW = Arrays.copyOf(this.weights, this.nSamples);
        DiagonalMatrix mW = new DiagonalMatrix(rW);
        RealMatrix design = mXT.multiply((RealMatrix)mW).multiply((RealMatrix)mX);
        try {
            QRDecomposition cd = new QRDecomposition(design);
            DecompositionSolver s = cd.getSolver();
            vcm = s.getInverse();
        }
        catch (SingularMatrixException npex) {
            return Double.NaN;
        }
        double nLeungDOF = this.delta1 * this.delta1 / this.delta2;
        for (int i = 0; i < this.nSamples; ++i) {
            rW[i] = this.weights[i] * this.weights[i];
        }
        DiagonalMatrix mW2 = new DiagonalMatrix(rW);
        RealMatrix mS = vcm.multiply(mXT).multiply((RealMatrix)mW2).multiply((RealMatrix)mX).multiply(vcm);
        double pS = mS.getEntry(0, 0);
        double p = Math.sqrt(this.sigma2 * (1.0 + pS));
        TDistribution td = new TDistribution(nLeungDOF);
        double ta = td.inverseCumulativeProbability(1.0 - alpha / 2.0);
        return ta * p;
    }

    public double[] getPredictionInterval(double alpha) {
        double h = this.getPredictionIntervalHalfRange(alpha);
        double[] a = new double[]{this.beta[0] - h, this.beta[0] + h};
        return a;
    }

    public int getDegreesOfFreedom() {
        this.computeVarianceAndHat();
        return this.nDegOfFreedom;
    }

    public RealMatrix getHatMatrix() {
        this.computeVarianceAndHat();
        return this.hat;
    }

    public final int getMinimumRequiredSamples(SurfaceModel sm) {
        return sm.getCoefficientCount() + 1;
    }

    public double[] getQueryCoordinates() {
        double[] p = new double[]{this.xOffset, this.yOffset};
        return p;
    }

    public SurfaceModel getModel() {
        return this.model;
    }

    public double getAICc() {
        this.computeVarianceAndHat();
        double lv = Math.log(this.mlSigma2);
        double x = ((double)this.nSamples + this.traceHat) / ((double)(this.nSamples - 2) - this.traceHat);
        return (double)this.nSamples * (lv + log2PI + x);
    }

    public double getEstimatedValue(double xQuery, double yQuery) {
        double x = xQuery - this.xOffset;
        double y = yQuery - this.yOffset;
        switch (this.model) {
            case Planar: {
                return this.beta[0] + (this.beta[1] * x + this.beta[2] * y);
            }
            case PlanarWithCrossTerms: {
                return this.beta[0] + (this.beta[1] * x + this.beta[2] * y + this.beta[3] * x * y);
            }
            case QuadraticWithCrossTerms: {
                return this.beta[0] + (this.beta[1] * x + this.beta[2] * y + this.beta[3] * x * x + this.beta[4] * y * y + this.beta[5] * x * y);
            }
            case Quadratic: {
                return this.beta[0] + (this.beta[1] * x + this.beta[2] * y + this.beta[3] * x * x + this.beta[4] * y * y);
            }
            case CubicWithCrossTerms: {
                return this.beta[0] + (this.beta[1] * x + this.beta[2] * y + this.beta[3] * x * x + this.beta[4] * y * y + this.beta[5] * x * y + this.beta[6] * x * x * y + this.beta[7] * x * y * y + this.beta[8] * x * x * x + this.beta[9] * y * y * y);
            }
            case Cubic: {
                return this.beta[0] + (this.beta[1] * x + this.beta[2] * y + this.beta[3] * x * x + this.beta[4] * y * y + this.beta[5] * x * x * x + this.beta[6] * y * y * y);
            }
        }
        return Double.NaN;
    }

    public void clear() {
        this.nSamples = 0;
        this.areVarianceAndHatPrepped = false;
        this.samples = null;
        this.weights = null;
        this.residuals = null;
        this.hat = null;
    }

    public double[] getResiduals() {
        if (this.nSamples == 0) {
            return new double[0];
        }
        this.computeVarianceAndHat();
        return Arrays.copyOf(this.residuals, this.nSamples);
    }

    public double[][] getSamples() {
        if (this.nSamples == 0) {
            return new double[0][0];
        }
        return (double[][])Arrays.copyOf(this.samples, this.nSamples);
    }

    public double[] getWeights() {
        if (this.nSamples == 0) {
            return new double[0];
        }
        return Arrays.copyOf(this.weights, this.nSamples);
    }

    public int getSampleCount() {
        return this.nSamples;
    }

    public String toString() {
        return "SurfaceGWR: model=" + (Object)((Object)this.model);
    }

    double evaluateAICc(SurfaceModel sm, double xQuery, double yQuery, int nSamples, double[][] samples, double[] weights, double[][] sampleWeightsMatrix) {
        double[][] bigS = new double[nSamples][nSamples];
        double[][] bigW = sampleWeightsMatrix;
        double[][] input = this.computeDesignMatrix(sm, xQuery, yQuery, nSamples, samples);
        BlockRealMatrix mX = new BlockRealMatrix(input);
        RealMatrix mXT = mX.transpose();
        double traceS = 0.0;
        for (int i = 0; i < nSamples; ++i) {
            RealMatrix cInv;
            DiagonalMatrix mW = new DiagonalMatrix(bigW[i]);
            RealMatrix mXTW = mXT.multiply((RealMatrix)mW);
            RealMatrix rx = mX.getRowMatrix(i);
            RealMatrix c = mXTW.multiply((RealMatrix)mX);
            QRDecomposition cd = new QRDecomposition(c);
            DecompositionSolver cdSolver = cd.getSolver();
            try {
                cInv = cdSolver.getInverse();
            }
            catch (NullPointerException | SingularMatrixException badMatrix) {
                return Double.NaN;
            }
            RealMatrix r = rx.multiply(cInv).multiply(mXTW);
            double[] row = r.getRow(0);
            traceS += row[i];
            System.arraycopy(row, 0, bigS[i], 0, nSamples);
        }
        BlockRealMatrix mS = new BlockRealMatrix(bigS);
        double[][] zArray = new double[nSamples][1];
        for (int i = 0; i < nSamples; ++i) {
            zArray[i][0] = samples[i][2];
        }
        BlockRealMatrix mY = new BlockRealMatrix(zArray);
        RealMatrix mYH = mS.multiply((RealMatrix)mY);
        double sse = 0.0;
        for (int i = 0; i < nSamples; ++i) {
            double yHat = mYH.getEntry(i, 0);
            double e = zArray[i][0] - yHat;
            sse += e * e;
        }
        double mls2 = sse / (double)nSamples;
        double lv = Math.log(mls2);
        double x = ((double)nSamples + traceS) / ((double)(nSamples - 2) - traceS);
        return (double)nSamples * (lv + log2PI + x);
    }

    public void initWeightsUsingGaussianKernel(double x, double y, double[][] samples, int nSamples, double bandwidth, double[] weights) {
        if (Double.isInfinite(bandwidth)) {
            Arrays.fill(weights, 0, nSamples, 1.0);
        } else {
            double lambda2 = bandwidth * bandwidth;
            for (int i = 0; i < nSamples; ++i) {
                double dx = samples[i][0] - x;
                double dy = samples[i][1] - y;
                double d2 = dx * dx + dy * dy;
                weights[i] = Math.exp(-0.5 * d2 / lambda2);
            }
        }
    }

    public void initWeightsMatrixUsingGaussianKernel(double[][] samples, int nSamples, double bandwidth, double[][] matrix) {
        if (Double.isInfinite(bandwidth)) {
            for (int i = 0; i < nSamples; ++i) {
                Arrays.fill(matrix[i], 0, nSamples, 1.0);
            }
        } else {
            double lambda2 = bandwidth * bandwidth;
            for (int i = 0; i < nSamples; ++i) {
                double d2;
                double dy;
                double dx;
                int j;
                double x = samples[i][0];
                double y = samples[i][1];
                for (j = 0; j < i; ++j) {
                    dx = samples[j][0] - x;
                    dy = samples[j][1] - y;
                    d2 = dx * dx + dy * dy;
                    matrix[i][j] = Math.exp(-0.5 * d2 / lambda2);
                }
                matrix[i][i] = 1.0;
                for (j = i + 1; j < nSamples; ++j) {
                    dx = samples[j][0] - x;
                    dy = samples[j][1] - y;
                    d2 = dx * dx + dy * dy;
                    matrix[i][j] = Math.exp(-0.5 * d2 / lambda2);
                }
            }
        }
    }

    public boolean isSampleWeightsMatrixSet() {
        return this.sampleWeightsMatrix != null;
    }

    public void setSampleWeightsMatrix(double[][] sampleWeightsMatrix) {
        this.sampleWeightsMatrix = sampleWeightsMatrix;
    }
}

