/*
 * Decompiled with CFR 0.152.
 */
package org.tinfour.regression;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.math3.linear.RealMatrix;
import org.tinfour.common.IIncrementalTin;
import org.tinfour.common.IIncrementalTinNavigator;
import org.tinfour.common.IQuadEdge;
import org.tinfour.common.PolygonConstraint;
import org.tinfour.common.Thresholds;
import org.tinfour.common.Vertex;
import org.tinfour.interpolation.IInterpolatorOverTin;
import org.tinfour.interpolation.IVertexValuator;
import org.tinfour.interpolation.NaturalNeighborElements;
import org.tinfour.interpolation.NaturalNeighborInterpolator;
import org.tinfour.interpolation.VertexValuatorDefault;
import org.tinfour.regression.OlsSurface;
import org.tinfour.regression.SurfaceModel;
import org.tinfour.standard.IncrementalTin;

public class OlsNeighborInterpolator
implements IInterpolatorOverTin {
    private final NaturalNeighborInterpolator nni;
    private final IncrementalTin workTin;
    private final NaturalNeighborInterpolator workNni;
    private final IIncrementalTinNavigator navigator;
    private final Thresholds thresholds;
    private final OlsSurface olsSurface = new OlsSurface();
    private double[] beta;
    private double sigma;
    private double sigma2;
    private double zResult;
    private double xQuery;
    private double yQuery;
    private SelectionMethod selectionMethod;
    private boolean modelFallbackEnabled;
    private PrintStream reportSamples;
    private final SurfaceModel surfaceModel;
    private final List<Vertex> samplesFromRegression = new ArrayList<Vertex>();
    private final VertexValuatorDefault defaultValuator = new VertexValuatorDefault();

    public OlsNeighborInterpolator(IIncrementalTin tin, SurfaceModel model) {
        if (tin == null) {
            throw new IllegalArgumentException("Null TIN instance passed to constructor");
        }
        if (!tin.isBootstrapped()) {
            throw new IllegalArgumentException("Unitialized TIN passed to constructor");
        }
        this.surfaceModel = model;
        this.nni = new NaturalNeighborInterpolator(tin);
        this.thresholds = tin.getThresholds();
        double spacing = this.thresholds.getNominalPointSpacing();
        this.workTin = new IncrementalTin(spacing / 10.0);
        this.workNni = new NaturalNeighborInterpolator((IIncrementalTin)this.workTin);
        this.navigator = tin.getNavigator();
    }

    public OlsNeighborInterpolator(IIncrementalTin tin) {
        if (tin == null) {
            throw new IllegalArgumentException("Null TIN instance passed to constructor");
        }
        if (!tin.isBootstrapped()) {
            throw new IllegalArgumentException("Unitialized TIN passed to constructor");
        }
        this.surfaceModel = SurfaceModel.Quadratic;
        this.nni = new NaturalNeighborInterpolator(tin);
        this.thresholds = tin.getThresholds();
        double spacing = this.thresholds.getNominalPointSpacing();
        this.workTin = new IncrementalTin(spacing / 10.0);
        this.workNni = new NaturalNeighborInterpolator((IIncrementalTin)this.workTin);
        this.navigator = tin.getNavigator();
    }

    public void setModelFallbackEnabled(boolean enabled) {
        this.modelFallbackEnabled = enabled;
    }

    public double interpolate(double x, double y, IVertexValuator valuator) {
        this.clearResults();
        this.xQuery = x;
        this.yQuery = y;
        IQuadEdge edgeQuery = this.getRelatedEdge(x, y);
        if (edgeQuery == null) {
            return Double.NaN;
        }
        return this.computeRegression(x, y, valuator, edgeQuery, false, false);
    }

    public double interpolate(double x, double y, IVertexValuator valuator, boolean computeExtendedStatistics) {
        this.clearResults();
        this.xQuery = x;
        this.yQuery = y;
        IQuadEdge edgeQuery = this.getRelatedEdge(x, y);
        if (edgeQuery == null) {
            return Double.NaN;
        }
        return this.computeRegression(x, y, valuator, edgeQuery, false, computeExtendedStatistics);
    }

    private double computeRegression(double x, double y, IVertexValuator valuator, IQuadEdge edgeQuery, boolean crossValidate, boolean computeExtendedStatistics) {
        SurfaceModel model;
        double[][] samples;
        IVertexValuator vq = valuator;
        if (vq == null) {
            vq = this.defaultValuator;
        }
        Vertex A = edgeQuery.getA();
        double distance = A.getDistance(x, y);
        int k = 0;
        if (distance > this.thresholds.getVertexTolerance() * 8.0) {
            int i;
            this.selectionMethod = SelectionMethod.Neighborhood;
            NaturalNeighborElements innerElements = this.nni.getNaturalNeighborElements(x, y);
            if (innerElements == null) {
                return Double.NaN;
            }
            List envelope = this.nni.getBowyerWatsonEnvelope(x, y);
            NaturalNeighborElements outerElements = this.getAdjacentElements(envelope);
            if (outerElements == null) {
                return Double.NaN;
            }
            int n = innerElements.getElementCount() + outerElements.getElementCount();
            samples = new double[n][3];
            Vertex[] vArray = innerElements.getNaturalNeighbors();
            for (i = 0; i < vArray.length; ++i) {
                this.samplesFromRegression.add(vArray[i]);
                samples[k][0] = vArray[i].getX() - x;
                samples[k][1] = vArray[i].getY() - y;
                samples[k][2] = vq.value(vArray[i]);
                ++k;
            }
            vArray = outerElements.getNaturalNeighbors();
            for (i = 0; i < vArray.length; ++i) {
                this.samplesFromRegression.add(vArray[i]);
                samples[k][0] = vArray[i].getX() - x;
                samples[k][1] = vArray[i].getY() - y;
                samples[k][2] = vq.value(vArray[i]);
                ++k;
            }
        } else {
            int i;
            IQuadEdge edge0 = edgeQuery;
            ArrayList<IQuadEdge> envelope = new ArrayList<IQuadEdge>();
            ArrayList<Vertex> innerList = new ArrayList<Vertex>();
            for (IQuadEdge e : edge0.pinwheel()) {
                envelope.add(e.getForward());
                if (e.getB() == null) {
                    return Double.NaN;
                }
                innerList.add(e.getB());
            }
            this.workTin.clear();
            this.workTin.add(innerList, null);
            if (!this.workTin.isBootstrapped()) {
                this.workTin.clear();
                return Double.NaN;
            }
            this.workNni.resetForChangeToTin();
            NaturalNeighborElements innerElements = this.workNni.getNaturalNeighborElements(x, y);
            if (innerElements == null) {
                return Double.NaN;
            }
            NaturalNeighborElements outerElements = this.getAdjacentElements(envelope);
            if (outerElements == null) {
                return Double.NaN;
            }
            int n = innerElements.getElementCount() + outerElements.getElementCount() + 1;
            samples = new double[n][3];
            Vertex[] vArray = innerElements.getNaturalNeighbors();
            k = 0;
            if (crossValidate) {
                this.selectionMethod = SelectionMethod.CrossValidate;
            } else {
                this.selectionMethod = SelectionMethod.CoincidentVertex;
                Vertex C = edgeQuery.getA();
                samples[0][0] = 0.0;
                samples[0][1] = 0.0;
                samples[0][2] = vq.value(C);
                k = 1;
                this.samplesFromRegression.add(C);
            }
            for (i = 0; i < vArray.length; ++i) {
                this.samplesFromRegression.add(vArray[i]);
                samples[k][0] = vArray[i].getX() - x;
                samples[k][1] = vArray[i].getY() - y;
                samples[k][2] = vq.value(vArray[i]);
                ++k;
            }
            vArray = outerElements.getNaturalNeighbors();
            for (i = 0; i < vArray.length; ++i) {
                this.samplesFromRegression.add(vArray[i]);
                samples[k][0] = vArray[i].getX() - x;
                samples[k][1] = vArray[i].getY() - y;
                samples[k][2] = vq.value(vArray[i]);
                ++k;
            }
        }
        if (this.reportSamples != null) {
            this.writeSamplesToPrintStream(k, samples);
            this.reportSamples = null;
        }
        if (k > (model = this.pickModel(k)).getCoefficientCount()) {
            this.zResult = this.olsSurface.computeRegression(model, 0.0, 0.0, k, samples, computeExtendedStatistics);
            if (Double.isFinite(this.zResult)) {
                this.beta = this.olsSurface.getParameters();
                this.sigma2 = this.olsSurface.getVariance();
                this.sigma = Math.sqrt(this.sigma2);
                return this.zResult;
            }
        }
        return Double.NaN;
    }

    public boolean isSurfaceNormalSupported() {
        return true;
    }

    public double[] getSurfaceNormal() {
        if (Double.isFinite(this.zResult)) {
            double x = this.beta[1];
            double y = this.beta[2];
            double s = Math.sqrt(x * x + y * y + 1.0);
            return new double[]{-x / s, -y / s, 1.0 / s};
        }
        return new double[0];
    }

    public String getMethod() {
        return "OLS Neighbor Interpolation";
    }

    public void resetForChangeToTin() {
        this.navigator.resetForChangeToTin();
        this.nni.resetForChangeToTin();
    }

    public double crossValidate(Vertex v, boolean computeExtendedStatistics) {
        this.clearResults();
        this.xQuery = v.getX();
        this.yQuery = v.getY();
        double x = v.getX();
        double y = v.getY();
        IQuadEdge edgeQuery = this.getRelatedEdge(x, y);
        if (edgeQuery == null) {
            return Double.NaN;
        }
        Vertex A = edgeQuery.getA();
        if (!A.equals(v)) {
            return Double.NaN;
        }
        return this.computeRegression(x, y, null, edgeQuery, true, computeExtendedStatistics);
    }

    public double crossValidate(Vertex v) {
        this.clearResults();
        this.xQuery = v.getX();
        this.yQuery = v.getY();
        double x = v.getX();
        double y = v.getY();
        IQuadEdge edgeQuery = this.getRelatedEdge(x, y);
        if (edgeQuery == null) {
            return Double.NaN;
        }
        Vertex A = edgeQuery.getA();
        if (!A.equals(v)) {
            return Double.NaN;
        }
        return this.computeRegression(x, y, null, edgeQuery, true, false);
    }

    public double[] getInterpolationCoordinates() {
        double[] p = new double[]{this.xQuery, this.yQuery, this.zResult};
        return p;
    }

    private void clearResults() {
        this.beta = null;
        this.sigma = Double.NaN;
        this.sigma2 = Double.NaN;
        this.zResult = Double.NaN;
        this.selectionMethod = SelectionMethod.Neighborhood;
        this.samplesFromRegression.clear();
    }

    private IQuadEdge getRelatedEdge(double x, double y) {
        IQuadEdge e = this.navigator.getNeighborEdge(x, y);
        if (e == null) {
            return null;
        }
        Vertex A = e.getA();
        Vertex B = e.getB();
        double a2 = A.getDistanceSq(x, y);
        double b2 = B.getDistanceSq(x, y);
        if (b2 < a2) {
            IQuadEdge f = e.getForward();
            Vertex C = f.getB();
            if (C == null) {
                return null;
            }
            double c2 = C.getDistanceSq(x, y);
            if (c2 < b2) {
                return f.getForward();
            }
            return f;
        }
        IQuadEdge r = e.getReverse();
        Vertex C = r.getA();
        if (C == null) {
            return null;
        }
        double c2 = C.getDistanceSq(x, y);
        if (c2 < a2) {
            return r;
        }
        return e;
    }

    private NaturalNeighborElements getAdjacentElements(List<IQuadEdge> envelope) {
        int n = envelope.size();
        if (n < 3) {
            return null;
        }
        if (this.reportSamples != null) {
            this.reportSamples.println("Envelope");
            for (IQuadEdge q : envelope) {
                this.reportSamples.println(q.toString());
            }
            this.reportSamples.println("\n\n");
        }
        ArrayList<Vertex> exList = new ArrayList<Vertex>();
        for (IQuadEdge q : envelope) {
            exList.add(q.getA());
        }
        ArrayList<Vertex> list = new ArrayList<Vertex>();
        for (int i = 0; i < n; ++i) {
            IQuadEdge e0 = envelope.get(i);
            IQuadEdge e1 = envelope.get((i + 1) % n);
            Object p = e0.getReverseFromDual().getDual();
            IQuadEdge haltEdge = e1.getForwardFromDual();
            while (!p.equals(haltEdge)) {
                Vertex B = p.getB();
                if (B != null && !exList.contains(B) && !list.contains(B)) {
                    list.add(B);
                    if (this.reportSamples != null) {
                        this.reportSamples.println(p.toString());
                    }
                }
                p = p.getDualFromReverse();
            }
        }
        NaturalNeighborElements nne = null;
        this.workTin.clear();
        this.workTin.add(list, null);
        if (this.workTin.isBootstrapped()) {
            this.workNni.resetForChangeToTin();
            nne = this.workNni.getNaturalNeighborElements(this.xQuery, this.yQuery);
        }
        if (nne == null && list.size() >= 3) {
            List perimeter = this.workTin.getPerimeter();
            PolygonConstraint pc = new PolygonConstraint();
            for (IQuadEdge iEdge : perimeter) {
                pc.add(iEdge.getA());
            }
            pc.complete();
            double areaOfConvexHull = pc.getArea();
            Vertex[] neighbors = list.toArray(new Vertex[0]);
            double[] lambda = new double[neighbors.length];
            Arrays.fill(lambda, 1.0 / (double)lambda.length);
            return new NaturalNeighborElements(this.xQuery, this.yQuery, lambda, neighbors, areaOfConvexHull);
        }
        return nne;
    }

    public double[] getBeta() {
        if (this.beta == null) {
            return new double[0];
        }
        return Arrays.copyOf(this.beta, this.beta.length);
    }

    public double getVariance() {
        return this.sigma2;
    }

    public double getSigma() {
        return this.sigma;
    }

    public double getResultZ() {
        return this.zResult;
    }

    private SurfaceModel pickModel(int n) {
        int k = this.surfaceModel.getCoefficientCount();
        if (n < k + 1 && this.modelFallbackEnabled) {
            return SurfaceModel.Planar;
        }
        return this.surfaceModel;
    }

    public double getConfidenceIntervalHalfSpan(double populationFraction) {
        if (!(0.0 < populationFraction) || !(populationFraction < 1.0)) {
            throw new IllegalArgumentException("Population fraction is not in the range (0,1): " + populationFraction);
        }
        return this.olsSurface.getConfidenceIntervalHalfSpan(populationFraction);
    }

    public double getPredictionIntervalHalfSpan(double populationFraction) {
        if (!(0.0 < populationFraction) || !(populationFraction < 1.0)) {
            throw new IllegalArgumentException("Population fraction is not in the range (0,1): " + populationFraction);
        }
        return this.olsSurface.getPredictonIntervalHalfSpan(populationFraction);
    }

    public void setSampleReportStream(PrintStream ps) {
        this.reportSamples = ps;
    }

    private void writeSamplesToPrintStream(int k, double[][] samples) {
        this.reportSamples.println("x,y,z");
        for (int i = 0; i < k; ++i) {
            this.reportSamples.format("%9.8f\t%9.8f\t%9.8f %n", samples[i][0], samples[i][1], samples[i][2]);
        }
    }

    public SelectionMethod getSelectionMethod() {
        return this.selectionMethod;
    }

    public RealMatrix getHatMatrix() {
        return this.olsSurface.getHatMatrix();
    }

    public double[] getRStudentValues() {
        return this.olsSurface.rStudentValues;
    }

    public int getDegreesOfFreedom() {
        return this.olsSurface.nDegOfFreedom;
    }

    public double[] getStandardErrorOfParameters() {
        return this.olsSurface.getStandardErrorOfParameters();
    }

    public List<Vertex> getVertices() {
        ArrayList<Vertex> list = new ArrayList<Vertex>();
        list.addAll(this.samplesFromRegression);
        return list;
    }

    public double getRSquared() {
        return this.olsSurface.getRSquared();
    }

    public double computeEstimatedValue(double xEstimate, double yEstimate) {
        if (Double.isFinite(this.zResult)) {
            return this.olsSurface.computeEstimatedValue(xEstimate - this.xQuery, yEstimate - this.yQuery);
        }
        return Double.NaN;
    }

    public static enum SelectionMethod {
        Neighborhood,
        CoincidentVertex,
        CrossValidate;

    }
}

