/*
 * Decompiled with CFR 0.152.
 */
package org.tinfour.regression;

import java.util.Arrays;
import org.apache.commons.math3.distribution.TDistribution;
import org.apache.commons.math3.linear.BlockRealMatrix;
import org.apache.commons.math3.linear.DecompositionSolver;
import org.apache.commons.math3.linear.QRDecomposition;
import org.apache.commons.math3.linear.RealMatrix;
import org.apache.commons.math3.linear.SingularMatrixException;
import org.tinfour.regression.SurfaceModel;

public class OlsSurface {
    private double xOffset = Double.NaN;
    private double yOffset = Double.NaN;
    private double zOffset = Double.NaN;
    int nSamples = 0;
    int nVariables = 0;
    int nDegOfFreedom = 0;
    double[] beta = null;
    double zEstimate = Double.NaN;
    double sigma2 = Double.NaN;
    double sse;
    double ssr;
    double sst;
    double r2;
    double standardErrorOfPrediction = Double.NaN;
    double adjustedStandardErrorOfPrediction;
    double[] standardErrorOfParameters = null;
    RealMatrix hat;
    double[] rStudentValues;
    private SurfaceModel model = SurfaceModel.Quadratic;

    public double computeRegression(SurfaceModel model, double xQuery, double yQuery, int nSamples, double[][] samples, boolean computeExtendedStatistics) {
        double xy;
        double xy2;
        double y4;
        double x4;
        double y3;
        double x3;
        double y2;
        double x2;
        double z;
        double y;
        double x;
        int i;
        double[][] input;
        double[][] g;
        this.clear();
        this.model = model;
        if (nSamples < model.getCoefficientCount()) {
            throw new IllegalArgumentException("Insufficient number of samples for regression: found " + nSamples + ", need " + model.getCoefficientCount());
        }
        this.nSamples = nSamples;
        this.xOffset = xQuery;
        this.yOffset = yQuery;
        double zSum = 0.0;
        for (int i2 = 0; i2 < nSamples; ++i2) {
            zSum += samples[i2][2];
        }
        double zMean = zSum / (double)nSamples;
        if (model == SurfaceModel.CubicWithCrossTerms) {
            this.nVariables = 9;
            g = new double[10][1];
            input = new double[10][10];
            input[0][0] = nSamples;
            for (i = 0; i < nSamples; ++i) {
                x = samples[i][0] - xQuery;
                y = samples[i][1] - yQuery;
                z = samples[i][2] - zMean;
                x2 = x * x;
                y2 = y * y;
                x3 = x * x2;
                y3 = y * y2;
                x4 = x2 * x2;
                y4 = y2 * y2;
                xy2 = x * y;
                double[] dArray = input[0];
                dArray[1] = dArray[1] + x;
                double[] dArray2 = input[0];
                dArray2[2] = dArray2[2] + y;
                double[] dArray3 = input[0];
                dArray3[3] = dArray3[3] + x2;
                double[] dArray4 = input[0];
                dArray4[4] = dArray4[4] + y2;
                double[] dArray5 = input[0];
                dArray5[5] = dArray5[5] + xy2;
                double[] dArray6 = input[0];
                dArray6[6] = dArray6[6] + x2 * y;
                double[] dArray7 = input[0];
                dArray7[7] = dArray7[7] + x * y2;
                double[] dArray8 = input[0];
                dArray8[8] = dArray8[8] + x3;
                double[] dArray9 = input[0];
                dArray9[9] = dArray9[9] + y3;
                double[] dArray10 = input[1];
                dArray10[1] = dArray10[1] + x2;
                double[] dArray11 = input[1];
                dArray11[2] = dArray11[2] + xy2;
                double[] dArray12 = input[1];
                dArray12[3] = dArray12[3] + x3;
                double[] dArray13 = input[1];
                dArray13[4] = dArray13[4] + x * y2;
                double[] dArray14 = input[1];
                dArray14[5] = dArray14[5] + x2 * y;
                double[] dArray15 = input[1];
                dArray15[6] = dArray15[6] + x * x2 * y;
                double[] dArray16 = input[1];
                dArray16[7] = dArray16[7] + x * x * y2;
                double[] dArray17 = input[1];
                dArray17[8] = dArray17[8] + x * x3;
                double[] dArray18 = input[1];
                dArray18[9] = dArray18[9] + x * y3;
                double[] dArray19 = input[2];
                dArray19[2] = dArray19[2] + y2;
                double[] dArray20 = input[2];
                dArray20[3] = dArray20[3] + x2 * y;
                double[] dArray21 = input[2];
                dArray21[4] = dArray21[4] + y3;
                double[] dArray22 = input[2];
                dArray22[5] = dArray22[5] + x * y2;
                double[] dArray23 = input[2];
                dArray23[6] = dArray23[6] + y * x2 * y;
                double[] dArray24 = input[2];
                dArray24[7] = dArray24[7] + y * x * y2;
                double[] dArray25 = input[2];
                dArray25[8] = dArray25[8] + y * x3;
                double[] dArray26 = input[2];
                dArray26[9] = dArray26[9] + y * y3;
                double[] dArray27 = input[3];
                dArray27[3] = dArray27[3] + x4;
                double[] dArray28 = input[3];
                dArray28[4] = dArray28[4] + x2 * y2;
                double[] dArray29 = input[3];
                dArray29[5] = dArray29[5] + x3 * y;
                double[] dArray30 = input[3];
                dArray30[6] = dArray30[6] + x2 * x2 * y;
                double[] dArray31 = input[3];
                dArray31[7] = dArray31[7] + x2 * x * y2;
                double[] dArray32 = input[3];
                dArray32[8] = dArray32[8] + x2 * x3;
                double[] dArray33 = input[3];
                dArray33[9] = dArray33[9] + x2 * y3;
                double[] dArray34 = input[4];
                dArray34[4] = dArray34[4] + y4;
                double[] dArray35 = input[4];
                dArray35[5] = dArray35[5] + x * y3;
                double[] dArray36 = input[4];
                dArray36[6] = dArray36[6] + y2 * x2 * y;
                double[] dArray37 = input[4];
                dArray37[7] = dArray37[7] + y2 * x * y2;
                double[] dArray38 = input[4];
                dArray38[8] = dArray38[8] + y2 * x3;
                double[] dArray39 = input[4];
                dArray39[9] = dArray39[9] + y2 * y3;
                double[] dArray40 = input[5];
                dArray40[5] = dArray40[5] + x2 * y2;
                double[] dArray41 = input[5];
                dArray41[6] = dArray41[6] + xy2 * x2 * y;
                double[] dArray42 = input[5];
                dArray42[7] = dArray42[7] + xy2 * x * y2;
                double[] dArray43 = input[5];
                dArray43[8] = dArray43[8] + xy2 * x3;
                double[] dArray44 = input[5];
                dArray44[9] = dArray44[9] + xy2 * y3;
                double[] dArray45 = input[6];
                dArray45[6] = dArray45[6] + x2 * y * x2 * y;
                double[] dArray46 = input[6];
                dArray46[7] = dArray46[7] + x2 * y * x * y2;
                double[] dArray47 = input[6];
                dArray47[8] = dArray47[8] + x2 * y * x3;
                double[] dArray48 = input[6];
                dArray48[9] = dArray48[9] + x2 * y * y3;
                double[] dArray49 = input[7];
                dArray49[7] = dArray49[7] + y2 * x * x * y2;
                double[] dArray50 = input[7];
                dArray50[8] = dArray50[8] + y2 * x * x3;
                double[] dArray51 = input[7];
                dArray51[9] = dArray51[9] + y2 * x * y3;
                double[] dArray52 = input[8];
                dArray52[8] = dArray52[8] + x3 * x3;
                double[] dArray53 = input[8];
                dArray53[9] = dArray53[9] + x3 * y3;
                double[] dArray54 = input[9];
                dArray54[9] = dArray54[9] + y3 * y3;
                double[] dArray55 = g[0];
                dArray55[0] = dArray55[0] + z;
                double[] dArray56 = g[1];
                dArray56[0] = dArray56[0] + x * z;
                double[] dArray57 = g[2];
                dArray57[0] = dArray57[0] + y * z;
                double[] dArray58 = g[3];
                dArray58[0] = dArray58[0] + x2 * z;
                double[] dArray59 = g[4];
                dArray59[0] = dArray59[0] + y2 * z;
                double[] dArray60 = g[5];
                dArray60[0] = dArray60[0] + xy2 * z;
                double[] dArray61 = g[6];
                dArray61[0] = dArray61[0] + x2 * y * z;
                double[] dArray62 = g[7];
                dArray62[0] = dArray62[0] + x * y2 * z;
                double[] dArray63 = g[8];
                dArray63[0] = dArray63[0] + x3 * z;
                double[] dArray64 = g[9];
                dArray64[0] = dArray64[0] + y3 * z;
            }
            input[1][0] = input[0][1];
            input[2][0] = input[0][2];
            input[2][1] = input[1][2];
            input[3][0] = input[0][3];
            input[3][1] = input[1][3];
            input[3][2] = input[2][3];
            input[4][0] = input[0][4];
            input[4][1] = input[1][4];
            input[4][2] = input[2][4];
            input[4][3] = input[3][4];
            input[5][0] = input[0][5];
            input[5][1] = input[1][5];
            input[5][2] = input[2][5];
            input[5][3] = input[3][5];
            input[5][4] = input[4][5];
            input[6][0] = input[0][6];
            input[6][1] = input[1][6];
            input[6][2] = input[2][6];
            input[6][3] = input[3][6];
            input[6][4] = input[4][6];
            input[6][5] = input[5][6];
            input[7][0] = input[0][7];
            input[7][1] = input[1][7];
            input[7][2] = input[2][7];
            input[7][3] = input[3][7];
            input[7][4] = input[4][7];
            input[7][5] = input[5][7];
            input[7][6] = input[6][7];
            input[8][0] = input[0][8];
            input[8][1] = input[1][8];
            input[8][2] = input[2][8];
            input[8][3] = input[3][8];
            input[8][4] = input[4][8];
            input[8][5] = input[5][8];
            input[8][6] = input[6][8];
            input[8][7] = input[7][8];
            input[9][0] = input[0][9];
            input[9][1] = input[1][9];
            input[9][2] = input[2][9];
            input[9][3] = input[3][9];
            input[9][4] = input[4][9];
            input[9][5] = input[5][9];
            input[9][6] = input[6][9];
            input[9][7] = input[7][9];
            input[9][8] = input[8][9];
        } else if (model == SurfaceModel.QuadraticWithCrossTerms) {
            this.nVariables = 5;
            g = new double[6][1];
            input = new double[6][6];
            input[0][0] = nSamples;
            for (i = 0; i < nSamples; ++i) {
                x = samples[i][0] - xQuery;
                y = samples[i][1] - yQuery;
                z = samples[i][2] - zMean;
                x2 = x * x;
                y2 = y * y;
                x3 = x * x2;
                y3 = y * y2;
                x4 = x2 * x2;
                y4 = y2 * y2;
                xy2 = x * y;
                double[] dArray = input[0];
                dArray[1] = dArray[1] + x;
                double[] dArray65 = input[0];
                dArray65[2] = dArray65[2] + y;
                double[] dArray66 = input[0];
                dArray66[3] = dArray66[3] + x2;
                double[] dArray67 = input[0];
                dArray67[4] = dArray67[4] + y2;
                double[] dArray68 = input[0];
                dArray68[5] = dArray68[5] + xy2;
                double[] dArray69 = input[1];
                dArray69[1] = dArray69[1] + x2;
                double[] dArray70 = input[1];
                dArray70[2] = dArray70[2] + xy2;
                double[] dArray71 = input[1];
                dArray71[3] = dArray71[3] + x * x2;
                double[] dArray72 = input[1];
                dArray72[4] = dArray72[4] + x * y2;
                double[] dArray73 = input[1];
                dArray73[5] = dArray73[5] + x * xy2;
                double[] dArray74 = input[2];
                dArray74[2] = dArray74[2] + y2;
                double[] dArray75 = input[2];
                dArray75[3] = dArray75[3] + x2 * y;
                double[] dArray76 = input[2];
                dArray76[4] = dArray76[4] + y3;
                double[] dArray77 = input[2];
                dArray77[5] = dArray77[5] + x * y2;
                double[] dArray78 = input[3];
                dArray78[3] = dArray78[3] + x4;
                double[] dArray79 = input[3];
                dArray79[4] = dArray79[4] + x2 * y2;
                double[] dArray80 = input[3];
                dArray80[5] = dArray80[5] + x3 * y;
                double[] dArray81 = input[4];
                dArray81[4] = dArray81[4] + y4;
                double[] dArray82 = input[4];
                dArray82[5] = dArray82[5] + x * y3;
                double[] dArray83 = input[5];
                dArray83[5] = dArray83[5] + x2 * y2;
                double[] dArray84 = g[0];
                dArray84[0] = dArray84[0] + z;
                double[] dArray85 = g[1];
                dArray85[0] = dArray85[0] + x * z;
                double[] dArray86 = g[2];
                dArray86[0] = dArray86[0] + y * z;
                double[] dArray87 = g[3];
                dArray87[0] = dArray87[0] + x2 * z;
                double[] dArray88 = g[4];
                dArray88[0] = dArray88[0] + y2 * z;
                double[] dArray89 = g[5];
                dArray89[0] = dArray89[0] + xy2 * z;
            }
            input[1][0] = input[0][1];
            input[2][0] = input[0][2];
            input[2][1] = input[1][2];
            input[3][0] = input[0][3];
            input[3][1] = input[1][3];
            input[3][2] = input[2][3];
            input[4][0] = input[0][4];
            input[4][1] = input[1][4];
            input[4][2] = input[2][4];
            input[4][3] = input[3][4];
            input[5][0] = input[0][5];
            input[5][1] = input[1][5];
            input[5][2] = input[2][5];
            input[5][3] = input[3][5];
            input[5][4] = input[4][5];
        } else if (model == SurfaceModel.Quadratic) {
            this.nVariables = 4;
            g = new double[5][1];
            input = new double[5][5];
            input[0][0] = nSamples;
            for (i = 0; i < nSamples; ++i) {
                x = samples[i][0] - xQuery;
                y = samples[i][1] - yQuery;
                z = samples[i][2] - zMean;
                x2 = x * x;
                y2 = y * y;
                double[] dArray = input[0];
                dArray[1] = dArray[1] + x;
                double[] dArray90 = input[0];
                dArray90[2] = dArray90[2] + y;
                double[] dArray91 = input[0];
                dArray91[3] = dArray91[3] + x2;
                double[] dArray92 = input[0];
                dArray92[4] = dArray92[4] + y2;
                double[] dArray93 = input[1];
                dArray93[1] = dArray93[1] + x2;
                double[] dArray94 = input[1];
                dArray94[2] = dArray94[2] + x * y;
                double[] dArray95 = input[1];
                dArray95[3] = dArray95[3] + x * x2;
                double[] dArray96 = input[1];
                dArray96[4] = dArray96[4] + x * y2;
                double[] dArray97 = input[2];
                dArray97[2] = dArray97[2] + y2;
                double[] dArray98 = input[2];
                dArray98[3] = dArray98[3] + y * x2;
                double[] dArray99 = input[2];
                dArray99[4] = dArray99[4] + y * y2;
                double[] dArray100 = input[3];
                dArray100[3] = dArray100[3] + x2 * x2;
                double[] dArray101 = input[3];
                dArray101[4] = dArray101[4] + x2 * y2;
                double[] dArray102 = input[4];
                dArray102[4] = dArray102[4] + y2 * y2;
                double[] dArray103 = g[0];
                dArray103[0] = dArray103[0] + z;
                double[] dArray104 = g[1];
                dArray104[0] = dArray104[0] + x * z;
                double[] dArray105 = g[2];
                dArray105[0] = dArray105[0] + y * z;
                double[] dArray106 = g[3];
                dArray106[0] = dArray106[0] + x2 * z;
                double[] dArray107 = g[4];
                dArray107[0] = dArray107[0] + y2 * z;
            }
            input[1][0] = input[0][1];
            input[2][0] = input[0][2];
            input[2][1] = input[1][2];
            input[3][0] = input[0][3];
            input[3][1] = input[1][3];
            input[3][2] = input[2][3];
            input[4][0] = input[0][4];
            input[4][1] = input[1][4];
            input[4][2] = input[2][4];
            input[4][3] = input[3][4];
        } else if (model == SurfaceModel.Planar) {
            this.nVariables = 2;
            g = new double[3][1];
            input = new double[3][3];
            input[0][0] = nSamples;
            for (i = 0; i < nSamples; ++i) {
                x = samples[i][0] - xQuery;
                y = samples[i][1] - yQuery;
                z = samples[i][2] - zMean;
                x2 = x * x;
                y2 = y * y;
                double[] dArray = input[0];
                dArray[1] = dArray[1] + x;
                double[] dArray108 = input[0];
                dArray108[2] = dArray108[2] + y;
                double[] dArray109 = input[1];
                dArray109[1] = dArray109[1] + x2;
                double[] dArray110 = input[1];
                dArray110[2] = dArray110[2] + x * y;
                double[] dArray111 = input[2];
                dArray111[2] = dArray111[2] + y2;
                double[] dArray112 = g[0];
                dArray112[0] = dArray112[0] + z;
                double[] dArray113 = g[1];
                dArray113[0] = dArray113[0] + x * z;
                double[] dArray114 = g[2];
                dArray114[0] = dArray114[0] + y * z;
            }
            input[1][0] = input[0][1];
            input[2][0] = input[0][2];
            input[2][1] = input[1][2];
        } else if (model == SurfaceModel.PlanarWithCrossTerms) {
            this.nVariables = 3;
            g = new double[4][1];
            input = new double[4][4];
            input[0][0] = nSamples;
            for (i = 0; i < nSamples; ++i) {
                x = samples[i][0] - xQuery;
                y = samples[i][1] - yQuery;
                z = samples[i][2] - zMean;
                x2 = x * x;
                y2 = y * y;
                xy = x * y;
                double[] dArray = input[0];
                dArray[1] = dArray[1] + x;
                double[] dArray115 = input[0];
                dArray115[2] = dArray115[2] + y;
                double[] dArray116 = input[0];
                dArray116[3] = dArray116[3] + xy;
                double[] dArray117 = input[1];
                dArray117[1] = dArray117[1] + x2;
                double[] dArray118 = input[1];
                dArray118[2] = dArray118[2] + xy;
                double[] dArray119 = input[1];
                dArray119[3] = dArray119[3] + xy * x;
                double[] dArray120 = input[2];
                dArray120[2] = dArray120[2] + y2;
                double[] dArray121 = input[2];
                dArray121[3] = dArray121[3] + xy * y;
                double[] dArray122 = input[3];
                dArray122[3] = dArray122[3] + xy * xy;
                double[] dArray123 = g[0];
                dArray123[0] = dArray123[0] + z;
                double[] dArray124 = g[1];
                dArray124[0] = dArray124[0] + x * z;
                double[] dArray125 = g[2];
                dArray125[0] = dArray125[0] + y * z;
                double[] dArray126 = g[3];
                dArray126[0] = dArray126[0] + xy * z;
            }
            input[1][0] = input[0][1];
            input[2][0] = input[0][2];
            input[2][1] = input[1][2];
            input[3][0] = input[0][3];
            input[3][1] = input[1][3];
            input[3][2] = input[2][3];
        } else {
            this.nVariables = 6;
            g = new double[7][1];
            input = new double[7][7];
            input[0][0] = nSamples;
            for (i = 0; i < nSamples; ++i) {
                x = samples[i][0] - xQuery;
                y = samples[i][1] - yQuery;
                z = samples[i][2] - zMean;
                x2 = x * x;
                y2 = y * y;
                xy = x * y;
                double x32 = x * x2;
                double y32 = y * y2;
                double x42 = x2 * x2;
                double y42 = y2 * y2;
                double[] dArray = input[0];
                dArray[1] = dArray[1] + x;
                double[] dArray127 = input[0];
                dArray127[2] = dArray127[2] + y;
                double[] dArray128 = input[0];
                dArray128[3] = dArray128[3] + x2;
                double[] dArray129 = input[0];
                dArray129[4] = dArray129[4] + y2;
                double[] dArray130 = input[0];
                dArray130[5] = dArray130[5] + x32;
                double[] dArray131 = input[0];
                dArray131[6] = dArray131[6] + y32;
                double[] dArray132 = input[1];
                dArray132[1] = dArray132[1] + x2;
                double[] dArray133 = input[1];
                dArray133[2] = dArray133[2] + xy;
                double[] dArray134 = input[1];
                dArray134[3] = dArray134[3] + x32;
                double[] dArray135 = input[1];
                dArray135[4] = dArray135[4] + y2 * x;
                double[] dArray136 = input[1];
                dArray136[5] = dArray136[5] + x42;
                double[] dArray137 = input[1];
                dArray137[6] = dArray137[6] + y32 * x;
                double[] dArray138 = input[2];
                dArray138[2] = dArray138[2] + y2;
                double[] dArray139 = input[2];
                dArray139[3] = dArray139[3] + x2 * y;
                double[] dArray140 = input[2];
                dArray140[4] = dArray140[4] + y32;
                double[] dArray141 = input[2];
                dArray141[5] = dArray141[5] + x32 * y;
                double[] dArray142 = input[2];
                dArray142[6] = dArray142[6] + y42;
                double[] dArray143 = input[3];
                dArray143[3] = dArray143[3] + x42;
                double[] dArray144 = input[3];
                dArray144[4] = dArray144[4] + y2 * x2;
                double[] dArray145 = input[3];
                dArray145[5] = dArray145[5] + x32 * x2;
                double[] dArray146 = input[3];
                dArray146[6] = dArray146[6] + y32 * x2;
                double[] dArray147 = input[4];
                dArray147[4] = dArray147[4] + y42;
                double[] dArray148 = input[4];
                dArray148[5] = dArray148[5] + x32 * y2;
                double[] dArray149 = input[4];
                dArray149[6] = dArray149[6] + y32 * y2;
                double[] dArray150 = input[5];
                dArray150[5] = dArray150[5] + x32 * x32;
                double[] dArray151 = input[5];
                dArray151[6] = dArray151[6] + y32 * x32;
                double[] dArray152 = input[6];
                dArray152[6] = dArray152[6] + y32 * y32;
                double[] dArray153 = g[0];
                dArray153[0] = dArray153[0] + z;
                double[] dArray154 = g[1];
                dArray154[0] = dArray154[0] + x * z;
                double[] dArray155 = g[2];
                dArray155[0] = dArray155[0] + y * z;
                double[] dArray156 = g[3];
                dArray156[0] = dArray156[0] + x2 * z;
                double[] dArray157 = g[4];
                dArray157[0] = dArray157[0] + y2 * z;
                double[] dArray158 = g[5];
                dArray158[0] = dArray158[0] + x32 * z;
                double[] dArray159 = g[6];
                dArray159[0] = dArray159[0] + y32 * z;
            }
            input[1][0] = input[0][1];
            input[2][0] = input[0][2];
            input[2][1] = input[1][2];
            input[3][0] = input[0][3];
            input[3][1] = input[1][3];
            input[3][2] = input[2][3];
            input[4][0] = input[0][4];
            input[4][1] = input[1][4];
            input[4][2] = input[2][4];
            input[4][3] = input[3][4];
            input[5][0] = input[0][5];
            input[5][1] = input[1][5];
            input[5][2] = input[2][5];
            input[5][3] = input[3][5];
            input[5][4] = input[4][5];
            input[6][0] = input[0][6];
            input[6][1] = input[1][6];
            input[6][2] = input[2][6];
            input[6][3] = input[3][6];
            input[6][4] = input[4][6];
            input[6][5] = input[5][6];
        }
        this.nDegOfFreedom = nSamples - this.nVariables - 1;
        if (this.nDegOfFreedom < 1) {
            throw new IllegalArgumentException("Inadequate sample size " + nSamples + " for " + this.nDegOfFreedom + " degrees of freedom");
        }
        BlockRealMatrix matrixG = new BlockRealMatrix(g);
        BlockRealMatrix matrixA = new BlockRealMatrix(input);
        try {
            QRDecomposition cd = new QRDecomposition((RealMatrix)matrixA);
            DecompositionSolver solver = cd.getSolver();
            RealMatrix solution = solver.solve((RealMatrix)matrixG);
            RealMatrix aInv = solver.getInverse();
            this.beta = new double[this.nVariables + 1];
            for (int i3 = 0; i3 < this.beta.length; ++i3) {
                this.beta[i3] = solution.getEntry(i3, 0);
            }
            this.zOffset = zMean;
            this.zEstimate = zMean + this.beta[0];
            double[] e = new double[nSamples];
            this.initializeResidualArray(model, nSamples, samples, e);
            this.sigma2 = this.sse / (double)this.nDegOfFreedom;
            this.standardErrorOfPrediction = Math.sqrt(this.sigma2 * aInv.getEntry(0, 0));
            this.adjustedStandardErrorOfPrediction = Math.sqrt(this.sigma2 * (1.0 + aInv.getEntry(0, 0)));
            this.r2 = this.ssr / this.sst;
            this.standardErrorOfParameters = new double[this.nVariables + 1];
            for (int i4 = 0; i4 < this.standardErrorOfParameters.length; ++i4) {
                this.standardErrorOfParameters[i4] = Math.sqrt(this.sigma2 * aInv.getEntry(i4, i4));
            }
            if (computeExtendedStatistics) {
                double[][] dm = this.computeDesignMatrix(model, nSamples, samples);
                BlockRealMatrix mX = new BlockRealMatrix(dm);
                RealMatrix mXT = mX.transpose();
                RealMatrix hat = mX.multiply(aInv).multiply(mXT);
                this.rStudentValues = new double[nSamples];
                for (int i5 = 0; i5 < nSamples; ++i5) {
                    double s2 = 0.0;
                    for (int j = 0; j < nSamples; ++j) {
                        if (j == i5) continue;
                        s2 += e[i5] * e[i5];
                    }
                    double s1 = Math.sqrt(s2 / (double)(this.nDegOfFreedom - 1));
                    double hii = hat.getEntry(i5, i5);
                    this.rStudentValues[i5] = e[i5] / (s1 * Math.sqrt(1.0 - hii));
                }
            }
        }
        catch (SingularMatrixException npex) {
            return Double.NaN;
        }
        return this.zEstimate;
    }

    public double[] getParameters() {
        if (this.beta == null) {
            return new double[0];
        }
        return Arrays.copyOf(this.beta, this.beta.length);
    }

    public double[] getStandardErrorOfParameters() {
        if (this.standardErrorOfParameters == null) {
            return new double[0];
        }
        return Arrays.copyOf(this.standardErrorOfParameters, this.standardErrorOfParameters.length);
    }

    public double getVariance() {
        return this.sigma2;
    }

    public double getStandardErrorOfPrediction() {
        return this.standardErrorOfPrediction;
    }

    public int getDegreesOfFreedom() {
        return this.nDegOfFreedom;
    }

    public final int getMinimumRequiredSamples(SurfaceModel sm) {
        return sm.getCoefficientCount() + 1;
    }

    public double[] getQueryCoordinates() {
        double[] p = new double[]{this.xOffset, this.yOffset};
        return p;
    }

    public double getOffsetX() {
        return this.xOffset;
    }

    public double getOffsetY() {
        return this.yOffset;
    }

    public double getOffsetZ() {
        return this.zOffset;
    }

    public double getEstimatedZ() {
        return this.zEstimate;
    }

    public SurfaceModel getModel() {
        return this.model;
    }

    public double computeEstimatedValue(double xEstimate, double yEstimate) {
        double x = xEstimate - this.xOffset;
        double y = yEstimate - this.yOffset;
        switch (this.model) {
            case Planar: {
                return this.beta[0] + (this.beta[1] * x + this.beta[2] * y) + this.zOffset;
            }
            case PlanarWithCrossTerms: {
                return this.beta[0] + (this.beta[1] * x + this.beta[2] * y + this.beta[3] * x * y) + this.zOffset;
            }
            case QuadraticWithCrossTerms: {
                return this.beta[0] + (this.beta[1] * x + this.beta[2] * y + this.beta[3] * x * x + this.beta[4] * y * y + this.beta[5] * x * y) + this.zOffset;
            }
            case Quadratic: {
                return this.beta[0] + (this.beta[1] * x + this.beta[2] * y + this.beta[3] * x * x + this.beta[4] * y * y) + this.zOffset;
            }
            case CubicWithCrossTerms: {
                return this.beta[0] + (this.beta[1] * x + this.beta[2] * y + this.beta[3] * x * x + this.beta[4] * y * y + this.beta[5] * x * y + this.beta[6] * x * x * y + this.beta[7] * x * y * y + this.beta[8] * x * x * x + this.beta[9] * y * y * y) + this.zOffset;
            }
            case Cubic: {
                return this.beta[0] + (this.beta[1] * x + this.beta[2] * y + this.beta[3] * x * x + this.beta[4] * y * y + this.beta[5] * x * x * x + this.beta[6] * y * y * y) + this.zOffset;
            }
        }
        return Double.NaN;
    }

    void clear() {
        this.xOffset = Double.NaN;
        this.yOffset = Double.NaN;
        this.zOffset = Double.NaN;
        this.zEstimate = Double.NaN;
        this.sigma2 = Double.NaN;
        this.standardErrorOfPrediction = Double.NaN;
        this.nSamples = 0;
        this.nDegOfFreedom = 0;
        this.nVariables = 0;
        this.beta = null;
        this.standardErrorOfParameters = null;
        this.hat = null;
    }

    public double getConfidenceIntervalHalfSpan(double populationFraction) {
        if (!(0.0 < populationFraction) || !(populationFraction < 1.0)) {
            throw new IllegalArgumentException("Population fraction is not in the range (0,1): " + populationFraction);
        }
        double alpha = 1.0 - populationFraction;
        TDistribution td = new TDistribution((double)this.nDegOfFreedom);
        double ta = td.inverseCumulativeProbability(1.0 - alpha / 2.0);
        return ta * this.standardErrorOfPrediction;
    }

    public double getPredictonIntervalHalfSpan(double populationFraction) {
        if (!(0.0 < populationFraction) || !(populationFraction < 1.0)) {
            throw new IllegalArgumentException("Population fraction is not in the range (0,1): " + populationFraction);
        }
        double alpha = 1.0 - populationFraction;
        TDistribution td = new TDistribution((double)this.nDegOfFreedom);
        double ta = td.inverseCumulativeProbability(1.0 - alpha / 2.0);
        return ta * this.adjustedStandardErrorOfPrediction;
    }

    double[][] computeDesignMatrix(SurfaceModel sm, int n, double[][] s) {
        double[][] matrix;
        if (sm == SurfaceModel.CubicWithCrossTerms) {
            matrix = new double[n][10];
            for (int i = 0; i < n; ++i) {
                double x = s[i][0] - this.xOffset;
                double y = s[i][1] - this.yOffset;
                double x2 = x * x;
                double y2 = y * y;
                double x3 = x * x2;
                double y3 = y * y2;
                double xy = x * y;
                matrix[i][0] = 1.0;
                matrix[i][1] = x;
                matrix[i][2] = y;
                matrix[i][3] = x2;
                matrix[i][4] = y2;
                matrix[i][5] = xy;
                matrix[i][6] = x2 * y;
                matrix[i][7] = x * y2;
                matrix[i][8] = x3;
                matrix[i][9] = y3;
            }
        } else if (sm == SurfaceModel.QuadraticWithCrossTerms) {
            matrix = new double[n][6];
            for (int i = 0; i < n; ++i) {
                double x = s[i][0] - this.xOffset;
                double y = s[i][1] - this.yOffset;
                double x2 = x * x;
                double y2 = y * y;
                double xy = x * y;
                matrix[i][0] = 1.0;
                matrix[i][1] = x;
                matrix[i][2] = y;
                matrix[i][3] = x2;
                matrix[i][4] = y2;
                matrix[i][5] = xy;
            }
        } else if (sm == SurfaceModel.Quadratic) {
            matrix = new double[n][5];
            for (int i = 0; i < n; ++i) {
                double x = s[i][0] - this.xOffset;
                double y = s[i][1] - this.yOffset;
                double x2 = x * x;
                double y2 = y * y;
                matrix[i][0] = 1.0;
                matrix[i][1] = x;
                matrix[i][2] = y;
                matrix[i][3] = x2;
                matrix[i][4] = y2;
            }
        } else if (sm == SurfaceModel.Planar) {
            matrix = new double[n][3];
            for (int i = 0; i < n; ++i) {
                double x = s[i][0] - this.xOffset;
                double y = s[i][1] - this.yOffset;
                matrix[i][0] = 1.0;
                matrix[i][1] = x;
                matrix[i][2] = y;
            }
        } else if (sm == SurfaceModel.PlanarWithCrossTerms) {
            matrix = new double[n][4];
            for (int i = 0; i < n; ++i) {
                double x = s[i][0] - this.xOffset;
                double y = s[i][1] - this.yOffset;
                double xy = x * y;
                matrix[i][0] = 1.0;
                matrix[i][1] = x;
                matrix[i][2] = y;
                matrix[i][3] = xy;
            }
        } else {
            matrix = new double[n][7];
            for (int i = 0; i < n; ++i) {
                double x = s[i][0] - this.xOffset;
                double y = s[i][1] - this.yOffset;
                double x2 = x * x;
                double y2 = y * y;
                double x3 = x * x2;
                double y3 = y * y2;
                matrix[i][0] = 1.0;
                matrix[i][1] = x;
                matrix[i][2] = y;
                matrix[i][3] = x2;
                matrix[i][4] = y2;
                matrix[i][5] = x3;
                matrix[i][6] = y3;
            }
        }
        return matrix;
    }

    public String toString() {
        return "Ordinary Least Squares: model=" + this.model == null ? "None" : this.model.name();
    }

    RealMatrix getHatMatrix() {
        return this.hat;
    }

    double initializeResidualArray(SurfaceModel sm, int n, double[][] s, double[] r) {
        double r2Sum = 0.0;
        this.sst = 0.0;
        if (sm == SurfaceModel.CubicWithCrossTerms) {
            double b0 = this.beta[0];
            double b1 = this.beta[1];
            double b2 = this.beta[2];
            double b3 = this.beta[3];
            double b4 = this.beta[4];
            double b5 = this.beta[5];
            double b6 = this.beta[6];
            double b7 = this.beta[7];
            double b8 = this.beta[9];
            double b9 = this.beta[10];
            for (int i = 0; i < n; ++i) {
                double x = s[i][0] - this.xOffset;
                double y = s[i][1] - this.yOffset;
                double z = s[i][2] - this.zOffset;
                double x2 = x * x;
                double y2 = y * y;
                double x3 = x * x2;
                double y3 = y * y2;
                double xy = x * y;
                r[i] = b0 + b1 * x + b2 * y + b3 * x2 + b4 * y2 + b5 * xy + b6 * x2 * y + b7 * x * y2 + b8 * x3 + b9 * y3 - z;
                r2Sum += r[i] * r[i];
                this.sst += z * z;
            }
        } else if (sm == SurfaceModel.QuadraticWithCrossTerms) {
            double b0 = this.beta[0];
            double b1 = this.beta[1];
            double b2 = this.beta[2];
            double b3 = this.beta[3];
            double b4 = this.beta[4];
            double b5 = this.beta[5];
            for (int i = 0; i < n; ++i) {
                double x = s[i][0] - this.xOffset;
                double y = s[i][1] - this.yOffset;
                double x2 = x * x;
                double y2 = y * y;
                double xy = x * y;
                double z = s[i][2] - this.zOffset;
                r[i] = b0 + b1 * x + b2 * y + b3 * x2 + b4 * y2 + b5 * xy - z;
                r2Sum += r[i] * r[i];
                this.sst += z * z;
            }
        } else if (sm == SurfaceModel.Quadratic) {
            double b0 = this.beta[0];
            double b1 = this.beta[1];
            double b2 = this.beta[2];
            double b3 = this.beta[3];
            double b4 = this.beta[4];
            for (int i = 0; i < n; ++i) {
                double x = s[i][0] - this.xOffset;
                double y = s[i][1] - this.yOffset;
                double x2 = x * x;
                double y2 = y * y;
                double z = s[i][2] - this.zOffset;
                double q = b0 + b1 * x + b2 * y + b3 * x2 + b4 * y2 - z;
                r2Sum += q * q;
                r[i] = q;
                this.sst += z * z;
            }
        } else if (sm == SurfaceModel.Planar) {
            double b0 = this.beta[0];
            double b1 = this.beta[1];
            double b2 = this.beta[2];
            for (int i = 0; i < n; ++i) {
                double x = s[i][0] - this.xOffset;
                double y = s[i][1] - this.yOffset;
                double z = s[i][2] - this.zOffset;
                r[i] = b0 + b1 * x + b2 * y - z;
                r2Sum += r[i] * r[i];
                this.sst += z * z;
            }
        } else if (sm == SurfaceModel.PlanarWithCrossTerms) {
            double b0 = this.beta[0];
            double b1 = this.beta[1];
            double b2 = this.beta[2];
            double b3 = this.beta[3];
            for (int i = 0; i < n; ++i) {
                double x = s[i][0] - this.xOffset;
                double y = s[i][1] - this.yOffset;
                double xy = x * y;
                double z = s[i][2] - this.zOffset;
                r[i] = b0 + b1 * x + b2 * y + b3 * xy - z;
                r2Sum += r[i] * r[i];
                this.sst += z * z;
            }
        } else {
            double b0 = this.beta[0];
            double b1 = this.beta[1];
            double b2 = this.beta[2];
            double b3 = this.beta[3];
            double b4 = this.beta[4];
            double b5 = this.beta[5];
            double b6 = this.beta[6];
            for (int i = 0; i < n; ++i) {
                double x = s[i][0] - this.xOffset;
                double y = s[i][1] - this.yOffset;
                double x2 = x * x;
                double y2 = y * y;
                double x3 = x * x2;
                double y3 = y * y2;
                double z = s[i][2] - this.zOffset;
                r[i] = b0 + b1 * x + b2 * y + b3 * x2 + b4 * y2 + b5 * x3 + b6 * y3 - z;
                r2Sum += r[i] * r[i];
                this.sst += z * z;
            }
        }
        this.sse = r2Sum;
        this.ssr = this.sst - this.sse;
        return r2Sum;
    }

    public double getRSquared() {
        return this.r2;
    }
}

