/*
 * Decompiled with CFR 0.152.
 */
package org.tinfour.regression;

public enum SurfaceModel {
    Planar(3, "PLN"),
    PlanarWithCrossTerms(4, "PWC"),
    Quadratic(5, "QDR"),
    QuadraticWithCrossTerms(6, "QWC"),
    Cubic(7, "CUB"),
    CubicWithCrossTerms(10, "CWC");

    final int nCoefficients;
    final String abbreviation;

    private SurfaceModel(int nCoefficients, String abbreviation) {
        this.nCoefficients = nCoefficients;
        this.abbreviation = abbreviation;
    }

    public int getCoefficientCount() {
        return this.nCoefficients;
    }

    public int getIndependentVariableCount() {
        return this.nCoefficients - 1;
    }

    public String getAbbreviation() {
        return this.abbreviation;
    }
}

