/*
 * Decompiled with CFR 0.152.
 */
package org.tinfour.common;

import org.tinfour.common.IConstraint;
import org.tinfour.common.IIncrementalTin;
import org.tinfour.common.IQuadEdge;
import org.tinfour.common.Vertex;

public class SimpleTriangle {
    private final IIncrementalTin tin;
    private final IQuadEdge edgeA;
    private final IQuadEdge edgeB;
    private final IQuadEdge edgeC;

    public SimpleTriangle(IIncrementalTin tin, IQuadEdge a, IQuadEdge b, IQuadEdge c) {
        this.tin = tin;
        this.edgeA = a;
        this.edgeB = b;
        this.edgeC = c;
    }

    public IQuadEdge getEdgeA() {
        return this.edgeA;
    }

    public IQuadEdge getEdgeB() {
        return this.edgeB;
    }

    public IQuadEdge getEdgeC() {
        return this.edgeC;
    }

    public double getArea() {
        Vertex a = this.edgeA.getA();
        Vertex b = this.edgeB.getA();
        Vertex c = this.edgeC.getA();
        double h = (c.y - a.y) * (b.x - a.x) - (c.x - a.x) * (b.y - a.y);
        return h / 2.0;
    }

    public IConstraint getContainingRegion() {
        IQuadEdge a = this.getEdgeA();
        IQuadEdge b = this.getEdgeB();
        IQuadEdge c = this.getEdgeC();
        if (a.isConstrainedRegionInterior()) {
            int index = a.getConstraintIndex();
            return this.tin.getConstraint(index);
        }
        if (b.isConstrainedRegionInterior()) {
            int index = b.getConstraintIndex();
            return this.tin.getConstraint(index);
        }
        if (c.isConstrainedRegionInterior()) {
            int index = c.getConstraintIndex();
            return this.tin.getConstraint(index);
        }
        if (a.isConstrainedRegionBorder() && b.isConstrainedRegionBorder() && c.isConstrainedRegionBorder()) {
            int aIndex = a.getConstraintIndex();
            int bIndex = b.getConstraintIndex();
            int cIndex = c.getConstraintIndex();
            if (aIndex == bIndex && bIndex == cIndex) {
                return this.tin.getConstraint(cIndex);
            }
        }
        return null;
    }
}

