/*
 * Decompiled with CFR 0.152.
 */
package org.tinfour.common;

import org.tinfour.common.ISamplePoint;

public class Vertex
implements ISamplePoint {
    public static final int BIT_SYNTHETIC = 1;
    public static final int BIT_CONSTRAINT = 2;
    private int index;
    public final double x;
    public final double y;
    final float z;
    protected byte status;
    protected byte reserved0;
    protected byte reserved1;
    protected byte colorIndex;

    public Vertex(double x, double y, double z) {
        this.x = x;
        this.y = y;
        this.z = (float)z;
        this.index = 0;
    }

    public Vertex(double x, double y, double z, int index) {
        this.x = x;
        this.y = y;
        this.z = (float)z;
        this.index = index;
    }

    public String getLabel() {
        return (this.isSynthetic() ? "S" : "") + Integer.toString(this.index);
    }

    public String toString() {
        String s = (this.isSynthetic() ? "S" : " ") + this.index + ": " + "x=" + this.x + ", " + "y=" + this.y + ", " + "z=" + this.z;
        return s;
    }

    public double getDistanceSq(Vertex v) {
        double dx = this.x - v.x;
        double dy = this.y - v.y;
        return dx * dx + dy * dy;
    }

    @Override
    public double getDistanceSq(double x, double y) {
        double dx = this.x - x;
        double dy = this.y - y;
        return dx * dx + dy * dy;
    }

    public double getDistance(double x, double y) {
        double dx = this.x - x;
        double dy = this.y - y;
        return Math.sqrt(dx * dx + dy * dy);
    }

    public double getDistance(Vertex v) {
        double dx = this.x - v.x;
        double dy = this.y - v.y;
        return Math.sqrt(dx * dx + dy * dy);
    }

    @Override
    public double getX() {
        return this.x;
    }

    @Override
    public double getY() {
        return this.y;
    }

    @Override
    public double getZ() {
        return this.z;
    }

    public boolean isNull() {
        return Double.isNaN(this.z);
    }

    public int getIndex() {
        return this.index;
    }

    public void setIndex(int index) {
        this.index = index;
    }

    public boolean isSynthetic() {
        return (this.status & 1) != 0;
    }

    public void setSynthetic(boolean synthetic) {
        this.status = synthetic ? (byte)(this.status | 1) : (byte)(this.status & 0xFFFFFFFE);
    }

    public void setConstraintMember(boolean constraintMember) {
        this.status = constraintMember ? (byte)(this.status | 2) : (byte)(this.status & 0xFFFFFFFD);
    }

    public void setStatus(int status) {
        this.status = (byte)status;
    }

    public int getStatus() {
        return this.status & 0xFF;
    }

    public boolean isConstraintMember() {
        return (this.status & 2) != 0;
    }

    public int getColorIndex() {
        return this.colorIndex;
    }

    public void setColorIndex(int colorIndex) {
        if ((colorIndex & 0xFFFFFF00) != 0) {
            throw new IllegalArgumentException("Color index out of valid range [0..255]");
        }
        this.colorIndex = (byte)(colorIndex & 0xFF);
    }
}

