/*
 * Decompiled with CFR 0.152.
 */
package org.tinfour.io;

import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;

public class DelimitedReader
implements Closeable {
    final InputStream fins;
    final BufferedInputStream bins;
    final int delimiter;
    int lineIndex;

    public DelimitedReader(File file, char delimiter) throws IOException {
        this.fins = new FileInputStream(file);
        this.bins = new BufferedInputStream(this.fins);
        this.delimiter = delimiter;
    }

    public DelimitedReader(InputStream ins, char delimiter) throws IOException {
        this.fins = ins;
        this.bins = new BufferedInputStream(this.fins);
        this.delimiter = delimiter;
    }

    public List<String> readStrings() throws IOException {
        ArrayList<String> sList = new ArrayList<String>();
        this.readStrings(sList);
        return sList;
    }

    public void readStrings(List<String> sList) throws IOException {
        StringBuilder sb = new StringBuilder();
        sList.clear();
        boolean newLine = true;
        while (true) {
            int c;
            if ((c = this.bins.read()) < 0) {
                if (sb.length() <= 0) break;
                sList.add(sb.toString());
                sb.setLength(0);
                break;
            }
            if (c == 0) continue;
            if (newLine) {
                newLine = false;
                ++this.lineIndex;
            }
            if (c == 32 && sb.length() == 0) continue;
            if (c == 10) {
                newLine = true;
                if (sb.length() > 0) {
                    sList.add(sb.toString());
                    sb.setLength(0);
                }
                if (sList.isEmpty()) continue;
                break;
            }
            if (c == this.delimiter) {
                if (this.delimiter == 32 && sb.length() == 0) continue;
                sList.add(sb.toString());
                sb.setLength(0);
                continue;
            }
            if (Character.isWhitespace(c)) continue;
            sb.append((char)c);
        }
    }

    @Override
    public void close() throws IOException {
        this.bins.close();
        this.fins.close();
    }

    public int getLineNumber() {
        return this.lineIndex;
    }
}

