/*
 * Decompiled with CFR 0.152.
 */
package org.tinfour.utils;

import java.io.PrintStream;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.tinfour.common.IIncrementalTin;
import org.tinfour.common.INeighborEdgeLocator;
import org.tinfour.common.IQuadEdge;
import org.tinfour.common.Vertex;

public class VertexColorizerKempe6 {
    public void assignColorsToVertices(IIncrementalTin tin) {
        if (tin == null) {
            throw new IllegalArgumentException("Null input not supported");
        }
        if (!tin.isBootstrapped()) {
            throw new IllegalArgumentException("Unable to process input, TIN is not bootstrapped");
        }
        List<Vertex> masterList = tin.getVertices();
        int[] masterIndex = new int[masterList.size()];
        for (int i = 0; i < masterList.size(); ++i) {
            Vertex v2 = masterList.get(i);
            masterIndex[i] = v2.getIndex();
            v2.setColorIndex(6);
        }
        ArrayList<Vertex> vertexList = new ArrayList<Vertex>();
        boolean[] visited = new boolean[tin.getMaximumEdgeAllocationIndex() + 1];
        for (IQuadEdge e : tin.edges()) {
            IQuadEdge d;
            if (!visited[e.getIndex()]) {
                this.setDegree(e, visited, vertexList);
            }
            if (visited[(d = e.getDual()).getIndex()]) continue;
            this.setDegree(d, visited, vertexList);
        }
        ArrayDeque<Vertex> stack = new ArrayDeque<Vertex>();
        INeighborEdgeLocator locator = tin.getNeighborEdgeLocator();
        while (!vertexList.isEmpty()) {
            Vertex vRemove = null;
            for (Vertex vertex : vertexList) {
                if (vertex.getIndex() > 5) continue;
                vRemove = vertex;
                break;
            }
            vertexList.remove(vRemove);
            stack.push(vRemove);
            IQuadEdge eRemove = this.locateEdge(locator, vRemove);
            if (eRemove == null) {
                throw new IllegalStateException("Internal error, unable to locate edge");
            }
            for (IQuadEdge p : eRemove.pinwheel()) {
                Vertex B = p.getB();
                if (B == null) continue;
                B.setIndex(B.getIndex() - 1);
            }
        }
        for (int i = 0; i < masterList.size(); ++i) {
            masterList.get(i).setIndex(masterIndex[i]);
        }
        boolean[] flag = new boolean[7];
        int iStart = 0;
        while (!stack.isEmpty()) {
            Vertex vertex = (Vertex)stack.pop();
            IQuadEdge e = this.locateEdge(locator, vertex);
            Arrays.fill(flag, true);
            for (IQuadEdge p : e.pinwheel()) {
                Vertex B = p.getB();
                if (B == null) continue;
                int colorIndex = B.getColorIndex();
                flag[colorIndex] = false;
            }
            for (int i = 0; i < 6; ++i) {
                int iTest = (i + iStart) % 6;
                if (!flag[iTest]) continue;
                vertex.setColorIndex(iTest);
                break;
            }
            ++iStart;
        }
    }

    public boolean verifyAssignments(IIncrementalTin tin, PrintStream ps) {
        if (tin == null) {
            throw new IllegalArgumentException("Null input not supported");
        }
        if (!tin.isBootstrapped()) {
            throw new IllegalArgumentException("Unable to process input, TIN is not bootstrapped");
        }
        boolean[] visited = new boolean[tin.getMaximumEdgeAllocationIndex() + 1];
        for (IQuadEdge edge : tin.edges()) {
            IQuadEdge dual;
            if (!visited[edge.getIndex()]) {
                Vertex A = edge.getA();
                int test = A.getColorIndex();
                if (test < 0 || test > 5) {
                    if (ps != null) {
                        ps.println("Unassigned color index for vertex " + A.getIndex());
                    }
                    return false;
                }
                for (IQuadEdge e : edge.pinwheel()) {
                    visited[e.getIndex()] = true;
                    Vertex B = e.getB();
                    if (B == null || B.getColorIndex() != test) continue;
                    if (ps != null) {
                        ps.println("Adjacent vertices share a common color index for vertices: " + A.getIndex() + ", " + B.getIndex());
                    }
                    return false;
                }
            }
            if (visited[(dual = edge.getDual()).getIndex()]) continue;
            Vertex A = dual.getA();
            int test = A.getColorIndex();
            if (test < 0 || test > 5) {
                if (ps != null) {
                    ps.println("Unassigned color index for vertex " + A.getIndex());
                }
                return false;
            }
            for (IQuadEdge e : dual.pinwheel()) {
                visited[e.getIndex()] = true;
                Vertex B = e.getB();
                if (B == null || B.getColorIndex() != test) continue;
                if (ps != null) {
                    ps.println("Adjacent vertices share a common color index for vertices: " + A.getIndex() + ", " + B.getIndex());
                }
                return false;
            }
        }
        return true;
    }

    private void setDegree(IQuadEdge e, boolean[] visited, List<Vertex> vertexList) {
        Vertex A = e.getA();
        if (A != null) {
            vertexList.add(A);
            int n = 0;
            for (IQuadEdge p : e.pinwheel()) {
                visited[p.getIndex()] = true;
                if (p.getB() == null) continue;
                ++n;
            }
            A.setIndex(n);
            A.setColorIndex(0);
        }
    }

    private IQuadEdge locateEdge(INeighborEdgeLocator locator, Vertex v) {
        IQuadEdge e = locator.getNeigborEdge(v.getX(), v.getY());
        if (e == null) {
            return null;
        }
        if (e.getA() == v) {
            return e;
        }
        IQuadEdge f = e.getForward();
        if (f.getA() == v) {
            return f;
        }
        IQuadEdge r = e.getReverse();
        if (r.getA() == v) {
            return r;
        }
        throw new IllegalStateException("Internal error");
    }
}

