/*
 * Decompiled with CFR 0.152.
 */
package org.tinfour.utils;

import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.tinfour.common.IPolyline;
import org.tinfour.common.Vertex;

public class PolylineThinner {
    public IPolyline thinPoints(IPolyline feature, List<IPolyline> neighborList, double threshold) {
        Node node;
        Node firstNode;
        int nNodeMin;
        feature.complete();
        List<Vertex> vList = feature.getVertices();
        if (vList.size() < 2) {
            return null;
        }
        Rectangle2D r2d = feature.getBounds();
        int nNode = vList.size();
        int nRemoved = 0;
        boolean polygon = feature.isPolygon();
        if (polygon) {
            if (nNode < 3) {
                return null;
            }
            nNodeMin = 3;
        } else {
            if (nNode < 3) {
                return null;
            }
            nNodeMin = 0;
        }
        Node lastNode = firstNode = new Node(vList.get(0));
        for (int i = 1; i < nNode; ++i) {
            node = new Node(vList.get(i));
            node.prior = lastNode;
            lastNode.next = node;
            lastNode = node;
        }
        if (feature.isPolygon()) {
            firstNode.prior = lastNode;
            lastNode.next = firstNode;
        } else {
            firstNode = firstNode.next;
            lastNode = lastNode.prior;
            nNode -= 2;
        }
        boolean foundAreaLessThanThreshold = false;
        node = firstNode;
        for (int i = 0; i < nNode; ++i) {
            node.computeArea();
            if (node.areaAbs < threshold) {
                foundAreaLessThanThreshold = true;
            }
            node = node.next;
        }
        if (!foundAreaLessThanThreshold) {
            return null;
        }
        ArrayList<Iterable<Vertex>> testList = new ArrayList<Iterable<Vertex>>();
        testList.add(feature);
        if (neighborList != null) {
            for (IPolyline cTest : neighborList) {
                if (cTest == feature || !cTest.getBounds().intersects(r2d)) continue;
                testList.add(cTest);
            }
        }
        node = firstNode;
        for (int i = 0; i < nNode; ++i) {
            if (node.areaAbs < threshold) {
                node.testForProhibition(testList, threshold);
            }
            node = node.next;
        }
        while (true) {
            double a;
            testList.set(0, new NodeIterable(firstNode, nNode, polygon));
            Node minNode = null;
            double minArea = threshold;
            node = firstNode;
            for (int i = 0; i < nNode; ++i) {
                if (node.areaAbs < minArea && !node.prohibited) {
                    minArea = node.areaAbs;
                    minNode = node;
                }
                node = node.next;
            }
            if (minNode == null) break;
            minNode.prior.next = minNode.next;
            minNode.next.prior = minNode.prior;
            if (minNode == firstNode) {
                firstNode = minNode.next;
            }
            ++nRemoved;
            if (--nNode <= nNodeMin) break;
            testList.set(0, new NodeIterable(firstNode, nNode, polygon));
            if (minNode.prior.prior != null && (a = minNode.prior.computeArea()) < threshold) {
                minNode.prior.testForProhibition(testList, threshold);
            }
            if (minNode.next.next == null || !((a = minNode.next.computeArea()) < threshold)) continue;
            minNode.next.testForProhibition(testList, threshold);
        }
        if (nRemoved > 0) {
            return feature.refactor(new NodeIterable(firstNode, nNode, polygon));
        }
        return null;
    }

    private class NodeIterable
    implements Iterable<Vertex> {
        Node firstNode;
        int nNode;

        NodeIterable(Node firstNode, int nNode, boolean polygon) {
            if (polygon) {
                this.firstNode = firstNode;
                this.nNode = nNode;
            } else {
                this.firstNode = firstNode.prior;
                this.nNode = nNode + 2;
            }
        }

        @Override
        public Iterator<Vertex> iterator() {
            return new NodeIterator(this.firstNode, this.nNode);
        }
    }

    private static class NodeIterator
    implements Iterator<Vertex> {
        Node node;
        int iNode;
        int nNode;

        NodeIterator(Node firstNode, int nNode) {
            this.node = firstNode;
            this.nNode = nNode;
        }

        @Override
        public boolean hasNext() {
            return this.iNode < this.nNode;
        }

        @Override
        public Vertex next() {
            ++this.iNode;
            Vertex v = this.node.vertex;
            this.node = this.node.next;
            return v;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Remove operation not supported");
        }
    }

    private static class Node {
        Vertex vertex;
        double area;
        double areaAbs;
        double x;
        double y;
        boolean prohibited;
        Node prior;
        Node next;

        Node(Vertex v) {
            this.vertex = v;
            this.x = v.getX();
            this.y = v.getY();
        }

        private double computeArea() {
            double cx = this.prior.x - this.x;
            double cy = this.prior.y - this.y;
            double bx = this.next.x - this.x;
            double by = this.next.y - this.y;
            this.area = (bx * cy - by * cx) / 2.0;
            this.areaAbs = Math.abs(this.area);
            return this.areaAbs;
        }

        private boolean testForProhibition(List<Iterable<Vertex>> testList, double threshold) {
            double ax = this.x;
            double ay = this.y;
            double bx = this.next.x;
            double by = this.next.y;
            double cx = this.prior.x;
            double cy = this.prior.y;
            double xAB = bx - ax;
            double yAB = by - ay;
            double xBC = cx - bx;
            double yBC = cy - by;
            double xCA = ax - cx;
            double yCA = ay - cy;
            this.prohibited = false;
            if (this.areaAbs < threshold / 1.0E9) {
                double dot = xCA * xAB + yCA * yAB;
                if (dot < 0.0) {
                    this.prohibited = false;
                    return false;
                }
                double c2 = (xBC * xBC + yBC * yBC) * 0.999999999;
                boolean selfConstraint = true;
                for (Iterable<Vertex> test : testList) {
                    for (Vertex vTest : test) {
                        double vx = vTest.getX() - bx;
                        double vy = vTest.getY() - by;
                        double test2 = Math.abs(xCA * vy - yCA * vx);
                        if (!(test2 < 1.0E-12) || !(1.0E-12 < (dot = xBC * vx + yBC * vy)) || !(dot < c2) || selfConstraint && vTest == this.vertex) continue;
                        this.prohibited = true;
                        return true;
                    }
                    selfConstraint = false;
                }
            } else {
                boolean selfConstraint = true;
                for (Iterable<Vertex> test : testList) {
                    for (Vertex vTest : test) {
                        double test2;
                        double test1;
                        double vx = vTest.getX();
                        double vy = vTest.getY();
                        double test0 = xAB * (vy - ay) - yAB * (vx - ax);
                        if (!(test0 >= 0.0 && (test1 = xBC * (vy - by) - yBC * (vx - bx)) >= 0.0 && (test2 = xCA * (vy - cy) - yCA * (vx - cx)) >= 0.0 && (!selfConstraint || vTest != this.vertex && vTest != this.next.vertex && vTest != this.prior.vertex))) continue;
                        this.prohibited = true;
                        return true;
                    }
                    selfConstraint = false;
                }
            }
            return false;
        }

        public String toString() {
            return String.format("%s %12.6f %s", this.vertex.toString(), this.area, this.prohibited ? "prohibited" : "");
        }
    }
}

