/*
 * Decompiled with CFR 0.152.
 */
package org.tinfour.utils.loaders;

import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.tinfour.common.IMonitorWithCancellation;
import org.tinfour.common.Vertex;
import org.tinfour.io.DelimitedReader;
import org.tinfour.utils.LinearUnits;
import org.tinfour.utils.loaders.CoordinatePair;
import org.tinfour.utils.loaders.ICoordinateTransform;
import org.tinfour.utils.loaders.IVertexReader;
import org.tinfour.utils.loaders.SimpleGeographicTransform;

public class VertexReaderText
implements Closeable,
IVertexReader {
    private final File file;
    private char delimiter;
    double xMin;
    double xMax;
    double yMin;
    double yMax;
    double zMin;
    double zMax;
    boolean isSourceInGeographicCoordinates;
    LinearUnits linearUnits = LinearUnits.UNKNOWN;
    ICoordinateTransform coordinateTransform;

    public VertexReaderText(File file) throws IOException {
        if (file == null) {
            throw new NullPointerException("Null file specification");
        }
        if (!file.exists()) {
            throw new IOException("Specified file does not exist: " + file.getPath());
        }
        this.file = file;
        this.delimiter = '\u0000';
        String name = file.getName();
        if (name != null) {
            String ext;
            int i = name.lastIndexOf(46);
            if (name.length() - i == 4 && ".csv".equalsIgnoreCase(ext = name.substring(i, name.length()))) {
                this.delimiter = (char)44;
            }
        }
        if (this.delimiter == '\u0000') {
            this.delimiter = this.scanFileForDelimiter(file);
        }
    }

    @Override
    public List<Vertex> read(IMonitorWithCancellation monitor) throws IOException {
        if (this.delimiter == '\u0000') {
            throw new IOException("Unable to deduce delimiter character for file");
        }
        List<Vertex> list = this.readDelimitedFile(this.file, this.delimiter);
        if (list.isEmpty()) {
            this.xMin = Double.NaN;
            this.xMax = Double.NaN;
            this.yMin = Double.NaN;
            this.yMax = Double.NaN;
            this.zMin = Double.NaN;
            this.zMax = Double.NaN;
        } else {
            Vertex v = list.get(0);
            this.xMax = this.xMin = v.getX();
            this.yMax = this.yMin = v.getY();
            this.zMax = this.zMin = v.getZ();
            for (Vertex vertex : list) {
                double x = vertex.getX();
                double y = vertex.getY();
                double z = vertex.getZ();
                if (x < this.xMin) {
                    this.xMin = x;
                } else if (x > this.xMax) {
                    this.xMax = x;
                }
                if (y < this.yMin) {
                    this.yMin = y;
                } else if (y > this.yMax) {
                    this.yMax = y;
                }
                if (z < this.zMin) {
                    this.zMin = z;
                    continue;
                }
                if (!(z > this.zMax)) continue;
                this.zMax = z;
            }
        }
        return list;
    }

    List<Vertex> readDelimitedFile(File file, char delimiter) throws IOException {
        try (DelimitedReader dlim = new DelimitedReader(file, delimiter);){
            boolean status;
            List<String> sList = dlim.readStrings();
            ArrayList<Vertex> vList = new ArrayList<Vertex>();
            boolean headerRow = false;
            int xColumn = 0;
            int yColumn = 1;
            int zColumn = 2;
            int nColumnsRequired = 3;
            boolean geoText = false;
            boolean xFound = false;
            boolean yFound = false;
            int k = 0;
            for (String s : sList) {
                char c = s.charAt(0);
                if (Character.isAlphabetic(c) || c == '_') {
                    headerRow = true;
                    int n = k + 1;
                    if ("x".equalsIgnoreCase(s)) {
                        xColumn = k;
                        if (n > nColumnsRequired) {
                            nColumnsRequired = n;
                        }
                    } else if ("y".equalsIgnoreCase(s)) {
                        yColumn = k;
                        if (n > nColumnsRequired) {
                            nColumnsRequired = n;
                        }
                    } else if ("z".equalsIgnoreCase(s)) {
                        zColumn = k;
                        if (n > nColumnsRequired) {
                            nColumnsRequired = n;
                        }
                    } else if (s.toLowerCase().startsWith("lon")) {
                        geoText = true;
                        xColumn = k;
                        if (n > nColumnsRequired) {
                            nColumnsRequired = n;
                        }
                    } else if (s.toLowerCase().startsWith("lat")) {
                        geoText = true;
                        yColumn = k;
                        if (n > nColumnsRequired) {
                            nColumnsRequired = n;
                        }
                    }
                }
                ++k;
            }
            int iVertex = 0;
            if (headerRow) {
                if (xFound && yFound && geoText) {
                    geoText = false;
                }
                if ((sList = dlim.readStrings()).size() < nColumnsRequired) {
                    throw new IOException("Insufficient columns in line " + dlim.getLineNumber());
                }
                try {
                    double x = Double.parseDouble(sList.get(xColumn));
                    double y = Double.parseDouble(sList.get(yColumn));
                    double z = Double.parseDouble(sList.get(zColumn));
                    if (geoText && this.coordinateTransform == null) {
                        this.coordinateTransform = new SimpleGeographicTransform(y, x, this.linearUnits);
                        this.isSourceInGeographicCoordinates = true;
                        CoordinatePair c = new CoordinatePair();
                        status = this.coordinateTransform.forward(x, y, c);
                        if (!status) {
                            throw new IOException("Invalid transformation for coordinates in line " + dlim.getLineNumber());
                        }
                        x = c.x;
                        y = c.y;
                    }
                    vList.add(new Vertex(x, y, z, iVertex));
                    ++iVertex;
                }
                catch (NumberFormatException nex) {
                    throw new IOException("Invalid numeric format in " + dlim.getLineNumber(), nex);
                }
            }
            try {
                CoordinatePair c = new CoordinatePair();
                while (!(sList = dlim.readStrings()).isEmpty()) {
                    if (sList.size() < nColumnsRequired) {
                        throw new IOException("Insufficient columns in line " + dlim.getLineNumber());
                    }
                    double x = Double.parseDouble(sList.get(xColumn));
                    double y = Double.parseDouble(sList.get(yColumn));
                    double z = Double.parseDouble(sList.get(zColumn));
                    if (this.coordinateTransform != null) {
                        status = this.coordinateTransform.forward(x, y, c);
                        if (!status) {
                            throw new IOException("Undefined coordinates in line " + dlim.getLineNumber() + ": " + x + ", " + y);
                        }
                        x = c.x;
                        y = c.y;
                    }
                    vList.add(new Vertex(x, y, z, iVertex));
                    ++iVertex;
                }
            }
            catch (NumberFormatException nex) {
                throw new IOException("Invalid numeric format in " + dlim.getLineNumber(), nex);
            }
            ArrayList<Vertex> arrayList = vList;
            return arrayList;
        }
    }

    public char getDelimiter() {
        return this.delimiter;
    }

    public void setDelimiter(char delimiter) {
        if (delimiter == '\u0000') {
            throw new IllegalArgumentException("Invalid delimiter (charactter zero)");
        }
        this.delimiter = delimiter;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private char scanFileForDelimiter(File file) throws IOException {
        try (FileInputStream fins = new FileInputStream(file);){
            int c;
            BufferedInputStream bins = new BufferedInputStream(fins);
            boolean commentLine = false;
            boolean commaFound = false;
            boolean pipeFound = false;
            boolean textFound = false;
            int embeddedWhitespace = 0;
            int embeddedWhitespaceCandidate = 0;
            boolean escape = false;
            while ((c = bins.read()) > 0) {
                if (escape) {
                    escape = false;
                    continue;
                }
                if (commentLine) {
                    if (c != 10) continue;
                    commentLine = false;
                    continue;
                }
                if (c == 10) {
                    if (!textFound) continue;
                    break;
                }
                if (Character.isWhitespace(c)) {
                    if (!textFound) continue;
                    if (c == 9) {
                        embeddedWhitespaceCandidate = c;
                        continue;
                    }
                    if (c != 32 || embeddedWhitespaceCandidate != 0) continue;
                    embeddedWhitespaceCandidate = c;
                    continue;
                }
                if (embeddedWhitespaceCandidate != 0 && embeddedWhitespace != 9) {
                    embeddedWhitespace = embeddedWhitespaceCandidate;
                }
                if (c == 35 && !textFound) {
                    commentLine = true;
                    continue;
                }
                textFound = true;
                if (c == 92) {
                    escape = true;
                    continue;
                }
                if (c == 44) {
                    commaFound = true;
                    continue;
                }
                if (c != 124) continue;
                pipeFound = true;
            }
            if (pipeFound) {
                char c2 = '|';
                return c2;
            }
            if (commaFound) {
                char c3 = ',';
                return c3;
            }
            if (embeddedWhitespace > 0) {
                char c4 = (char)embeddedWhitespace;
                return c4;
            }
            char c5 = '\u0000';
            return c5;
        }
    }

    @Override
    public void close() throws IOException {
    }

    @Override
    public double getXMin() {
        return this.xMin;
    }

    @Override
    public double getXMax() {
        return this.xMax;
    }

    @Override
    public double getYMin() {
        return this.yMin;
    }

    @Override
    public double getYMax() {
        return this.yMax;
    }

    @Override
    public double getZMin() {
        return this.zMin;
    }

    @Override
    public double getZMax() {
        return this.zMax;
    }

    @Override
    public boolean isSourceInGeographicCoordinates() {
        return this.isSourceInGeographicCoordinates;
    }

    public LinearUnits getLinearUnits() {
        return this.linearUnits;
    }

    public void setLinearUnits(LinearUnits linearUnits) {
        this.linearUnits = linearUnits == null ? LinearUnits.UNKNOWN : linearUnits;
    }

    @Override
    public ICoordinateTransform getCoordinateTransform() {
        return this.coordinateTransform;
    }

    @Override
    public void setCoordinateTransform(ICoordinateTransform transform) {
        this.coordinateTransform = transform;
    }
}

