/*
 * Decompiled with CFR 0.152.
 */
package org.tinfour.contour;

import java.awt.geom.AffineTransform;
import java.awt.geom.Path2D;
import java.util.Arrays;
import org.tinfour.common.IQuadEdge;
import org.tinfour.common.Vertex;
import org.tinfour.contour.TipLink;

public class Contour {
    private static final int GROWTH_FACTOR = 256;
    int n;
    double[] xy;
    final int contourIndex;
    final int leftIndex;
    final int rightIndex;
    final double z;
    final boolean closedLoop;
    IQuadEdge startEdge;
    Vertex startVertex;
    IQuadEdge terminalEdge;
    Vertex terminalVertex;
    boolean traversedForward;
    boolean traversedBackward;
    TipLink startTip;
    TipLink terminalTip;

    public Contour(int contourIndex, int leftIndex, int rightIndex, double z, boolean closedLoop) {
        this.contourIndex = contourIndex;
        this.leftIndex = leftIndex;
        this.rightIndex = rightIndex;
        this.z = z;
        this.xy = new double[256];
        this.closedLoop = closedLoop;
    }

    void add(IQuadEdge e, double zA, double zB) {
        assert (zA > zB) : "Adding non-decending edge";
        if (this.n == 0) {
            this.startEdge = e;
            this.startVertex = null;
        } else if (this.n == this.xy.length) {
            this.xy = Arrays.copyOf(this.xy, this.xy.length + 256);
        }
        this.terminalEdge = e;
        this.terminalVertex = null;
        Vertex A = e.getA();
        Vertex B = e.getB();
        double zDelta = zB - zA;
        this.xy[this.n++] = ((this.z - zA) * B.getX() + (zB - this.z) * A.getX()) / zDelta;
        this.xy[this.n++] = ((this.z - zA) * B.getY() + (zB - this.z) * A.getY()) / zDelta;
    }

    void add(IQuadEdge e, Vertex v) {
        assert (v.equals(e.getB())) : "Through-vertex case, edge not pointing at vertex";
        if (this.n == 0) {
            this.startEdge = e;
            this.startVertex = v;
        } else if (this.n == this.xy.length) {
            this.xy = Arrays.copyOf(this.xy, this.xy.length + 256);
        }
        this.terminalEdge = e;
        this.terminalVertex = v;
        this.xy[this.n++] = v.getX();
        this.xy[this.n++] = v.getY();
    }

    public void add(double x, double y) {
        if (this.n == this.xy.length) {
            this.xy = Arrays.copyOf(this.xy, this.xy.length + 256);
        }
        this.xy[this.n++] = x;
        this.xy[this.n++] = y;
    }

    public double[] getCoordinates() {
        return Arrays.copyOf(this.xy, this.n);
    }

    public boolean isEmpty() {
        return this.n < 4;
    }

    public int size() {
        return this.n / 2;
    }

    public void complete() {
        if (this.closedLoop && this.n >= 6) {
            double x0 = this.xy[0];
            double y0 = this.xy[1];
            double x1 = this.xy[this.n - 2];
            double y1 = this.xy[this.n - 1];
            if (x0 != x1 || y0 != y1) {
                this.add(x0, y0);
            }
        }
        if (this.xy.length > this.n) {
            this.xy = Arrays.copyOf(this.xy, this.n);
        }
    }

    public int getIndex() {
        return this.contourIndex;
    }

    public Path2D getPath2D(AffineTransform transform) {
        Path2D.Double path = new Path2D.Double();
        if (this.n >= 4) {
            double[] c = new double[this.n];
            transform.transform(this.xy, 0, c, 0, this.n / 2);
            ((Path2D)path).moveTo(c[0], c[1]);
            for (int i = 1; i < this.n / 2; ++i) {
                ((Path2D)path).lineTo(c[i * 2], c[i * 2 + 1]);
            }
            if (this.closedLoop) {
                path.closePath();
            }
        }
        return path;
    }

    public ContourType getContourType() {
        if (this.rightIndex == -1) {
            return ContourType.Perimeter;
        }
        return ContourType.Interior;
    }

    public boolean isClosed() {
        return this.closedLoop;
    }

    public String toString() {
        String cString = "";
        if (this.n >= 4) {
            double x0 = this.xy[0];
            double y0 = this.xy[1];
            double x1 = this.xy[this.n - 2];
            double y1 = this.xy[this.n - 1];
            cString = String.format("(x0,y0)=(%f,%f)  (x1,y1)=(%f,%f)", x0, y0, x1, y1);
        }
        return "Contour " + this.contourIndex + ": L=" + this.leftIndex + ", R=" + this.rightIndex + ", z=" + this.z + ", closed=" + this.closedLoop + "  " + cString;
    }

    public static enum ContourType {
        Interior,
        Perimeter;

    }
}

