/*
 * Decompiled with CFR 0.152.
 */
package org.tinfour.interpolation;

import org.tinfour.common.IIncrementalTin;
import org.tinfour.common.IIncrementalTinNavigator;
import org.tinfour.common.IQuadEdge;
import org.tinfour.common.Thresholds;
import org.tinfour.common.Vertex;
import org.tinfour.interpolation.IInterpolatorOverTin;
import org.tinfour.interpolation.IVertexValuator;
import org.tinfour.interpolation.VertexValuatorDefault;

public class TriangularFacetInterpolator
implements IInterpolatorOverTin {
    private final double vertexTolerance2;
    private final double precisionThreshold;
    final IIncrementalTin tin;
    final IIncrementalTinNavigator navigator;
    private final VertexValuatorDefault defaultValuator = new VertexValuatorDefault();
    private double nx;
    private double ny;
    private double nz;

    public TriangularFacetInterpolator(IIncrementalTin tin) {
        Thresholds thresholds = tin.getThresholds();
        this.vertexTolerance2 = thresholds.getVertexTolerance2();
        this.precisionThreshold = thresholds.getPrecisionThreshold();
        this.tin = tin;
        this.navigator = tin.getNavigator();
    }

    @Override
    public void resetForChangeToTin() {
        this.navigator.resetForChangeToTin();
    }

    @Override
    public double interpolate(double x, double y, IVertexValuator valuator) {
        IQuadEdge e;
        IVertexValuator vq = valuator;
        if (vq == null) {
            vq = this.defaultValuator;
        }
        if ((e = this.navigator.getNeighborEdge(x, y)) == null) {
            return Double.NaN;
        }
        Vertex v0 = e.getA();
        Vertex v1 = e.getB();
        Vertex v2 = e.getForward().getB();
        double z0 = vq.value(v0);
        double z1 = vq.value(v1);
        double sx = x - v0.x;
        double sy = y - v0.y;
        double ax = v1.x - v0.x;
        double ay = v1.y - v0.y;
        double az = z1 - z0;
        if (v2 == null) {
            this.nx = 0.0;
            this.ny = 0.0;
            this.nz = 0.0;
            double px = -ay;
            double py = ax;
            double h = (sx * px + sy * py) / Math.sqrt(ax * ax + ay * ay);
            if (Math.abs(h) < this.precisionThreshold) {
                double t = Math.abs(ax) > Math.abs(ay) ? sx / ax : sy / ay;
                return t * (z1 - z0) + z0;
            }
            return Double.NaN;
        }
        double z2 = vq.value(v2);
        double bx = v2.x - v0.x;
        double by = v2.y - v0.y;
        double bz = z2 - z0;
        this.nx = ay * bz - az * by;
        this.ny = az * bx - ax * bz;
        this.nz = ax * by - ay * bx;
        if (v0.getDistanceSq(x, y) < this.vertexTolerance2) {
            return z0;
        }
        if (v1.getDistanceSq(x, y) < this.vertexTolerance2) {
            return z1;
        }
        if (v2.getDistanceSq(x, y) < this.vertexTolerance2) {
            return z2;
        }
        if (Math.abs(this.nz) < this.precisionThreshold) {
            return (z0 + z1 + z2) / 3.0;
        }
        return z0 - (this.nx * sx + this.ny * sy) / this.nz;
    }

    @Override
    public boolean isSurfaceNormalSupported() {
        return true;
    }

    @Override
    public double[] getSurfaceNormal() {
        double nS = Math.sqrt(this.nx * this.nx + this.ny * this.ny + this.nz * this.nz);
        if (nS < 1.0E-20) {
            return new double[0];
        }
        double[] n = new double[]{this.nx / nS, this.ny / nS, this.nz / nS};
        return n;
    }

    @Override
    public String getMethod() {
        return "Triangular Facet";
    }
}

