/*
 * Decompiled with CFR 0.152.
 */
package org.tinfour.common;

import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.tinfour.common.IConstraint;
import org.tinfour.common.IIncrementalTin;
import org.tinfour.common.IQuadEdge;
import org.tinfour.common.Vertex;

public abstract class PolyLineConstraintAdapter
implements IConstraint,
Iterable<Vertex> {
    protected final List<Vertex> list;
    private final Rectangle2D bounds = new Rectangle2D.Double();
    private double x = Double.NaN;
    private double y = Double.NaN;
    protected Object applicationData;
    protected int constraintIndex;
    protected IQuadEdge constraintLinkingEdge;
    protected IIncrementalTin maintainingTin;
    protected boolean isComplete;
    protected double length;
    static int nDense;

    PolyLineConstraintAdapter() {
        this.list = new ArrayList<Vertex>();
    }

    PolyLineConstraintAdapter(List<Vertex> vList) {
        this.list = new ArrayList<Vertex>(vList.size() + 1);
        for (Vertex v : vList) {
            this.add(v);
        }
    }

    @Override
    public List<Vertex> getVertices() {
        return this.list;
    }

    @Override
    public final void add(Vertex v) {
        this.isComplete = false;
        double vx = v.getX();
        double vy = v.getY();
        if (this.list.isEmpty()) {
            this.bounds.setRect(vx, vy, 0.0, 0.0);
        } else {
            if (vx == this.x && vy == this.y) {
                return;
            }
            this.length += v.getDistance(this.x, this.y);
            this.bounds.add(vx, vy);
        }
        this.x = vx;
        this.y = vy;
        v.setConstraintMember(true);
        this.list.add(v);
    }

    @Override
    public Rectangle2D getBounds() {
        return this.bounds;
    }

    @Override
    public void setApplicationData(Object applicationData) {
        this.applicationData = applicationData;
    }

    @Override
    public Object getApplicationData() {
        return this.applicationData;
    }

    @Override
    public void setConstraintIndex(IIncrementalTin tin, int index) {
        this.constraintIndex = index;
        this.maintainingTin = tin;
    }

    @Override
    public int getConstraintIndex() {
        return this.constraintIndex;
    }

    @Override
    public double getLength() {
        return this.length;
    }

    @Override
    public Iterator<Vertex> iterator() {
        return this.list.iterator();
    }

    @Override
    public IQuadEdge getConstraintLinkingEdge() {
        return this.constraintLinkingEdge;
    }

    @Override
    public void setConstraintLinkingEdge(IQuadEdge edge) {
        this.constraintLinkingEdge = edge;
    }

    @Override
    public IIncrementalTin getManagingTin() {
        return this.maintainingTin;
    }

    @Override
    public boolean isPointInsideConstraint(double x, double y) {
        if (!this.isPolygon()) {
            return false;
        }
        if (!this.isComplete) {
            return false;
        }
        int rCross = 0;
        int lCross = 0;
        Vertex v0 = this.list.get(this.list.size() - 1);
        for (Vertex v1 : this.list) {
            double xTest;
            double x0 = v0.getX();
            double y0 = v0.getY();
            double x1 = v1.getX();
            double y1 = v1.getY();
            v0 = v1;
            double yDelta = y0 - y1;
            if (y1 > y != y0 > y && (xTest = (x1 * y0 - x0 * y1 + y * (x0 - x1)) / yDelta) > x) {
                ++rCross;
            }
            if (y1 < y == y0 < y || !((xTest = (x1 * y0 - x0 * y1 + y * (x0 - x1)) / yDelta) < x)) continue;
            ++lCross;
        }
        if ((rCross ^ lCross) & true) {
            return false;
        }
        return rCross & true;
    }

    @Override
    public void densify(double threshold) {
        ArrayList<Vertex> vList = new ArrayList<Vertex>();
        if (this.list.size() < 2) {
            return;
        }
        ++nDense;
        vList.add(this.list.get(0));
        for (int i0 = 0; i0 < this.list.size() - 1; ++i0) {
            Vertex v0 = this.list.get(i0);
            Vertex v1 = this.list.get(i0 + 1);
            double d = v0.getDistance(v1);
            int n = 0;
            if (d > threshold) {
                n = (int)Math.floor(d / threshold) + 1;
                for (int i = 1; i < n; ++i) {
                    double t = (double)i / (double)n;
                    double x0 = v0.getX();
                    double y0 = v0.getY();
                    double z0 = v0.getZ();
                    double x1 = v1.getX();
                    double y1 = v1.getY();
                    double z1 = v1.getZ();
                    double x = t * (x1 - x0) + x0;
                    double y = t * (y1 - y0) + y0;
                    double z = t * (z1 - z0) + z0;
                    Vertex v = new Vertex(x, y, z, vList.size());
                    v.setSynthetic(true);
                    v.setConstraintMember(true);
                    vList.add(v);
                }
            }
            vList.add(v1);
        }
        this.list.clear();
        this.list.addAll(vList);
    }
}

