/*
 * Decompiled with CFR 0.152.
 */
package org.tinfour.interpolation;

import java.io.PrintStream;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.List;
import org.tinfour.common.Circumcircle;
import org.tinfour.common.GeometricOperations;
import org.tinfour.common.IIncrementalTin;
import org.tinfour.common.IIncrementalTinNavigator;
import org.tinfour.common.IQuadEdge;
import org.tinfour.common.Thresholds;
import org.tinfour.common.Vertex;
import org.tinfour.interpolation.IInterpolatorOverTin;
import org.tinfour.interpolation.IVertexValuator;
import org.tinfour.interpolation.VertexValuatorDefault;

public class NaturalNeighborInterpolator
implements IInterpolatorOverTin {
    private final double vertexTolerance2;
    private final double inCircleThreshold;
    private final double halfPlaneThreshold;
    final IIncrementalTin tin;
    final GeometricOperations geoOp;
    IIncrementalTinNavigator navigator;
    private final VertexValuatorDefault defaultValuator = new VertexValuatorDefault();
    private double barycentricCoordinateDeviation;
    private long sumN;
    private long sumSides;
    private long nInCircle;
    private long nInCircleExtended;

    public NaturalNeighborInterpolator(IIncrementalTin tin) {
        Thresholds thresholds = tin.getThresholds();
        this.geoOp = new GeometricOperations(thresholds);
        this.vertexTolerance2 = thresholds.getVertexTolerance2();
        this.inCircleThreshold = thresholds.getInCircleThreshold();
        this.halfPlaneThreshold = thresholds.getHalfPlaneThreshold();
        this.tin = tin;
        this.navigator = tin.getNavigator();
    }

    @Override
    public void resetForChangeToTin() {
        this.navigator.resetForChangeToTin();
    }

    @Override
    public double interpolate(double x, double y, IVertexValuator valuator) {
        List<IQuadEdge> eList;
        int nEdge;
        IVertexValuator vq = valuator;
        if (vq == null) {
            vq = this.defaultValuator;
        }
        if ((nEdge = (eList = this.getBowyerWatsonEnvelope(x, y)).size()) == 0) {
            return Double.NaN;
        }
        if (nEdge == 1) {
            IQuadEdge e = eList.get(0);
            Vertex v = e.getA();
            return vq.value(v);
        }
        ++this.sumN;
        this.sumSides += (long)eList.size();
        double[] w = this.getBarycentricCoordinates(eList, x, y);
        if (w == null) {
            return Double.NaN;
        }
        double zSum = 0.0;
        int k = 0;
        for (IQuadEdge s : eList) {
            double z = vq.value(s.getA());
            zSum += w[k++] * z;
        }
        return zSum;
    }

    public double getBarycentricCoordinateDeviation() {
        return this.barycentricCoordinateDeviation;
    }

    public List<IQuadEdge> getBowyerWatsonEnvelope(double x, double y) {
        double h;
        ArrayList<IQuadEdge> eList = new ArrayList<IQuadEdge>();
        IQuadEdge locatorEdge = this.navigator.getNeighborEdge(x, y);
        if (locatorEdge == null) {
            return eList;
        }
        IQuadEdge e = locatorEdge;
        IQuadEdge f = e.getForward();
        IQuadEdge r = e.getReverse();
        Vertex v0 = e.getA();
        Vertex v1 = e.getB();
        Vertex v2 = e.getForward().getB();
        if (v2 == null) {
            return eList;
        }
        if (v0.getDistanceSq(x, y) < this.vertexTolerance2) {
            eList.add(e);
            return eList;
        }
        if (v1.getDistanceSq(x, y) < this.vertexTolerance2) {
            eList.add(e.getForward());
            return eList;
        }
        if (v2.getDistanceSq(x, y) < this.vertexTolerance2) {
            eList.add(e.getReverse());
            return eList;
        }
        if (e.isConstrained() && (h = this.geoOp.halfPlane(v0.x, v0.y, v1.x, v1.y, x, y)) < this.halfPlaneThreshold) {
            return eList;
        }
        if (f.isConstrained() && (h = this.geoOp.halfPlane(v1.x, v1.y, v2.x, v2.y, x, y)) < this.halfPlaneThreshold) {
            return eList;
        }
        if (r.isConstrained() && (h = this.geoOp.halfPlane(v2.x, v2.y, v0.x, v0.y, x, y)) < this.halfPlaneThreshold) {
            return eList;
        }
        ArrayDeque<IQuadEdge> stack = new ArrayDeque<IQuadEdge>();
        IQuadEdge c = locatorEdge;
        while (true) {
            IQuadEdge n0 = c.getDual();
            IQuadEdge n1 = n0.getForward();
            if (c.isConstrained()) {
                h = -1.0;
            } else if (n1.getB() == null) {
                h = -1.0;
            } else {
                ++this.nInCircle;
                double a11 = n0.getA().x - x;
                double a12 = n0.getA().y - y;
                double a21 = n1.getA().x - x;
                double a32 = n1.getB().y - y;
                double a31 = n1.getB().x - x;
                double a22 = n1.getA().y - y;
                h = (a11 * a11 + a12 * a12) * (a21 * a32 - a31 * a22) + (a21 * a21 + a22 * a22) * (a31 * a12 - a11 * a32) + (a31 * a31 + a32 * a32) * (a11 * a22 - a21 * a12);
                if (-this.inCircleThreshold < h && h < this.inCircleThreshold) {
                    ++this.nInCircleExtended;
                    h = this.geoOp.inCircleQuadPrecision(n0.getA().x, n0.getA().y, n1.getA().x, n1.getA().y, n1.getB().x, n1.getB().y, x, y);
                }
            }
            if (h >= 0.0) {
                stack.addFirst(n0);
                c = n1;
                continue;
            }
            eList.add(c);
            c = c.getForward();
            IQuadEdge p = (IQuadEdge)stack.peekFirst();
            while (c.equals(p)) {
                stack.remove();
                c = c.getDual().getForward();
                p = (IQuadEdge)stack.peekFirst();
            }
            if (c.equals(locatorEdge)) break;
        }
        return eList;
    }

    @Override
    public String getMethod() {
        return "Natural Neighbor (Sibson's C0)";
    }

    IQuadEdge checkTriangleVerticesForMatch(IQuadEdge baseEdge, double x, double y, double distanceTolerance2) {
        Vertex v2;
        IQuadEdge sEdge = baseEdge;
        IQuadEdge sFwd = sEdge.getForward();
        double dMin = sEdge.getA().getDistanceSq(x, y);
        double dFwd = sFwd.getA().getDistanceSq(x, y);
        if (dFwd < dMin) {
            sEdge = sFwd;
            dMin = dFwd;
        }
        if ((v2 = sEdge.getForward().getB()) != null && v2.getDistanceSq(x, y) < dMin) {
            return sFwd.getForward();
        }
        return sEdge;
    }

    @Override
    public boolean isSurfaceNormalSupported() {
        return false;
    }

    @Override
    public double[] getSurfaceNormal() {
        return new double[0];
    }

    public double[] getBarycentricCoordinates(List<IQuadEdge> polygon, double x, double y) {
        int nEdge = polygon.size();
        if (nEdge < 3) {
            return new double[0];
        }
        Circumcircle c0 = new Circumcircle();
        Circumcircle c1 = new Circumcircle();
        Circumcircle c2 = new Circumcircle();
        Circumcircle c3 = new Circumcircle();
        double wSum = 0.0;
        double[] weights = new double[nEdge];
        for (int i0 = 0; i0 < nEdge; ++i0) {
            int i1 = (i0 + 1) % nEdge;
            IQuadEdge e0 = polygon.get(i0);
            IQuadEdge e1 = polygon.get(i1);
            Vertex a = e0.getA();
            Vertex b = e1.getA();
            Vertex c = e1.getB();
            double ax = a.getX() - x;
            double ay = a.getY() - y;
            double bx = b.getX() - x;
            double by = b.getY() - y;
            double cx = c.getX() - x;
            double cy = c.getY() - y;
            double x0 = (ax + bx) / 2.0;
            double y0 = (ay + by) / 2.0;
            double x1 = (bx + cx) / 2.0;
            double y1 = (by + cy) / 2.0;
            if (i0 == 0) {
                this.geoOp.circumcircle(ax, ay, bx, by, 0.0, 0.0, c0);
                Vertex nb = e0.getForward().getB();
                this.geoOp.circumcircle(ax, ay, bx, by, nb.getX() - x, nb.getY() - y, c3);
            } else {
                c0.copy(c1);
            }
            this.geoOp.circumcircle(bx, by, cx, cy, 0.0, 0.0, c1);
            double wXY = x0 * c0.getY() - c0.getX() * y0 + (c0.getX() * c1.getY() - c1.getX() * c0.getY()) + (c1.getX() * y1 - x1 * c1.getY());
            IQuadEdge n = e0.getForward();
            double wThiessen = x0 * c3.getY() - c3.getX() * y0;
            while (!n.equals(e1)) {
                IQuadEdge n1 = n.getDual();
                n = n1.getForward();
                c2.copy(c3);
                a = n1.getA();
                b = n.getA();
                c = n.getB();
                ax = a.getX() - x;
                ay = a.getY() - y;
                bx = b.getX() - x;
                by = b.getY() - y;
                cx = c.getX() - x;
                cy = c.getY() - y;
                this.geoOp.circumcircle(ax, ay, bx, by, cx, cy, c3);
                wThiessen += c2.getX() * c3.getY() - c3.getX() * c2.getY();
            }
            double wDelta = wXY - (wThiessen += c3.getX() * y1 - x1 * c3.getY());
            wSum += wDelta;
            weights[i1] = wDelta;
        }
        int i = 0;
        while (i < weights.length) {
            int n = i++;
            weights[n] = weights[n] / wSum;
        }
        double xSum = 0.0;
        double ySum = 0.0;
        int k = 0;
        for (IQuadEdge s : polygon) {
            Vertex v = s.getA();
            xSum += weights[k] * (v.getX() - x);
            ySum += weights[k] * (v.getY() - y);
            ++k;
        }
        this.barycentricCoordinateDeviation = Math.sqrt(xSum * xSum + ySum * ySum);
        return weights;
    }

    public void printDiagnostics(PrintStream ps) {
        long nC = this.geoOp.getCircumcircleCount();
        long nCE = this.geoOp.getExtendedCircumcircleCount();
        ps.format("N inCircle:          %12d%n", this.nInCircle);
        ps.format("N inCircle extended: %12d%n", this.nInCircleExtended);
        ps.format("N circumcircle:      %12d%n", nC);
        ps.format("N circumcircle ext:  %12d%n", nCE);
        long n = this.sumN > 0L ? this.sumN : 1L;
        ps.format("Avg circumcircles per interpolation: %9.6f%n", (double)nC / (double)n);
        ps.format("Avg sides per Theissen polygon:      %9.6f%n", (double)this.sumSides / (double)n);
    }

    public void clearDiagnostics() {
        this.geoOp.clearDiagnostics();
        this.nInCircle = 0L;
        this.nInCircleExtended = 0L;
        this.sumSides = 0L;
        this.sumN = 0L;
    }
}

