/*
 * Decompiled with CFR 0.152.
 */
package org.tinfour.utils;

import java.util.Arrays;

public final class AxisIntervals {
    private static final double LN10 = Math.log(10.0);
    private static final double[][] testIntervals = new double[][]{{1.0, 0.5, 0.1}, {2.0, 1.0}, {5.0, 1.0}};
    final double value0;
    final double value1;
    final double[][] cTics;
    final double[] cLabels;
    final double unitsPerPixel;
    final double interval;
    final double subInterval;
    final int intervalMagnitude;
    final String labelFormat;
    final boolean isValue0Labeled;
    final boolean isValue1Labeled;

    private AxisIntervals(double value0, double value1, double[][] cTics, double[] cLabels, double unitsPerPixel, double interval, double subInterval, int intervalMagnitude, String labelFormat, boolean isValue0Labeled, boolean isValue1Labeled) {
        this.value0 = value0;
        this.value1 = value1;
        this.cTics = (double[][])Arrays.copyOf(cTics, cTics.length);
        this.cLabels = Arrays.copyOf(cLabels, cLabels.length);
        this.unitsPerPixel = unitsPerPixel;
        this.interval = interval;
        this.subInterval = subInterval;
        this.intervalMagnitude = intervalMagnitude;
        this.labelFormat = labelFormat;
        this.isValue0Labeled = isValue0Labeled;
        this.isValue1Labeled = isValue1Labeled;
    }

    public double getValue0() {
        return this.value0;
    }

    public double getValue1() {
        return this.value1;
    }

    public boolean isValue0Labeled() {
        return this.isValue0Labeled;
    }

    public boolean isValue1Labeled() {
        return this.isValue1Labeled;
    }

    public double[][] getTicCoordinates() {
        double[][] d = new double[this.cTics.length][];
        for (int i = 0; i < this.cTics.length; ++i) {
            d[i] = Arrays.copyOf(this.cTics[i], this.cTics[i].length);
        }
        return d;
    }

    public double[] getLabelCoordinates() {
        return Arrays.copyOf(this.cLabels, this.cLabels.length);
    }

    public String[] getLabels() {
        String[] a = new String[this.cLabels.length];
        for (int i = 0; i < a.length; ++i) {
            a[i] = String.format(this.labelFormat, this.cLabels[i]);
        }
        return a;
    }

    public String getLabelFormat() {
        return this.labelFormat;
    }

    public double getCoordinateScale() {
        return 1.0 / this.unitsPerPixel;
    }

    private static double pow10(int i10) {
        double m10 = Math.exp((double)i10 * LN10);
        if (i10 > 0) {
            m10 = Math.floor(m10 + 1.0E-9);
        }
        return m10;
    }

    public static AxisIntervals computeIntervals(double value0, double value1, int primaryMinIntervalInPixels, int secondaryMinIntervalInPixels, int sizeInPixels) {
        int i1;
        double delta = Math.abs(value1 - value0);
        double uPerPixel = delta / (double)sizeInPixels;
        double log10 = Math.log(delta) / LN10;
        int i10 = (int)Math.floor(log10 + 1.0E-9);
        double firstScore = Double.POSITIVE_INFINITY;
        double firstInterval = Double.NaN;
        double bestM10 = Double.NaN;
        int firstPowerOf10 = 0;
        int firstIndex = -1;
        for (int iPow = i10 - 1; iPow <= i10; ++iPow) {
            double m10 = AxisIntervals.pow10(iPow);
            for (int iTest = 0; iTest < testIntervals.length; ++iTest) {
                double vTest = testIntervals[iTest][0] * m10;
                double pTest = vTest / uPerPixel;
                double pScore = pTest - (double)primaryMinIntervalInPixels;
                if (!(pScore >= 0.0) || !(pScore < firstScore)) continue;
                bestM10 = m10;
                firstPowerOf10 = iPow;
                firstInterval = vTest;
                firstIndex = iTest;
                firstScore = pScore;
            }
        }
        if (firstIndex < 0) {
            return null;
        }
        int secondIndex = -1;
        double secondInterval = Double.NaN;
        double secondScore = Double.POSITIVE_INFINITY;
        for (int i = 1; i < testIntervals[firstIndex].length; ++i) {
            double vTest = testIntervals[firstIndex][i] * bestM10;
            double pTest = vTest / uPerPixel;
            double pScore = pTest - (double)secondaryMinIntervalInPixels;
            if (!(pScore >= 0.0) || !(pScore < secondScore)) continue;
            secondInterval = vTest;
            secondIndex = i;
            secondScore = pScore;
        }
        int nDiv = 1;
        if (secondIndex > 0) {
            nDiv = 2;
        }
        double vOffset = Math.floor(value0 / firstInterval) * firstInterval;
        double v0 = value0 - vOffset;
        double v1 = value1 - vOffset;
        int i0 = (int)Math.ceil(v0 / firstInterval - 1.0E-5);
        if ((double)i0 * firstInterval < v0 - firstInterval / 2.0) {
            ++i0;
        }
        if ((double)(i1 = (int)Math.floor(v1 / firstInterval + 1.0E-5)) * firstInterval > v1 + firstInterval / 2.0) {
            --i1;
        }
        double f0 = (double)i0 * firstInterval;
        double f1 = (double)i1 * firstInterval;
        boolean isValue0Labeled = Math.abs(f0 - v0) / uPerPixel < 1.0;
        boolean isValue1Labeled = Math.abs(f1 - v1) / uPerPixel < 1.0;
        int nTics = i1 - i0 + 1;
        double[][] xTic = new double[nDiv][];
        xTic[0] = new double[nTics];
        double[] xLabel = new double[nTics];
        for (int i = 0; i < nTics; ++i) {
            double v;
            xTic[0][i] = v = vOffset + (double)(i + i0) * firstInterval;
            xLabel[i] = v;
        }
        if (nDiv == 2) {
            int m = (int)Math.floor(firstInterval / secondInterval + 1.0E-5);
            xTic[1] = new double[nTics * m * 2];
            i0 = (int)Math.floor(v0 / secondInterval);
            i1 = (int)Math.ceil(v1 / secondInterval);
            int k = 0;
            for (int i = i0 + 1; i <= i1; ++i) {
                double v;
                if (i % m == 0 || !((v = (double)i * secondInterval) > v0) || !(v < v1)) continue;
                xTic[1][k++] = v + vOffset;
            }
            xTic[1] = Arrays.copyOf(xTic[1], k);
        }
        String labelFmt = "%f";
        if (firstPowerOf10 > 5) {
            labelFmt = "%6.3e";
        } else if (firstPowerOf10 >= 0) {
            int nDigits = firstPowerOf10 + 1;
            if (xTic[0][0] < 0.0) {
                ++nDigits;
            }
            labelFmt = "%" + nDigits + ".0f";
        } else if (firstPowerOf10 >= -3) {
            int nDecimals = -firstPowerOf10;
            labelFmt = "%" + (nDecimals + 2) + "." + nDecimals + "f";
        } else {
            labelFmt = "%6.3e";
        }
        return new AxisIntervals(value0, value1, xTic, xLabel, uPerPixel, firstInterval, secondInterval, firstPowerOf10, labelFmt, isValue0Labeled, isValue1Labeled);
    }

    public double mapValueToPixel(double value) {
        return (value - this.value0) / this.unitsPerPixel;
    }

    public int getIntervalMagnitude() {
        return this.intervalMagnitude;
    }
}

