/*
 * Decompiled with CFR 0.152.
 */
package org.tinfour.demo.examples;

import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.SimpleTimeZone;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.tinfour.common.IIncrementalTin;
import org.tinfour.common.Vertex;
import org.tinfour.demo.utils.IDevelopmentTest;
import org.tinfour.demo.utils.TestOptions;
import org.tinfour.demo.utils.VertexLoader;
import org.tinfour.gwr.GwrTinInterpolator;
import org.tinfour.semivirtual.SemiVirtualIncrementalTin;
import org.tinfour.standard.IncrementalTin;

public class ExampleMultiThreadTest
implements IDevelopmentTest {
    static String[] mandatoryOptions = new String[]{"-in"};
    static final double MAX_MEMORY_FRACTION = 0.6;
    static final long MEMORY_FOR_VIRTUAL = 120L;
    static final long MEMORY_FOR_STANDARD = 240L;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void runTest(PrintStream ps, String[] args) throws IOException {
        IIncrementalTin tin;
        Date date = new Date();
        SimpleDateFormat sdFormat = new SimpleDateFormat("dd MMM yyyy HH:mm", Locale.getDefault());
        sdFormat.setTimeZone(new SimpleTimeZone(0, "UTC"));
        ps.format("ExampleGridFromLasFile%n", new Object[0]);
        ps.format("Date/time of test: %s (UTC)%n", sdFormat.format(date));
        TestOptions options = new TestOptions();
        options.setLidarClass(2);
        boolean[] optionsMatched = options.argumentScan(args);
        options.checkForMandatoryOptions(args, mandatoryOptions);
        Double cellsizeArg = options.scanDoubleOption(args, "-cellSize", optionsMatched);
        double cellSize = 1.0;
        if (cellsizeArg != null && (cellSize = cellsizeArg.doubleValue()) <= 0.0) {
            throw new IllegalArgumentException("Invalid cell size: " + cellSize);
        }
        int nThreads = options.scanIntOption(args, "-nThreads", optionsMatched, 1);
        int nTests = options.getTestCount(5);
        options.checkForUnrecognizedArgument(args, optionsMatched);
        File inputFile = options.getInputFile();
        ps.format("Input file: %s%n", inputFile.getAbsolutePath());
        VertexLoader loader = new VertexLoader();
        List<Vertex> vertexList = loader.readInputFile(options);
        int nVertices = vertexList.size();
        double xmin = loader.getXMin();
        double xmax = loader.getXMax();
        double ymin = loader.getYMin();
        double ymax = loader.getYMax();
        double zmin = loader.getZMin();
        double zmax = loader.getZMax();
        ps.format("Number of vertices: %8d%n", nVertices);
        ps.format("Range x values:     %11.3f, %11.3f, (%f)%n", xmin, xmax, xmax - xmin);
        ps.format("Range y values:     %11.3f, %11.3f, (%f)%n", ymin, ymax, ymax - ymin);
        ps.format("Range z values:     %11.3f, %11.3f, (%f)%n", zmin, zmax, zmax - zmin);
        ps.format("Grid cell size:     %11.3f%n", cellSize);
        ps.flush();
        GridFromBounds grid = new GridFromBounds(cellSize, xmin, xmax, ymin, ymax);
        ps.format("Output grid%n", new Object[0]);
        ps.format("   Rows:              %8d%n", grid.nRows);
        ps.format("   Columns:           %8d%n", grid.nCols);
        ps.format("   Cells:             %8d%n", grid.nCells);
        ps.format("%n", new Object[0]);
        ps.format("Number of threads:    %8d%n", nThreads);
        ps.format("Available processors: %8d%n", Runtime.getRuntime().availableProcessors());
        ps.format("Number of tests:      %8d%n", nTests);
        ps.format("%n", new Object[0]);
        if (options.isTinClassSet()) {
            tin = options.getNewInstanceOfTestTin();
        } else {
            long maxMemoryBytes = Runtime.getRuntime().maxMemory();
            double maxAllowedForUse = (double)maxMemoryBytes * 0.6;
            ps.format("Memory limit for JVM:                       %11.3f megabytes%n", (double)maxMemoryBytes / 1024.0 / 1024.0);
            ps.format("Rule of thumb threshold for method choice:  %11.3f megabytes%n", maxAllowedForUse / 1024.0 / 1024.0);
            long nBytesNeededForStandard = (long)nVertices * 240L;
            long nBytesNeededForVirtual = (long)nVertices * 120L;
            ps.format("Memory required for standard edge class:    %11.3f megabytes%n", (double)nBytesNeededForStandard / 1024.0 / 1024.0);
            ps.format("Memory required for virtual edge class:     %11.3f megabytes%n", (double)nBytesNeededForVirtual / 1024.0 / 1024.0);
            if ((double)nBytesNeededForStandard < maxAllowedForUse) {
                tin = new IncrementalTin();
            } else {
                ps.format("Virtual edge representation selected%n", new Object[0]);
                tin = new SemiVirtualIncrementalTin();
            }
        }
        ps.format("%nBuilding TIN using: %s%n", tin.getClass().getName());
        long time0 = System.nanoTime();
        tin.add(vertexList, null);
        long time1 = System.nanoTime();
        ps.format("Time to build TIN (milliseconds):  %11.3f%n", (double)(time1 - time0) / 1000000.0);
        ThreadPoolExecutor executor = new ThreadPoolExecutor(nThreads, nThreads, 1000L, TimeUnit.SECONDS, (BlockingQueue<Runnable>)new LinkedBlockingQueue<Runnable>(){
            private static final long serialVersionUID = 1L;
        });
        ps.format("%n", new Object[0]);
        ps.format("Performing time comparison tests for elevation grid%n%n", new Object[0]);
        float[][] results1 = new float[grid.nRows][grid.nCols];
        float[][] resultsN = new float[grid.nRows][grid.nCols];
        ps.format("         Time to Process (ms)%n", new Object[0]);
        ps.format("        Single        Multiple       Change (percent)%n", new Object[0]);
        for (int iTest = 0; iTest < nTests; ++iTest) {
            time0 = System.nanoTime();
            this.populateElevationGrid(tin, grid, 0, grid.nRows, results1);
            time1 = System.nanoTime();
            double delta1 = (double)(time1 - time0) / 1000000.0;
            time0 = System.nanoTime();
            TestJobStatusBoard statusBoard = new TestJobStatusBoard(nThreads);
            int nRowsPerJob = (grid.nRows + nThreads - 1) / nThreads;
            for (int i = 0; i < nThreads; ++i) {
                int row0 = i * nRowsPerJob;
                int nRow = nRowsPerJob;
                if (row0 + nRow > grid.nRows) {
                    nRow = grid.nRows - row0;
                }
                TestJob job = new TestJob(tin, grid, row0, nRow, resultsN, statusBoard);
                executor.execute(job);
            }
            TestJobStatusBoard i = statusBoard;
            synchronized (i) {
                while (statusBoard.unfinishedJobsRemain()) {
                    try {
                        statusBoard.wait();
                    }
                    catch (InterruptedException iex) {}
                }
            }
            time1 = System.nanoTime();
            double deltaN = (double)(time1 - time0) / 1000000.0;
            ps.format("%2d    %9.2f      %9.2f         %9.2f%n", iTest, delta1, deltaN, 100.0 * deltaN / delta1);
            ps.flush();
        }
        int mismatches = 0;
        for (int iRow = 0; iRow < grid.nRows; ++iRow) {
            for (int iCol = 0; iCol < grid.nCols; ++iCol) {
                double delta = results1[iRow][iCol] - resultsN[iRow][iCol];
                double absDelta = Math.abs(delta);
                if (!(absDelta > 1.0E-16)) continue;
                System.err.println("Mismatch " + ++mismatches + ": " + iRow + ", " + iCol + ": " + results1[iRow][iCol] + "-" + resultsN[iRow][iCol] + "=" + delta);
            }
        }
        executor.shutdownNow();
    }

    void populateElevationGrid(IIncrementalTin tin, GridFromBounds grid, int row0, int nRows, float[][] results) {
        int nCols = grid.nCols;
        double xLL = grid.xLowerLeft;
        double yUL = grid.yUpperRight;
        double cellSize = grid.cellSize;
        GwrTinInterpolator interpolator = new GwrTinInterpolator(tin);
        for (int iRow = row0; iRow < row0 + nRows; ++iRow) {
            float[] row = results[iRow];
            double yRow = yUL - (double)iRow * cellSize;
            for (int iCol = 0; iCol < nCols; ++iCol) {
                double xCol = (double)iCol * cellSize + xLL;
                double z = interpolator.interpolate(xCol, yRow, null);
                row[iCol] = Double.isNaN(z) ? Float.NaN : (float)z;
            }
        }
    }

    public static void main(String[] args) {
        ExampleMultiThreadTest example = new ExampleMultiThreadTest();
        try {
            example.runTest(System.out, args);
        }
        catch (IOException | IllegalArgumentException ex) {
            ex.printStackTrace(System.err);
        }
    }

    private class TestJob
    implements Runnable {
        final IIncrementalTin tin;
        final GridFromBounds grid;
        final int row0;
        final int nRow;
        final float[][] results;
        final TestJobStatusBoard statusBoard;

        TestJob(IIncrementalTin tin, GridFromBounds grid, int row0, int nRow, float[][] results, TestJobStatusBoard statusBoard) {
            this.tin = tin;
            this.grid = grid;
            this.row0 = row0;
            this.nRow = nRow;
            this.results = results;
            this.statusBoard = statusBoard;
        }

        @Override
        public void run() {
            ExampleMultiThreadTest.this.populateElevationGrid(this.tin, this.grid, this.row0, this.nRow, this.results);
            this.statusBoard.checkIn();
        }
    }

    private class TestJobStatusBoard {
        final int nJobs;
        int nJobsDone;

        TestJobStatusBoard(int nJobs) {
            this.nJobs = nJobs;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void checkIn() {
            TestJobStatusBoard testJobStatusBoard = this;
            synchronized (testJobStatusBoard) {
                ++this.nJobsDone;
                if (this.nJobsDone == this.nJobs) {
                    this.notifyAll();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        boolean unfinishedJobsRemain() {
            TestJobStatusBoard testJobStatusBoard = this;
            synchronized (testJobStatusBoard) {
                return this.nJobsDone < this.nJobs;
            }
        }
    }

    class GridFromBounds {
        final double cellSize;
        final double xLowerLeft;
        final double yLowerLeft;
        final double xUpperRight;
        final double yUpperRight;
        final int nRows;
        final int nCols;
        final int nCells;

        GridFromBounds(double cellSize, double xmin, double xmax, double ymin, double ymax) {
            this.cellSize = cellSize;
            if (cellSize <= 0.0) {
                throw new IllegalArgumentException("Zero or negative cell size not allowed");
            }
            if (xmin >= xmax || ymin >= ymax) {
                throw new IllegalArgumentException("Min/max bounds incorrect");
            }
            int j0 = (int)Math.ceil(xmin / cellSize);
            int j1 = (int)Math.floor(xmax / cellSize);
            int i0 = (int)Math.ceil(ymin / cellSize);
            int i1 = (int)Math.floor(ymax / cellSize);
            this.nRows = i1 - i0 + 1;
            this.nCols = j1 - j0 + 1;
            this.nCells = this.nRows * this.nCols;
            if (this.nRows < 1 || this.nCols < 1) {
                throw new IllegalArgumentException("Bounds are two small for specified cellSize");
            }
            this.xLowerLeft = (double)j0 * cellSize;
            this.yLowerLeft = (double)i0 * cellSize;
            this.xUpperRight = (double)j1 * cellSize;
            this.yUpperRight = (double)i1 * cellSize;
        }
    }
}

