/*
 * Decompiled with CFR 0.152.
 */
package org.tinfour.demo.examples.lake;

import java.awt.geom.Rectangle2D;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;
import org.tinfour.common.IConstraint;
import org.tinfour.common.PolygonConstraint;
import org.tinfour.common.Vertex;
import org.tinfour.gis.utils.ConstraintReaderShapefile;
import org.tinfour.gis.utils.VertexReaderShapefile;
import org.tinfour.utils.HilbertSort;
import org.tinfour.utils.Tincalc;
import org.tinfour.utils.loaders.ICoordinateTransform;
import org.tinfour.utils.loaders.VertexReaderText;

public class BathymetryData {
    private final double zMin;
    private final double zMax;
    private final double zMean;
    private final int zMaxIndex;
    private final int zMinIndex;
    private final List<Vertex> soundings;
    private final List<PolygonConstraint> lakeConstraints;
    private final List<PolygonConstraint> islandConstraints;
    private final Rectangle2D soundingBounds;
    private final Rectangle2D bounds;
    private final double nominalPointSpacing;
    private final long timeToLoadData;

    public BathymetryData(File inputSoundingsFile, File inputShorelineFile, File inputIslandFile, String dbfBathymetryField) throws IOException {
        Rectangle2D b;
        long time0 = System.nanoTime();
        String extension = this.getFileExtension(inputSoundingsFile);
        VertexReaderText vertexReader = null;
        if ("csv".equalsIgnoreCase(extension) || ".txt".equalsIgnoreCase(extension)) {
            vertexReader = new VertexReaderText(inputSoundingsFile);
            this.soundings = vertexReader.read(null);
        } else if ("shp".equalsIgnoreCase(extension)) {
            VertexReaderShapefile vls = new VertexReaderShapefile(inputSoundingsFile);
            vls.setDbfFieldForZ(dbfBathymetryField);
            this.soundings = vls.read(null);
            vertexReader = vls;
        } else {
            throw new IllegalArgumentException("Unsupported file format " + extension + " for input soundings " + inputSoundingsFile.getPath());
        }
        if (this.soundings.size() < 3) {
            throw new IllegalArgumentException("Input file contains fewer than 3 samples, " + inputSoundingsFile.getPath());
        }
        if (this.soundings.size() > 16) {
            HilbertSort hilbertSort = new HilbertSort();
            hilbertSort.sort(this.soundings);
        }
        double z0 = Double.POSITIVE_INFINITY;
        double z1 = Double.NEGATIVE_INFINITY;
        double zSum = 0.0;
        int indexOfMaxZ = -1;
        int indexOfMinZ = -1;
        Vertex v0 = this.soundings.get(0);
        Rectangle2D.Double r2d = new Rectangle2D.Double(v0.getX(), v0.getY(), 0.0, 0.0);
        for (Vertex v : this.soundings) {
            r2d.add(v.getX(), v.getY());
            double z = v.getZ();
            if (z > z1) {
                z1 = z;
                indexOfMaxZ = v.getIndex();
            }
            if (z < z0) {
                z0 = z;
                indexOfMinZ = v.getIndex();
            }
            zSum += z;
        }
        this.zMin = z0;
        this.zMax = z1;
        this.zMean = zSum / (double)this.soundings.size();
        this.zMaxIndex = indexOfMaxZ;
        this.zMinIndex = indexOfMinZ;
        this.soundingBounds = r2d;
        double area = this.soundingBounds.getWidth() * this.soundingBounds.getHeight();
        if (area == 0.0) {
            throw new IllegalArgumentException("Degenerate set of input samples, " + inputSoundingsFile.getPath());
        }
        int n = this.soundings.size();
        this.nominalPointSpacing = Tincalc.sampleSpacing((double)area, (int)n);
        this.lakeConstraints = new ArrayList<PolygonConstraint>();
        this.islandConstraints = new ArrayList<PolygonConstraint>();
        ICoordinateTransform coordinateTransform = vertexReader.getCoordinateTransform();
        List<PolygonConstraint> listL = this.loadConstraints(inputShorelineFile, coordinateTransform);
        List<PolygonConstraint> listI = this.loadConstraints(inputIslandFile, coordinateTransform);
        this.transcribeConstraints(listL, listI);
        r2d = new Rectangle2D.Double(this.soundingBounds.getX(), this.soundingBounds.getY(), this.soundingBounds.getWidth(), this.soundingBounds.getHeight());
        for (IConstraint iConstraint : this.lakeConstraints) {
            b = iConstraint.getBounds();
            r2d.add(b);
        }
        for (IConstraint iConstraint : this.islandConstraints) {
            b = iConstraint.getBounds();
            r2d.add(b);
        }
        this.bounds = r2d;
        long time1 = System.nanoTime();
        this.timeToLoadData = time1 - time0;
    }

    private List<PolygonConstraint> loadConstraints(File file, ICoordinateTransform coordinateTransform) throws IOException {
        ArrayList<PolygonConstraint> list = new ArrayList<PolygonConstraint>();
        if (file == null) {
            return list;
        }
        try (ConstraintReaderShapefile cReader = new ConstraintReaderShapefile(file);){
            cReader.setCoordinateTransform(coordinateTransform);
            List temp = cReader.read();
            for (IConstraint con : temp) {
                if (con instanceof PolygonConstraint) {
                    list.add((PolygonConstraint)con);
                    continue;
                }
                throw new IllegalArgumentException("Constraint file contains non-polygon features " + file.getName());
            }
        }
        return list;
    }

    private void transcribeConstraints(List<PolygonConstraint> listL, List<PolygonConstraint> listI) {
        boolean lakeContainsHoles = false;
        for (PolygonConstraint p : listL) {
            if (!(p.getArea() < 0.0)) continue;
            lakeContainsHoles = true;
            break;
        }
        if (lakeContainsHoles) {
            for (PolygonConstraint p : listL) {
                double a = p.getArea();
                if (a > 0.0) {
                    this.lakeConstraints.add(p);
                    continue;
                }
                if (!(a < 0.0)) continue;
                this.islandConstraints.add(this.reverse(p));
            }
        } else {
            this.lakeConstraints.addAll(listL);
            for (PolygonConstraint p : listI) {
                double a = p.getArea();
                if (!(a > 0.0)) continue;
                this.islandConstraints.add(p);
            }
        }
    }

    private PolygonConstraint reverse(PolygonConstraint c) {
        List vList = c.getVertices();
        ArrayList nList = new ArrayList(vList.size());
        for (int i = vList.size() - 1; i >= 0; --i) {
            nList.add(vList.get(i));
        }
        return c.getConstraintWithNewGeometry(nList);
    }

    public double getMinZ() {
        return this.zMin;
    }

    public double getMaxZ() {
        return this.zMax;
    }

    public double getMeanZ() {
        return this.zMean;
    }

    public double getNominalPointSpacing() {
        return this.nominalPointSpacing;
    }

    public List<Vertex> getSoundings() {
        ArrayList<Vertex> result = new ArrayList<Vertex>(this.soundings.size());
        result.addAll(this.soundings);
        return result;
    }

    public List<Vertex> getReducedListOfSoundings(int nTarget) {
        int n = this.soundings.size();
        ArrayList<Vertex> result = new ArrayList<Vertex>(nTarget + 10);
        int skip = (int)((double)this.soundings.size() / (double)nTarget + 0.5);
        if (skip == 0) {
            skip = 1;
        }
        int k = 0;
        for (int i = 0; i < nTarget && k < n; k += skip, ++i) {
            result.add(this.soundings.get(k));
        }
        return result;
    }

    public List<PolygonConstraint> getLakeConstraints() {
        return this.lakeConstraints;
    }

    public List<PolygonConstraint> getIslandConstraints() {
        return this.islandConstraints;
    }

    public Rectangle2D getSoundingBounds() {
        return new Rectangle2D.Double(this.soundingBounds.getX(), this.soundingBounds.getY(), this.soundingBounds.getWidth(), this.soundingBounds.getHeight());
    }

    public Rectangle2D getBounds() {
        return new Rectangle2D.Double(this.bounds.getX(), this.bounds.getY(), this.bounds.getWidth(), this.bounds.getHeight());
    }

    public long getTimeToLoadData() {
        return this.timeToLoadData;
    }

    public void printSummary(PrintStream ps) {
        double x0 = this.soundingBounds.getMinX();
        double y0 = this.soundingBounds.getMinY();
        double x1 = this.soundingBounds.getMaxX();
        double y1 = this.soundingBounds.getMaxY();
        ps.format("Input Data%n", new Object[0]);
        ps.format("  Soundings%n", new Object[0]);
        ps.format("     Count:               %7d%n", this.soundings.size());
        ps.format("     Min (x,y,z):         %9.1f, %9.1f, %9.2f (feature %d)%n", x0, y0, this.zMin, this.zMinIndex);
        ps.format("     Max (x,y,z):         %9.1f, %9.1f, %9.2f (feature %d)%n", x1, y1, this.zMax, this.zMaxIndex);
        ps.format("     width,height:        %9.1f, %9.1f%n", x1 - x0, y1 - y0);
        ps.format("     Est. sample spacing: %9.1f%n", this.nominalPointSpacing);
    }

    private String getFileExtension(File file) {
        String name;
        int i;
        if (file != null && (i = (name = file.getName()).lastIndexOf(46)) > 0 && i < name.length() - 1) {
            return name.substring(i + 1, name.length());
        }
        return null;
    }
}

