/*
 * Decompiled with CFR 0.152.
 */
package org.tinfour.demo.performance;

import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.SimpleTimeZone;
import org.tinfour.common.IIncrementalTin;
import org.tinfour.common.IIntegrityCheck;
import org.tinfour.common.Vertex;
import org.tinfour.common.VertexMergerGroup;
import org.tinfour.demo.utils.IDevelopmentTest;
import org.tinfour.demo.utils.TestOptions;
import org.tinfour.demo.utils.VertexLoader;

public class RepeatedDeleteTest
implements IDevelopmentTest {
    static final String[] mandatoryOptions = new String[]{"-in"};
    static final String[] usage = new String[]{"Usage for Test Repeated Deletion and Reinsert", "   Mandatory Arguments:", "       -in <valid LAS, CSV, or TXT file>", "   Optional Arguments:", "       -lidarClass      value in the range 0 to 255, defaults to not applied", "       -lidarThinning   thinnging factor, range 0 to 1.0, defaults to not applied", "       -clip            xmin, xmax, ymin, ymax", "       -prealloc, -noPrealloc  boolean, default noPreAlloc", "       -preSort,  -noPreSort   boolean, dfault noPreSort", "       -tinClass <class>   path of class for testing, defaults to IncrementalTin"};

    public static void main(String[] args) {
        RepeatedDeleteTest test = new RepeatedDeleteTest();
        try {
            test.runTest(System.out, args);
        }
        catch (IOException | IllegalArgumentException ex) {
            ex.printStackTrace(System.err);
        }
    }

    @Override
    public void runTest(PrintStream ps, String[] args) throws IOException {
        if (args.length == 0) {
            for (String s : usage) {
                ps.println(s);
            }
            return;
        }
        TestOptions options = new TestOptions();
        boolean[] optionsMatched = options.argumentScan(args);
        options.checkForUnrecognizedArgument(args, optionsMatched);
        Class<?> tinClass = options.getTinClass();
        boolean usePreAlloc = options.isPreAllocateEnabled(false);
        int nTests = options.getTestCount(8);
        File input = options.getInputFile();
        Locale locale = Locale.getDefault();
        Date date = new Date();
        SimpleDateFormat sdFormat = new SimpleDateFormat("dd MMM yyyy HH:mm", locale);
        sdFormat.setTimeZone(new SimpleTimeZone(0, "UTC"));
        long sumTotal = 0L;
        long maxTime = 0L;
        int nTotal = 0;
        long mem0 = this.getUsedMemory();
        VertexLoader loader = new VertexLoader();
        List<Vertex> vertexList = loader.readInputFile(options);
        double timeForPreSort = loader.getTimeForPreSort();
        int nVertices = vertexList.size();
        long mem1 = this.getUsedMemory();
        long vertexMemory = mem1 - mem0;
        long mem2 = mem1;
        ps.println("");
        ps.println("Date of test:       " + sdFormat.format(date) + " UTC");
        ps.println("Input file:         " + input.getAbsolutePath());
        ps.println("TIN class:          " + tinClass.getName());
        ps.println("Time for pre-sort   " + timeForPreSort);
        ps.println("Number of vertices  " + vertexList.size());
        IIncrementalTin tin = options.getNewInstanceOfTestTin();
        ps.println("run,        build,    avg_build,     total_mem,   alloc_time");
        int iAvg = 3;
        for (int iTest = 0; iTest < nTests; ++iTest) {
            long time1;
            long time0;
            String preallocTime = "       ~~~";
            tin = options.getNewInstanceOfTestTin();
            if (usePreAlloc) {
                time0 = System.nanoTime();
                tin.preAllocateEdges(nVertices);
                time1 = System.nanoTime();
                preallocTime = String.format("%12.3f", (double)(time1 - time0) / 1000000.0);
            }
            tin.add(vertexList, null);
            List testList = tin.getVertices();
            time0 = System.nanoTime();
            for (Vertex v : testList) {
                if (v instanceof VertexMergerGroup) continue;
                tin.remove(v);
                tin.add(v);
            }
            time1 = System.nanoTime();
            long deltaBuild = time1 - time0;
            double avgTotal = 0.0;
            if (iTest >= iAvg) {
                nTotal = iTest - iAvg + 1;
                avgTotal = (double)(sumTotal += deltaBuild) / (double)nTotal;
                if (deltaBuild > maxTime) {
                    maxTime = deltaBuild;
                }
            }
            long memTotal = iTest == 0 ? (mem2 = this.getUsedMemory()) : this.getUsedMemory();
            if (iTest < nTests - 1) {
                tin.dispose();
            }
            ps.format("%3d, %12.3f, %12.3f, %12.3f, %s%n", iTest, (double)deltaBuild / 1000000.0, avgTotal / 1000000.0, (double)memTotal / 1048576.0, preallocTime);
        }
        if (nTotal > 1) {
            double avgTotal = (sumTotal - maxTime) / (long)(nTotal - 1);
            ps.format("Avg max removed:   %12.3f%n", avgTotal / 1000000.0);
        }
        ps.println("");
        long deltaMemory = mem2 - mem1;
        double bytesPerVertex = (double)(deltaMemory + vertexMemory) / (double)nVertices;
        double verticesOnly = (double)vertexMemory / (double)nVertices;
        ps.println("");
        ps.println("Stats for last run in series");
        ps.println("Vertices added to TIN:    " + nVertices);
        ps.println("Memory use (bytes/vertex) ");
        ps.format("   All objects:           %6.2f%n", bytesPerVertex);
        ps.format("   Vertices only:         %6.2f%n", verticesOnly);
        ps.println("");
        ps.println("Performing integrity check");
        IIntegrityCheck sane2 = tin.getIntegrityCheck();
        boolean status = sane2.inspect();
        if (!status) {
            ps.println("Integrity check failed " + sane2.getMessage());
        }
        tin.printDiagnostics(ps);
        ps.println("Test complete");
    }

    private long getUsedMemory() {
        Runtime runtime = Runtime.getRuntime();
        runtime.gc();
        try {
            Thread.sleep(2000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return runtime.totalMemory() - runtime.freeMemory();
    }
}

