/*
 * Decompiled with CFR 0.152.
 */
package org.tinfour.demo.utils;

import com.github.mreutegg.laszip4j.LASPoint;
import com.github.mreutegg.laszip4j.LASReader;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.tinfour.common.IMonitorWithCancellation;
import org.tinfour.common.Vertex;
import org.tinfour.demo.utils.VertexWithClassification;
import org.tinfour.gis.las.ILasRecordFilter;
import org.tinfour.gis.las.LasPoint;
import org.tinfour.gis.las.LasScaleAndOffset;

public class VertexLoaderLaz {
    LasScaleAndOffset lasScaleAndOffset;
    double geoOffsetX;
    double geoScaleX;
    double geoOffsetY;
    double geoScaleY;
    long maximumNumberOfVertices;

    VertexLoaderLaz(LasScaleAndOffset lasScaleAndOffset, double geoOffsetX, double geoScaleX, double geoOffsetY, double geoScaleY, long maximumNumberOfVertices) {
        this.lasScaleAndOffset = lasScaleAndOffset;
        this.geoOffsetX = geoOffsetX;
        this.geoScaleX = geoScaleX;
        this.geoOffsetY = geoOffsetY;
        this.geoScaleY = geoScaleY;
        this.maximumNumberOfVertices = maximumNumberOfVertices;
    }

    public List<Vertex> loadVertices(File file, long nVertices, ILasRecordFilter filter, int iProgressThreshold, IMonitorWithCancellation progressMonitor) throws IOException {
        ArrayList<Vertex> list = new ArrayList<Vertex>();
        int pProgressThreshold = 0;
        LASReader reader = new LASReader(file);
        LasScaleAndOffset so = this.lasScaleAndOffset;
        LasPoint t4Point = new LasPoint();
        int iRecord = 0;
        for (LASPoint p : reader.getPoints()) {
            if (pProgressThreshold == iProgressThreshold && progressMonitor != null) {
                pProgressThreshold = 0;
                progressMonitor.reportProgress((int)(0.1 + 100.0 * (double)(iRecord + 1) / (double)nVertices));
            }
            ++iRecord;
            ++pProgressThreshold;
            if (p.isWithheld()) continue;
            t4Point.x = (double)p.getX() * so.xScaleFactor + so.xOffset;
            t4Point.y = (double)p.getY() * so.yScaleFactor + so.yOffset;
            t4Point.z = (double)p.getZ() * so.zScaleFactor + so.zOffset;
            t4Point.classification = p.getClassification();
            t4Point.returnNumber = p.getReturnNumber();
            t4Point.numberOfReturns = p.getNumberOfReturns();
            if (!filter.accept(t4Point)) continue;
            double x = (t4Point.x - this.geoOffsetX) * this.geoScaleX;
            double y = (t4Point.y - this.geoOffsetY) * this.geoScaleY;
            double z = t4Point.z;
            VertexWithClassification v = new VertexWithClassification(x, y, z, iRecord, t4Point.classification);
            list.add(v);
            if ((long)list.size() < this.maximumNumberOfVertices) continue;
            break;
        }
        return list;
    }
}

