/*
 * Decompiled with CFR 0.152.
 */
package org.tinfour.demo.viewer;

import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.LayoutStyle;
import org.tinfour.gis.shapefile.DbfField;
import org.tinfour.gis.shapefile.DbfFileReader;
import org.tinfour.gis.shapefile.ShapefileReader;
import org.tinfour.gis.shapefile.ShapefileType;

public class ShapefileOptionsPanel
extends JPanel {
    private ActionListener okActionListener;
    private JButton cancelButton;
    private JLabel fileDescriptionLabel;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JComboBox<String> metadataComboBox;
    private JRadioButton metadataRadioButton;
    private JButton okButton;
    private JRadioButton shapefileGeometryRadioButton;
    private ButtonGroup zCoordinateSourceButtonGroup;

    public ShapefileOptionsPanel() {
        this.initComponents();
    }

    void applyShapefile(ShapefileReader reader) {
        String[] s;
        ArrayList<String> fList = new ArrayList<String>();
        try (DbfFileReader dbfFile = reader.getDbfFileReader();){
            List list = dbfFile.getFields();
            for (DbfField field : list) {
                if (!field.isNumeric()) continue;
                fList.add(field.getName());
            }
        }
        catch (IOException ioex) {
            fList.clear();
        }
        if (fList.size() > 0) {
            s = fList.toArray(new String[fList.size()]);
            this.metadataRadioButton.setEnabled(true);
        } else {
            s = new String[]{"Not applicable"};
            this.metadataRadioButton.setEnabled(false);
            this.metadataComboBox.setEnabled(false);
        }
        DefaultComboBoxModel<String> model = new DefaultComboBoxModel<String>(s);
        this.metadataComboBox.setModel(model);
        ShapefileType sfType = reader.getShapefileType();
        String name = reader.getFile().getName();
        String description = sfType.is3D() ? name + " has a 3D geometry" : name + " has a 2D geometry";
        this.fileDescriptionLabel.setText(description);
    }

    private void hideDialog() {
        Container c = this;
        while (!((c = c.getParent()) instanceof JDialog)) {
        }
        JDialog jd = (JDialog)c;
        jd.setVisible(false);
    }

    void setOkActionListener(ActionListener listener) {
        this.okActionListener = listener;
    }

    String getMetadataSelection() {
        Object s;
        if (this.metadataRadioButton.isSelected() && (s = this.metadataComboBox.getSelectedItem()) instanceof String) {
            return (String)s;
        }
        return null;
    }

    private void initComponents() {
        this.zCoordinateSourceButtonGroup = new ButtonGroup();
        this.jPanel1 = new JPanel();
        this.shapefileGeometryRadioButton = new JRadioButton();
        this.metadataRadioButton = new JRadioButton();
        this.metadataComboBox = new JComboBox();
        this.jLabel2 = new JLabel();
        this.jLabel3 = new JLabel();
        this.jLabel4 = new JLabel();
        this.jLabel5 = new JLabel();
        this.fileDescriptionLabel = new JLabel();
        this.jPanel2 = new JPanel();
        this.cancelButton = new JButton();
        this.okButton = new JButton();
        this.jPanel1.setBorder(BorderFactory.createTitledBorder("Shapefile z-coordinate options"));
        this.zCoordinateSourceButtonGroup.add(this.shapefileGeometryRadioButton);
        this.shapefileGeometryRadioButton.setSelected(true);
        this.shapefileGeometryRadioButton.setText("Use Shapefile Geometry");
        this.zCoordinateSourceButtonGroup.add(this.metadataRadioButton);
        this.metadataRadioButton.setText("Use Metadata Element (from DBF file)");
        this.metadataRadioButton.setToolTipText("Use Z coordinate from Shapefile (if available)");
        this.metadataComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.metadataComboBox.setToolTipText("Select element from metadata");
        this.metadataComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ShapefileOptionsPanel.this.metadataComboBoxActionPerformed(evt);
            }
        });
        this.jLabel2.setText("Metadata Fields:");
        this.jLabel3.setText("If a Shapefile includes 3D coordinates, it can be used to specify Z values.");
        this.jLabel4.setText("If the associated metadata includes numeric fields, they can be used for Z coordinates.");
        this.jLabel5.setText("If the geometry option is used for 2D Shapefiles, all Z values will be set to zero.");
        this.fileDescriptionLabel.setText("Filename is a 2D file.");
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.metadataRadioButton).addComponent(this.shapefileGeometryRadioButton)).addGap(0, 0, Short.MAX_VALUE)).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addComponent(this.fileDescriptionLabel).addContainerGap(-1, Short.MAX_VALUE)).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addGap(21, 21, 21).addComponent(this.jLabel2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.metadataComboBox, -2, 87, -2)).addComponent(this.jLabel3).addComponent(this.jLabel4).addComponent(this.jLabel5)).addContainerGap(15, Short.MAX_VALUE))));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addComponent(this.shapefileGeometryRadioButton).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.metadataRadioButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 76, Short.MAX_VALUE).addComponent(this.fileDescriptionLabel).addGap(72, 72, 72)).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addGap(63, 63, 63).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.metadataComboBox, -2, -1, -2).addComponent(this.jLabel2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 70, Short.MAX_VALUE).addComponent(this.jLabel3).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel5).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel4).addContainerGap())));
        this.cancelButton.setText("Cancel");
        this.cancelButton.setToolTipText("Click to cancel selections");
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ShapefileOptionsPanel.this.cancelButtonActionPerformed(evt);
            }
        });
        this.okButton.setText("OK");
        this.okButton.setToolTipText("Click to apply selections");
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ShapefileOptionsPanel.this.okButtonActionPerformed(evt);
            }
        });
        GroupLayout jPanel2Layout = new GroupLayout(this.jPanel2);
        this.jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel2Layout.createSequentialGroup().addContainerGap(309, Short.MAX_VALUE).addComponent(this.okButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cancelButton).addContainerGap()));
        jPanel2Layout.linkSize(0, this.cancelButton, this.okButton);
        jPanel2Layout.setVerticalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel2Layout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.cancelButton).addComponent(this.okButton)).addContainerGap()));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel2, -1, -1, Short.MAX_VALUE).addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(10, 10, 10).addComponent(this.jPanel1, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.jPanel2, -2, -1, -2).addGap(0, 0, 0)));
    }

    private void okButtonActionPerformed(ActionEvent evt) {
        this.hideDialog();
        if (this.okActionListener != null) {
            this.okActionListener.actionPerformed(evt);
        }
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        this.hideDialog();
    }

    private void metadataComboBoxActionPerformed(ActionEvent evt) {
        this.metadataRadioButton.setSelected(true);
    }
}

