/*
 * Decompiled with CFR 0.152.
 */
package org.tinfour.demo.viewer;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.tinfour.common.IMonitorWithCancellation;
import org.tinfour.demo.viewer.StatusPanelMonitor;

public class StatusPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    JLabel statusLabel;
    StatusPanelMonitor currentMonitor;
    int taskIndex;

    StatusPanel() {
        this.setLayout(new GridBagLayout());
        this.statusLabel = new JLabel("To view a data source, drag file onto panel");
        this.statusLabel.setToolTipText("Indicates status");
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.weightx = 0.9;
        c.ipadx = 5;
        c.fill = 0;
        c.anchor = 22;
        this.add((Component)this.statusLabel, c);
    }

    public void postMessage(final int index, final String message) {
        if (SwingUtilities.isEventDispatchThread()) {
            this.spPostNotice(index, message);
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    StatusPanel.this.spPostNotice(index, message);
                }
            });
        }
    }

    public void clear(final int taskIndex) {
        if (SwingUtilities.isEventDispatchThread()) {
            this.spClear(taskIndex);
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    StatusPanel.this.spClear(taskIndex);
                }
            });
        }
    }

    private void spPostNotice(int index, String notice) {
        if (index < this.taskIndex) {
            return;
        }
        this.taskIndex = index;
        if (notice == null || notice.isEmpty()) {
            this.statusLabel.setText("");
        } else {
            this.statusLabel.setText(notice);
        }
    }

    private void spClear(int index) {
        if (index < this.taskIndex) {
            return;
        }
        this.statusLabel.setText("");
        this.taskIndex = 0;
    }

    public IMonitorWithCancellation getProgressMonitor(final int index) {
        if (index == this.taskIndex && this.currentMonitor != null) {
            return this.currentMonitor;
        }
        final StatusPanel self = this;
        final StatusPanelMonitor monitor = new StatusPanelMonitor(this, index, 0, 0, 100);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (index >= self.taskIndex) {
                    self.taskIndex = index;
                    if (StatusPanel.this.currentMonitor != null) {
                        StatusPanel.this.remove(StatusPanel.this.currentMonitor);
                    }
                    monitor.setValue(0);
                    monitor.setStringPainted(true);
                    GridBagConstraints c = new GridBagConstraints();
                    c.gridx = 1;
                    c.gridy = 0;
                    c.weightx = 0.0;
                    c.fill = 0;
                    c.anchor = 22;
                    c.ipadx = 5;
                    StatusPanel.this.add((Component)monitor, c);
                    StatusPanel.this.currentMonitor = monitor;
                    StatusPanel.this.revalidate();
                }
            }
        });
        return monitor;
    }

    @Override
    public void remove(Component c) {
        super.remove(c);
        if (c.equals(this.currentMonitor)) {
            this.currentMonitor = null;
            this.revalidate();
            this.repaint();
        }
    }
}

