/*
 * Decompiled with CFR 0.152.
 */
package org.tinfour.demo.viewer;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Arrays;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.ListCellRenderer;
import org.tinfour.demo.utils.TestPalette;
import org.tinfour.demo.viewer.ColorButton;
import org.tinfour.demo.viewer.DataViewingPanel;
import org.tinfour.demo.viewer.backplane.LidarPointSelection;
import org.tinfour.demo.viewer.backplane.ViewOptions;

class ViewOptionsPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private DataViewingPanel dvPanel;
    private ViewOptions view = new ViewOptions();
    private List<String> paletteNames;
    private JPanel actionsPanel;
    private JTextField ambientTextField;
    private JButton applyButton;
    private JTextField azimuthTextField;
    private JRadioButton blackOnWhiteRadioButton;
    private JButton cancelButton;
    private JCheckBox constraintsCheckBox;
    private ColorButton constraintsColorButton;
    private JCheckBox edgesCheckBox;
    private JTextField elevationTextField;
    private ButtonGroup foregroundBackgroundButtonGroup;
    private JCheckBox fullResolutionGridCheckbox;
    private JCheckBox hillshadeCheckBox;
    private JLabel jLabel1;
    private JLabel jLabel10;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private JLabel jLabel8;
    private JLabel jLabel9;
    private JComboBox<String> labelFieldComboBox;
    private JCheckBox labelsCheckBox;
    private JRadioButton lidarAllPointsButton;
    private JRadioButton lidarFirstReturnButton;
    private JRadioButton lidarGroundPointsButton;
    private JRadioButton lidarLastReturnButton;
    private ButtonGroup lidarPointSelectionGroup;
    private JButton okayButton;
    private JPanel optionsPanel;
    private ButtonGroup paletteAssignButtonGroup;
    private JRadioButton paletteAssignEntireDataSet;
    private JRadioButton paletteAssignFixedRange;
    private JTextField paletteAssignMaxRange;
    private JTextField paletteAssignMinRange;
    private JComboBox<Integer> paletteComboBox;
    private JCheckBox rasterCheckBox;
    private JComboBox<String> rasterMethodComboBox;
    private JCheckBox verticesCheckBox;
    private JRadioButton whiteOnBlackRadioButton;
    private JCheckBox wireframeCheckBox;
    private ButtonGroup wireframeColorButtonGroup;
    private JRadioButton wireframeColorUsingForeground;
    private JRadioButton wireframeColorUsingPalette;
    private JComboBox<String> wireframeSampleThinningComboBox;

    ViewOptionsPanel() {
        this.initComponents();
        this.initializePalette();
    }

    void setDataViewingPanel(DataViewingPanel dvPanel) {
        this.dvPanel = dvPanel;
    }

    void setViewOptions(ViewOptions view) {
        this.view = new ViewOptions(view);
        this.transcribeViewToComponents();
    }

    final void initializePalette() {
        this.paletteNames = TestPalette.getPaletteNames();
        Icon[] icons = new Icon[this.paletteNames.size()];
        String[] names = new String[this.paletteNames.size()];
        Integer[] indices = new Integer[this.paletteNames.size()];
        boolean readFailure = false;
        for (int i = 0; i < icons.length; ++i) {
            String s;
            names[i] = s = this.paletteNames.get(i);
            icons[i] = TestPalette.getIconByName(s, 96, 20);
            indices[i] = i;
            if (icons[i] != null) continue;
            readFailure = true;
        }
        if (readFailure) {
            int k = 0;
            for (int i = 0; i < icons.length; ++i) {
                if (icons[i] == null) continue;
                names[k] = names[i];
                icons[k] = icons[i];
                indices[k] = indices[i];
                ++k;
            }
            names = Arrays.copyOf(names, k);
            icons = Arrays.copyOf(icons, k);
            indices = Arrays.copyOf(indices, k);
        }
        DefaultComboBoxModel<Integer> dcb = new DefaultComboBoxModel<Integer>(indices);
        this.paletteComboBox.setModel(dcb);
        this.paletteComboBox.setRenderer(new PaletteRenderer(names, icons));
    }

    private void setDouble(JTextField field, String fmt, double v) {
        if (!Double.isNaN(v)) {
            if (Math.floor(v + 1.0E-6) == (double)((int)v)) {
                field.setText(Integer.toString((int)v));
            } else {
                field.setText(String.format(fmt, v));
            }
        }
    }

    void transcribeViewToComponents() {
        int paletteIndex = 0;
        String s = this.view.getPaletteName();
        List<String> names = TestPalette.getPaletteNames();
        for (int i = 0; i < names.size(); ++i) {
            if (!names.get(i).equalsIgnoreCase(s)) continue;
            paletteIndex = i;
            break;
        }
        this.paletteComboBox.setSelectedIndex(paletteIndex);
        int fgOption = this.view.getForegroundBackgroundOption();
        this.blackOnWhiteRadioButton.setSelected(fgOption == 0);
        this.whiteOnBlackRadioButton.setSelected(fgOption == 1);
        boolean useRangeOfValues = this.view.useRangeOfValuesForPalette();
        double[] d = this.view.getRangeForPalette();
        this.setDouble(this.paletteAssignMinRange, "%5.3f", d[0]);
        this.setDouble(this.paletteAssignMaxRange, "%5.3f", d[1]);
        this.paletteAssignEntireDataSet.setSelected(!useRangeOfValues);
        this.paletteAssignFixedRange.setSelected(useRangeOfValues);
        this.wireframeCheckBox.setSelected(this.view.isWireframeSelected());
        ViewOptions.SampleThinning wThin = this.view.getWireframeSampleThinning();
        switch (wThin) {
            case Medium: {
                this.wireframeSampleThinningComboBox.setSelectedIndex(0);
                break;
            }
            case Fine: {
                this.wireframeSampleThinningComboBox.setSelectedIndex(1);
                break;
            }
            case ExtraFine: {
                this.wireframeSampleThinningComboBox.setSelectedIndex(2);
                break;
            }
            default: {
                this.wireframeSampleThinningComboBox.setSelectedIndex(0);
            }
        }
        this.wireframeColorUsingForeground.setSelected(!this.view.usePaletteForWireframe());
        this.wireframeColorUsingPalette.setSelected(this.view.usePaletteForWireframe());
        this.edgesCheckBox.setSelected(this.view.isEdgeRenderingSelected());
        this.verticesCheckBox.setSelected(this.view.isVertexRenderingSelected());
        this.labelsCheckBox.setSelected(this.view.isLabelRenderingSelected());
        s = this.view.getFieldForLabel();
        if ("Z".equalsIgnoreCase(s)) {
            this.labelFieldComboBox.setSelectedItem(0);
        } else if ("ID".equalsIgnoreCase(s)) {
            this.labelFieldComboBox.setSelectedItem(1);
        } else {
            this.labelFieldComboBox.setSelectedItem(0);
        }
        this.constraintsCheckBox.setSelected(this.view.isConstraintRenderingSelected());
        this.constraintsColorButton.setColor(this.view.getConstraintColor());
        this.rasterCheckBox.setSelected(this.view.isRasterSelected());
        this.hillshadeCheckBox.setSelected(this.view.isHillshadeSelected());
        this.setDouble(this.azimuthTextField, "%3.1f", this.view.getHillshadeAzimuth());
        this.setDouble(this.elevationTextField, "%3.1f", this.view.getHillshadeElevation());
        this.setDouble(this.ambientTextField, "%3.1f", this.view.getHillshadeAmbient());
        this.fullResolutionGridCheckbox.setSelected(this.view.isFullResolutionGridSelected());
        this.lidarGroundPointsButton.setSelected(false);
        this.lidarFirstReturnButton.setSelected(false);
        this.lidarAllPointsButton.setSelected(false);
        switch (this.view.getLidarPointSelection()) {
            case GroundPoints: {
                this.lidarGroundPointsButton.setSelected(true);
                break;
            }
            case FirstReturn: {
                this.lidarFirstReturnButton.setSelected(true);
                break;
            }
            case LastReturn: {
                this.lidarLastReturnButton.setSelected(true);
                break;
            }
            case AllPoints: {
                this.lidarAllPointsButton.setSelected(false);
                break;
            }
            default: {
                this.lidarGroundPointsButton.setSelected(true);
            }
        }
        int index = this.view.getRasterInterpolationMethod().ordinal();
        this.rasterMethodComboBox.setSelectedIndex(index);
    }

    private double extractField(JTextField field, double value) {
        double d = this.extractDouble(field);
        if (Double.isNaN(d)) {
            return value;
        }
        return d;
    }

    private double extractDouble(JTextField field) {
        try {
            String s = field.getText();
            if (s != null && !(s = s.trim()).isEmpty()) {
                return Double.parseDouble(s.trim());
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return Double.NaN;
    }

    boolean transcribeComponentsToView() {
        boolean badInput = false;
        int paletteIndex = this.paletteComboBox.getSelectedIndex();
        String paletteName = this.paletteNames.get(paletteIndex);
        this.view.setPaletteName(paletteName);
        if (this.blackOnWhiteRadioButton.isSelected()) {
            this.view.setForegroundBackgroundOption(0);
            this.view.setForeground(Color.black);
            this.view.setBackground(Color.white);
        } else {
            this.view.setForegroundBackgroundOption(1);
            this.view.setForeground(Color.white);
            this.view.setBackground(Color.black);
        }
        boolean useRangeOfValues = this.paletteAssignFixedRange.isSelected();
        double a = this.extractDouble(this.paletteAssignMinRange);
        double b = this.extractDouble(this.paletteAssignMaxRange);
        double[] d = new double[]{a, b};
        this.view.setRangeForPalette(d);
        if (useRangeOfValues) {
            if (Double.isNaN(a) || Double.isNaN(b)) {
                JOptionPane.showMessageDialog(this.paletteAssignFixedRange, "Invalid entry for specified palette range", "Bad Numeric Entry", 0);
                useRangeOfValues = false;
                badInput = true;
            } else if (Math.abs(a - b) < Math.abs(a + b) / 1000000.0) {
                JOptionPane.showMessageDialog(this.paletteAssignFixedRange, "Palette range entries must be distinct", "Values not distinct", 0);
                useRangeOfValues = false;
                badInput = true;
            }
        }
        this.view.setUseRangeOfValuesForPalette(useRangeOfValues);
        this.view.setWireframeSelected(this.wireframeCheckBox.isSelected());
        int index = this.wireframeSampleThinningComboBox.getSelectedIndex();
        switch (index) {
            case 0: {
                this.view.setWireframeSampleThinning(ViewOptions.SampleThinning.Medium);
                break;
            }
            case 1: {
                this.view.setWireframeSampleThinning(ViewOptions.SampleThinning.Fine);
                break;
            }
            case 2: {
                this.view.setWireframeSampleThinning(ViewOptions.SampleThinning.ExtraFine);
                break;
            }
            default: {
                this.view.setWireframeSampleThinning(ViewOptions.SampleThinning.Medium);
            }
        }
        this.view.setUsePaletteForWireframe(this.wireframeColorUsingPalette.isSelected());
        this.view.setEdgeRenderingSelected(this.edgesCheckBox.isSelected());
        this.view.setVertexRenderingSelected(this.verticesCheckBox.isSelected());
        this.view.setLabelRenderingSelected(this.labelsCheckBox.isSelected());
        String labelField = "Z";
        if (this.labelFieldComboBox.getSelectedIndex() == 1) {
            labelField = "ID";
        }
        this.view.setFieldForLabel(labelField);
        this.view.setConstraintRenderingSelected(this.constraintsCheckBox.isSelected());
        this.view.setConstraintColor(this.constraintsColorButton.colorChoice);
        this.view.setRasterSelected(this.rasterCheckBox.isSelected());
        this.view.setHillshadeSelected(this.hillshadeCheckBox.isSelected());
        this.view.setHillshadeAzimuth(this.extractField(this.azimuthTextField, 135.0));
        this.view.setHillshadeElevation(this.extractField(this.elevationTextField, 60.0));
        this.view.setHillshadeAmbient(this.extractField(this.ambientTextField, 135.0));
        this.view.setFullResolutionGridSelected(this.fullResolutionGridCheckbox.isSelected());
        if (this.lidarGroundPointsButton.isSelected()) {
            this.view.setLidarPointSelection(LidarPointSelection.GroundPoints);
        } else if (this.lidarFirstReturnButton.isSelected()) {
            this.view.setLidarPointSelection(LidarPointSelection.FirstReturn);
        } else if (this.lidarLastReturnButton.isSelected()) {
            this.view.setLidarPointSelection(LidarPointSelection.LastReturn);
        } else {
            this.view.setLidarPointSelection(LidarPointSelection.AllPoints);
        }
        index = this.rasterMethodComboBox.getSelectedIndex();
        ViewOptions.RasterInterpolationMethod rim = ViewOptions.RasterInterpolationMethod.values()[index];
        this.view.setRasterInterpolationMethod(rim);
        return badInput;
    }

    private void hideDialog() {
        Container c = this;
        while (!((c = c.getParent()) instanceof JDialog)) {
        }
        JDialog jd = (JDialog)c;
        jd.setVisible(false);
    }

    private void initComponents() {
        this.paletteAssignButtonGroup = new ButtonGroup();
        this.lidarPointSelectionGroup = new ButtonGroup();
        this.wireframeColorButtonGroup = new ButtonGroup();
        this.foregroundBackgroundButtonGroup = new ButtonGroup();
        this.optionsPanel = new JPanel();
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.whiteOnBlackRadioButton = new JRadioButton();
        this.blackOnWhiteRadioButton = new JRadioButton();
        this.jLabel4 = new JLabel();
        this.paletteComboBox = new JComboBox();
        this.paletteAssignEntireDataSet = new JRadioButton();
        this.paletteAssignFixedRange = new JRadioButton();
        this.paletteAssignMinRange = new JTextField();
        this.jLabel5 = new JLabel();
        this.paletteAssignMaxRange = new JTextField();
        this.wireframeCheckBox = new JCheckBox();
        this.edgesCheckBox = new JCheckBox();
        this.verticesCheckBox = new JCheckBox();
        this.labelsCheckBox = new JCheckBox();
        this.labelFieldComboBox = new JComboBox();
        this.rasterCheckBox = new JCheckBox();
        this.hillshadeCheckBox = new JCheckBox();
        this.jLabel6 = new JLabel();
        this.azimuthTextField = new JTextField();
        this.jLabel7 = new JLabel();
        this.elevationTextField = new JTextField();
        this.jLabel8 = new JLabel();
        this.ambientTextField = new JTextField();
        this.jLabel9 = new JLabel();
        this.lidarGroundPointsButton = new JRadioButton();
        this.lidarAllPointsButton = new JRadioButton();
        this.jLabel10 = new JLabel();
        this.wireframeColorUsingForeground = new JRadioButton();
        this.wireframeColorUsingPalette = new JRadioButton();
        this.fullResolutionGridCheckbox = new JCheckBox();
        this.jLabel3 = new JLabel();
        this.wireframeSampleThinningComboBox = new JComboBox();
        this.lidarFirstReturnButton = new JRadioButton();
        this.rasterMethodComboBox = new JComboBox();
        this.lidarLastReturnButton = new JRadioButton();
        this.constraintsCheckBox = new JCheckBox();
        this.constraintsColorButton = new ColorButton();
        this.actionsPanel = new JPanel();
        this.applyButton = new JButton();
        this.cancelButton = new JButton();
        this.okayButton = new JButton();
        this.optionsPanel.setBorder(BorderFactory.createEtchedBorder());
        this.jLabel1.setText("Color Options");
        this.jLabel2.setText("Foreground and Background Colors");
        this.foregroundBackgroundButtonGroup.add(this.whiteOnBlackRadioButton);
        this.whiteOnBlackRadioButton.setText("White on Black");
        this.whiteOnBlackRadioButton.setToolTipText("Select white foreground objects on a black background");
        this.whiteOnBlackRadioButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ViewOptionsPanel.this.whiteOnBlackRadioButtonActionPerformed(evt);
            }
        });
        this.foregroundBackgroundButtonGroup.add(this.blackOnWhiteRadioButton);
        this.blackOnWhiteRadioButton.setSelected(true);
        this.blackOnWhiteRadioButton.setText("Black on White");
        this.blackOnWhiteRadioButton.setToolTipText("Select black foreground objects on a white background");
        this.jLabel4.setText("Palette");
        this.paletteComboBox.setToolTipText("Select palette for rendering rasters");
        this.paletteAssignButtonGroup.add(this.paletteAssignEntireDataSet);
        this.paletteAssignEntireDataSet.setSelected(true);
        this.paletteAssignEntireDataSet.setText("Use Range of  Data Set");
        this.paletteAssignEntireDataSet.setToolTipText("Assign colors based on range of entire data set");
        this.paletteAssignButtonGroup.add(this.paletteAssignFixedRange);
        this.paletteAssignFixedRange.setText("Specified Range");
        this.paletteAssignFixedRange.setToolTipText("Assign colors based on specified range");
        this.paletteAssignMinRange.setColumns(6);
        this.paletteAssignMinRange.setText("0.0");
        this.paletteAssignMinRange.setToolTipText("Minimum value for range");
        this.jLabel5.setText("to");
        this.paletteAssignMaxRange.setColumns(6);
        this.paletteAssignMaxRange.setText("8000.0");
        this.paletteAssignMaxRange.setToolTipText("Maximum value for range");
        this.wireframeCheckBox.setSelected(true);
        this.wireframeCheckBox.setText("Wireframe");
        this.wireframeCheckBox.setToolTipText("Check to enable display of wireframe or point data");
        this.edgesCheckBox.setSelected(true);
        this.edgesCheckBox.setText("Edges");
        this.edgesCheckBox.setToolTipText("Enable depiction of edges from TIN");
        this.verticesCheckBox.setSelected(true);
        this.verticesCheckBox.setText("Vertices");
        this.verticesCheckBox.setToolTipText("Enable rendering of vertices from model");
        this.labelsCheckBox.setText("Labels");
        this.labelsCheckBox.setToolTipText("Enable labeling of vertices");
        this.labelFieldComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"Z", "ID"}));
        this.labelFieldComboBox.setToolTipText("Select field for labeling");
        this.rasterCheckBox.setText("Raster");
        this.rasterCheckBox.setToolTipText("Enable color-coded raster background using palette");
        this.hillshadeCheckBox.setText("Hillshade");
        this.hillshadeCheckBox.setToolTipText("Enable rendering of hillshade using z value");
        this.jLabel6.setText("Azimuth");
        this.azimuthTextField.setColumns(5);
        this.azimuthTextField.setText("125");
        this.azimuthTextField.setToolTipText("Azimuth for light source in degrees");
        this.jLabel7.setText("Elevation");
        this.elevationTextField.setColumns(5);
        this.elevationTextField.setText("60");
        this.elevationTextField.setToolTipText("Elevation for light source 15 to 90 degrees");
        this.jLabel8.setText("Ambient");
        this.ambientTextField.setColumns(5);
        this.ambientTextField.setText("25");
        this.ambientTextField.setToolTipText("Percent ambient light 0 to 60 percent");
        this.jLabel9.setText("Lidar Options (LAS files only)");
        this.lidarPointSelectionGroup.add(this.lidarGroundPointsButton);
        this.lidarGroundPointsButton.setSelected(true);
        this.lidarGroundPointsButton.setText("Ground Points Only");
        this.lidarGroundPointsButton.setToolTipText("Select lidar ground points only");
        this.lidarPointSelectionGroup.add(this.lidarAllPointsButton);
        this.lidarAllPointsButton.setText("All samples");
        this.lidarAllPointsButton.setToolTipText("Use all lidar samples regardless of classification");
        this.jLabel10.setText("Color Options");
        this.wireframeColorButtonGroup.add(this.wireframeColorUsingForeground);
        this.wireframeColorUsingForeground.setSelected(true);
        this.wireframeColorUsingForeground.setText("Use Foreground");
        this.wireframeColorUsingForeground.setToolTipText("Use foreground color for wireframe rendering");
        this.wireframeColorButtonGroup.add(this.wireframeColorUsingPalette);
        this.wireframeColorUsingPalette.setText("Use Palette");
        this.wireframeColorUsingPalette.setToolTipText("Use palette for wireframe rendering");
        this.fullResolutionGridCheckbox.setText("Build Grid with Full Resolution (Use with caution)");
        this.fullResolutionGridCheckbox.setToolTipText("Optionally selects non-thinned sample set for raster grid");
        this.fullResolutionGridCheckbox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ViewOptionsPanel.this.fullResolutionGridCheckboxActionPerformed(evt);
            }
        });
        this.jLabel3.setText("Sample Thinning");
        this.wireframeSampleThinningComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{" Medium", "Fine", "Extra Fine"}));
        this.lidarPointSelectionGroup.add(this.lidarFirstReturnButton);
        this.lidarFirstReturnButton.setText("First Returns Only");
        this.lidarFirstReturnButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ViewOptionsPanel.this.lidarFirstReturnButtonActionPerformed(evt);
            }
        });
        this.rasterMethodComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{" Natural Neighbor Interpolation", "Geographically Weighted Regression", "Triangular Facets"}));
        this.rasterMethodComboBox.setToolTipText("Select method for raster interpolation");
        this.lidarPointSelectionGroup.add(this.lidarLastReturnButton);
        this.lidarLastReturnButton.setText("Last Returns Only");
        this.constraintsCheckBox.setText("Constraints");
        this.constraintsCheckBox.setToolTipText("Check to enable display of constraints");
        this.constraintsColorButton.setToolTipText("Select color for rendering constraints");
        this.constraintsColorButton.setMargin(new Insets(2, 2, 2, 2));
        this.constraintsColorButton.setMaximumSize(new Dimension(20, 20));
        this.constraintsColorButton.setMinimumSize(new Dimension(20, 20));
        this.constraintsColorButton.setPreferredSize(new Dimension(20, 20));
        GroupLayout optionsPanelLayout = new GroupLayout(this.optionsPanel);
        this.optionsPanel.setLayout(optionsPanelLayout);
        optionsPanelLayout.setHorizontalGroup(optionsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(optionsPanelLayout.createSequentialGroup().addContainerGap().addGroup(optionsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(optionsPanelLayout.createSequentialGroup().addComponent(this.constraintsCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.constraintsColorButton, -2, -1, -2)).addComponent(this.fullResolutionGridCheckbox).addGroup(optionsPanelLayout.createSequentialGroup().addComponent(this.hillshadeCheckBox).addGap(18, 18, 18).addComponent(this.jLabel6).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.azimuthTextField, -2, 38, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jLabel7).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.elevationTextField, -2, -1, -2).addGap(18, 18, 18).addComponent(this.jLabel8).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.ambientTextField, -2, -1, -2)).addComponent(this.jLabel1).addComponent(this.wireframeCheckBox).addGroup(optionsPanelLayout.createSequentialGroup().addComponent(this.rasterCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.rasterMethodComboBox, -2, -1, -2)).addGroup(optionsPanelLayout.createSequentialGroup().addGap(21, 21, 21).addGroup(optionsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.edgesCheckBox).addGroup(optionsPanelLayout.createSequentialGroup().addComponent(this.verticesCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.labelsCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.labelFieldComboBox, -2, -1, -2)).addGroup(optionsPanelLayout.createSequentialGroup().addComponent(this.jLabel3).addGap(18, 18, 18).addComponent(this.wireframeSampleThinningComboBox, -2, -1, -2)))).addComponent(this.jLabel9).addGroup(optionsPanelLayout.createSequentialGroup().addGap(10, 10, 10).addGroup(optionsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.lidarAllPointsButton).addComponent(this.lidarGroundPointsButton).addComponent(this.lidarFirstReturnButton).addComponent(this.lidarLastReturnButton))).addGroup(optionsPanelLayout.createSequentialGroup().addGap(10, 10, 10).addGroup(optionsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(optionsPanelLayout.createSequentialGroup().addComponent(this.jLabel4).addGap(34, 34, 34).addGroup(optionsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.paletteAssignEntireDataSet).addComponent(this.paletteComboBox, -2, -1, -2).addGroup(optionsPanelLayout.createSequentialGroup().addComponent(this.paletteAssignFixedRange).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.paletteAssignMinRange, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(optionsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel10).addGroup(optionsPanelLayout.createSequentialGroup().addGap(10, 10, 10).addGroup(optionsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.wireframeColorUsingPalette).addComponent(this.wireframeColorUsingForeground))).addGroup(optionsPanelLayout.createSequentialGroup().addComponent(this.jLabel5).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.paletteAssignMaxRange, -2, -1, -2)))))).addComponent(this.jLabel2).addComponent(this.blackOnWhiteRadioButton).addComponent(this.whiteOnBlackRadioButton)))).addContainerGap(-1, Short.MAX_VALUE)));
        optionsPanelLayout.setVerticalGroup(optionsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(optionsPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel2).addGap(1, 1, 1).addComponent(this.blackOnWhiteRadioButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.whiteOnBlackRadioButton).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(optionsPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel4).addComponent(this.paletteComboBox, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.paletteAssignEntireDataSet).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(optionsPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.paletteAssignFixedRange).addComponent(this.paletteAssignMinRange, -2, -1, -2).addComponent(this.jLabel5).addComponent(this.paletteAssignMaxRange, -2, -1, -2)).addGap(3, 3, 3).addGroup(optionsPanelLayout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.constraintsCheckBox).addComponent(this.constraintsColorButton, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.wireframeCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(optionsPanelLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(optionsPanelLayout.createSequentialGroup().addComponent(this.jLabel10).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.wireframeColorUsingForeground).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.wireframeColorUsingPalette).addGap(5, 5, 5)).addGroup(optionsPanelLayout.createSequentialGroup().addGroup(optionsPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel3).addComponent(this.wireframeSampleThinningComboBox, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.edgesCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(optionsPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.verticesCheckBox).addComponent(this.labelsCheckBox).addComponent(this.labelFieldComboBox, -2, -1, -2)))).addGroup(optionsPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.rasterCheckBox).addComponent(this.rasterMethodComboBox, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(optionsPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.hillshadeCheckBox).addComponent(this.jLabel6).addComponent(this.azimuthTextField, -2, -1, -2).addComponent(this.jLabel7).addComponent(this.elevationTextField, -2, -1, -2).addComponent(this.jLabel8).addComponent(this.ambientTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.fullResolutionGridCheckbox).addGap(18, 18, 18).addComponent(this.jLabel9).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.lidarGroundPointsButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.lidarFirstReturnButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.lidarLastReturnButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.lidarAllPointsButton).addContainerGap(17, Short.MAX_VALUE)));
        this.applyButton.setText("Apply");
        this.applyButton.setToolTipText("Apply settings");
        this.applyButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ViewOptionsPanel.this.applyButtonActionPerformed(evt);
            }
        });
        this.cancelButton.setText("Cancel");
        this.cancelButton.setToolTipText("Close dialog without applying settings");
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ViewOptionsPanel.this.cancelButtonActionPerformed(evt);
            }
        });
        this.okayButton.setText("OK");
        this.okayButton.setToolTipText("Apply settings and close dialog");
        this.okayButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ViewOptionsPanel.this.okButtonActionPerformed(evt);
            }
        });
        GroupLayout actionsPanelLayout = new GroupLayout(this.actionsPanel);
        this.actionsPanel.setLayout(actionsPanelLayout);
        actionsPanelLayout.setHorizontalGroup(actionsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, actionsPanelLayout.createSequentialGroup().addContainerGap(208, Short.MAX_VALUE).addComponent(this.okayButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cancelButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.applyButton).addContainerGap()));
        actionsPanelLayout.linkSize(0, this.applyButton, this.cancelButton, this.okayButton);
        actionsPanelLayout.setVerticalGroup(actionsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, actionsPanelLayout.createSequentialGroup().addGap(0, 0, Short.MAX_VALUE).addGroup(actionsPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.okayButton).addComponent(this.cancelButton).addComponent(this.applyButton))));
        actionsPanelLayout.linkSize(1, this.applyButton, this.cancelButton, this.okayButton);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.actionsPanel, -1, -1, Short.MAX_VALUE).addComponent(this.optionsPanel, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.optionsPanel, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.actionsPanel, -2, -1, -2).addContainerGap()));
    }

    private void okButtonActionPerformed(ActionEvent evt) {
        boolean badInput = this.transcribeComponentsToView();
        if (badInput) {
            return;
        }
        this.hideDialog();
        if (this.dvPanel != null) {
            this.dvPanel.setViewOptions(new ViewOptions(this.view));
        }
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        this.transcribeViewToComponents();
        this.hideDialog();
    }

    private void applyButtonActionPerformed(ActionEvent evt) {
        boolean badInput = this.transcribeComponentsToView();
        if (badInput) {
            return;
        }
        if (this.dvPanel != null) {
            this.dvPanel.setViewOptions(new ViewOptions(this.view));
        }
    }

    private void whiteOnBlackRadioButtonActionPerformed(ActionEvent evt) {
    }

    private void fullResolutionGridCheckboxActionPerformed(ActionEvent evt) {
    }

    private void lidarFirstReturnButtonActionPerformed(ActionEvent evt) {
    }

    class PaletteRenderer
    extends JLabel
    implements ListCellRenderer<Integer> {
        private static final long serialVersionUID = 1L;
        String[] names;
        Icon[] icons;

        PaletteRenderer(String[] names, Icon[] icons) {
            this.names = names;
            this.icons = icons;
        }

        @Override
        public Component getListCellRendererComponent(JList<? extends Integer> list, Integer value, int index, boolean isSelected, boolean cellHasFocus) {
            int selectedIndex = value;
            if (isSelected) {
                this.setBackground(list.getSelectionBackground());
                this.setForeground(list.getSelectionForeground());
            } else {
                this.setBackground(list.getBackground());
                this.setForeground(list.getForeground());
            }
            Icon icon = this.icons[selectedIndex];
            String name = this.names[selectedIndex];
            this.setIcon(icon);
            if (icon != null) {
                this.setText(null);
                this.setToolTipText("Select the palette " + name);
                this.setFont(list.getFont());
            }
            return this;
        }
    }
}

