/*
 * Decompiled with CFR 0.152.
 */
package org.tinfour.demo.viewer.backplane;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Formatter;
import java.util.List;
import org.tinfour.common.IConstraint;
import org.tinfour.common.IIncrementalTin;
import org.tinfour.common.IMonitorWithCancellation;
import org.tinfour.common.IQuadEdge;
import org.tinfour.common.Vertex;
import org.tinfour.demo.viewer.backplane.IModel;
import org.tinfour.demo.viewer.backplane.ModelSerialSource;
import org.tinfour.semivirtual.SemiVirtualIncrementalTin;
import org.tinfour.utils.HilbertSort;
import org.tinfour.utils.LinearUnits;
import org.tinfour.utils.Tincalc;
import org.tinfour.utils.loaders.CoordinatePair;
import org.tinfour.utils.loaders.ICoordinateTransform;
import org.tinfour.utils.loaders.SimpleGeographicTransform;

public class ModelAdapter
implements IModel {
    private static final int MAX_VERTICES_IN_TIN = 100000;
    protected final int serialIndex;
    final File file;
    List<Vertex> vertexList;
    List<Vertex> vertexListSortedByIndex;
    double xMin;
    double yMin;
    double zMin;
    double xMax;
    double yMax;
    double zMax;
    double nominalPointSpacing;
    double area;
    double geoScaleX;
    double geoScaleY;
    double geoOffsetX;
    double geoOffsetY;
    boolean geographicCoordinates;
    ICoordinateTransform coordinateTransform;
    LinearUnits linearUnits = LinearUnits.UNKNOWN;
    long timeToLoad;
    long timeToSort;
    boolean areVerticesLoaded;
    boolean areConstraintsLoaded;
    IIncrementalTin referenceTin;
    double referenceReductionFactor;
    List<Vertex> perimeterList;
    List<IConstraint> constraintList;

    public ModelAdapter(File file) {
        this.file = file;
        this.vertexList = new ArrayList<Vertex>();
        this.constraintList = new ArrayList<IConstraint>();
        this.serialIndex = ModelSerialSource.getSerialIndex();
    }

    @Override
    public void load(IMonitorWithCancellation monitor) throws IOException {
        if (this.isLoaded()) {
            throw new IllegalStateException("Internal error, multiple calls to load model");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void prepareModelForRendering(List<Vertex> list, IMonitorWithCancellation monitor) {
        if (monitor.isCanceled()) {
            return;
        }
        ArrayList<Vertex> sortedByIndexList = new ArrayList<Vertex>(list.size());
        sortedByIndexList.addAll(list);
        monitor.postMessage("Preparing model for rendering");
        long time0 = System.currentTimeMillis();
        if (list.size() > 16) {
            HilbertSort hilbertSort = new HilbertSort();
            hilbertSort.sort(list);
        }
        long time1 = System.currentTimeMillis();
        ModelAdapter modelAdapter = this;
        synchronized (modelAdapter) {
            this.timeToSort = time1 - time0;
            this.vertexListSortedByIndex = sortedByIndexList;
            this.vertexList = list;
            int nVertices = list.size();
            double mx0 = this.getMinX();
            double my0 = this.getMinY();
            double mx1 = this.getMaxX();
            double my1 = this.getMaxY();
            this.area = (mx1 - mx0) * (my1 - my0);
            this.nominalPointSpacing = Tincalc.sampleSpacing((double)this.area, (int)nVertices);
            this.prepareReferenceTin(list, null, monitor);
            this.areVerticesLoaded = true;
        }
        monitor.postMessage("");
    }

    void prepareReferenceTin(List<Vertex> list, List<IConstraint> constraints, IMonitorWithCancellation monitor) {
        int nVertices = list.size();
        this.referenceTin = new SemiVirtualIncrementalTin(this.nominalPointSpacing);
        if (nVertices <= 100000) {
            this.referenceTin.add(list, monitor);
            this.referenceReductionFactor = 1.0;
        } else {
            double s;
            ArrayList<Vertex> thinList = new ArrayList<Vertex>(100500);
            this.referenceReductionFactor = s = (double)nVertices / 100000.0;
            int priorIndex = -1;
            for (int i = 0; i < 100000; ++i) {
                int index = (int)((double)i * s + 0.5);
                if (index <= priorIndex) continue;
                thinList.add(list.get(index));
                priorIndex = index;
            }
            if (priorIndex != nVertices - 1) {
                thinList.add(list.get(nVertices - 1));
            }
            this.referenceTin.add(thinList, monitor);
            for (Vertex v : list) {
                if (this.referenceTin.isPointInsideTin(v.getX(), v.getY())) continue;
                this.referenceTin.add(v);
            }
        }
        if (constraints != null) {
            this.referenceTin.addConstraints(constraints, true);
        }
        List pList = this.referenceTin.getPerimeter();
        this.perimeterList = new ArrayList<Vertex>();
        for (IQuadEdge e : pList) {
            Vertex a = e.getA();
            double x = a.getX();
            double y = a.getY();
            double z = a.getZ();
            this.perimeterList.add(new Vertex(x, y, z, -1));
        }
        double s = 0.0;
        double xC = this.perimeterList.get(this.perimeterList.size() - 1).getX();
        double yC = this.perimeterList.get(this.perimeterList.size() - 1).getY();
        double x1 = 0.0;
        double y1 = 0.0;
        for (Vertex v : this.perimeterList) {
            double x0 = x1;
            double y0 = y1;
            x1 = v.getX() - xC;
            y1 = v.getY() - yC;
            s += x0 * y1 - x1 * y0;
        }
        this.area = s / 2.0;
        this.nominalPointSpacing = Tincalc.sampleSpacing((double)this.area, (int)nVertices);
    }

    @Override
    public double getMinX() {
        return this.xMin;
    }

    @Override
    public double getMaxX() {
        return this.xMax;
    }

    @Override
    public double getMinY() {
        return this.yMin;
    }

    @Override
    public double getMaxY() {
        return this.yMax;
    }

    @Override
    public double getMinZ() {
        return this.zMin;
    }

    @Override
    public double getMaxZ() {
        return this.zMax;
    }

    @Override
    public double getNominalPointSpacing() {
        return this.nominalPointSpacing;
    }

    @Override
    public double getArea() {
        return this.area;
    }

    @Override
    public File getFile() {
        return this.file;
    }

    @Override
    public String getName() {
        return this.file.getName();
    }

    @Override
    public String getDescription() {
        return "ModelAdapter";
    }

    @Override
    public int getVertexCount() {
        return this.vertexList.size();
    }

    @Override
    public List<Vertex> getVertexList() {
        return this.vertexList;
    }

    @Override
    public String getFormattedCoordinates(double x, double y) {
        CoordinatePair cPair;
        if (this.coordinateTransform instanceof SimpleGeographicTransform && this.coordinateTransform.inverse(x, y, cPair = new CoordinatePair())) {
            StringBuilder sb = new StringBuilder();
            Formatter fmt = new Formatter(sb);
            this.fmtGeo(fmt, cPair.y, true);
            sb.append(" / ");
            this.fmtGeo(fmt, cPair.x, false);
            return sb.toString();
        }
        return String.format("%4.2f,%4.2f", x, y);
    }

    @Override
    public String getFormattedX(double x) {
        CoordinatePair cPair;
        if (this.coordinateTransform instanceof SimpleGeographicTransform && this.coordinateTransform.inverse(x, 0.0, cPair = new CoordinatePair())) {
            StringBuilder sb = new StringBuilder();
            Formatter fmt = new Formatter(sb);
            this.fmtGeo(fmt, cPair.x, false);
            return sb.toString();
        }
        return String.format("%11.2f", x);
    }

    @Override
    public String getFormattedY(double y) {
        CoordinatePair cPair;
        if (this.coordinateTransform instanceof SimpleGeographicTransform && this.coordinateTransform.inverse(0.0, y, cPair = new CoordinatePair())) {
            StringBuilder sb = new StringBuilder();
            Formatter fmt = new Formatter(sb);
            this.fmtGeo(fmt, cPair.y, false);
            return sb.toString();
        }
        return String.format("%11.2f", y);
    }

    void fmtGeo(Formatter fmt, double coord, boolean latFlag) {
        double c = coord;
        if (c < -180.0) {
            c += 360.0;
        } else if (c >= 180.0) {
            c -= 360.0;
        }
        int x = (int)(Math.abs(c) * 360000.0 + 0.5);
        int deg = x / 360000;
        int min = (x - deg * 360000) / 6000;
        int sec = x % 6000;
        if (latFlag) {
            char q = c < 0.0 ? (char)'S' : 'N';
            fmt.format("%02d\u00b0 %02d' %05.2f\" %c", deg, min, (double)sec / 100.0, Character.valueOf(q));
        } else {
            char q = c < 0.0 ? (char)'W' : 'E';
            fmt.format("%03d\u00b0 %02d' %05.2f\" %c", deg, min, (double)sec / 100.0, Character.valueOf(q));
        }
    }

    @Override
    public boolean isCoordinateSystemGeographic() {
        return this.geographicCoordinates;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isLoaded() {
        ModelAdapter modelAdapter = this;
        synchronized (modelAdapter) {
            return this.areVerticesLoaded;
        }
    }

    @Override
    public IIncrementalTin getReferenceTin() {
        return this.referenceTin;
    }

    @Override
    public double getReferenceReductionFactor() {
        return this.referenceReductionFactor;
    }

    @Override
    public long getTimeToLoadInMillis() {
        return this.timeToLoad;
    }

    @Override
    public long getTimeToSortInMillis() {
        return this.timeToSort;
    }

    @Override
    public List<Vertex> getPerimeterVertices() {
        return this.perimeterList;
    }

    @Override
    public LinearUnits getLinearUnits() {
        return this.linearUnits;
    }

    @Override
    public Vertex getVertexForIndex(int index) {
        Vertex key = new Vertex(0.0, 0.0, 0.0, index);
        int i = Collections.binarySearch(this.vertexListSortedByIndex, key, new Comparator<Vertex>(){

            @Override
            public int compare(Vertex t, Vertex t1) {
                return t.getIndex() - t1.getIndex();
            }
        });
        if (i >= 0) {
            return this.vertexListSortedByIndex.get(i);
        }
        return null;
    }

    @Override
    public void xy2geo(double x, double y, double[] geo) {
        CoordinatePair cPair;
        if (this.coordinateTransform instanceof SimpleGeographicTransform && this.coordinateTransform.inverse(x, y, cPair = new CoordinatePair())) {
            geo[0] = cPair.y;
            geo[1] = cPair.x;
            return;
        }
        geo[0] = Double.NaN;
        geo[1] = Double.NaN;
    }

    @Override
    public void geo2xy(double latitude, double longitude, double[] xy) {
        CoordinatePair cPair;
        if (this.coordinateTransform instanceof SimpleGeographicTransform && this.coordinateTransform.forward(longitude, latitude, cPair = new CoordinatePair())) {
            xy[0] = cPair.x;
            xy[1] = cPair.y;
            return;
        }
        xy[0] = Double.NaN;
        xy[1] = Double.NaN;
    }

    void copyModelParameters(ModelAdapter model) {
        this.vertexList = model.vertexList;
        this.vertexListSortedByIndex = model.vertexListSortedByIndex;
        this.xMin = model.xMin;
        this.yMin = model.yMin;
        this.zMin = model.zMin;
        this.xMax = model.xMax;
        this.yMax = model.yMax;
        this.zMax = model.zMax;
        this.nominalPointSpacing = model.nominalPointSpacing;
        this.area = model.area;
        this.coordinateTransform = model.getCoordinateTransform();
        this.geographicCoordinates = model.geographicCoordinates;
        this.timeToLoad = model.timeToLoad;
        this.timeToSort = model.timeToSort;
        this.areVerticesLoaded = model.areVerticesLoaded;
        this.referenceTin = model.referenceTin;
        this.referenceReductionFactor = model.referenceReductionFactor;
        this.perimeterList = model.perimeterList;
    }

    @Override
    public void addConstraints(File constraintsFile, List<IConstraint> constraints) {
        if (constraints == null || constraints.isEmpty()) {
            return;
        }
        this.constraintList = new ArrayList<IConstraint>(constraints.size());
        this.constraintList.addAll(constraints);
        this.prepareReferenceTin(this.vertexList, constraints, null);
    }

    @Override
    public boolean hasConstraints() {
        return this.constraintList != null && !this.constraintList.isEmpty();
    }

    @Override
    public List<IConstraint> getConstraints() {
        return this.constraintList;
    }

    @Override
    public boolean hasVertexSource() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public boolean areVerticesLoaded() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public boolean hasConstraintsSource() {
        return this.hasConstraints();
    }

    @Override
    public boolean areConstraintsLoaded() {
        return this.hasConstraints();
    }

    @Override
    public ICoordinateTransform getCoordinateTransform() {
        return this.coordinateTransform;
    }
}

