/*
 * Decompiled with CFR 0.152.
 */
package org.tinfour.demo.viewer.backplane;

import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Formatter;
import java.util.List;
import java.util.Locale;
import java.util.SimpleTimeZone;
import org.tinfour.common.IMonitorWithCancellation;
import org.tinfour.demo.viewer.backplane.IModel;
import org.tinfour.demo.viewer.backplane.LidarPointSelection;
import org.tinfour.demo.viewer.backplane.ModelAdapter;
import org.tinfour.gis.las.LasFileReader;
import org.tinfour.gis.las.LasGpsTimeType;
import org.tinfour.gis.las.LasPoint;
import org.tinfour.gis.las.LasRecordFilterByClass;
import org.tinfour.gis.las.LasRecordFilterByFirstReturn;
import org.tinfour.gis.las.LasRecordFilterByLastReturn;
import org.tinfour.gis.utils.VertexReaderLas;
import org.tinfour.utils.LinearUnits;

public class ModelFromLas
extends ModelAdapter
implements IModel {
    public static final int GROUND_POINT = 2;
    private static final String[] classificationDescription = new String[]{"Created, never classified", "Unclassified", "Ground", "Low Vegetation", "Medium Vegetation", "High Vegetation", "Building", "Low Point (noise)", "Model Key-point (mass point)", "Water", "Reserved for ASPRS definition", "Reserved for ASPRS definition", "Overlap Point"};
    LidarPointSelection lidarPointSelection;
    int nonGroundPoints;
    int groundPoints;
    LinearUnits linearUnits = LinearUnits.UNKNOWN;

    public ModelFromLas(File file, LidarPointSelection lidarPointSelection) {
        super(file);
        this.lidarPointSelection = lidarPointSelection;
    }

    @Override
    public void load(IMonitorWithCancellation monitor) throws IOException {
        if (this.areVerticesLoaded) {
            System.out.println("Internal error, multiple calls to load model");
            return;
        }
        long time0 = System.currentTimeMillis();
        VertexReaderLas reader = new VertexReaderLas(this.file);
        LasRecordFilterByFirstReturn vFilter = null;
        switch (this.lidarPointSelection) {
            case GroundPoints: {
                vFilter = new LasRecordFilterByClass(2);
                break;
            }
            case FirstReturn: {
                vFilter = new LasRecordFilterByFirstReturn();
                break;
            }
            case LastReturn: {
                vFilter = new LasRecordFilterByLastReturn();
                break;
            }
        }
        reader.setFilter(vFilter);
        List list = reader.read(monitor);
        if (list.isEmpty()) {
            monitor.reportDone();
            if (this.lidarPointSelection == LidarPointSelection.AllPoints) {
                throw new IOException("Unable to read points from file");
            }
            throw new IOException("Source Lidar file does not contain samples for " + (Object)((Object)this.lidarPointSelection));
        }
        this.linearUnits = reader.getLinearUnits();
        this.xMin = reader.getXMin();
        this.yMin = reader.getYMin();
        this.xMax = reader.getXMax();
        this.yMax = reader.getYMax();
        this.zMin = reader.getZMin();
        this.zMax = reader.getZMax();
        this.geographicCoordinates = reader.isSourceInGeographicCoordinates();
        if (this.geographicCoordinates) {
            this.coordinateTransform = reader.getCoordinateTransform();
        }
        long time1 = System.currentTimeMillis();
        this.timeToLoad = time1 - time0;
        System.out.println("Loaded " + list.size() + " vertices in " + this.timeToLoad + " ms");
        this.prepareModelForRendering(list, monitor);
    }

    @Override
    public String getDescription() {
        return "Lidar (" + (Object)((Object)this.lidarPointSelection) + ")";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void formatLidarFields(Formatter fmt, int vertexId) {
        if (vertexId < 0) {
            return;
        }
        LasFileReader reader = null;
        try {
            reader = new LasFileReader(this.file);
            LasPoint record = new LasPoint();
            reader.readRecord((long)vertexId, record);
            String description = record.classification < classificationDescription.length ? classificationDescription[record.classification] : "Reserved (" + record.classification + ")";
            fmt.format("   Classification: %s%n", description);
            fmt.format("   Return:    %d of %d%n", record.returnNumber, record.numberOfReturns);
            fmt.format("   Intensity: %d%n", record.intensity);
            LasGpsTimeType gpsType = reader.getLasGpsTimeType();
            Date date = gpsType.transformGpsTimeToDate(record.gpsTime);
            SimpleDateFormat sdf = gpsType == LasGpsTimeType.WeekTime ? new SimpleDateFormat("EEE hh:MM:ss.S", Locale.getDefault()) : new SimpleDateFormat("EEE YYYY-MM-dd HH:mm:ss.S", Locale.getDefault());
            sdf.setTimeZone(new SimpleTimeZone(0, "UTC"));
            fmt.format("   Time/Date: %s UTC%n", sdf.format(date));
        }
        catch (IOException ioex) {
            System.err.println("IOException reading " + this.file.getName() + " " + ioex.getMessage());
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException dontCare) {}
            }
        }
    }

    public LidarPointSelection getLidarPointSelection() {
        return this.lidarPointSelection;
    }

    @Override
    public LinearUnits getLinearUnits() {
        return this.linearUnits;
    }

    public String toString() {
        String conType = this.hasConstraints() ? " CDT" : "";
        String loaded = this.isLoaded() ? "Loaded" : "Unloaded";
        return String.format("Model From LAS %d %s%s", this.serialIndex, loaded, conType);
    }
}

