/*
 * Decompiled with CFR 0.152.
 */
package com.github.mreutegg.laszip4j.laslib;

import com.github.mreutegg.laszip4j.clib.Cstdio;
import com.github.mreutegg.laszip4j.laslib.LAScriterion;
import com.github.mreutegg.laszip4j.laszip.LASpoint;

class LAScriterionDropx
extends LAScriterion {
    private double below_x;
    private double above_x;

    @Override
    public String name() {
        return "drop_x";
    }

    @Override
    public int get_command(StringBuilder string) {
        return Cstdio.sprintf(string, "-%s %g %g ", this.name(), this.below_x, this.above_x);
    }

    @Override
    public boolean filter(LASpoint point) {
        double x = point.get_x();
        return this.below_x <= x && x < this.above_x;
    }

    public LAScriterionDropx(double below_x, double above_x) {
        this.below_x = below_x;
        this.above_x = above_x;
    }
}

