/*
 * Decompiled with CFR 0.152.
 */
package com.github.mreutegg.laszip4j.laslib;

import com.github.mreutegg.laszip4j.clib.Cstdio;
import com.github.mreutegg.laszip4j.clib.Cstdlib;
import com.github.mreutegg.laszip4j.clib.Cstring;
import com.github.mreutegg.laszip4j.laslib.LAScriterion;
import com.github.mreutegg.laszip4j.laslib.LAScriterionAnd;
import com.github.mreutegg.laszip4j.laslib.LAScriterionDropClassifications;
import com.github.mreutegg.laszip4j.laslib.LAScriterionDropExtendedClassifications;
import com.github.mreutegg.laszip4j.laslib.LAScriterionDropFirstOfManyReturn;
import com.github.mreutegg.laszip4j.laslib.LAScriterionDropFirstReturn;
import com.github.mreutegg.laszip4j.laslib.LAScriterionDropGpsTimeAbove;
import com.github.mreutegg.laszip4j.laslib.LAScriterionDropGpsTimeBelow;
import com.github.mreutegg.laszip4j.laslib.LAScriterionDropGpsTimeBetween;
import com.github.mreutegg.laszip4j.laslib.LAScriterionDropIntensityAbove;
import com.github.mreutegg.laszip4j.laslib.LAScriterionDropIntensityBelow;
import com.github.mreutegg.laszip4j.laslib.LAScriterionDropIntensityBetween;
import com.github.mreutegg.laszip4j.laslib.LAScriterionDropKeypoint;
import com.github.mreutegg.laszip4j.laslib.LAScriterionDropLastOfManyReturn;
import com.github.mreutegg.laszip4j.laslib.LAScriterionDropLastReturn;
import com.github.mreutegg.laszip4j.laslib.LAScriterionDropMiddleReturn;
import com.github.mreutegg.laszip4j.laslib.LAScriterionDropOverlap;
import com.github.mreutegg.laszip4j.laslib.LAScriterionDropPointSource;
import com.github.mreutegg.laszip4j.laslib.LAScriterionDropPointSourceAbove;
import com.github.mreutegg.laszip4j.laslib.LAScriterionDropPointSourceBelow;
import com.github.mreutegg.laszip4j.laslib.LAScriterionDropPointSourceBetween;
import com.github.mreutegg.laszip4j.laslib.LAScriterionDropScanAngleAbove;
import com.github.mreutegg.laszip4j.laslib.LAScriterionDropScanAngleBelow;
import com.github.mreutegg.laszip4j.laslib.LAScriterionDropScanAngleBetween;
import com.github.mreutegg.laszip4j.laslib.LAScriterionDropScanDirection;
import com.github.mreutegg.laszip4j.laslib.LAScriterionDropSpecificNumberOfReturns;
import com.github.mreutegg.laszip4j.laslib.LAScriterionDropSynthetic;
import com.github.mreutegg.laszip4j.laslib.LAScriterionDropUserData;
import com.github.mreutegg.laszip4j.laslib.LAScriterionDropUserDataAbove;
import com.github.mreutegg.laszip4j.laslib.LAScriterionDropUserDataBelow;
import com.github.mreutegg.laszip4j.laslib.LAScriterionDropUserDataBetween;
import com.github.mreutegg.laszip4j.laslib.LAScriterionDropWavepacket;
import com.github.mreutegg.laszip4j.laslib.LAScriterionDropWithheld;
import com.github.mreutegg.laszip4j.laslib.LAScriterionDropX;
import com.github.mreutegg.laszip4j.laslib.LAScriterionDropXAbove;
import com.github.mreutegg.laszip4j.laslib.LAScriterionDropXBelow;
import com.github.mreutegg.laszip4j.laslib.LAScriterionDropY;
import com.github.mreutegg.laszip4j.laslib.LAScriterionDropYAbove;
import com.github.mreutegg.laszip4j.laslib.LAScriterionDropYBelow;
import com.github.mreutegg.laszip4j.laslib.LAScriterionDropZ;
import com.github.mreutegg.laszip4j.laslib.LAScriterionDropZAbove;
import com.github.mreutegg.laszip4j.laslib.LAScriterionDropZBelow;
import com.github.mreutegg.laszip4j.laslib.LAScriterionDropx;
import com.github.mreutegg.laszip4j.laslib.LAScriterionDropxAbove;
import com.github.mreutegg.laszip4j.laslib.LAScriterionDropxBelow;
import com.github.mreutegg.laszip4j.laslib.LAScriterionDropxy;
import com.github.mreutegg.laszip4j.laslib.LAScriterionDropxyz;
import com.github.mreutegg.laszip4j.laslib.LAScriterionDropy;
import com.github.mreutegg.laszip4j.laslib.LAScriterionDropyAbove;
import com.github.mreutegg.laszip4j.laslib.LAScriterionDropyBelow;
import com.github.mreutegg.laszip4j.laslib.LAScriterionDropz;
import com.github.mreutegg.laszip4j.laslib.LAScriterionDropzAbove;
import com.github.mreutegg.laszip4j.laslib.LAScriterionDropzBelow;
import com.github.mreutegg.laszip4j.laslib.LAScriterionKeepCircle;
import com.github.mreutegg.laszip4j.laslib.LAScriterionKeepEdgeOfFlightLine;
import com.github.mreutegg.laszip4j.laslib.LAScriterionKeepEveryNth;
import com.github.mreutegg.laszip4j.laslib.LAScriterionKeepFirstOfManyReturn;
import com.github.mreutegg.laszip4j.laslib.LAScriterionKeepFirstReturn;
import com.github.mreutegg.laszip4j.laslib.LAScriterionKeepGpsTime;
import com.github.mreutegg.laszip4j.laslib.LAScriterionKeepIntensity;
import com.github.mreutegg.laszip4j.laslib.LAScriterionKeepIntensityAbove;
import com.github.mreutegg.laszip4j.laslib.LAScriterionKeepIntensityBelow;
import com.github.mreutegg.laszip4j.laslib.LAScriterionKeepKeypoint;
import com.github.mreutegg.laszip4j.laslib.LAScriterionKeepLastOfManyReturn;
import com.github.mreutegg.laszip4j.laslib.LAScriterionKeepLastReturn;
import com.github.mreutegg.laszip4j.laslib.LAScriterionKeepMiddleReturn;
import com.github.mreutegg.laszip4j.laslib.LAScriterionKeepOverlap;
import com.github.mreutegg.laszip4j.laslib.LAScriterionKeepPointSource;
import com.github.mreutegg.laszip4j.laslib.LAScriterionKeepPointSourceBetween;
import com.github.mreutegg.laszip4j.laslib.LAScriterionKeepRGB;
import com.github.mreutegg.laszip4j.laslib.LAScriterionKeepRandomFraction;
import com.github.mreutegg.laszip4j.laslib.LAScriterionKeepReturns;
import com.github.mreutegg.laszip4j.laslib.LAScriterionKeepScanAngle;
import com.github.mreutegg.laszip4j.laslib.LAScriterionKeepScanDirectionChange;
import com.github.mreutegg.laszip4j.laslib.LAScriterionKeepSpecificNumberOfReturns;
import com.github.mreutegg.laszip4j.laslib.LAScriterionKeepSynthetic;
import com.github.mreutegg.laszip4j.laslib.LAScriterionKeepTile;
import com.github.mreutegg.laszip4j.laslib.LAScriterionKeepUserData;
import com.github.mreutegg.laszip4j.laslib.LAScriterionKeepUserDataAbove;
import com.github.mreutegg.laszip4j.laslib.LAScriterionKeepUserDataBelow;
import com.github.mreutegg.laszip4j.laslib.LAScriterionKeepUserDataBetween;
import com.github.mreutegg.laszip4j.laslib.LAScriterionKeepWavepacket;
import com.github.mreutegg.laszip4j.laslib.LAScriterionKeepWithheld;
import com.github.mreutegg.laszip4j.laslib.LAScriterionKeepX;
import com.github.mreutegg.laszip4j.laslib.LAScriterionKeepXY;
import com.github.mreutegg.laszip4j.laslib.LAScriterionKeepY;
import com.github.mreutegg.laszip4j.laslib.LAScriterionKeepZ;
import com.github.mreutegg.laszip4j.laslib.LAScriterionKeepx;
import com.github.mreutegg.laszip4j.laslib.LAScriterionKeepxy;
import com.github.mreutegg.laszip4j.laslib.LAScriterionKeepxyz;
import com.github.mreutegg.laszip4j.laslib.LAScriterionKeepy;
import com.github.mreutegg.laszip4j.laslib.LAScriterionKeepz;
import com.github.mreutegg.laszip4j.laslib.LAScriterionOr;
import com.github.mreutegg.laszip4j.laslib.LAScriterionThinWithGrid;
import com.github.mreutegg.laszip4j.laslib.LAScriterionThinWithTime;
import com.github.mreutegg.laszip4j.laszip.LASpoint;
import java.io.PrintStream;

public class LASfilter {
    private static final PrintStream stderr = System.err;
    private int num_criteria = 0;
    private int alloc_criteria = 0;
    private LAScriterion[] criteria = null;
    private int[] counters = null;

    void clean() {
        this.alloc_criteria = 0;
        this.num_criteria = 0;
        this.criteria = null;
        this.counters = null;
    }

    static void usage() {
        Cstdio.fprintf(stderr, "Filter points based on their coordinates.\n", new Object[0]);
        Cstdio.fprintf(stderr, "  -keep_tile 631000 4834000 1000 (ll_x ll_y size)\n", new Object[0]);
        Cstdio.fprintf(stderr, "  -keep_circle 630250.00 4834750.00 100 (x y radius)\n", new Object[0]);
        Cstdio.fprintf(stderr, "  -keep_xy 630000 4834000 631000 4836000 (min_x min_y max_x max_y)\n", new Object[0]);
        Cstdio.fprintf(stderr, "  -drop_xy 630000 4834000 631000 4836000 (min_x min_y max_x max_y)\n", new Object[0]);
        Cstdio.fprintf(stderr, "  -keep_x 631500.50 631501.00 (min_x max_x)\n", new Object[0]);
        Cstdio.fprintf(stderr, "  -drop_x 631500.50 631501.00 (min_x max_x)\n", new Object[0]);
        Cstdio.fprintf(stderr, "  -drop_x_below 630000.50 (min_x)\n", new Object[0]);
        Cstdio.fprintf(stderr, "  -drop_x_above 630500.50 (max_x)\n", new Object[0]);
        Cstdio.fprintf(stderr, "  -keep_y 4834500.25 4834550.25 (min_y max_y)\n", new Object[0]);
        Cstdio.fprintf(stderr, "  -drop_y 4834500.25 4834550.25 (min_y max_y)\n", new Object[0]);
        Cstdio.fprintf(stderr, "  -drop_y_below 4834500.25 (min_y)\n", new Object[0]);
        Cstdio.fprintf(stderr, "  -drop_y_above 4836000.75 (max_y)\n", new Object[0]);
        Cstdio.fprintf(stderr, "  -keep_z 11.125 130.725 (min_z max_z)\n", new Object[0]);
        Cstdio.fprintf(stderr, "  -drop_z 11.125 130.725 (min_z max_z)\n", new Object[0]);
        Cstdio.fprintf(stderr, "  -drop_z_below 11.125 (min_z)\n", new Object[0]);
        Cstdio.fprintf(stderr, "  -drop_z_above 130.725 (max_z)\n", new Object[0]);
        Cstdio.fprintf(stderr, "  -keep_xyz 620000 4830000 100 621000 4831000 200 (min_x min_y min_z max_x max_y max_z)\n", new Object[0]);
        Cstdio.fprintf(stderr, "  -drop_xyz 620000 4830000 100 621000 4831000 200 (min_x min_y min_z max_x max_y max_z)\n", new Object[0]);
        Cstdio.fprintf(stderr, "Filter points based on their return number.\n", new Object[0]);
        Cstdio.fprintf(stderr, "  -keep_first -first_only -drop_first\n", new Object[0]);
        Cstdio.fprintf(stderr, "  -keep_last -last_only -drop_last\n", new Object[0]);
        Cstdio.fprintf(stderr, "  -keep_first_of_many -keep_last_of_many\n", new Object[0]);
        Cstdio.fprintf(stderr, "  -drop_first_of_many -drop_last_of_many\n", new Object[0]);
        Cstdio.fprintf(stderr, "  -keep_middle -drop_middle\n", new Object[0]);
        Cstdio.fprintf(stderr, "  -keep_return 1 2 3\n", new Object[0]);
        Cstdio.fprintf(stderr, "  -drop_return 3 4\n", new Object[0]);
        Cstdio.fprintf(stderr, "  -keep_single -drop_single\n", new Object[0]);
        Cstdio.fprintf(stderr, "  -keep_double -drop_double\n", new Object[0]);
        Cstdio.fprintf(stderr, "  -keep_triple -drop_triple\n", new Object[0]);
        Cstdio.fprintf(stderr, "  -keep_quadruple -drop_quadruple\n", new Object[0]);
        Cstdio.fprintf(stderr, "  -keep_quintuple -drop_quintuple\n", new Object[0]);
        Cstdio.fprintf(stderr, "Filter points based on the scanline flags.\n", new Object[0]);
        Cstdio.fprintf(stderr, "  -drop_scan_direction 0\n", new Object[0]);
        Cstdio.fprintf(stderr, "  -keep_scan_direction_change\n", new Object[0]);
        Cstdio.fprintf(stderr, "  -keep_edge_of_flight_line\n", new Object[0]);
        Cstdio.fprintf(stderr, "Filter points based on their intensity.\n", new Object[0]);
        Cstdio.fprintf(stderr, "  -keep_intensity 20 380\n", new Object[0]);
        Cstdio.fprintf(stderr, "  -drop_intensity_below 20\n", new Object[0]);
        Cstdio.fprintf(stderr, "  -drop_intensity_above 380\n", new Object[0]);
        Cstdio.fprintf(stderr, "  -drop_intensity_between 4000 5000\n", new Object[0]);
        Cstdio.fprintf(stderr, "Filter points based on classifications or flags.\n", new Object[0]);
        Cstdio.fprintf(stderr, "  -keep_class 1 3 7\n", new Object[0]);
        Cstdio.fprintf(stderr, "  -drop_class 4 2\n", new Object[0]);
        Cstdio.fprintf(stderr, "  -keep_extended_class 43\n", new Object[0]);
        Cstdio.fprintf(stderr, "  -drop_extended_class 129 135\n", new Object[0]);
        Cstdio.fprintf(stderr, "  -drop_synthetic -keep_synthetic\n", new Object[0]);
        Cstdio.fprintf(stderr, "  -drop_keypoint -keep_keypoint\n", new Object[0]);
        Cstdio.fprintf(stderr, "  -drop_withheld -keep_withheld\n", new Object[0]);
        Cstdio.fprintf(stderr, "  -drop_overlap -keep_overlap\n", new Object[0]);
        Cstdio.fprintf(stderr, "Filter points based on their user data.\n", new Object[0]);
        Cstdio.fprintf(stderr, "  -keep_user_data 1\n", new Object[0]);
        Cstdio.fprintf(stderr, "  -drop_user_data 255\n", new Object[0]);
        Cstdio.fprintf(stderr, "  -keep_user_data_below 50\n", new Object[0]);
        Cstdio.fprintf(stderr, "  -keep_user_data_above 150\n", new Object[0]);
        Cstdio.fprintf(stderr, "  -keep_user_data_between 10 20\n", new Object[0]);
        Cstdio.fprintf(stderr, "  -drop_user_data_below 1\n", new Object[0]);
        Cstdio.fprintf(stderr, "  -drop_user_data_above 100\n", new Object[0]);
        Cstdio.fprintf(stderr, "  -drop_user_data_between 10 40\n", new Object[0]);
        Cstdio.fprintf(stderr, "Filter points based on their point source ID.\n", new Object[0]);
        Cstdio.fprintf(stderr, "  -keep_point_source 3\n", new Object[0]);
        Cstdio.fprintf(stderr, "  -keep_point_source_between 2 6\n", new Object[0]);
        Cstdio.fprintf(stderr, "  -drop_point_source 27\n", new Object[0]);
        Cstdio.fprintf(stderr, "  -drop_point_source_below 6\n", new Object[0]);
        Cstdio.fprintf(stderr, "  -drop_point_source_above 15\n", new Object[0]);
        Cstdio.fprintf(stderr, "  -drop_point_source_between 17 21\n", new Object[0]);
        Cstdio.fprintf(stderr, "Filter points based on their scan angle.\n", new Object[0]);
        Cstdio.fprintf(stderr, "  -keep_scan_angle -15 15\n", new Object[0]);
        Cstdio.fprintf(stderr, "  -drop_abs_scan_angle_above 15\n", new Object[0]);
        Cstdio.fprintf(stderr, "  -drop_abs_scan_angle_below 1\n", new Object[0]);
        Cstdio.fprintf(stderr, "  -drop_scan_angle_below -15\n", new Object[0]);
        Cstdio.fprintf(stderr, "  -drop_scan_angle_above 15\n", new Object[0]);
        Cstdio.fprintf(stderr, "  -drop_scan_angle_between -25 -23\n", new Object[0]);
        Cstdio.fprintf(stderr, "Filter points based on their gps time.\n", new Object[0]);
        Cstdio.fprintf(stderr, "  -keep_gps_time 11.125 130.725\n", new Object[0]);
        Cstdio.fprintf(stderr, "  -drop_gps_time_below 11.125\n", new Object[0]);
        Cstdio.fprintf(stderr, "  -drop_gps_time_above 130.725\n", new Object[0]);
        Cstdio.fprintf(stderr, "  -drop_gps_time_between 22.0 48.0\n", new Object[0]);
        Cstdio.fprintf(stderr, "Filter points based on their RGB/NIR channel.\n", new Object[0]);
        Cstdio.fprintf(stderr, "  -keep_RGB_red 1 1\n", new Object[0]);
        Cstdio.fprintf(stderr, "  -keep_RGB_green 30 100\n", new Object[0]);
        Cstdio.fprintf(stderr, "  -keep_RGB_blue 0 0\n", new Object[0]);
        Cstdio.fprintf(stderr, "  -keep_RGB_nir 64 127\n", new Object[0]);
        Cstdio.fprintf(stderr, "Filter points based on their wavepacket.\n", new Object[0]);
        Cstdio.fprintf(stderr, "  -keep_wavepacket 0\n", new Object[0]);
        Cstdio.fprintf(stderr, "  -drop_wavepacket 3\n", new Object[0]);
        Cstdio.fprintf(stderr, "Filter points with simple thinning.\n", new Object[0]);
        Cstdio.fprintf(stderr, "  -keep_every_nth 2\n", new Object[0]);
        Cstdio.fprintf(stderr, "  -keep_random_fraction 0.1\n", new Object[0]);
        Cstdio.fprintf(stderr, "  -thin_with_grid 1.0\n", new Object[0]);
        Cstdio.fprintf(stderr, "  -thin_with_time 0.001\n", new Object[0]);
        Cstdio.fprintf(stderr, "Boolean combination of filters.\n", new Object[0]);
        Cstdio.fprintf(stderr, "  -filter_and\n", new Object[0]);
    }

    public boolean parse(int argc, String[] argv) {
        int keep_return_mask = 0;
        int drop_return_mask = 0;
        int keep_classification_mask = 0;
        int drop_classification_mask = 0;
        int[] keep_extended_classification_mask = new int[]{0, 0, 0, 0, 0, 0, 0, 0};
        int[] drop_extended_classification_mask = new int[]{0, 0, 0, 0, 0, 0, 0, 0};
        for (int i = 1; i < argc; ++i) {
            if (argv[i].isEmpty()) continue;
            if (Cstring.strcmp(argv[i], "-h") == 0 || Cstring.strcmp(argv[i], "-help") == 0) {
                LASfilter.usage();
                return Boolean.TRUE;
            }
            if (Cstring.strncmp(argv[i], "-clip_", 6) == 0) {
                if (Cstring.strcmp(argv[i], "-clip_z_below") == 0) {
                    Cstdio.fprintf(stderr, "WARNING: '%s' will not be supported in the future. check documentation with '-h'.\n", argv[i]);
                    Cstdio.fprintf(stderr, "  rename '-clip_z_below' to '-drop_z_below'.\n", new Object[0]);
                    Cstdio.fprintf(stderr, "  rename '-clip_z_above' to '-drop_z_above'.\n", new Object[0]);
                    Cstdio.fprintf(stderr, "  rename '-clip_z_between' to '-drop_z'.\n", new Object[0]);
                    Cstdio.fprintf(stderr, "  rename '-clip' to '-keep_xy'.\n", new Object[0]);
                    Cstdio.fprintf(stderr, "  rename '-clip_tile' to '-keep_tile'.\n", new Object[0]);
                    if (i + 1 >= argc) {
                        Cstdio.fprintf(stderr, "ERROR: '%s' needs 1 argument: max_z\n", argv[i]);
                        return Boolean.FALSE;
                    }
                    this.add_criterion(new LAScriterionDropzBelow(Cstdlib.atof(argv[i + 1])));
                    argv[i] = "";
                    argv[i + 1] = "";
                    ++i;
                    continue;
                }
                if (Cstring.strcmp(argv[i], "-clip_z_above") == 0) {
                    Cstdio.fprintf(stderr, "WARNING: '%s' will not be supported in the future. check documentation with '-h'.\n", argv[i]);
                    Cstdio.fprintf(stderr, "  rename '-clip_z_below' to '-drop_z_below'.\n", new Object[0]);
                    Cstdio.fprintf(stderr, "  rename '-clip_z_above' to '-drop_z_above'.\n", new Object[0]);
                    Cstdio.fprintf(stderr, "  rename '-clip_z_between' to '-drop_z'.\n", new Object[0]);
                    Cstdio.fprintf(stderr, "  rename '-clip' to '-keep_xy'.\n", new Object[0]);
                    Cstdio.fprintf(stderr, "  rename '-clip_tile' to '-keep_tile'.\n", new Object[0]);
                    if (i + 1 >= argc) {
                        Cstdio.fprintf(stderr, "ERROR: '%s' needs 1 argument: max_z\n", argv[i]);
                        return Boolean.FALSE;
                    }
                    this.add_criterion(new LAScriterionDropzAbove(Cstdlib.atof(argv[i + 1])));
                    argv[i] = "";
                    argv[i + 1] = "";
                    ++i;
                    continue;
                }
                if (Cstring.strcmp(argv[i], "-clip_to_bounding_box") == 0 || Cstring.strcmp(argv[i], "-clip_to_bb") == 0) continue;
                Cstdio.fprintf(stderr, "ERROR: '%s' is no longer recognized. check documentation with '-h'.\n", argv[i]);
                Cstdio.fprintf(stderr, "  rename '-clip' to '-keep_xy'.\n", new Object[0]);
                Cstdio.fprintf(stderr, "  rename '-clip_box' to '-keep_xyz'.\n", new Object[0]);
                Cstdio.fprintf(stderr, "  rename '-clip_tile' to '-keep_tile'.\n", new Object[0]);
                Cstdio.fprintf(stderr, "  rename '-clip_z_below' to '-drop_z_below'.\n", new Object[0]);
                Cstdio.fprintf(stderr, "  rename '-clip_z_above' to '-drop_z_above'.\n", new Object[0]);
                Cstdio.fprintf(stderr, "  rename '-clip_z_between' to '-drop_z'.\n", new Object[0]);
                Cstdio.fprintf(stderr, "  etc ...\n", new Object[0]);
                return Boolean.FALSE;
            }
            if (Cstring.strncmp(argv[i], "-keep_", 6) == 0) {
                if (Cstring.strncmp(argv[i], "-keep_first", 11) == 0) {
                    if (Cstring.strcmp(argv[i], "-keep_first") == 0) {
                        this.add_criterion(new LAScriterionKeepFirstReturn());
                        argv[i] = "";
                        continue;
                    }
                    if (Cstring.strcmp(argv[i], "-keep_first_of_many") != 0) continue;
                    this.add_criterion(new LAScriterionKeepFirstOfManyReturn());
                    argv[i] = "";
                    continue;
                }
                if (Cstring.strcmp(argv[i], "-keep_middle") == 0) {
                    this.add_criterion(new LAScriterionKeepMiddleReturn());
                    argv[i] = "";
                    continue;
                }
                if (Cstring.strncmp(argv[i], "-keep_last", 10) == 0) {
                    if (Cstring.strcmp(argv[i], "-keep_last") == 0) {
                        this.add_criterion(new LAScriterionKeepLastReturn());
                        argv[i] = "";
                        continue;
                    }
                    if (Cstring.strcmp(argv[i], "-keep_last_of_many") != 0) continue;
                    this.add_criterion(new LAScriterionKeepLastOfManyReturn());
                    argv[i] = "";
                    continue;
                }
                if (Cstring.strncmp(argv[i], "-keep_class", 11) == 0) {
                    if (Cstring.strcmp(argv[i], "-keep_classification") != 0 && Cstring.strcmp(argv[i], "-keep_class") != 0) continue;
                    if (i + 1 >= argc) {
                        Cstdio.fprintf(stderr, "ERROR: '%s' needs 1 at least argument: classification\n", argv[i]);
                        return Boolean.FALSE;
                    }
                    argv[i] = "";
                    ++i;
                    do {
                        if (Cstdlib.atoi(argv[i]) > 31) {
                            Cstdio.fprintf(stderr, "ERROR: cannot keep classification %d because it is larger than 31\n", Cstdlib.atoi(argv[i]));
                            return Boolean.FALSE;
                        }
                        if (Cstdlib.atoi(argv[i]) < 0) {
                            Cstdio.fprintf(stderr, "ERROR: cannot keep classification %d because it is smaller than 0\n", Cstdlib.atoi(argv[i]));
                            return Boolean.FALSE;
                        }
                        keep_classification_mask |= 1 << Cstdlib.atoi(argv[i]);
                        argv[i] = "";
                    } while (++i < argc && '0' <= LASfilter.asChar(argv[i]) && LASfilter.asChar(argv[i]) <= '9');
                    --i;
                    continue;
                }
                if (Cstring.strncmp(argv[i], "-keep_extended_", 15) == 0) {
                    if (Cstring.strcmp(argv[i], "-keep_extended_classification") != 0 && Cstring.strcmp(argv[i], "-keep_extended_class") != 0) continue;
                    if (i + 1 >= argc) {
                        Cstdio.fprintf(stderr, "ERROR: '%s' needs 1 at least argument: classification\n", argv[i]);
                        return Boolean.FALSE;
                    }
                    argv[i] = "";
                    ++i;
                    do {
                        if (Cstdlib.atoi(argv[i]) > 255) {
                            Cstdio.fprintf(stderr, "ERROR: cannot keep extended classification %d because it is larger than 255\n", Cstdlib.atoi(argv[i]));
                            return Boolean.FALSE;
                        }
                        if (Cstdlib.atoi(argv[i]) < 0) {
                            Cstdio.fprintf(stderr, "ERROR: cannot keep extended classification %d because it is smaller than 0\n", Cstdlib.atoi(argv[i]));
                            return Boolean.FALSE;
                        }
                        int n = Cstdlib.atoi(argv[i]) / 32;
                        keep_extended_classification_mask[n] = keep_extended_classification_mask[n] | 1 << Cstdlib.atoi(argv[i]) - 32 * (Cstdlib.atoi(argv[i]) / 32);
                        argv[i] = "";
                    } while (++i < argc && '0' <= LASfilter.asChar(argv[i]) && LASfilter.asChar(argv[i]) <= '9');
                    --i;
                    continue;
                }
                if (Cstring.strncmp(argv[i], "-keep_x", 7) == 0) {
                    if (Cstring.strcmp(argv[i], "-keep_xy") == 0) {
                        if (i + 4 >= argc) {
                            Cstdio.fprintf(stderr, "ERROR: '%s' needs 4 arguments: min_x min_y max_x max_y\n", argv[i]);
                            return Boolean.FALSE;
                        }
                        this.add_criterion(new LAScriterionKeepxy(Cstdlib.atof(argv[i + 1]), Cstdlib.atof(argv[i + 2]), Cstdlib.atof(argv[i + 3]), Cstdlib.atof(argv[i + 4])));
                        argv[i] = "";
                        argv[i + 1] = "";
                        argv[i + 2] = "";
                        argv[i + 3] = "";
                        argv[i + 4] = "";
                        i += 4;
                        continue;
                    }
                    if (Cstring.strcmp(argv[i], "-keep_xyz") == 0) {
                        if (i + 6 >= argc) {
                            Cstdio.fprintf(stderr, "ERROR: '%s' needs 6 arguments: min_x min_y min_z max_x max_y max_z\n", argv[i]);
                            return Boolean.FALSE;
                        }
                        this.add_criterion(new LAScriterionKeepxyz(Cstdlib.atof(argv[i + 1]), Cstdlib.atof(argv[i + 2]), Cstdlib.atof(argv[i + 3]), Cstdlib.atof(argv[i + 4]), Cstdlib.atof(argv[i + 5]), Cstdlib.atof(argv[i + 6])));
                        argv[i] = "";
                        argv[i + 1] = "";
                        argv[i + 2] = "";
                        argv[i + 3] = "";
                        argv[i + 4] = "";
                        argv[i + 5] = "";
                        argv[i + 6] = "";
                        i += 6;
                        continue;
                    }
                    if (Cstring.strcmp(argv[i], "-keep_x") != 0) continue;
                    if (i + 2 >= argc) {
                        Cstdio.fprintf(stderr, "ERROR: '%s' needs 2 arguments: min_x max_x\n", argv[i]);
                        return Boolean.FALSE;
                    }
                    this.add_criterion(new LAScriterionKeepx(Cstdlib.atof(argv[i + 1]), Cstdlib.atof(argv[i + 2])));
                    argv[i] = "";
                    argv[i + 1] = "";
                    argv[i + 2] = "";
                    i += 2;
                    continue;
                }
                if (Cstring.strcmp(argv[i], "-keep_y") == 0) {
                    if (i + 2 >= argc) {
                        Cstdio.fprintf(stderr, "ERROR: '%s' needs 2 arguments: min_y max_y\n", argv[i]);
                        return Boolean.FALSE;
                    }
                    this.add_criterion(new LAScriterionKeepy(Cstdlib.atof(argv[i + 1]), Cstdlib.atof(argv[i + 2])));
                    argv[i] = "";
                    argv[i + 1] = "";
                    argv[i + 2] = "";
                    i += 2;
                    continue;
                }
                if (Cstring.strcmp(argv[i], "-keep_z") == 0) {
                    if (i + 2 >= argc) {
                        Cstdio.fprintf(stderr, "ERROR: '%s' needs 2 arguments: min_z max_z\n", argv[i]);
                        return Boolean.FALSE;
                    }
                    this.add_criterion(new LAScriterionKeepz(Cstdlib.atof(argv[i + 1]), Cstdlib.atof(argv[i + 2])));
                    argv[i] = "";
                    argv[i + 1] = "";
                    argv[i + 2] = "";
                    i += 2;
                    continue;
                }
                if (Cstring.strncmp(argv[i], "-keep_X", 7) == 0) {
                    if (Cstring.strcmp(argv[i], "-keep_XY") == 0) {
                        if (i + 4 >= argc) {
                            Cstdio.fprintf(stderr, "ERROR: '%s' needs 4 arguments: min_X min_Y max_X max_Y\n", argv[i]);
                            return Boolean.FALSE;
                        }
                        this.add_criterion(new LAScriterionKeepXY(Cstdlib.atoi(argv[i + 1]), Cstdlib.atoi(argv[i + 2]), Cstdlib.atoi(argv[i + 3]), Cstdlib.atoi(argv[i + 4])));
                        argv[i] = "";
                        argv[i + 1] = "";
                        argv[i + 2] = "";
                        argv[i + 3] = "";
                        argv[i + 4] = "";
                        i += 4;
                        continue;
                    }
                    if (Cstring.strcmp(argv[i], "-keep_X") != 0) continue;
                    if (i + 2 >= argc) {
                        Cstdio.fprintf(stderr, "ERROR: '%s' needs 2 arguments: min_X max_X\n", argv[i]);
                        return Boolean.FALSE;
                    }
                    this.add_criterion(new LAScriterionKeepX(Cstdlib.atoi(argv[i + 1]), Cstdlib.atoi(argv[i + 2])));
                    argv[i] = "";
                    argv[i + 1] = "";
                    argv[i + 2] = "";
                    i += 2;
                    continue;
                }
                if (Cstring.strcmp(argv[i], "-keep_Y") == 0) {
                    if (i + 2 >= argc) {
                        Cstdio.fprintf(stderr, "ERROR: '%s' needs 2 arguments: min_Y max_Y\n", argv[i]);
                        return Boolean.FALSE;
                    }
                    this.add_criterion(new LAScriterionKeepY(Cstdlib.atoi(argv[i + 1]), Cstdlib.atoi(argv[i + 2])));
                    argv[i] = "";
                    argv[i + 1] = "";
                    argv[i + 2] = "";
                    i += 2;
                    continue;
                }
                if (Cstring.strcmp(argv[i], "-keep_Z") == 0) {
                    if (i + 2 >= argc) {
                        Cstdio.fprintf(stderr, "ERROR: '%s' needs 2 arguments: min_Z max_Z\n", argv[i]);
                        return Boolean.FALSE;
                    }
                    this.add_criterion(new LAScriterionKeepZ(Cstdlib.atoi(argv[i + 1]), Cstdlib.atoi(argv[i + 2])));
                    argv[i] = "";
                    argv[i + 1] = "";
                    argv[i + 2] = "";
                    i += 2;
                    continue;
                }
                if (Cstring.strcmp(argv[i], "-keep_tile") == 0) {
                    if (i + 3 >= argc) {
                        Cstdio.fprintf(stderr, "ERROR: '%s' needs 3 arguments: llx lly size\n", argv[i]);
                        return Boolean.FALSE;
                    }
                    this.add_criterion(new LAScriterionKeepTile((float)Cstdlib.atof(argv[i + 1]), (float)Cstdlib.atof(argv[i + 2]), (float)Cstdlib.atof(argv[i + 3])));
                    argv[i] = "";
                    argv[i + 1] = "";
                    argv[i + 2] = "";
                    argv[i + 3] = "";
                    i += 3;
                    continue;
                }
                if (Cstring.strcmp(argv[i], "-keep_circle") == 0) {
                    if (i + 3 >= argc) {
                        Cstdio.fprintf(stderr, "ERROR: '%s' needs 3 arguments: center_x center_y radius\n", argv[i]);
                        return Boolean.FALSE;
                    }
                    this.add_criterion(new LAScriterionKeepCircle(Cstdlib.atof(argv[i + 1]), Cstdlib.atof(argv[i + 2]), Cstdlib.atof(argv[i + 3])));
                    argv[i] = "";
                    argv[i + 1] = "";
                    argv[i + 2] = "";
                    argv[i + 3] = "";
                    i += 3;
                    continue;
                }
                if (Cstring.strcmp(argv[i], "-keep_return") == 0) {
                    if (i + 1 >= argc) {
                        Cstdio.fprintf(stderr, "ERROR: '%s' needs at least 1 argument: return_number\n", argv[i]);
                        return Boolean.FALSE;
                    }
                    argv[i] = "";
                    ++i;
                    do {
                        keep_return_mask |= 1 << Cstdlib.atoi(argv[i]);
                        argv[i] = "";
                    } while (++i < argc && '0' <= LASfilter.asChar(argv[i]) && LASfilter.asChar(argv[i]) <= '9');
                    --i;
                    continue;
                }
                if (Cstring.strcmp(argv[i], "-keep_return_mask") == 0) {
                    if (i + 1 >= argc) {
                        Cstdio.fprintf(stderr, "ERROR: '%s' needs 1 argument: return_mask\n", argv[i]);
                        return Boolean.FALSE;
                    }
                    keep_return_mask = Cstdlib.atoi(argv[i + 1]);
                    argv[i] = "";
                    argv[i + 1] = "";
                    ++i;
                    continue;
                }
                if (Cstring.strcmp(argv[i], "-keep_single") == 0) {
                    this.add_criterion(new LAScriterionKeepSpecificNumberOfReturns(1));
                    argv[i] = "";
                    continue;
                }
                if (Cstring.strcmp(argv[i], "-keep_double") == 0) {
                    this.add_criterion(new LAScriterionKeepSpecificNumberOfReturns(2));
                    argv[i] = "";
                    continue;
                }
                if (Cstring.strcmp(argv[i], "-keep_triple") == 0) {
                    this.add_criterion(new LAScriterionKeepSpecificNumberOfReturns(3));
                    argv[i] = "";
                    continue;
                }
                if (Cstring.strcmp(argv[i], "-keep_quadruple") == 0) {
                    this.add_criterion(new LAScriterionKeepSpecificNumberOfReturns(4));
                    argv[i] = "";
                    continue;
                }
                if (Cstring.strcmp(argv[i], "-keep_quintuple") == 0) {
                    this.add_criterion(new LAScriterionKeepSpecificNumberOfReturns(5));
                    argv[i] = "";
                    continue;
                }
                if (Cstring.strncmp(argv[i], "-keep_intensity", 15) == 0) {
                    if (Cstring.strcmp(argv[i], "-keep_intensity") == 0) {
                        if (i + 2 >= argc) {
                            Cstdio.fprintf(stderr, "ERROR: '%s' needs 2 arguments: min max\n", argv[i]);
                            return Boolean.FALSE;
                        }
                        this.add_criterion(new LAScriterionKeepIntensity(Cstdlib.atoi(argv[i + 1]), Cstdlib.atoi(argv[i + 2])));
                        argv[i] = "";
                        argv[i + 1] = "";
                        argv[i + 2] = "";
                        i += 2;
                        continue;
                    }
                    if (Cstring.strcmp(argv[i], "-keep_intensity_above") == 0) {
                        if (i + 1 >= argc) {
                            Cstdio.fprintf(stderr, "ERROR: '%s' needs 1 argument: max\n", argv[i]);
                            return Boolean.FALSE;
                        }
                        this.add_criterion(new LAScriterionKeepIntensityAbove(Cstdlib.atoi(argv[i + 1])));
                        argv[i] = "";
                        argv[i + 1] = "";
                        ++i;
                        continue;
                    }
                    if (Cstring.strcmp(argv[i], "-keep_intensity_below") != 0) continue;
                    if (i + 1 >= argc) {
                        Cstdio.fprintf(stderr, "ERROR: '%s' needs 1 argument: min\n", argv[i]);
                        return Boolean.FALSE;
                    }
                    this.add_criterion(new LAScriterionKeepIntensityBelow(Cstdlib.atoi(argv[i + 1])));
                    argv[i] = "";
                    argv[i + 1] = "";
                    ++i;
                    continue;
                }
                if (Cstring.strncmp(argv[i], "-keep_RGB_", 10) == 0) {
                    if (Cstring.strcmp(argv[i] + 10, "red") == 0) {
                        if (i + 2 >= argc) {
                            Cstdio.fprintf(stderr, "ERROR: '%s' needs 2 arguments: min max\n", argv[i]);
                            return Boolean.FALSE;
                        }
                        this.add_criterion(new LAScriterionKeepRGB(Cstdlib.atoi(argv[i + 1]), Cstdlib.atoi(argv[i + 2]), 0));
                        argv[i] = "";
                        argv[i + 1] = "";
                        argv[i + 2] = "";
                        i += 2;
                        continue;
                    }
                    if (Cstring.strcmp(argv[i] + 10, "green") == 0) {
                        if (i + 2 >= argc) {
                            Cstdio.fprintf(stderr, "ERROR: '%s' needs 2 arguments: min max\n", argv[i]);
                            return Boolean.FALSE;
                        }
                        this.add_criterion(new LAScriterionKeepRGB(Cstdlib.atoi(argv[i + 1]), Cstdlib.atoi(argv[i + 2]), 1));
                        argv[i] = "";
                        argv[i + 1] = "";
                        argv[i + 2] = "";
                        i += 2;
                        continue;
                    }
                    if (Cstring.strcmp(argv[i] + 10, "blue") == 0) {
                        if (i + 2 >= argc) {
                            Cstdio.fprintf(stderr, "ERROR: '%s' needs 2 arguments: min max\n", argv[i]);
                            return Boolean.FALSE;
                        }
                        this.add_criterion(new LAScriterionKeepRGB(Cstdlib.atoi(argv[i + 1]), Cstdlib.atoi(argv[i + 2]), 2));
                        argv[i] = "";
                        argv[i + 1] = "";
                        argv[i + 2] = "";
                        i += 2;
                        continue;
                    }
                    if (Cstring.strcmp(argv[i] + 10, "nir") != 0) continue;
                    if (i + 2 >= argc) {
                        Cstdio.fprintf(stderr, "ERROR: '%s' needs 2 arguments: min max\n", argv[i]);
                        return Boolean.FALSE;
                    }
                    this.add_criterion(new LAScriterionKeepRGB(Cstdlib.atoi(argv[i + 1]), Cstdlib.atoi(argv[i + 2]), 3));
                    argv[i] = "";
                    argv[i + 1] = "";
                    argv[i + 2] = "";
                    i += 2;
                    continue;
                }
                if (Cstring.strcmp(argv[i], "-keep_scan_angle") == 0) {
                    if (i + 2 >= argc) {
                        Cstdio.fprintf(stderr, "ERROR: '%s' needs 2 arguments: min max\n", argv[i]);
                        return Boolean.FALSE;
                    }
                    this.add_criterion(new LAScriterionKeepScanAngle(Cstdlib.atoi(argv[i + 1]), Cstdlib.atoi(argv[i + 2])));
                    argv[i] = "";
                    argv[i + 1] = "";
                    argv[i + 2] = "";
                    i += 2;
                    continue;
                }
                if (Cstring.strcmp(argv[i], "-keep_synthetic") == 0) {
                    this.add_criterion(new LAScriterionKeepSynthetic());
                    argv[i] = "";
                    continue;
                }
                if (Cstring.strcmp(argv[i], "-keep_keypoint") == 0) {
                    this.add_criterion(new LAScriterionKeepKeypoint());
                    argv[i] = "";
                    continue;
                }
                if (Cstring.strcmp(argv[i], "-keep_withheld") == 0) {
                    this.add_criterion(new LAScriterionKeepWithheld());
                    argv[i] = "";
                    continue;
                }
                if (Cstring.strcmp(argv[i], "-keep_overlap") == 0) {
                    this.add_criterion(new LAScriterionKeepOverlap());
                    argv[i] = "";
                    continue;
                }
                if (Cstring.strcmp(argv[i], "-keep_wavepacket") == 0) {
                    if (i + 1 >= argc) {
                        Cstdio.fprintf(stderr, "ERROR: '%s' needs 1 argument: index\n", argv[i]);
                        return Boolean.FALSE;
                    }
                    argv[i] = "";
                    this.add_criterion(new LAScriterionKeepWavepacket(Cstdlib.atoi(argv[++i])));
                    argv[i] = "";
                    continue;
                }
                if (Cstring.strncmp(argv[i], "-keep_user_data", 15) == 0) {
                    if (Cstring.strcmp(argv[i], "-keep_user_data") == 0) {
                        if (i + 1 >= argc) {
                            Cstdio.fprintf(stderr, "ERROR: '%s' needs 1 argument: value\n", argv[i]);
                            return Boolean.FALSE;
                        }
                        this.add_criterion(new LAScriterionKeepUserData((byte)Cstdlib.atoi(argv[i + 1])));
                        argv[i] = "";
                        argv[i + 1] = "";
                        ++i;
                        continue;
                    }
                    if (Cstring.strcmp(argv[i], "-keep_user_data_below") == 0) {
                        if (i + 2 >= argc) {
                            Cstdio.fprintf(stderr, "ERROR: '%s' needs 1 argument: value\n", argv[i]);
                            return Boolean.FALSE;
                        }
                        this.add_criterion(new LAScriterionKeepUserDataBelow((byte)Cstdlib.atoi(argv[i + 1])));
                        argv[i] = "";
                        argv[i + 1] = "";
                        ++i;
                        continue;
                    }
                    if (Cstring.strcmp(argv[i], "-keep_user_data_above") == 0) {
                        if (i + 2 >= argc) {
                            Cstdio.fprintf(stderr, "ERROR: '%s' needs 1 argument: value\n", argv[i]);
                            return Boolean.FALSE;
                        }
                        this.add_criterion(new LAScriterionKeepUserDataAbove((byte)Cstdlib.atoi(argv[i + 1])));
                        argv[i] = "";
                        argv[i + 1] = "";
                        ++i;
                        continue;
                    }
                    if (Cstring.strcmp(argv[i], "-keep_user_data_between") != 0) continue;
                    if (i + 2 >= argc) {
                        Cstdio.fprintf(stderr, "ERROR: '%s' needs 2 arguments: min_value max_value\n", argv[i]);
                        return Boolean.FALSE;
                    }
                    this.add_criterion(new LAScriterionKeepUserDataBetween((byte)Cstdlib.atoi(argv[i + 1]), (byte)Cstdlib.atoi(argv[i + 2])));
                    argv[i] = "";
                    argv[i + 1] = "";
                    argv[i + 2] = "";
                    i += 2;
                    continue;
                }
                if (Cstring.strncmp(argv[i], "-keep_point_source", 18) == 0) {
                    if (Cstring.strcmp(argv[i], "-keep_point_source") == 0) {
                        if (i + 1 >= argc) {
                            Cstdio.fprintf(stderr, "ERROR: '%s' needs 1 argument: ID\n", argv[i]);
                            return Boolean.FALSE;
                        }
                        this.add_criterion(new LAScriterionKeepPointSource((char)Cstdlib.atoi(argv[i + 1])));
                        argv[i] = "";
                        argv[i + 1] = "";
                        ++i;
                        continue;
                    }
                    if (Cstring.strcmp(argv[i], "-keep_point_source_between") != 0) continue;
                    if (i + 2 >= argc) {
                        Cstdio.fprintf(stderr, "ERROR: '%s' needs 2 arguments: min_ID max_ID\n", argv[i]);
                        return Boolean.FALSE;
                    }
                    this.add_criterion(new LAScriterionKeepPointSourceBetween((char)Cstdlib.atoi(argv[i + 1]), (char)Cstdlib.atoi(argv[i + 2])));
                    argv[i] = "";
                    argv[i + 1] = "";
                    argv[i + 2] = "";
                    i += 2;
                    continue;
                }
                if (Cstring.strncmp(argv[i], "-keep_gps", 9) == 0) {
                    if (Cstring.strcmp(argv[i], "-keep_gps_time") != 0 && Cstring.strcmp(argv[i], "-keep_gpstime") != 0) continue;
                    if (i + 2 >= argc) {
                        Cstdio.fprintf(stderr, "ERROR: '%s' needs 2 arguments: min max\n", argv[i]);
                        return Boolean.FALSE;
                    }
                    this.add_criterion(new LAScriterionKeepGpsTime(Cstdlib.atof(argv[i + 1]), Cstdlib.atof(argv[i + 2])));
                    argv[i] = "";
                    argv[i + 1] = "";
                    argv[i + 2] = "";
                    i += 2;
                    continue;
                }
                if (Cstring.strcmp(argv[i], "-keep_every_nth") == 0) {
                    if (i + 1 >= argc) {
                        Cstdio.fprintf(stderr, "ERROR: '%s' needs 1 argument: nth\n", argv[i]);
                        return Boolean.FALSE;
                    }
                    this.add_criterion(new LAScriterionKeepEveryNth(Cstdlib.atoi(argv[i + 1])));
                    argv[i] = "";
                    argv[i + 1] = "";
                    ++i;
                    continue;
                }
                if (Cstring.strcmp(argv[i], "-keep_random_fraction") == 0) {
                    if (i + 1 >= argc) {
                        Cstdio.fprintf(stderr, "ERROR: '%s' needs 1 argument: fraction\n", argv[i]);
                        return Boolean.FALSE;
                    }
                    this.add_criterion(new LAScriterionKeepRandomFraction((float)Cstdlib.atof(argv[i + 1])));
                    argv[i] = "";
                    argv[i + 1] = "";
                    ++i;
                    continue;
                }
                if (Cstring.strcmp(argv[i], "-keep_scan_direction_change") == 0) {
                    this.add_criterion(new LAScriterionKeepScanDirectionChange());
                    argv[i] = "";
                    continue;
                }
                if (Cstring.strcmp(argv[i], "-keep_edge_of_flight_line") != 0) continue;
                this.add_criterion(new LAScriterionKeepEdgeOfFlightLine());
                argv[i] = "";
                continue;
            }
            if (Cstring.strncmp(argv[i], "-drop_", 6) == 0) {
                if (Cstring.strncmp(argv[i], "-drop_first", 11) == 0) {
                    if (Cstring.strcmp(argv[i], "-drop_first") == 0) {
                        this.add_criterion(new LAScriterionDropFirstReturn());
                        argv[i] = "";
                        continue;
                    }
                    if (Cstring.strcmp(argv[i], "-drop_first_of_many") != 0) continue;
                    this.add_criterion(new LAScriterionDropFirstOfManyReturn());
                    argv[i] = "";
                    continue;
                }
                if (Cstring.strncmp(argv[i], "-drop_last", 10) == 0) {
                    if (Cstring.strcmp(argv[i], "-drop_last") == 0) {
                        this.add_criterion(new LAScriterionDropLastReturn());
                        argv[i] = "";
                        continue;
                    }
                    if (Cstring.strcmp(argv[i], "-drop_last_of_many") != 0) continue;
                    this.add_criterion(new LAScriterionDropLastOfManyReturn());
                    argv[i] = "";
                    continue;
                }
                if (Cstring.strcmp(argv[i], "-drop_middle") == 0) {
                    this.add_criterion(new LAScriterionDropMiddleReturn());
                    argv[i] = "";
                    continue;
                }
                if (Cstring.strncmp(argv[i], "-drop_class", 11) == 0) {
                    if (Cstring.strcmp(argv[i], "-drop_classification") == 0 || Cstring.strcmp(argv[i], "-drop_class") == 0) {
                        if (i + 1 >= argc) {
                            Cstdio.fprintf(stderr, "ERROR: '%s' needs at least 1 argument: classification\n", argv[i]);
                            return Boolean.FALSE;
                        }
                        argv[i] = "";
                        ++i;
                        do {
                            if (Cstdlib.atoi(argv[i]) > 31) {
                                Cstdio.fprintf(stderr, "ERROR: cannot drop classification %d because it is larger than 31\n", Cstdlib.atoi(argv[i]));
                                return Boolean.FALSE;
                            }
                            if (Cstdlib.atoi(argv[i]) < 0) {
                                Cstdio.fprintf(stderr, "ERROR: cannot drop classification %d because it is smaller than 0\n", Cstdlib.atoi(argv[i]));
                                return Boolean.FALSE;
                            }
                            drop_classification_mask |= 1 << Cstdlib.atoi(argv[i]);
                            argv[i] = "";
                        } while (++i < argc && '0' <= LASfilter.asChar(argv[i]) && LASfilter.asChar(argv[i]) <= '9');
                        --i;
                        continue;
                    }
                    if (Cstring.strcmp(argv[i], "-drop_classification_mask") != 0) continue;
                    if (i + 1 >= argc) {
                        Cstdio.fprintf(stderr, "ERROR: '%s' needs 1 argument: mask\n", argv[i]);
                        return Boolean.FALSE;
                    }
                    drop_classification_mask = Cstdlib.atoi(argv[i + 1]);
                    argv[i] = "";
                    argv[i + 1] = "";
                    ++i;
                    continue;
                }
                if (Cstring.strncmp(argv[i], "-drop_extended_", 15) == 0) {
                    if (Cstring.strcmp(argv[i], "-drop_extended_classification") == 0 || Cstring.strcmp(argv[i], "-drop_extended_class") == 0) {
                        if (i + 1 >= argc) {
                            Cstdio.fprintf(stderr, "ERROR: '%s' needs at least 1 argument: classification\n", argv[i]);
                            return Boolean.FALSE;
                        }
                        argv[i] = "";
                        ++i;
                        do {
                            if (Cstdlib.atoi(argv[i]) > 255) {
                                Cstdio.fprintf(stderr, "ERROR: cannot drop extended classification %d because it is larger than 255\n", Cstdlib.atoi(argv[i]));
                                return Boolean.FALSE;
                            }
                            if (Cstdlib.atoi(argv[i]) < 0) {
                                Cstdio.fprintf(stderr, "ERROR: cannot drop extended classification %d because it is smaller than 0\n", Cstdlib.atoi(argv[i]));
                                return Boolean.FALSE;
                            }
                            int n = Cstdlib.atoi(argv[i]) / 32;
                            drop_extended_classification_mask[n] = drop_extended_classification_mask[n] | 1 << Cstdlib.atoi(argv[i]) - 32 * (Cstdlib.atoi(argv[i]) / 32);
                            argv[i] = "";
                        } while (++i < argc && '0' <= LASfilter.asChar(argv[i]) && LASfilter.asChar(argv[i]) <= '9');
                        --i;
                        continue;
                    }
                    if (Cstring.strcmp(argv[i], "-drop_extended_classification_mask") != 0) continue;
                    if (i + 8 >= argc) {
                        Cstdio.fprintf(stderr, "ERROR: '%s' needs 8 arguments: mask7 mask6 mask5 mask4 mask3 mask2 mask1 mask0\n", argv[i]);
                        return Boolean.FALSE;
                    }
                    drop_extended_classification_mask[7] = Cstdlib.atoi(argv[i + 1]);
                    drop_extended_classification_mask[6] = Cstdlib.atoi(argv[i + 2]);
                    drop_extended_classification_mask[5] = Cstdlib.atoi(argv[i + 3]);
                    drop_extended_classification_mask[4] = Cstdlib.atoi(argv[i + 4]);
                    drop_extended_classification_mask[3] = Cstdlib.atoi(argv[i + 5]);
                    drop_extended_classification_mask[2] = Cstdlib.atoi(argv[i + 6]);
                    drop_extended_classification_mask[1] = Cstdlib.atoi(argv[i + 7]);
                    drop_extended_classification_mask[0] = Cstdlib.atoi(argv[i + 8]);
                    argv[i] = "";
                    argv[i + 1] = "";
                    argv[i + 2] = "";
                    argv[i + 3] = "";
                    argv[i + 4] = "";
                    argv[i + 5] = "";
                    argv[i + 6] = "";
                    argv[i + 7] = "";
                    argv[i + 8] = "";
                    i += 8;
                    continue;
                }
                if (Cstring.strncmp(argv[i], "-drop_x", 7) == 0) {
                    if (Cstring.strcmp(argv[i], "-drop_xy") == 0) {
                        if (i + 4 >= argc) {
                            Cstdio.fprintf(stderr, "ERROR: '%s' needs 4 arguments: min_x min_y max_x max_y\n", argv[i]);
                            return Boolean.FALSE;
                        }
                        this.add_criterion(new LAScriterionDropxy(Cstdlib.atof(argv[i + 1]), Cstdlib.atof(argv[i + 2]), Cstdlib.atof(argv[i + 3]), Cstdlib.atof(argv[i + 4])));
                        argv[i] = "";
                        argv[i + 1] = "";
                        argv[i + 2] = "";
                        argv[i + 3] = "";
                        argv[i + 4] = "";
                        i += 4;
                        continue;
                    }
                    if (Cstring.strcmp(argv[i], "-drop_xyz") == 0) {
                        if (i + 6 >= argc) {
                            Cstdio.fprintf(stderr, "ERROR: '%s' needs 6 arguments: min_x min_y min_z max_x max_y max_z\n", argv[i]);
                            return Boolean.FALSE;
                        }
                        this.add_criterion(new LAScriterionDropxyz(Cstdlib.atof(argv[i + 1]), Cstdlib.atof(argv[i + 2]), Cstdlib.atof(argv[i + 3]), Cstdlib.atof(argv[i + 4]), Cstdlib.atof(argv[i + 5]), Cstdlib.atof(argv[i + 6])));
                        argv[i] = "";
                        argv[i + 1] = "";
                        argv[i + 2] = "";
                        argv[i + 3] = "";
                        argv[i + 4] = "";
                        argv[i + 5] = "";
                        argv[i + 6] = "";
                        i += 6;
                        continue;
                    }
                    if (Cstring.strcmp(argv[i], "-drop_x") == 0) {
                        if (i + 2 >= argc) {
                            Cstdio.fprintf(stderr, "ERROR: '%s' needs 2 arguments: min_x max_x\n", argv[i]);
                            return Boolean.FALSE;
                        }
                        this.add_criterion(new LAScriterionDropx(Cstdlib.atof(argv[i + 1]), Cstdlib.atof(argv[i + 2])));
                        argv[i] = "";
                        argv[i + 1] = "";
                        argv[i + 2] = "";
                        i += 2;
                        continue;
                    }
                    if (Cstring.strcmp(argv[i], "-drop_x_below") == 0) {
                        if (i + 1 >= argc) {
                            Cstdio.fprintf(stderr, "ERROR: '%s' needs 1 argument: min_x\n", argv[i]);
                            return Boolean.FALSE;
                        }
                        this.add_criterion(new LAScriterionDropxBelow(Cstdlib.atof(argv[i + 1])));
                        argv[i] = "";
                        argv[i + 1] = "";
                        ++i;
                        continue;
                    }
                    if (Cstring.strcmp(argv[i], "-drop_x_above") != 0) continue;
                    if (i + 1 >= argc) {
                        Cstdio.fprintf(stderr, "ERROR: '%s' needs 1 argument: max_x\n", argv[i]);
                        return Boolean.FALSE;
                    }
                    this.add_criterion(new LAScriterionDropxAbove(Cstdlib.atof(argv[i + 1])));
                    argv[i] = "";
                    argv[i + 1] = "";
                    ++i;
                    continue;
                }
                if (Cstring.strncmp(argv[i], "-drop_y", 7) == 0) {
                    if (Cstring.strcmp(argv[i], "-drop_y") == 0) {
                        if (i + 2 >= argc) {
                            Cstdio.fprintf(stderr, "ERROR: '%s' needs 2 arguments: min_y max_y\n", argv[i]);
                            return Boolean.FALSE;
                        }
                        this.add_criterion(new LAScriterionDropy(Cstdlib.atof(argv[i + 1]), Cstdlib.atof(argv[i + 2])));
                        argv[i] = "";
                        argv[i + 1] = "";
                        argv[i + 2] = "";
                        i += 2;
                        continue;
                    }
                    if (Cstring.strcmp(argv[i], "-drop_y_below") == 0) {
                        if (i + 1 >= argc) {
                            Cstdio.fprintf(stderr, "ERROR: '%s' needs 1 argument: min_y\n", argv[i]);
                            return Boolean.FALSE;
                        }
                        this.add_criterion(new LAScriterionDropyBelow(Cstdlib.atof(argv[i + 1])));
                        argv[i] = "";
                        argv[i + 1] = "";
                        ++i;
                        continue;
                    }
                    if (Cstring.strcmp(argv[i], "-drop_y_above") != 0) continue;
                    if (i + 1 >= argc) {
                        Cstdio.fprintf(stderr, "ERROR: '%s' needs 1 argument: max_y\n", argv[i]);
                        return Boolean.FALSE;
                    }
                    this.add_criterion(new LAScriterionDropyAbove(Cstdlib.atof(argv[i + 1])));
                    argv[i] = "";
                    argv[i + 1] = "";
                    ++i;
                    continue;
                }
                if (Cstring.strncmp(argv[i], "-drop_z", 7) == 0) {
                    if (Cstring.strcmp(argv[i], "-drop_z") == 0) {
                        if (i + 2 >= argc) {
                            Cstdio.fprintf(stderr, "ERROR: '%s' needs 2 arguments: min_z max_z\n", argv[i]);
                            return Boolean.FALSE;
                        }
                        this.add_criterion(new LAScriterionDropz(Cstdlib.atof(argv[i + 1]), Cstdlib.atof(argv[i + 2])));
                        argv[i] = "";
                        argv[i + 1] = "";
                        argv[i + 2] = "";
                        i += 2;
                        continue;
                    }
                    if (Cstring.strcmp(argv[i], "-drop_z_below") == 0) {
                        if (i + 1 >= argc) {
                            Cstdio.fprintf(stderr, "ERROR: '%s' needs 1 argument: min_z\n", argv[i]);
                            return Boolean.FALSE;
                        }
                        this.add_criterion(new LAScriterionDropzBelow(Cstdlib.atof(argv[i + 1])));
                        argv[i] = "";
                        argv[i + 1] = "";
                        ++i;
                        continue;
                    }
                    if (Cstring.strcmp(argv[i], "-drop_z_above") != 0) continue;
                    if (i + 1 >= argc) {
                        Cstdio.fprintf(stderr, "ERROR: '%s' needs 1 argument: max_z\n", argv[i]);
                        return Boolean.FALSE;
                    }
                    this.add_criterion(new LAScriterionDropzAbove(Cstdlib.atof(argv[i + 1])));
                    argv[i] = "";
                    argv[i + 1] = "";
                    ++i;
                    continue;
                }
                if (Cstring.strncmp(argv[i], "-drop_X", 7) == 0) {
                    if (Cstring.strcmp(argv[i], "-drop_X") == 0) {
                        if (i + 2 >= argc) {
                            Cstdio.fprintf(stderr, "ERROR: '%s' needs 2 arguments: min_X max_X\n", argv[i]);
                            return Boolean.FALSE;
                        }
                        this.add_criterion(new LAScriterionDropX(Cstdlib.atoi(argv[i + 1]), Cstdlib.atoi(argv[i + 2])));
                        argv[i] = "";
                        argv[i + 1] = "";
                        argv[i + 2] = "";
                        i += 2;
                        continue;
                    }
                    if (Cstring.strcmp(argv[i], "-drop_X_below") == 0) {
                        if (i + 1 >= argc) {
                            Cstdio.fprintf(stderr, "ERROR: '%s' needs 1 argument: min_X\n", argv[i]);
                            return Boolean.FALSE;
                        }
                        this.add_criterion(new LAScriterionDropXBelow(Cstdlib.atoi(argv[i + 1])));
                        argv[i] = "";
                        argv[i + 1] = "";
                        ++i;
                        continue;
                    }
                    if (Cstring.strcmp(argv[i], "-drop_X_above") != 0) continue;
                    if (i + 1 >= argc) {
                        Cstdio.fprintf(stderr, "ERROR: '%s' needs 1 argument: max_X\n", argv[i]);
                        return Boolean.FALSE;
                    }
                    this.add_criterion(new LAScriterionDropXAbove(Cstdlib.atoi(argv[i + 1])));
                    argv[i] = "";
                    argv[i + 1] = "";
                    ++i;
                    continue;
                }
                if (Cstring.strncmp(argv[i], "-drop_Y", 7) == 0) {
                    if (Cstring.strcmp(argv[i], "-drop_Y") == 0) {
                        if (i + 2 >= argc) {
                            Cstdio.fprintf(stderr, "ERROR: '%s' needs 2 arguments: min_Y max_Y\n", argv[i]);
                            return Boolean.FALSE;
                        }
                        this.add_criterion(new LAScriterionDropY(Cstdlib.atoi(argv[i + 1]), Cstdlib.atoi(argv[i + 2])));
                        argv[i] = "";
                        argv[i + 1] = "";
                        argv[i + 2] = "";
                        i += 2;
                        continue;
                    }
                    if (Cstring.strcmp(argv[i], "-drop_Y_below") == 0) {
                        if (i + 1 >= argc) {
                            Cstdio.fprintf(stderr, "ERROR: '%s' needs 1 argument: min_Y\n", argv[i]);
                            return Boolean.FALSE;
                        }
                        this.add_criterion(new LAScriterionDropYBelow(Cstdlib.atoi(argv[i + 1])));
                        argv[i] = "";
                        argv[i + 1] = "";
                        ++i;
                        continue;
                    }
                    if (Cstring.strcmp(argv[i], "-drop_Y_above") != 0) continue;
                    if (i + 1 >= argc) {
                        Cstdio.fprintf(stderr, "ERROR: '%s' needs 1 argument: max_Y\n", argv[i]);
                        return Boolean.FALSE;
                    }
                    this.add_criterion(new LAScriterionDropYAbove(Cstdlib.atoi(argv[i + 1])));
                    argv[i] = "";
                    argv[i + 1] = "";
                    ++i;
                    continue;
                }
                if (Cstring.strncmp(argv[i], "-drop_Z", 7) == 0) {
                    if (Cstring.strcmp(argv[i], "-drop_Z") == 0) {
                        if (i + 2 >= argc) {
                            Cstdio.fprintf(stderr, "ERROR: '%s' needs 2 arguments: min_Z max_Z\n", argv[i]);
                            return Boolean.FALSE;
                        }
                        this.add_criterion(new LAScriterionDropZ(Cstdlib.atoi(argv[i + 1]), Cstdlib.atoi(argv[i + 2])));
                        argv[i] = "";
                        argv[i + 1] = "";
                        argv[i + 2] = "";
                        i += 2;
                        continue;
                    }
                    if (Cstring.strcmp(argv[i], "-drop_Z_below") == 0) {
                        if (i + 1 >= argc) {
                            Cstdio.fprintf(stderr, "ERROR: '%s' needs 1 argument: min_Z\n", argv[i]);
                            return Boolean.FALSE;
                        }
                        this.add_criterion(new LAScriterionDropZBelow(Cstdlib.atoi(argv[i + 1])));
                        argv[i] = "";
                        argv[i + 1] = "";
                        ++i;
                        continue;
                    }
                    if (Cstring.strcmp(argv[i], "-drop_Z_above") != 0) continue;
                    if (i + 1 >= argc) {
                        Cstdio.fprintf(stderr, "ERROR: '%s' needs 1 argument: max_Z\n", argv[i]);
                        return Boolean.FALSE;
                    }
                    this.add_criterion(new LAScriterionDropZAbove(Cstdlib.atoi(argv[i + 1])));
                    argv[i] = "";
                    argv[i + 1] = "";
                    ++i;
                    continue;
                }
                if (Cstring.strcmp(argv[i], "-drop_return") == 0) {
                    if (i + 1 >= argc) {
                        Cstdio.fprintf(stderr, "ERROR: '%s' needs at least 1 argument: return_number\n", argv[i]);
                        return Boolean.FALSE;
                    }
                    argv[i] = "";
                    ++i;
                    do {
                        drop_return_mask |= 1 << Cstdlib.atoi(argv[i]);
                        argv[i] = "";
                    } while (++i < argc && '0' <= LASfilter.asChar(argv[i]) && LASfilter.asChar(argv[i]) <= '9');
                    --i;
                    continue;
                }
                if (Cstring.strcmp(argv[i], "-drop_single") == 0) {
                    this.add_criterion(new LAScriterionDropSpecificNumberOfReturns(1));
                    argv[i] = "";
                    continue;
                }
                if (Cstring.strcmp(argv[i], "-drop_double") == 0) {
                    this.add_criterion(new LAScriterionDropSpecificNumberOfReturns(2));
                    argv[i] = "";
                    continue;
                }
                if (Cstring.strcmp(argv[i], "-drop_triple") == 0) {
                    this.add_criterion(new LAScriterionDropSpecificNumberOfReturns(3));
                    argv[i] = "";
                    continue;
                }
                if (Cstring.strcmp(argv[i], "-drop_quadruple") == 0) {
                    this.add_criterion(new LAScriterionDropSpecificNumberOfReturns(4));
                    argv[i] = "";
                    continue;
                }
                if (Cstring.strcmp(argv[i], "-drop_quintuple") == 0) {
                    this.add_criterion(new LAScriterionDropSpecificNumberOfReturns(5));
                    argv[i] = "";
                    continue;
                }
                if (Cstring.strcmp(argv[i], "-drop_scan_direction") == 0) {
                    this.add_criterion(new LAScriterionDropScanDirection(Cstdlib.atoi(argv[i + 1])));
                    argv[i] = "";
                    argv[i + 1] = "";
                    ++i;
                    continue;
                }
                if (Cstring.strncmp(argv[i], "-drop_intensity_above", 15) == 0) {
                    if (Cstring.strcmp(argv[i], "-drop_intensity_above") == 0) {
                        if (i + 1 >= argc) {
                            Cstdio.fprintf(stderr, "ERROR: '%s' needs 1 argument: max\n", argv[i]);
                            return Boolean.FALSE;
                        }
                        this.add_criterion(new LAScriterionDropIntensityAbove(Cstdlib.atoi(argv[i + 1])));
                        argv[i] = "";
                        argv[i + 1] = "";
                        ++i;
                        continue;
                    }
                    if (Cstring.strcmp(argv[i], "-drop_intensity_below") == 0) {
                        if (i + 1 >= argc) {
                            Cstdio.fprintf(stderr, "ERROR: '%s' needs 1 argument: min\n", argv[i]);
                            return Boolean.FALSE;
                        }
                        this.add_criterion(new LAScriterionDropIntensityBelow(Cstdlib.atoi(argv[i + 1])));
                        argv[i] = "";
                        argv[i + 1] = "";
                        ++i;
                        continue;
                    }
                    if (Cstring.strcmp(argv[i], "-drop_intensity_between") != 0) continue;
                    if (i + 2 >= argc) {
                        Cstdio.fprintf(stderr, "ERROR: '%s' needs 2 arguments: min max\n", argv[i]);
                        return Boolean.FALSE;
                    }
                    this.add_criterion(new LAScriterionDropIntensityBetween(Cstdlib.atoi(argv[i + 1]), Cstdlib.atoi(argv[i + 2])));
                    argv[i] = "";
                    argv[i + 1] = "";
                    argv[i + 2] = "";
                    i += 2;
                    continue;
                }
                if (Cstring.strncmp(argv[i], "-drop_abs_scan_angle_", 21) == 0) {
                    if (Cstring.strcmp(argv[i], "-drop_abs_scan_angle_above") == 0) {
                        if (i + 1 >= argc) {
                            Cstdio.fprintf(stderr, "ERROR: '%s' needs 1 argument: max\n", argv[i]);
                            return Boolean.FALSE;
                        }
                        int angle = Cstdlib.atoi(argv[i + 1]);
                        this.add_criterion(new LAScriterionKeepScanAngle(-angle, angle));
                        argv[i] = "";
                        argv[i + 1] = "";
                        ++i;
                        continue;
                    }
                    if (Cstring.strcmp(argv[i], "-drop_abs_scan_angle_below") != 0) continue;
                    if (i + 1 >= argc) {
                        Cstdio.fprintf(stderr, "ERROR: '%s' needs 1 argument: min\n", argv[i]);
                        return Boolean.FALSE;
                    }
                    int angle = Cstdlib.atoi(argv[i + 1]);
                    this.add_criterion(new LAScriterionDropScanAngleBetween(-angle + 1, angle - 1));
                    argv[i] = "";
                    argv[i + 1] = "";
                    ++i;
                    continue;
                }
                if (Cstring.strncmp(argv[i], "-drop_scan_angle_", 17) == 0) {
                    if (Cstring.strcmp(argv[i], "-drop_scan_angle_above") == 0) {
                        if (i + 1 >= argc) {
                            Cstdio.fprintf(stderr, "ERROR: '%s' needs 1 argument: max\n", argv[i]);
                            return Boolean.FALSE;
                        }
                        this.add_criterion(new LAScriterionDropScanAngleAbove(Cstdlib.atoi(argv[i + 1])));
                        argv[i] = "";
                        argv[i + 1] = "";
                        ++i;
                        continue;
                    }
                    if (Cstring.strcmp(argv[i], "-drop_scan_angle_below") == 0) {
                        if (i + 1 >= argc) {
                            Cstdio.fprintf(stderr, "ERROR: '%s' needs 1 argument: min\n", argv[i]);
                            return Boolean.FALSE;
                        }
                        this.add_criterion(new LAScriterionDropScanAngleBelow(Cstdlib.atoi(argv[i + 1])));
                        argv[i] = "";
                        argv[i + 1] = "";
                        ++i;
                        continue;
                    }
                    if (Cstring.strcmp(argv[i], "-drop_scan_angle_between") != 0) continue;
                    if (i + 2 >= argc) {
                        Cstdio.fprintf(stderr, "ERROR: '%s' needs 2 arguments: min max\n", argv[i]);
                        return Boolean.FALSE;
                    }
                    this.add_criterion(new LAScriterionDropScanAngleBetween(Cstdlib.atoi(argv[i + 1]), Cstdlib.atoi(argv[i + 2])));
                    argv[i] = "";
                    argv[i + 1] = "";
                    argv[i + 2] = "";
                    i += 2;
                    continue;
                }
                if (Cstring.strcmp(argv[i], "-drop_synthetic") == 0) {
                    this.add_criterion(new LAScriterionDropSynthetic());
                    argv[i] = "";
                    continue;
                }
                if (Cstring.strcmp(argv[i], "-drop_keypoint") == 0) {
                    this.add_criterion(new LAScriterionDropKeypoint());
                    argv[i] = "";
                    continue;
                }
                if (Cstring.strcmp(argv[i], "-drop_withheld") == 0) {
                    this.add_criterion(new LAScriterionDropWithheld());
                    argv[i] = "";
                    continue;
                }
                if (Cstring.strcmp(argv[i], "-drop_overlap") == 0) {
                    this.add_criterion(new LAScriterionDropOverlap());
                    argv[i] = "";
                    continue;
                }
                if (Cstring.strcmp(argv[i], "-drop_wavepacket") == 0) {
                    if (i + 1 >= argc) {
                        Cstdio.fprintf(stderr, "ERROR: '%s' needs 1 argument: index\n", argv[i]);
                        return Boolean.FALSE;
                    }
                    argv[i] = "";
                    this.add_criterion(new LAScriterionDropWavepacket(Cstdlib.atoi(argv[++i])));
                    argv[i] = "";
                    continue;
                }
                if (Cstring.strncmp(argv[i], "-drop_user_data", 15) == 0) {
                    if (Cstring.strcmp(argv[i], "-drop_user_data") == 0) {
                        if (i + 1 >= argc) {
                            Cstdio.fprintf(stderr, "ERROR: '%s' needs at least 1 argument: ID\n", argv[i]);
                            return Boolean.FALSE;
                        }
                        argv[i] = "";
                        ++i;
                        do {
                            this.add_criterion(new LAScriterionDropUserData((byte)Cstdlib.atoi(argv[i])));
                            argv[i] = "";
                        } while (++i < argc && '0' <= LASfilter.asChar(argv[i]) && LASfilter.asChar(argv[i]) <= '9');
                        --i;
                        continue;
                    }
                    if (Cstring.strcmp(argv[i], "-drop_user_data_below") == 0) {
                        if (i + 1 >= argc) {
                            Cstdio.fprintf(stderr, "ERROR: '%s' needs 1 argument: min_value\n", argv[i]);
                            return Boolean.FALSE;
                        }
                        this.add_criterion(new LAScriterionDropUserDataBelow((byte)Cstdlib.atoi(argv[i + 1])));
                        argv[i] = "";
                        argv[i + 1] = "";
                        ++i;
                        continue;
                    }
                    if (Cstring.strcmp(argv[i], "-drop_user_data_above") == 0) {
                        if (i + 1 >= argc) {
                            Cstdio.fprintf(stderr, "ERROR: '%s' needs 1 argument: max_value\n", argv[i]);
                            return Boolean.FALSE;
                        }
                        this.add_criterion(new LAScriterionDropUserDataAbove((byte)Cstdlib.atoi(argv[i + 1])));
                        argv[i] = "";
                        argv[i + 1] = "";
                        ++i;
                        continue;
                    }
                    if (Cstring.strcmp(argv[i], "-drop_user_data_between") != 0) continue;
                    if (i + 2 >= argc) {
                        Cstdio.fprintf(stderr, "ERROR: '%s' needs 2 arguments: min_value max_value\n", argv[i]);
                        return Boolean.FALSE;
                    }
                    this.add_criterion(new LAScriterionDropUserDataBetween((byte)Cstdlib.atoi(argv[i + 1]), (byte)Cstdlib.atoi(argv[i + 2])));
                    argv[i] = "";
                    argv[i + 1] = "";
                    argv[i + 2] = "";
                    i += 2;
                    continue;
                }
                if (Cstring.strncmp(argv[i], "-drop_point_source", 18) == 0) {
                    if (Cstring.strcmp(argv[i], "-drop_point_source") == 0) {
                        if (i + 1 >= argc) {
                            Cstdio.fprintf(stderr, "ERROR: '%s' needs at least 1 argument: ID\n", argv[i]);
                            return Boolean.FALSE;
                        }
                        argv[i] = "";
                        ++i;
                        do {
                            this.add_criterion(new LAScriterionDropPointSource((char)Cstdlib.atoi(argv[i])));
                            argv[i] = "";
                        } while (++i < argc && '0' <= LASfilter.asChar(argv[i]) && LASfilter.asChar(argv[i]) <= '9');
                        --i;
                        continue;
                    }
                    if (Cstring.strcmp(argv[i], "-drop_point_source_below") == 0) {
                        if (i + 1 >= argc) {
                            Cstdio.fprintf(stderr, "ERROR: '%s' needs 1 argument: min_ID\n", argv[i]);
                            return Boolean.FALSE;
                        }
                        this.add_criterion(new LAScriterionDropPointSourceBelow((char)Cstdlib.atoi(argv[i + 1])));
                        argv[i] = "";
                        argv[i + 1] = "";
                        ++i;
                        continue;
                    }
                    if (Cstring.strcmp(argv[i], "-drop_point_source_above") == 0) {
                        if (i + 1 >= argc) {
                            Cstdio.fprintf(stderr, "ERROR: '%s' needs 1 argument: max_ID\n", argv[i]);
                            return Boolean.FALSE;
                        }
                        this.add_criterion(new LAScriterionDropPointSourceAbove((char)Cstdlib.atoi(argv[i + 1])));
                        argv[i] = "";
                        argv[i + 1] = "";
                        ++i;
                        continue;
                    }
                    if (Cstring.strcmp(argv[i], "-drop_point_source_between") != 0) continue;
                    if (i + 2 >= argc) {
                        Cstdio.fprintf(stderr, "ERROR: '%s' needs 2 arguments: min_ID max_ID\n", argv[i]);
                        return Boolean.FALSE;
                    }
                    this.add_criterion(new LAScriterionDropPointSourceBetween((char)Cstdlib.atoi(argv[i + 1]), (char)Cstdlib.atoi(argv[i + 2])));
                    argv[i] = "";
                    argv[i + 1] = "";
                    argv[i + 2] = "";
                    i += 2;
                    continue;
                }
                if (Cstring.strncmp(argv[i], "-drop_gps", 9) != 0) continue;
                if (Cstring.strcmp(argv[i], "-drop_gps_time_above") == 0 || Cstring.strcmp(argv[i], "-drop_gpstime_above") == 0) {
                    if (i + 1 >= argc) {
                        Cstdio.fprintf(stderr, "ERROR: '%s' needs 1 argument: max_gps_time\n", argv[i]);
                        return Boolean.FALSE;
                    }
                    this.add_criterion(new LAScriterionDropGpsTimeAbove(Cstdlib.atof(argv[i + 1])));
                    argv[i] = "";
                    argv[i + 1] = "";
                    ++i;
                    continue;
                }
                if (Cstring.strcmp(argv[i], "-drop_gps_time_below") == 0 || Cstring.strcmp(argv[i], "-drop_gpstime_below") == 0) {
                    if (i + 1 >= argc) {
                        Cstdio.fprintf(stderr, "ERROR: '%s' needs 1 argument: min_gps_time\n", argv[i]);
                        return Boolean.FALSE;
                    }
                    this.add_criterion(new LAScriterionDropGpsTimeBelow(Cstdlib.atof(argv[i + 1])));
                    argv[i] = "";
                    argv[i + 1] = "";
                    ++i;
                    continue;
                }
                if (Cstring.strcmp(argv[i], "-drop_gps_time_between") != 0 && Cstring.strcmp(argv[i], "-drop_gpstime_between") != 0) continue;
                if (i + 2 >= argc) {
                    Cstdio.fprintf(stderr, "ERROR: '%s' needs 2 arguments: min max\n", argv[i]);
                    return Boolean.FALSE;
                }
                this.add_criterion(new LAScriterionDropGpsTimeBetween(Cstdlib.atof(argv[i + 1]), Cstdlib.atof(argv[i + 2])));
                argv[i] = "";
                argv[i + 1] = "";
                argv[i + 2] = "";
                i += 2;
                continue;
            }
            if (Cstring.strcmp(argv[i], "-first_only") == 0) {
                this.add_criterion(new LAScriterionKeepFirstReturn());
                argv[i] = "";
                continue;
            }
            if (Cstring.strcmp(argv[i], "-last_only") == 0) {
                this.add_criterion(new LAScriterionKeepLastReturn());
                argv[i] = "";
                continue;
            }
            if (Cstring.strncmp(argv[i], "-thin_", 6) == 0) {
                if (Cstring.strcmp(argv[i], "-thin_with_grid") == 0) {
                    if (i + 1 >= argc) {
                        Cstdio.fprintf(stderr, "ERROR: '%s' needs 1 argument: grid_spacing\n", argv[i]);
                        return Boolean.FALSE;
                    }
                    this.add_criterion(new LAScriterionThinWithGrid((float)Cstdlib.atof(argv[i + 1])));
                    argv[i] = "";
                    argv[i + 1] = "";
                    ++i;
                    continue;
                }
                if (Cstring.strcmp(argv[i], "-thin_with_time") != 0) continue;
                if (i + 1 >= argc) {
                    Cstdio.fprintf(stderr, "ERROR: '%s' needs 1 argument: time_spacing\n", argv[i]);
                    return Boolean.FALSE;
                }
                this.add_criterion(new LAScriterionThinWithTime((float)Cstdlib.atof(argv[i + 1])));
                argv[i] = "";
                argv[i + 1] = "";
                ++i;
                continue;
            }
            if (Cstring.strncmp(argv[i], "-filter_", 8) != 0) continue;
            if (Cstring.strcmp(argv[i], "-filter_and") == 0) {
                if (this.num_criteria < 2) {
                    Cstdio.fprintf(stderr, "ERROR: '%s' needs to be preceeded by at least two filters\n", argv[i]);
                    return Boolean.FALSE;
                }
                LAScriterionAnd filter_criterion = new LAScriterionAnd(this.criteria[this.num_criteria - 2], this.criteria[this.num_criteria - 1]);
                --this.num_criteria;
                this.criteria[this.num_criteria] = null;
                --this.num_criteria;
                this.criteria[this.num_criteria] = null;
                this.add_criterion(filter_criterion);
                argv[i] = "";
                continue;
            }
            if (Cstring.strcmp(argv[i], "-filter_or") != 0) continue;
            if (this.num_criteria < 2) {
                Cstdio.fprintf(stderr, "ERROR: '%s' needs to be preceeded by at least two filters\n", argv[i]);
                return Boolean.FALSE;
            }
            LAScriterionOr filter_criterion = new LAScriterionOr(this.criteria[this.num_criteria - 2], this.criteria[this.num_criteria - 1]);
            --this.num_criteria;
            this.criteria[this.num_criteria] = null;
            --this.num_criteria;
            this.criteria[this.num_criteria] = null;
            this.add_criterion(filter_criterion);
            argv[i] = "";
        }
        if (drop_return_mask != 0) {
            if (keep_return_mask != 0) {
                Cstdio.fprintf(stderr, "ERROR: cannot use '-drop_return' and '-keep_return' simultaneously\n", new Object[0]);
                return Boolean.FALSE;
            }
            keep_return_mask = 0xFF & ~drop_return_mask;
        }
        if (keep_return_mask != 0) {
            this.add_criterion(new LAScriterionKeepReturns(keep_return_mask));
        }
        if (keep_classification_mask != 0) {
            if (drop_classification_mask != 0) {
                Cstdio.fprintf(stderr, "ERROR: cannot use '-drop_class' and '-keep_class' simultaneously\n", new Object[0]);
                return Boolean.FALSE;
            }
            drop_classification_mask = ~keep_classification_mask;
        }
        if (drop_classification_mask != 0) {
            this.add_criterion(new LAScriterionDropClassifications(drop_classification_mask));
        }
        if (LASfilter.asBoolean(keep_extended_classification_mask[0]) || LASfilter.asBoolean(keep_extended_classification_mask[1]) || LASfilter.asBoolean(keep_extended_classification_mask[2]) || LASfilter.asBoolean(keep_extended_classification_mask[3]) || LASfilter.asBoolean(keep_extended_classification_mask[4]) || LASfilter.asBoolean(keep_extended_classification_mask[5]) || LASfilter.asBoolean(keep_extended_classification_mask[6]) || LASfilter.asBoolean(keep_extended_classification_mask[7])) {
            if (LASfilter.asBoolean(drop_extended_classification_mask[0]) || LASfilter.asBoolean(drop_extended_classification_mask[1]) || LASfilter.asBoolean(drop_extended_classification_mask[2]) || LASfilter.asBoolean(drop_extended_classification_mask[3]) || LASfilter.asBoolean(drop_extended_classification_mask[4]) || LASfilter.asBoolean(drop_extended_classification_mask[5]) || LASfilter.asBoolean(drop_extended_classification_mask[6]) || LASfilter.asBoolean(drop_extended_classification_mask[7])) {
                Cstdio.fprintf(stderr, "ERROR: cannot use '-drop_extended_class' and '-keep_extended_class' simultaneously\n", new Object[0]);
                return Boolean.FALSE;
            }
            drop_extended_classification_mask[0] = ~keep_extended_classification_mask[0];
            drop_extended_classification_mask[1] = ~keep_extended_classification_mask[1];
            drop_extended_classification_mask[2] = ~keep_extended_classification_mask[2];
            drop_extended_classification_mask[3] = ~keep_extended_classification_mask[3];
            drop_extended_classification_mask[4] = ~keep_extended_classification_mask[4];
            drop_extended_classification_mask[5] = ~keep_extended_classification_mask[5];
            drop_extended_classification_mask[6] = ~keep_extended_classification_mask[6];
            drop_extended_classification_mask[7] = ~keep_extended_classification_mask[7];
        }
        if (LASfilter.asBoolean(drop_extended_classification_mask[0]) || LASfilter.asBoolean(drop_extended_classification_mask[1]) || LASfilter.asBoolean(drop_extended_classification_mask[2]) || LASfilter.asBoolean(drop_extended_classification_mask[3]) || LASfilter.asBoolean(drop_extended_classification_mask[4]) || LASfilter.asBoolean(drop_extended_classification_mask[5]) || LASfilter.asBoolean(drop_extended_classification_mask[6]) || LASfilter.asBoolean(drop_extended_classification_mask[7])) {
            this.add_criterion(new LAScriterionDropExtendedClassifications(drop_extended_classification_mask));
        }
        return Boolean.TRUE;
    }

    public boolean parse(String string) {
        String[] argv = string.split(" ");
        return this.parse(argv.length, argv);
    }

    int unparse(StringBuilder string) {
        int n = 0;
        for (int i = 0; i < this.num_criteria; ++i) {
            n += this.criteria[i].get_command(string);
        }
        return n;
    }

    void addClipCircle(double x, double y, double radius) {
        this.add_criterion(new LAScriterionKeepCircle(x, y, radius));
    }

    void addClipBox(double min_x, double min_y, double min_z, double max_x, double max_y, double max_z) {
        this.add_criterion(new LAScriterionKeepxyz(min_x, min_y, min_z, max_x, max_y, max_z));
    }

    void addKeepScanDirectionChange() {
        this.add_criterion(new LAScriterionKeepScanDirectionChange());
    }

    public boolean filter(LASpoint point) {
        for (int i = 0; i < this.num_criteria; ++i) {
            if (!this.criteria[i].filter(point)) continue;
            int n = i;
            this.counters[n] = this.counters[n] + 1;
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    void reset() {
        for (int i = 0; i < this.num_criteria; ++i) {
            this.criteria[i].reset();
        }
    }

    LASfilter() {
    }

    void add_criterion(LAScriterion filter_criterion) {
        if (this.num_criteria == this.alloc_criteria) {
            this.alloc_criteria += 16;
            LAScriterion[] temp_criteria = new LAScriterion[this.alloc_criteria];
            int[] temp_counters = new int[this.alloc_criteria];
            if (this.criteria != null) {
                for (int i = 0; i < this.num_criteria; ++i) {
                    temp_criteria[i] = this.criteria[i];
                    temp_counters[i] = this.counters[i];
                }
            }
            this.criteria = temp_criteria;
            this.counters = temp_counters;
        }
        this.criteria[this.num_criteria] = filter_criterion;
        this.counters[this.num_criteria] = 0;
        ++this.num_criteria;
    }

    private static boolean asBoolean(int i) {
        return i != 0;
    }

    private static char asChar(String s) {
        if (s != null && !s.isEmpty()) {
            return s.charAt(0);
        }
        return '\u0000';
    }

    public boolean active() {
        return this.num_criteria != 0;
    }
}

