/*
 * Decompiled with CFR 0.152.
 */
package com.github.mreutegg.laszip4j.laslib;

import com.github.mreutegg.laszip4j.laslib.LASheader;
import com.github.mreutegg.laszip4j.laszip.LASpoint;

public class LASinventory {
    private boolean first;
    public long extended_number_of_point_records = 0L;
    public long[] extended_number_of_points_by_return = new long[16];
    public int max_X;
    public int min_X;
    public int max_Y;
    public int min_Y;
    public int max_Z;
    public int min_Z;

    public boolean active() {
        return this.first == Boolean.FALSE;
    }

    LASinventory() {
        for (int i = 0; i < 16; ++i) {
            this.extended_number_of_points_by_return[i] = 0L;
        }
        this.min_X = 0;
        this.max_X = 0;
        this.min_Y = 0;
        this.max_Y = 0;
        this.min_Z = 0;
        this.max_Z = 0;
        this.first = Boolean.TRUE;
    }

    boolean init(LASheader header) {
        if (header != null) {
            int i;
            this.extended_number_of_point_records = header.number_of_point_records != 0 ? (long)header.number_of_point_records : header.extended_number_of_point_records;
            for (i = 0; i < 5; ++i) {
                this.extended_number_of_points_by_return[i] = header.number_of_points_by_return[i] != 0 ? (long)header.number_of_points_by_return[i] : header.extended_number_of_points_by_return[i];
            }
            for (i = 5; i < 16; ++i) {
                this.extended_number_of_points_by_return[i] = header.extended_number_of_points_by_return[i];
            }
            this.max_X = header.get_X(header.max_x);
            this.min_X = header.get_X(header.min_x);
            this.max_Y = header.get_Y(header.max_y);
            this.min_Y = header.get_Y(header.min_y);
            this.max_Z = header.get_Z(header.max_z);
            this.min_Z = header.get_Z(header.min_z);
            this.first = Boolean.FALSE;
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    boolean add(LASpoint point) {
        ++this.extended_number_of_point_records;
        if (point.getExtended_point_type() != 0) {
            byte by = point.getExtended_return_number();
            this.extended_number_of_points_by_return[by] = this.extended_number_of_points_by_return[by] + 1L;
        } else {
            byte by = point.getReturn_number();
            this.extended_number_of_points_by_return[by] = this.extended_number_of_points_by_return[by] + 1L;
        }
        if (this.first) {
            this.min_X = this.max_X = point.get_X();
            this.min_Y = this.max_Y = point.get_Y();
            this.min_Z = this.max_Z = point.get_Z();
            this.first = Boolean.FALSE;
        } else {
            if (point.get_X() < this.min_X) {
                this.min_X = point.get_X();
            } else if (point.get_X() > this.max_X) {
                this.max_X = point.get_X();
            }
            if (point.get_Y() < this.min_Y) {
                this.min_Y = point.get_Y();
            } else if (point.get_Y() > this.max_Y) {
                this.max_Y = point.get_Y();
            }
            if (point.get_Z() < this.min_Z) {
                this.min_Z = point.get_Z();
            } else if (point.get_Z() > this.max_Z) {
                this.max_Z = point.get_Z();
            }
        }
        return Boolean.TRUE;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    boolean update_header(LASheader header) {
        int i;
        if (header == null) return Boolean.FALSE;
        if (this.extended_number_of_point_records > Integer.toUnsignedLong(-1)) {
            if (header.version_minor < 4) return Boolean.FALSE;
            header.number_of_point_records = 0;
        } else {
            header.number_of_point_records = (int)this.extended_number_of_point_records;
        }
        for (i = 0; i < 5; ++i) {
            if (this.extended_number_of_points_by_return[i + 1] > Integer.toUnsignedLong(-1)) {
                if (header.version_minor < 4) return Boolean.FALSE;
                header.number_of_points_by_return[i] = 0;
                continue;
            }
            header.number_of_points_by_return[i] = (int)this.extended_number_of_points_by_return[i + 1];
        }
        header.max_x = header.get_x(this.max_X);
        header.min_x = header.get_x(this.min_X);
        header.max_y = header.get_y(this.max_Y);
        header.min_y = header.get_y(this.min_Y);
        header.max_z = header.get_z(this.max_Z);
        header.min_z = header.get_z(this.min_Z);
        header.extended_number_of_point_records = this.extended_number_of_point_records;
        for (i = 0; i < 15; ++i) {
            header.extended_number_of_points_by_return[i] = this.extended_number_of_points_by_return[i + 1];
        }
        return Boolean.TRUE;
    }
}

