/*
 * Decompiled with CFR 0.152.
 */
package com.github.mreutegg.laszip4j.laslib;

import com.github.mreutegg.laszip4j.clib.Cstdio;
import com.github.mreutegg.laszip4j.clib.Cstring;
import com.github.mreutegg.laszip4j.laslib.LASevlr;
import com.github.mreutegg.laszip4j.laslib.LASheader;
import com.github.mreutegg.laszip4j.laslib.LASreader;
import com.github.mreutegg.laszip4j.laslib.LASvlr;
import com.github.mreutegg.laszip4j.laslib.LASvlr_classification;
import com.github.mreutegg.laszip4j.laslib.LASvlr_geo_keys;
import com.github.mreutegg.laszip4j.laslib.LASvlr_key_entry;
import com.github.mreutegg.laszip4j.laslib.LASvlr_lasoriginal;
import com.github.mreutegg.laszip4j.laslib.LASvlr_lastiling;
import com.github.mreutegg.laszip4j.laslib.LASvlr_wave_packet_descr;
import com.github.mreutegg.laszip4j.laszip.ByteStreamIn;
import com.github.mreutegg.laszip4j.laszip.ByteStreamInFile;
import com.github.mreutegg.laszip4j.laszip.ByteStreamInStream;
import com.github.mreutegg.laszip4j.laszip.LASattribute;
import com.github.mreutegg.laszip4j.laszip.LASattributer;
import com.github.mreutegg.laszip4j.laszip.LASindex;
import com.github.mreutegg.laszip4j.laszip.LASitem;
import com.github.mreutegg.laszip4j.laszip.LASquantizer;
import com.github.mreutegg.laszip4j.laszip.LASreadPoint;
import com.github.mreutegg.laszip4j.laszip.LASzip;
import com.github.mreutegg.laszip4j.laszip.MyDefs;
import java.io.InputStream;
import java.io.PrintStream;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public class LASreaderLAS
extends LASreader {
    private static final PrintStream stderr = System.err;
    private RandomAccessFile file = null;
    private ByteStreamIn stream = null;
    private LASreadPoint reader = null;
    private boolean checked_end;

    public boolean open(String file_name, int io_ibuffer_size) {
        return this.open(file_name, io_ibuffer_size, false);
    }

    boolean open(String file_name, int io_buffer_size, boolean peek_only) {
        if (file_name == null) {
            Cstdio.fprintf(stderr, "ERROR: fine name pointer is zero\n", new Object[0]);
            return Boolean.FALSE;
        }
        this.file = Cstdio.fopenRAF(file_name.toCharArray(), "rb");
        if (this.file == null) {
            Cstdio.fprintf(stderr, "ERROR: cannot open file '%s'\n", file_name);
            return Boolean.FALSE;
        }
        ByteStreamInFile in = new ByteStreamInFile(this.file);
        return this.open(in, peek_only);
    }

    boolean open(RandomAccessFile file, boolean peek_only) {
        if (file == null) {
            Cstdio.fprintf(stderr, "ERROR: file pointer is zero\n", new Object[0]);
            return Boolean.FALSE;
        }
        ByteStreamInFile in = new ByteStreamInFile(file);
        return this.open(in);
    }

    public boolean open(InputStream in) {
        return this.open(in, false);
    }

    boolean open(InputStream stream, boolean peek_only) {
        ByteStreamInStream in = new ByteStreamInStream(stream);
        return this.open(in, peek_only);
    }

    boolean open(ByteStreamIn stream) {
        return this.open(stream, false);
    }

    /*
     * Unable to fully structure code
     */
    boolean open(ByteStreamIn stream, boolean peek_only) {
        block285: {
            block286: {
                block284: {
                    if (stream == null) {
                        Cstdio.fprintf(LASreaderLAS.stderr, "ERROR: ByteStreamIn* pointer is zero\n", new Object[0]);
                        return Boolean.FALSE;
                    }
                    this.stream = stream;
                    this.header.clean();
                    try {
                        stream.getBytes(this.header.file_signature, 4);
                    }
                    catch (Exception e) {
                        Cstdio.fprintf(LASreaderLAS.stderr, "ERROR: reading header.file_signature\n", new Object[0]);
                        return Boolean.FALSE;
                    }
                    try {
                        this.header.file_source_ID = stream.get16bitsLE();
                    }
                    catch (Exception e) {
                        Cstdio.fprintf(LASreaderLAS.stderr, "ERROR: reading header.file_source_ID\n", new Object[0]);
                        return Boolean.FALSE;
                    }
                    try {
                        this.header.global_encoding = stream.get16bitsLE();
                    }
                    catch (Exception e) {
                        Cstdio.fprintf(LASreaderLAS.stderr, "ERROR: reading header.global_encoding\n", new Object[0]);
                        return Boolean.FALSE;
                    }
                    try {
                        this.header.project_ID_GUID_data_1 = stream.get32bitsLE();
                    }
                    catch (Exception e) {
                        Cstdio.fprintf(LASreaderLAS.stderr, "ERROR: reading header.project_ID_GUID_data_1\n", new Object[0]);
                        return Boolean.FALSE;
                    }
                    try {
                        this.header.project_ID_GUID_data_2 = stream.get16bitsLE();
                    }
                    catch (Exception e) {
                        Cstdio.fprintf(LASreaderLAS.stderr, "ERROR: reading header.project_ID_GUID_data_2\n", new Object[0]);
                        return Boolean.FALSE;
                    }
                    try {
                        this.header.project_ID_GUID_data_3 = stream.get16bitsLE();
                    }
                    catch (Exception e) {
                        Cstdio.fprintf(LASreaderLAS.stderr, "ERROR: reading header.project_ID_GUID_data_3\n", new Object[0]);
                        return Boolean.FALSE;
                    }
                    try {
                        stream.getBytes(this.header.project_ID_GUID_data_4, 8);
                    }
                    catch (Exception e) {
                        Cstdio.fprintf(LASreaderLAS.stderr, "ERROR: reading header.project_ID_GUID_data_4\n", new Object[0]);
                        return Boolean.FALSE;
                    }
                    try {
                        this.header.version_major = stream.getByte();
                    }
                    catch (Exception e) {
                        Cstdio.fprintf(LASreaderLAS.stderr, "ERROR: reading header.version_major\n", new Object[0]);
                        return Boolean.FALSE;
                    }
                    try {
                        this.header.version_minor = stream.getByte();
                    }
                    catch (Exception e) {
                        Cstdio.fprintf(LASreaderLAS.stderr, "ERROR: reading header.version_minor\n", new Object[0]);
                        return Boolean.FALSE;
                    }
                    try {
                        stream.getBytes(this.header.system_identifier, 32);
                    }
                    catch (Exception e) {
                        Cstdio.fprintf(LASreaderLAS.stderr, "ERROR: reading header.system_identifier\n", new Object[0]);
                        return Boolean.FALSE;
                    }
                    try {
                        stream.getBytes(this.header.generating_software, 32);
                    }
                    catch (Exception e) {
                        Cstdio.fprintf(LASreaderLAS.stderr, "ERROR: reading header.generating_software\n", new Object[0]);
                        return Boolean.FALSE;
                    }
                    try {
                        this.header.file_creation_day = stream.get16bitsLE();
                    }
                    catch (Exception e) {
                        Cstdio.fprintf(LASreaderLAS.stderr, "ERROR: reading header.file_creation_day\n", new Object[0]);
                        return Boolean.FALSE;
                    }
                    try {
                        this.header.file_creation_year = stream.get16bitsLE();
                    }
                    catch (Exception e) {
                        Cstdio.fprintf(LASreaderLAS.stderr, "ERROR: reading header.file_creation_year\n", new Object[0]);
                        return Boolean.FALSE;
                    }
                    try {
                        this.header.header_size = stream.get16bitsLE();
                    }
                    catch (Exception e) {
                        Cstdio.fprintf(LASreaderLAS.stderr, "ERROR: reading header.header_size\n", new Object[0]);
                        return Boolean.FALSE;
                    }
                    try {
                        this.header.offset_to_point_data = stream.get32bitsLE();
                    }
                    catch (Exception e) {
                        Cstdio.fprintf(LASreaderLAS.stderr, "ERROR: reading header.offset_to_point_data\n", new Object[0]);
                        return Boolean.FALSE;
                    }
                    try {
                        this.header.number_of_variable_length_records = stream.get32bitsLE();
                    }
                    catch (Exception e) {
                        Cstdio.fprintf(LASreaderLAS.stderr, "ERROR: reading header.number_of_variable_length_records\n", new Object[0]);
                        return Boolean.FALSE;
                    }
                    try {
                        this.header.point_data_format = stream.getByte();
                    }
                    catch (Exception e) {
                        Cstdio.fprintf(LASreaderLAS.stderr, "ERROR: reading header.point_data_format\n", new Object[0]);
                        return Boolean.FALSE;
                    }
                    try {
                        this.header.point_data_record_length = stream.get16bitsLE();
                    }
                    catch (Exception e) {
                        Cstdio.fprintf(LASreaderLAS.stderr, "ERROR: reading header.point_data_record_length\n", new Object[0]);
                        return Boolean.FALSE;
                    }
                    try {
                        this.header.number_of_point_records = stream.get32bitsLE();
                    }
                    catch (Exception e) {
                        Cstdio.fprintf(LASreaderLAS.stderr, "ERROR: reading header.number_of_point_records\n", new Object[0]);
                        return Boolean.FALSE;
                    }
                    for (i = 0; i < 5; ++i) {
                        try {
                            this.header.number_of_points_by_return[i] = stream.get32bitsLE();
                            continue;
                        }
                        catch (Exception e) {
                            Cstdio.fprintf(LASreaderLAS.stderr, "ERROR: reading header.number_of_points_by_return %d\n", new Object[]{i});
                            return Boolean.FALSE;
                        }
                    }
                    try {
                        this.header.x_scale_factor = Double.longBitsToDouble(stream.get64bitsLE());
                    }
                    catch (Exception e) {
                        Cstdio.fprintf(LASreaderLAS.stderr, "ERROR: reading header.x_scale_factor\n", new Object[0]);
                        return Boolean.FALSE;
                    }
                    try {
                        this.header.y_scale_factor = Double.longBitsToDouble(stream.get64bitsLE());
                    }
                    catch (Exception e) {
                        Cstdio.fprintf(LASreaderLAS.stderr, "ERROR: reading header.y_scale_factor\n", new Object[0]);
                        return Boolean.FALSE;
                    }
                    try {
                        this.header.z_scale_factor = Double.longBitsToDouble(stream.get64bitsLE());
                    }
                    catch (Exception e) {
                        Cstdio.fprintf(LASreaderLAS.stderr, "ERROR: reading header.z_scale_factor\n", new Object[0]);
                        return Boolean.FALSE;
                    }
                    try {
                        this.header.x_offset = Double.longBitsToDouble(stream.get64bitsLE());
                    }
                    catch (Exception e) {
                        Cstdio.fprintf(LASreaderLAS.stderr, "ERROR: reading header.x_offset\n", new Object[0]);
                        return Boolean.FALSE;
                    }
                    try {
                        this.header.y_offset = Double.longBitsToDouble(stream.get64bitsLE());
                    }
                    catch (Exception e) {
                        Cstdio.fprintf(LASreaderLAS.stderr, "ERROR: reading header.y_offset\n", new Object[0]);
                        return Boolean.FALSE;
                    }
                    try {
                        this.header.z_offset = Double.longBitsToDouble(stream.get64bitsLE());
                    }
                    catch (Exception e) {
                        Cstdio.fprintf(LASreaderLAS.stderr, "ERROR: reading header.z_offset\n", new Object[0]);
                        return Boolean.FALSE;
                    }
                    try {
                        this.header.max_x = Double.longBitsToDouble(stream.get64bitsLE());
                    }
                    catch (Exception e) {
                        Cstdio.fprintf(LASreaderLAS.stderr, "ERROR: reading header.max_x\n", new Object[0]);
                        return Boolean.FALSE;
                    }
                    try {
                        this.header.min_x = Double.longBitsToDouble(stream.get64bitsLE());
                    }
                    catch (Exception e) {
                        Cstdio.fprintf(LASreaderLAS.stderr, "ERROR: reading header.min_x\n", new Object[0]);
                        return Boolean.FALSE;
                    }
                    try {
                        this.header.max_y = Double.longBitsToDouble(stream.get64bitsLE());
                    }
                    catch (Exception e) {
                        Cstdio.fprintf(LASreaderLAS.stderr, "ERROR: reading header.max_y\n", new Object[0]);
                        return Boolean.FALSE;
                    }
                    try {
                        this.header.min_y = Double.longBitsToDouble(stream.get64bitsLE());
                    }
                    catch (Exception e) {
                        Cstdio.fprintf(LASreaderLAS.stderr, "ERROR: reading header.min_y\n", new Object[0]);
                        return Boolean.FALSE;
                    }
                    try {
                        this.header.max_z = Double.longBitsToDouble(stream.get64bitsLE());
                    }
                    catch (Exception e) {
                        Cstdio.fprintf(LASreaderLAS.stderr, "ERROR: reading header.max_z\n", new Object[0]);
                        return Boolean.FALSE;
                    }
                    try {
                        this.header.min_z = Double.longBitsToDouble(stream.get64bitsLE());
                    }
                    catch (Exception e) {
                        Cstdio.fprintf(LASreaderLAS.stderr, "ERROR: reading header.min_z\n", new Object[0]);
                        return Boolean.FALSE;
                    }
                    if (!this.header.check()) {
                        return Boolean.FALSE;
                    }
                    if (this.header.version_major == 1 && this.header.version_minor >= 3) {
                        if (this.header.header_size < '\u00eb') {
                            Cstdio.fprintf(LASreaderLAS.stderr, "WARNING: for LAS 1.%d header_size should at least be 235 but it is only %d\n", new Object[]{this.header.version_minor, Character.valueOf(this.header.header_size)});
                            this.header.user_data_in_header_size = this.header.header_size - 227;
                        } else {
                            try {
                                this.header.start_of_waveform_data_packet_record = stream.get64bitsLE();
                            }
                            catch (Exception e) {
                                Cstdio.fprintf(LASreaderLAS.stderr, "ERROR: reading header.start_of_waveform_data_packet_record\n", new Object[0]);
                                return Boolean.FALSE;
                            }
                            this.header.user_data_in_header_size = this.header.header_size - 235;
                        }
                    } else {
                        this.header.user_data_in_header_size = this.header.header_size - 227;
                    }
                    if (this.header.version_major == 1 && this.header.version_minor >= 4) {
                        if (this.header.header_size < '\u0177') {
                            Cstdio.fprintf(LASreaderLAS.stderr, "ERROR: for LAS 1.%d header_size should at least be 375 but it is only %d\n", new Object[]{this.header.version_minor, Character.valueOf(this.header.header_size)});
                            return Boolean.FALSE;
                        }
                        try {
                            this.header.start_of_first_extended_variable_length_record = stream.get64bitsLE();
                        }
                        catch (Exception e) {
                            Cstdio.fprintf(LASreaderLAS.stderr, "ERROR: reading header.start_of_first_extended_variable_length_record\n", new Object[0]);
                            return Boolean.FALSE;
                        }
                        try {
                            this.header.number_of_extended_variable_length_records = stream.get32bitsLE();
                        }
                        catch (Exception e) {
                            Cstdio.fprintf(LASreaderLAS.stderr, "ERROR: reading header.number_of_extended_variable_length_records\n", new Object[0]);
                            return Boolean.FALSE;
                        }
                        try {
                            this.header.extended_number_of_point_records = stream.get64bitsLE();
                        }
                        catch (Exception e) {
                            Cstdio.fprintf(LASreaderLAS.stderr, "ERROR: reading header.extended_number_of_point_records\n", new Object[0]);
                            return Boolean.FALSE;
                        }
                        for (i = 0; i < 15; ++i) {
                            try {
                                this.header.extended_number_of_points_by_return[i] = stream.get64bitsLE();
                                continue;
                            }
                            catch (Exception e) {
                                Cstdio.fprintf(LASreaderLAS.stderr, "ERROR: reading header.extended_number_of_points_by_return[%d]\n", new Object[]{i});
                                return Boolean.FALSE;
                            }
                        }
                        this.header.user_data_in_header_size = this.header.header_size - 375;
                    }
                    if (this.header.user_data_in_header_size != 0) {
                        this.header.user_data_in_header = new byte[this.header.user_data_in_header_size];
                        try {
                            stream.getBytes(this.header.user_data_in_header, this.header.user_data_in_header_size);
                        }
                        catch (Exception e) {
                            Cstdio.fprintf(LASreaderLAS.stderr, "ERROR: reading %d bytes of data into header.user_data_in_header\n", new Object[]{this.header.user_data_in_header_size});
                            return Boolean.FALSE;
                        }
                    }
                    this.npoints = this.header.number_of_point_records != 0 ? (long)this.header.number_of_point_records : this.header.extended_number_of_point_records;
                    this.p_count = 0L;
                    if (peek_only) {
                        this.header.point_data_format = (byte)(this.header.point_data_format & 127);
                        return Boolean.TRUE;
                    }
                    vlrs_size = 0;
                    if (this.header.number_of_variable_length_records == 0) break block284;
                    this.header.vlrs = new LASvlr[this.header.number_of_variable_length_records];
                    for (i = 0; i < this.header.number_of_variable_length_records; ++i) {
                        this.header.vlrs[i] = new LASvlr();
                        if (this.header.offset_to_point_data - vlrs_size - this.header.header_size < 54) {
                            Cstdio.fprintf(LASreaderLAS.stderr, "WARNING: only %d bytes until point block after reading %d of %d vlrs. skipping remaining vlrs ...\n", new Object[]{this.header.offset_to_point_data - vlrs_size - this.header.header_size, i, this.header.number_of_variable_length_records});
                            this.header.number_of_variable_length_records = i;
                            break;
                        }
                        try {
                            this.header.vlrs[i].reserved = stream.get16bitsLE();
                        }
                        catch (Exception e) {
                            Cstdio.fprintf(LASreaderLAS.stderr, "ERROR: reading header.vlrs[%d].reserved\n", new Object[]{i});
                            return Boolean.FALSE;
                        }
                        try {
                            stream.getBytes(this.header.vlrs[i].user_id, 16);
                        }
                        catch (Exception e) {
                            Cstdio.fprintf(LASreaderLAS.stderr, "ERROR: reading header.vlrs[%d].user_id\n", new Object[]{i});
                            return Boolean.FALSE;
                        }
                        try {
                            this.header.vlrs[i].record_id = stream.get16bitsLE();
                        }
                        catch (Exception e) {
                            Cstdio.fprintf(LASreaderLAS.stderr, "ERROR: reading header.vlrs[%d].record_id\n", new Object[]{i});
                            return Boolean.FALSE;
                        }
                        try {
                            this.header.vlrs[i].record_length_after_header = stream.get16bitsLE();
                        }
                        catch (Exception e) {
                            Cstdio.fprintf(LASreaderLAS.stderr, "ERROR: reading header.vlrs[%d].record_length_after_header\n", new Object[]{i});
                            return Boolean.FALSE;
                        }
                        try {
                            stream.getBytes(this.header.vlrs[i].description, 32);
                        }
                        catch (Exception e) {
                            Cstdio.fprintf(LASreaderLAS.stderr, "ERROR: reading header.vlrs[%d].description\n", new Object[]{i});
                            return Boolean.FALSE;
                        }
                        if (this.header.offset_to_point_data - (vlrs_size += 54) - this.header.header_size < this.header.vlrs[i].record_length_after_header) {
                            Cstdio.fprintf(LASreaderLAS.stderr, "WARNING: only %d bytes until point block when trying to read %d bytes into header.vlrs[%d].data\n", new Object[]{this.header.offset_to_point_data - vlrs_size - this.header.header_size, Character.valueOf(this.header.vlrs[i].record_length_after_header), i});
                            this.header.vlrs[i].record_length_after_header = (char)(this.header.offset_to_point_data - vlrs_size - this.header.header_size);
                        }
                        if (this.header.vlrs[i].record_length_after_header == '\u0000') ** GOTO lbl502
                        if (Cstring.strcmp(this.header.vlrs[i].user_id, "laszip encoded") == 0) {
                            this.header.laszip = new LASzip();
                            try {
                                this.header.laszip.compressor = stream.get16bitsLE();
                            }
                            catch (Exception e) {
                                Cstdio.fprintf(LASreaderLAS.stderr, "ERROR: reading compressor %d\n", new Object[]{Character.valueOf(this.header.laszip.compressor)});
                                return Boolean.FALSE;
                            }
                            try {
                                this.header.laszip.coder = stream.get16bitsLE();
                            }
                            catch (Exception e) {
                                Cstdio.fprintf(LASreaderLAS.stderr, "ERROR: reading coder %d\n", new Object[]{Character.valueOf(this.header.laszip.coder)});
                                return Boolean.FALSE;
                            }
                            try {
                                this.header.laszip.version_major = stream.getByte();
                            }
                            catch (Exception e) {
                                Cstdio.fprintf(LASreaderLAS.stderr, "ERROR: reading version_major %d\n", new Object[]{this.header.laszip.version_major});
                                return Boolean.FALSE;
                            }
                            try {
                                this.header.laszip.version_minor = stream.getByte();
                            }
                            catch (Exception e) {
                                Cstdio.fprintf(LASreaderLAS.stderr, "ERROR: reading version_minor %d\n", new Object[]{this.header.laszip.version_minor});
                                return Boolean.FALSE;
                            }
                            try {
                                this.header.laszip.version_revision = stream.get16bitsLE();
                            }
                            catch (Exception e) {
                                Cstdio.fprintf(LASreaderLAS.stderr, "ERROR: reading version_revision %d\n", new Object[]{Character.valueOf(this.header.laszip.version_revision)});
                                return Boolean.FALSE;
                            }
                            try {
                                this.header.laszip.options = stream.get32bitsLE();
                            }
                            catch (Exception e) {
                                Cstdio.fprintf(LASreaderLAS.stderr, "ERROR: reading options %d\n", new Object[]{this.header.laszip.options});
                                return Boolean.FALSE;
                            }
                            try {
                                this.header.laszip.chunk_size = stream.get32bitsLE();
                            }
                            catch (Exception e) {
                                Cstdio.fprintf(LASreaderLAS.stderr, "ERROR: reading chunk_size %d\n", new Object[]{this.header.laszip.chunk_size});
                                return Boolean.FALSE;
                            }
                            try {
                                this.header.laszip.number_of_special_evlrs = stream.get64bitsLE();
                            }
                            catch (Exception e) {
                                Cstdio.fprintf(LASreaderLAS.stderr, "ERROR: reading number_of_special_evlrs %d\n", new Object[]{this.header.laszip.number_of_special_evlrs});
                                return Boolean.FALSE;
                            }
                            try {
                                this.header.laszip.offset_to_special_evlrs = stream.get64bitsLE();
                            }
                            catch (Exception e) {
                                Cstdio.fprintf(LASreaderLAS.stderr, "ERROR: reading offset_to_special_evlrs %d\n", new Object[]{this.header.laszip.offset_to_special_evlrs});
                                return Boolean.FALSE;
                            }
                            try {
                                this.header.laszip.num_items = stream.get16bitsLE();
                            }
                            catch (Exception e) {
                                Cstdio.fprintf(LASreaderLAS.stderr, "ERROR: reading num_items %d\n", new Object[]{Character.valueOf(this.header.laszip.num_items)});
                                return Boolean.FALSE;
                            }
                            this.header.laszip.items = new LASitem[this.header.laszip.num_items];
                            for (j = 0; j < this.header.laszip.num_items; ++j) {
                                this.header.laszip.items[j] = new LASitem();
                                type = '\u0000';
                                size = '\u0000';
                                version = '\u0000';
                                try {
                                    type = stream.get16bitsLE();
                                }
                                catch (Exception e) {
                                    Cstdio.fprintf(LASreaderLAS.stderr, "ERROR: reading type %d of item %d\n", new Object[]{Character.valueOf(type), j});
                                    return Boolean.FALSE;
                                }
                                try {
                                    size = stream.get16bitsLE();
                                }
                                catch (Exception e) {
                                    Cstdio.fprintf(LASreaderLAS.stderr, "ERROR: reading size %d of item %d\n", new Object[]{Character.valueOf(size), j});
                                    return Boolean.FALSE;
                                }
                                try {
                                    version = stream.get16bitsLE();
                                }
                                catch (Exception e) {
                                    Cstdio.fprintf(LASreaderLAS.stderr, "ERROR: reading version %d of item %d\n", new Object[]{Character.valueOf(version), j});
                                    return Boolean.FALSE;
                                }
                                this.header.laszip.items[j].type = LASitem.Type.fromOrdinal(type);
                                this.header.laszip.items[j].size = size;
                                this.header.laszip.items[j].version = version;
                            }
                        } else {
                            if (Cstring.strcmp(this.header.vlrs[i].user_id, "LAStools") == 0 && this.header.vlrs[i].record_id == '\n' || Cstring.strcmp(this.header.vlrs[i].user_id, "lastools tile") == 0) {
                                this.header.clean_lastiling();
                                this.header.vlr_lastiling = new LASvlr_lastiling();
                                if (this.header.vlrs[i].record_length_after_header == '\u001c') {
                                    try {
                                        this.header.vlr_lastiling.level = stream.get32bitsLE();
                                    }
                                    catch (Exception e) {
                                        Cstdio.fprintf(LASreaderLAS.stderr, "ERROR: reading vlr_lastiling.level %d\n", new Object[]{this.header.vlr_lastiling.level});
                                        return Boolean.FALSE;
                                    }
                                    try {
                                        this.header.vlr_lastiling.level_index = stream.get32bitsLE();
                                    }
                                    catch (Exception e) {
                                        Cstdio.fprintf(LASreaderLAS.stderr, "ERROR: reading vlr_lastiling.level_index %d\n", new Object[]{this.header.vlr_lastiling.level_index});
                                        return Boolean.FALSE;
                                    }
                                    try {
                                        this.header.vlr_lastiling.implicit_levels = stream.get32bitsLE();
                                    }
                                    catch (Exception e) {
                                        Cstdio.fprintf(LASreaderLAS.stderr, "ERROR: reading vlr_lastiling.implicit_levels %d\n", new Object[]{this.header.vlr_lastiling.implicit_levels});
                                        return Boolean.FALSE;
                                    }
                                    try {
                                        this.header.vlr_lastiling.min_x = stream.get32bitsLE();
                                    }
                                    catch (Exception e) {
                                        Cstdio.fprintf(LASreaderLAS.stderr, "ERROR: reading vlr_lastiling.min_x %g\n", new Object[]{Float.valueOf(this.header.vlr_lastiling.min_x)});
                                        return Boolean.FALSE;
                                    }
                                    try {
                                        this.header.vlr_lastiling.max_x = stream.get32bitsLE();
                                    }
                                    catch (Exception e) {
                                        Cstdio.fprintf(LASreaderLAS.stderr, "ERROR: reading vlr_lastiling.max_x %g\n", new Object[]{Float.valueOf(this.header.vlr_lastiling.max_x)});
                                        return Boolean.FALSE;
                                    }
                                    try {
                                        this.header.vlr_lastiling.min_y = stream.get32bitsLE();
                                    }
                                    catch (Exception e) {
                                        Cstdio.fprintf(LASreaderLAS.stderr, "ERROR: reading vlr_lastiling.min_y %g\n", new Object[]{Float.valueOf(this.header.vlr_lastiling.min_y)});
                                        return Boolean.FALSE;
                                    }
                                    try {
                                        this.header.vlr_lastiling.max_y = stream.get32bitsLE();
                                    }
                                    catch (Exception e) {
                                        Cstdio.fprintf(LASreaderLAS.stderr, "ERROR: reading vlr_lastiling.max_y %g\n", new Object[]{Float.valueOf(this.header.vlr_lastiling.max_y)});
                                        return Boolean.FALSE;
                                    }
                                }
                                Cstdio.fprintf(LASreaderLAS.stderr, "ERROR: record_length_after_header of VLR %s (%d) is %d instead of 28\n", new Object[]{this.header.vlrs[i].user_id, Character.valueOf(this.header.vlrs[i].record_id), Character.valueOf(this.header.vlrs[i].record_length_after_header)});
                                return Boolean.FALSE;
                            }
                            if (Cstring.strcmp(this.header.vlrs[i].user_id, "LAStools") == 0 && this.header.vlrs[i].record_id == '\u0014') {
                                this.header.clean_lasoriginal();
                                this.header.vlr_lasoriginal = new LASvlr_lasoriginal();
                                if (this.header.vlrs[i].record_length_after_header == '\u00b0') {
                                    try {
                                        this.header.vlr_lasoriginal.number_of_point_records = stream.get64bitsLE();
                                    }
                                    catch (Exception e) {
                                        Cstdio.fprintf(LASreaderLAS.stderr, "ERROR: reading vlr_lasoriginal.number_of_point_records %d\n", new Object[]{this.header.vlr_lasoriginal.number_of_point_records});
                                        return Boolean.FALSE;
                                    }
                                    for (j = 0; j < 15; ++j) {
                                        try {
                                            this.header.vlr_lasoriginal.number_of_points_by_return[j] = stream.get64bitsLE();
                                            continue;
                                        }
                                        catch (Exception e) {
                                            Cstdio.fprintf(LASreaderLAS.stderr, "ERROR: reading vlr_lasoriginal.number_of_points_by_return[%d] %d\n", new Object[]{j, this.header.vlr_lasoriginal.number_of_points_by_return[j]});
                                            return Boolean.FALSE;
                                        }
                                    }
                                    try {
                                        this.header.vlr_lasoriginal.min_x = Double.longBitsToDouble(stream.get64bitsLE());
                                    }
                                    catch (Exception e) {
                                        Cstdio.fprintf(LASreaderLAS.stderr, "ERROR: reading vlr_lasoriginal.min_x %g\n", new Object[]{this.header.vlr_lasoriginal.min_x});
                                        return Boolean.FALSE;
                                    }
                                    try {
                                        this.header.vlr_lasoriginal.max_x = Double.longBitsToDouble(stream.get64bitsLE());
                                    }
                                    catch (Exception e) {
                                        Cstdio.fprintf(LASreaderLAS.stderr, "ERROR: reading vlr_lasoriginal.max_x %g\n", new Object[]{this.header.vlr_lasoriginal.max_x});
                                        return Boolean.FALSE;
                                    }
                                    try {
                                        this.header.vlr_lasoriginal.min_y = Double.longBitsToDouble(stream.get64bitsLE());
                                    }
                                    catch (Exception e) {
                                        Cstdio.fprintf(LASreaderLAS.stderr, "ERROR: reading vlr_lasoriginal.min_y %g\n", new Object[]{this.header.vlr_lasoriginal.min_y});
                                        return Boolean.FALSE;
                                    }
                                    try {
                                        this.header.vlr_lasoriginal.max_y = Double.longBitsToDouble(stream.get64bitsLE());
                                    }
                                    catch (Exception e) {
                                        Cstdio.fprintf(LASreaderLAS.stderr, "ERROR: reading vlr_lasoriginal.max_y %g\n", new Object[]{this.header.vlr_lasoriginal.max_y});
                                        return Boolean.FALSE;
                                    }
                                    try {
                                        this.header.vlr_lasoriginal.min_z = Double.longBitsToDouble(stream.get64bitsLE());
                                    }
                                    catch (Exception e) {
                                        Cstdio.fprintf(LASreaderLAS.stderr, "ERROR: reading vlr_lasoriginal.min_z %g\n", new Object[]{this.header.vlr_lasoriginal.min_z});
                                        return Boolean.FALSE;
                                    }
                                    try {
                                        this.header.vlr_lasoriginal.max_z = Double.longBitsToDouble(stream.get64bitsLE());
                                    }
                                    catch (Exception e) {
                                        Cstdio.fprintf(LASreaderLAS.stderr, "ERROR: reading vlr_lasoriginal.max_z %g\n", new Object[]{this.header.vlr_lasoriginal.max_z});
                                        return Boolean.FALSE;
                                    }
                                }
                                Cstdio.fprintf(LASreaderLAS.stderr, "ERROR: record_length_after_header of VLR %s (%d) is %d instead of 176\n", new Object[]{this.header.vlrs[i].user_id, Character.valueOf(this.header.vlrs[i].record_id), Character.valueOf(this.header.vlrs[i].record_length_after_header)});
                                return Boolean.FALSE;
                            }
                            this.header.vlrs[i].data = new byte[this.header.vlrs[i].record_length_after_header];
                            try {
                                stream.getBytes(this.header.vlrs[i].data, this.header.vlrs[i].record_length_after_header);
                            }
                            catch (Exception e) {
                                Cstdio.fprintf(LASreaderLAS.stderr, "ERROR: reading %d bytes of data into header.vlrs[%d].data\n", new Object[]{Character.valueOf(this.header.vlrs[i].record_length_after_header), i});
                                return Boolean.FALSE;
                            }
lbl502:
                            // 1 sources

                            this.header.vlrs[i].data = null;
                        }
                        vlrs_size += this.header.vlrs[i].record_length_after_header;
                        if (Cstring.strcmp(this.header.vlrs[i].user_id, "LASF_Projection") == 0) {
                            if (this.header.vlrs[i].data != null) {
                                if (this.header.vlrs[i].record_id == '\u87af') {
                                    if (this.header.vlr_geo_keys != null) {
                                        Cstdio.fprintf(LASreaderLAS.stderr, "WARNING: variable length records contain more than one GeoKeyDirectoryTag\n", new Object[0]);
                                    }
                                    this.header.vlr_geo_keys = LASvlr_geo_keys.fromByteArray(this.header.vlrs[i].data);
                                    if (this.header.vlr_geo_keys.key_directory_version != '\u0001') {
                                        Cstdio.fprintf(LASreaderLAS.stderr, "WARNING: wrong vlr_geo_keys.key_directory_version: %d != 1\n", new Object[]{Character.valueOf(this.header.vlr_geo_keys.key_directory_version)});
                                    }
                                    if (this.header.vlr_geo_keys.key_revision != '\u0001') {
                                        Cstdio.fprintf(LASreaderLAS.stderr, "WARNING: wrong vlr_geo_keys.key_revision: %d != 1\n", new Object[]{Character.valueOf(this.header.vlr_geo_keys.key_revision)});
                                    }
                                    if (this.header.vlr_geo_keys.minor_revision != '\u0000') {
                                        Cstdio.fprintf(LASreaderLAS.stderr, "WARNING: wrong vlr_geo_keys.minor_revision: %d != 0\n", new Object[]{Character.valueOf(this.header.vlr_geo_keys.minor_revision)});
                                    }
                                    buffer = ByteBuffer.wrap(this.header.vlrs[i].data).order(ByteOrder.LITTLE_ENDIAN);
                                    buffer.position(8);
                                    this.header.vlr_geo_key_entries = LASvlr_key_entry.fromByteBuffer(buffer);
                                    continue;
                                }
                                if (this.header.vlrs[i].record_id == '\u87b0') {
                                    if (this.header.vlr_geo_double_params != null) {
                                        Cstdio.fprintf(LASreaderLAS.stderr, "WARNING: variable length records contain more than one GeoF64ParamsTag\n", new Object[0]);
                                    }
                                    this.header.vlr_geo_double_params = LASheader.doublesFromByteArray(this.header.vlrs[i].data);
                                    continue;
                                }
                                if (this.header.vlrs[i].record_id == '\u87b1') {
                                    if (this.header.vlr_geo_ascii_params != null) {
                                        Cstdio.fprintf(LASreaderLAS.stderr, "WARNING: variable length records contain more than one GeoAsciiParamsTag\n", new Object[0]);
                                    }
                                    this.header.vlr_geo_ascii_params = MyDefs.stringFromByteArray(this.header.vlrs[i].data);
                                    continue;
                                }
                                if (this.header.vlrs[i].record_id == '\u083f' || this.header.vlrs[i].record_id == '\u0840') continue;
                                Cstdio.fprintf(LASreaderLAS.stderr, "WARNING: unknown LASF_Projection VLR with record_id %d.\n", new Object[]{Character.valueOf(this.header.vlrs[i].record_id)});
                                continue;
                            }
                            if (this.header.vlrs[i].record_id == '\u0840') continue;
                            Cstdio.fprintf(LASreaderLAS.stderr, "WARNING: no payload for LASF_Projection VLR with record_id %d.\n", new Object[]{Character.valueOf(this.header.vlrs[i].record_id)});
                            continue;
                        }
                        if (Cstring.strcmp(this.header.vlrs[i].user_id, "LASF_Spec") == 0) {
                            if (this.header.vlrs[i].data != null) {
                                if (this.header.vlrs[i].record_id == '\u0000') {
                                    if (this.header.vlr_classification != null) {
                                        Cstdio.fprintf(LASreaderLAS.stderr, "WARNING: variable length records contain more than one ClassificationLookup\n", new Object[0]);
                                    }
                                    this.header.vlr_classification = LASvlr_classification.fromByteArray(this.header.vlrs[i].data);
                                    continue;
                                }
                                if (this.header.vlrs[i].record_id == '\u0002' || this.header.vlrs[i].record_id == '\u0003') continue;
                                if (this.header.vlrs[i].record_id == '\u0004') {
                                    this.header.init_attributes(this.header.vlrs[i].record_length_after_header / MyDefs.sizeof(LASattribute.class), LASattribute.fromByteArray(this.header.vlrs[i].data));
                                    continue;
                                }
                                if (this.header.vlrs[i].record_id < 'd' || this.header.vlrs[i].record_id >= '\u0163') continue;
                                idx = this.header.vlrs[i].record_id - 99;
                                if (this.header.vlr_wave_packet_descr == null) {
                                    this.header.vlr_wave_packet_descr = new LASvlr_wave_packet_descr[256];
                                    for (j = 0; j < 256; ++j) {
                                        this.header.vlr_wave_packet_descr[j] = null;
                                    }
                                }
                                if (this.header.vlr_wave_packet_descr[idx] != null) {
                                    Cstdio.fprintf(LASreaderLAS.stderr, "WARNING: variable length records defines wave packet descr %d more than once\n", new Object[]{idx});
                                }
                                if (this.header.vlrs[i].record_length_after_header != '\u001a') {
                                    Cstdio.fprintf(LASreaderLAS.stderr, "WARNING: variable length record payload for wave packet descr %d is %d instead of 26 bytes\n", new Object[]{idx, (int)this.header.vlrs[i].record_length_after_header});
                                }
                                this.header.vlr_wave_packet_descr[idx] = LASvlr_wave_packet_descr.fromByteArray(this.header.vlrs[i].data);
                                if (this.header.vlr_wave_packet_descr[idx].getBitsPerSample() != 8 && this.header.vlr_wave_packet_descr[idx].getBitsPerSample() != 16) {
                                    Cstdio.fprintf(LASreaderLAS.stderr, "WARNING: bits per sample for wave packet descr %d is %d instead of 8 or 16\n", new Object[]{idx, (int)this.header.vlr_wave_packet_descr[idx].getBitsPerSample()});
                                }
                                if (this.header.vlr_wave_packet_descr[idx].getNumberOfSamples() == 0) {
                                    Cstdio.fprintf(LASreaderLAS.stderr, "WARNING: number of samples for wave packet descr %d is zero\n", new Object[]{idx});
                                }
                                if (this.header.vlr_wave_packet_descr[idx].getNumberOfSamples() > 8096) {
                                    Cstdio.fprintf(LASreaderLAS.stderr, "WARNING: number of samples of %d for wave packet descr %d is with unusually large\n", new Object[]{this.header.vlr_wave_packet_descr[idx].getNumberOfSamples(), idx});
                                }
                                if (this.header.vlr_wave_packet_descr[idx].getTemporalSpacing() != 0) continue;
                                Cstdio.fprintf(LASreaderLAS.stderr, "WARNING: temporal spacing for wave packet descr %d is zero\n", new Object[]{idx});
                                continue;
                            }
                            Cstdio.fprintf(LASreaderLAS.stderr, "WARNING: no payload for LASF_Spec (not specification-conform).\n", new Object[0]);
                            continue;
                        }
                        if (Cstring.strcmp(this.header.vlrs[i].user_id, "laszip encoded") != 0 && (Cstring.strcmp(this.header.vlrs[i].user_id, "LAStools") != 0 || this.header.vlrs[i].record_id >= '\u07d0') && Cstring.strcmp(this.header.vlrs[i].user_id, "lastools tile") != 0) continue;
                        this.header.offset_to_point_data -= 54 + this.header.vlrs[i].record_length_after_header;
                        vlrs_size -= 54 + this.header.vlrs[i].record_length_after_header;
                        --i;
                        --this.header.number_of_variable_length_records;
                    }
                }
                this.header.user_data_after_header_size = this.header.offset_to_point_data - vlrs_size - this.header.header_size;
                if (this.header.user_data_after_header_size != 0) {
                    this.header.user_data_after_header = new byte[this.header.user_data_after_header_size];
                    try {
                        stream.getBytes(this.header.user_data_after_header, this.header.user_data_after_header_size);
                    }
                    catch (Exception e) {
                        Cstdio.fprintf(LASreaderLAS.stderr, "ERROR: reading %d bytes of data into header.user_data_after_header\n", new Object[]{this.header.user_data_after_header_size});
                        return Boolean.FALSE;
                    }
                }
                if (this.header.version_major != 1 || this.header.version_minor < 4 || this.header.number_of_extended_variable_length_records == 0) break block285;
                if (stream.isSeekable()) break block286;
                Cstdio.fprintf(LASreaderLAS.stderr, "WARNING: LAS %d.%d file has %d EVLRs but stream is not seekable ...\n", new Object[]{this.header.version_major, this.header.version_minor, this.header.number_of_extended_variable_length_records});
                break block285;
            }
            here = stream.tell();
            stream.seek(this.header.start_of_first_extended_variable_length_record);
            this.header.evlrs = new LASevlr[this.header.number_of_extended_variable_length_records];
            evlrs_size = 0L;
            for (i = 0; i < this.header.number_of_extended_variable_length_records; ++i) {
                try {
                    this.header.evlrs[i].reserved = stream.get16bitsLE();
                }
                catch (Exception e) {
                    Cstdio.fprintf(LASreaderLAS.stderr, "ERROR: reading header.evlrs[%d].reserved\n", new Object[]{i});
                    return Boolean.FALSE;
                }
                try {
                    stream.getBytes(this.header.evlrs[i].user_id, 16);
                }
                catch (Exception e) {
                    Cstdio.fprintf(LASreaderLAS.stderr, "ERROR: reading header.evlrs[%d].user_id\n", new Object[]{i});
                    return Boolean.FALSE;
                }
                try {
                    this.header.evlrs[i].record_id = stream.get16bitsLE();
                }
                catch (Exception e) {
                    Cstdio.fprintf(LASreaderLAS.stderr, "ERROR: reading header.evlrs[%d].record_id\n", new Object[]{i});
                    return Boolean.FALSE;
                }
                try {
                    this.header.evlrs[i].record_length_after_header = stream.get64bitsLE();
                }
                catch (Exception e) {
                    Cstdio.fprintf(LASreaderLAS.stderr, "ERROR: reading header.evlrs[%d].record_length_after_header\n", new Object[]{i});
                    return Boolean.FALSE;
                }
                try {
                    stream.getBytes(this.header.evlrs[i].description, 32);
                }
                catch (Exception e) {
                    Cstdio.fprintf(LASreaderLAS.stderr, "ERROR: reading header.evlrs[%d].description\n", new Object[]{i});
                    return Boolean.FALSE;
                }
                evlrs_size += 60L;
                if (this.header.evlrs[i].record_length_after_header == 0L) ** GOTO lbl776
                if (Cstring.strcmp(this.header.evlrs[i].user_id, "laszip encoded") == 0) {
                    this.header.laszip = new LASzip();
                    try {
                        this.header.laszip.compressor = stream.get16bitsLE();
                    }
                    catch (Exception e) {
                        Cstdio.fprintf(LASreaderLAS.stderr, "ERROR: reading compressor %d\n", new Object[]{(int)this.header.laszip.compressor});
                        return Boolean.FALSE;
                    }
                    try {
                        this.header.laszip.coder = stream.get16bitsLE();
                    }
                    catch (Exception e) {
                        Cstdio.fprintf(LASreaderLAS.stderr, "ERROR: reading coder %d\n", new Object[]{(int)this.header.laszip.coder});
                        return Boolean.FALSE;
                    }
                    try {
                        this.header.laszip.version_major = stream.getByte();
                    }
                    catch (Exception e) {
                        Cstdio.fprintf(LASreaderLAS.stderr, "ERROR: reading version_major %d\n", new Object[]{this.header.laszip.version_major});
                        return Boolean.FALSE;
                    }
                    try {
                        this.header.laszip.version_minor = stream.getByte();
                    }
                    catch (Exception e) {
                        Cstdio.fprintf(LASreaderLAS.stderr, "ERROR: reading version_minor %d\n", new Object[]{this.header.laszip.version_minor});
                        return Boolean.FALSE;
                    }
                    try {
                        this.header.laszip.version_revision = stream.get16bitsLE();
                    }
                    catch (Exception e) {
                        Cstdio.fprintf(LASreaderLAS.stderr, "ERROR: reading version_revision %d\n", new Object[]{Character.valueOf(this.header.laszip.version_revision)});
                        return Boolean.FALSE;
                    }
                    try {
                        this.header.laszip.options = stream.get32bitsLE();
                    }
                    catch (Exception e) {
                        Cstdio.fprintf(LASreaderLAS.stderr, "ERROR: reading options %d\n", new Object[]{this.header.laszip.options});
                        return Boolean.FALSE;
                    }
                    try {
                        this.header.laszip.chunk_size = stream.get32bitsLE();
                    }
                    catch (Exception e) {
                        Cstdio.fprintf(LASreaderLAS.stderr, "ERROR: reading chunk_size %d\n", new Object[]{this.header.laszip.chunk_size});
                        return Boolean.FALSE;
                    }
                    try {
                        this.header.laszip.number_of_special_evlrs = stream.get64bitsLE();
                    }
                    catch (Exception e) {
                        Cstdio.fprintf(LASreaderLAS.stderr, "ERROR: reading number_of_special_evlrs %d\n", new Object[]{(int)this.header.laszip.number_of_special_evlrs});
                        return Boolean.FALSE;
                    }
                    try {
                        this.header.laszip.offset_to_special_evlrs = stream.get64bitsLE();
                    }
                    catch (Exception e) {
                        Cstdio.fprintf(LASreaderLAS.stderr, "ERROR: reading offset_to_special_evlrs %d\n", new Object[]{(int)this.header.laszip.offset_to_special_evlrs});
                        return Boolean.FALSE;
                    }
                    try {
                        this.header.laszip.num_items = stream.get16bitsLE();
                    }
                    catch (Exception e) {
                        Cstdio.fprintf(LASreaderLAS.stderr, "ERROR: reading num_items %d\n", new Object[]{Character.valueOf(this.header.laszip.num_items)});
                        return Boolean.FALSE;
                    }
                    this.header.laszip.items = new LASitem[this.header.laszip.num_items];
                    for (j = 0; j < this.header.laszip.num_items; ++j) {
                        type = '\u0000';
                        size = '\u0000';
                        version = '\u0000';
                        try {
                            type = stream.get16bitsLE();
                        }
                        catch (Exception e) {
                            Cstdio.fprintf(LASreaderLAS.stderr, "ERROR: reading type %d of item %d\n", new Object[]{Character.valueOf(type), j});
                            return Boolean.FALSE;
                        }
                        try {
                            size = stream.get16bitsLE();
                        }
                        catch (Exception e) {
                            Cstdio.fprintf(LASreaderLAS.stderr, "ERROR: reading size %d of item %d\n", new Object[]{Character.valueOf(size), j});
                            return Boolean.FALSE;
                        }
                        try {
                            version = stream.get16bitsLE();
                        }
                        catch (Exception e) {
                            Cstdio.fprintf(LASreaderLAS.stderr, "ERROR: reading version %d of item %d\n", new Object[]{Character.valueOf(version), j});
                            return Boolean.FALSE;
                        }
                        this.header.laszip.items[j].type = LASitem.Type.fromOrdinal(type);
                        this.header.laszip.items[j].size = size;
                        this.header.laszip.items[j].version = version;
                    }
                } else {
                    if (Cstring.strcmp(this.header.evlrs[i].user_id, "LAStools") == 0 && this.header.evlrs[i].record_id == '\n') {
                        this.header.clean_lastiling();
                        this.header.vlr_lastiling = new LASvlr_lastiling();
                        if (this.header.evlrs[i].record_length_after_header == 28L) {
                            try {
                                this.header.vlr_lastiling.level = stream.get32bitsLE();
                            }
                            catch (Exception e) {
                                Cstdio.fprintf(LASreaderLAS.stderr, "ERROR: reading vlr_lastiling.level %d\n", new Object[]{this.header.vlr_lastiling.level});
                                return Boolean.FALSE;
                            }
                            try {
                                this.header.vlr_lastiling.level_index = stream.get32bitsLE();
                            }
                            catch (Exception e) {
                                Cstdio.fprintf(LASreaderLAS.stderr, "ERROR: reading vlr_lastiling.level_index %d\n", new Object[]{this.header.vlr_lastiling.level_index});
                                return Boolean.FALSE;
                            }
                            try {
                                this.header.vlr_lastiling.implicit_levels = stream.get32bitsLE();
                            }
                            catch (Exception e) {
                                Cstdio.fprintf(LASreaderLAS.stderr, "ERROR: reading vlr_lastiling.implicit_levels %d\n", new Object[]{this.header.vlr_lastiling.implicit_levels});
                                return Boolean.FALSE;
                            }
                            try {
                                this.header.vlr_lastiling.min_x = Float.intBitsToFloat(stream.get32bitsLE());
                            }
                            catch (Exception e) {
                                Cstdio.fprintf(LASreaderLAS.stderr, "ERROR: reading vlr_lastiling.min_x %g\n", new Object[]{Float.valueOf(this.header.vlr_lastiling.min_x)});
                                return Boolean.FALSE;
                            }
                            try {
                                this.header.vlr_lastiling.max_x = Float.intBitsToFloat(stream.get32bitsLE());
                            }
                            catch (Exception e) {
                                Cstdio.fprintf(LASreaderLAS.stderr, "ERROR: reading vlr_lastiling.max_x %g\n", new Object[]{Float.valueOf(this.header.vlr_lastiling.max_x)});
                                return Boolean.FALSE;
                            }
                            try {
                                this.header.vlr_lastiling.min_y = Float.intBitsToFloat(stream.get32bitsLE());
                            }
                            catch (Exception e) {
                                Cstdio.fprintf(LASreaderLAS.stderr, "ERROR: reading vlr_lastiling.min_y %g\n", new Object[]{Float.valueOf(this.header.vlr_lastiling.min_y)});
                                return Boolean.FALSE;
                            }
                            try {
                                this.header.vlr_lastiling.max_y = Float.intBitsToFloat(stream.get32bitsLE());
                            }
                            catch (Exception e) {
                                Cstdio.fprintf(LASreaderLAS.stderr, "ERROR: reading vlr_lastiling.max_y %g\n", new Object[]{Float.valueOf(this.header.vlr_lastiling.max_y)});
                                return Boolean.FALSE;
                            }
                        }
                        Cstdio.fprintf(LASreaderLAS.stderr, "ERROR: record_length_after_header of EVLR %s (%d) is %d instead of 28\n", new Object[]{this.header.evlrs[i].user_id, Character.valueOf(this.header.evlrs[i].record_id), (int)this.header.evlrs[i].record_length_after_header});
                        return Boolean.FALSE;
                    }
                    this.header.evlrs[i].data = new byte[(int)this.header.evlrs[i].record_length_after_header];
                    try {
                        stream.getBytes(this.header.evlrs[i].data, (int)this.header.evlrs[i].record_length_after_header);
                    }
                    catch (Exception e) {
                        Cstdio.fprintf(LASreaderLAS.stderr, "ERROR: reading %d bytes of data into header.evlrs[%d].data\n", new Object[]{(int)this.header.evlrs[i].record_length_after_header, i});
                        return Boolean.FALSE;
                    }
lbl776:
                    // 1 sources

                    this.header.evlrs[i].data = null;
                }
                evlrs_size += this.header.evlrs[i].record_length_after_header;
                if (Cstring.strcmp(this.header.evlrs[i].user_id, "LASF_Projection") == 0) {
                    if (this.header.evlrs[i].record_id == '\u87af') {
                        if (this.header.vlr_geo_keys != null) {
                            Cstdio.fprintf(LASreaderLAS.stderr, "WARNING: variable length records contain more than one GeoKeyDirectoryTag\n", new Object[0]);
                        }
                        this.header.vlr_geo_keys = LASvlr_geo_keys.fromByteArray(this.header.evlrs[i].data);
                        if (this.header.vlr_geo_keys.key_directory_version != '\u0001') {
                            Cstdio.fprintf(LASreaderLAS.stderr, "WARNING: wrong vlr_geo_keys.key_directory_version: %d != 1\n", new Object[]{Character.valueOf(this.header.vlr_geo_keys.key_directory_version)});
                        }
                        if (this.header.vlr_geo_keys.key_revision != '\u0001') {
                            Cstdio.fprintf(LASreaderLAS.stderr, "WARNING: wrong vlr_geo_keys.key_revision: %d != 1\n", new Object[]{Character.valueOf(this.header.vlr_geo_keys.key_revision)});
                        }
                        if (this.header.vlr_geo_keys.minor_revision != '\u0000') {
                            Cstdio.fprintf(LASreaderLAS.stderr, "WARNING: wrong vlr_geo_keys.minor_revision: %d != 0\n", new Object[]{Character.valueOf(this.header.vlr_geo_keys.minor_revision)});
                        }
                        bb = ByteBuffer.wrap(this.header.evlrs[i].data).order(ByteOrder.LITTLE_ENDIAN);
                        bb.position(8);
                        this.header.vlr_geo_key_entries = LASvlr_key_entry.fromByteBuffer(bb);
                        continue;
                    }
                    if (this.header.evlrs[i].record_id == '\u87b0') {
                        if (this.header.vlr_geo_double_params != null) {
                            Cstdio.fprintf(LASreaderLAS.stderr, "WARNING: variable length records contain more than one GeoF64ParamsTag\n", new Object[0]);
                        }
                        this.header.vlr_geo_double_params = LASheader.doublesFromByteArray(this.header.evlrs[i].data);
                        continue;
                    }
                    if (this.header.evlrs[i].record_id != '\u87b1') continue;
                    if (this.header.vlr_geo_ascii_params != null) {
                        Cstdio.fprintf(LASreaderLAS.stderr, "WARNING: variable length records contain more than one GeoAsciiParamsTag\n", new Object[0]);
                    }
                    this.header.vlr_geo_ascii_params = MyDefs.stringFromByteArray(this.header.evlrs[i].data);
                    continue;
                }
                if (Cstring.strcmp(this.header.evlrs[i].user_id, "LASF_Spec") == 0) {
                    if (this.header.evlrs[i].record_id == '\u0000') {
                        if (this.header.vlr_classification != null) {
                            Cstdio.fprintf(LASreaderLAS.stderr, "WARNING: variable length records contain more than one ClassificationLookup\n", new Object[0]);
                        }
                        this.header.vlr_classification = LASvlr_classification.fromByteArray(this.header.evlrs[i].data);
                        continue;
                    }
                    if (this.header.evlrs[i].record_id == '\u0002' || this.header.evlrs[i].record_id == '\u0003') continue;
                    if (this.header.evlrs[i].record_id == '\u0004') {
                        this.header.init_attributes((int)this.header.evlrs[i].record_length_after_header / MyDefs.sizeof(LASattribute.class), LASattribute.fromByteArray(this.header.evlrs[i].data));
                        continue;
                    }
                    if (this.header.evlrs[i].record_id < 'd' || this.header.evlrs[i].record_id >= '\u0163') continue;
                    idx = this.header.evlrs[i].record_id - 99;
                    if (this.header.vlr_wave_packet_descr == null) {
                        this.header.vlr_wave_packet_descr = new LASvlr_wave_packet_descr[256];
                        for (j = 0; j < 256; ++j) {
                            this.header.vlr_wave_packet_descr[j] = null;
                        }
                    }
                    if (this.header.vlr_wave_packet_descr[idx] != null) {
                        Cstdio.fprintf(LASreaderLAS.stderr, "WARNING: extended variable length records defines wave packet descr %d more than once\n", new Object[]{idx});
                    }
                    this.header.vlr_wave_packet_descr[idx] = LASvlr_wave_packet_descr.fromByteArray(this.header.evlrs[i].data);
                    continue;
                }
                if (Cstring.strcmp(this.header.evlrs[i].user_id, "laszip encoded") != 0 && Cstring.strcmp(this.header.evlrs[i].user_id, "LAStools") != 0) continue;
                evlrs_size -= 60L + this.header.evlrs[i].record_length_after_header;
                --i;
                --this.header.number_of_extended_variable_length_records;
            }
            stream.seek(here);
        }
        if (this.header.laszip != null && !this.header.laszip.check()) {
            Cstdio.fprintf(LASreaderLAS.stderr, "ERROR: %s\n", new Object[]{this.header.laszip.get_error()});
            Cstdio.fprintf(LASreaderLAS.stderr, "       please upgrade to the latest release of LAStools (with LASzip)\n", new Object[0]);
            Cstdio.fprintf(LASreaderLAS.stderr, "       or contact 'martin.isenburg@rapidlasso.com' for assistance.\n", new Object[0]);
            return Boolean.FALSE;
        }
        if ((this.header.point_data_format & 128) != 0 || (this.header.point_data_format & 64) != 0) {
            if (this.header.laszip == null) {
                Cstdio.fprintf(LASreaderLAS.stderr, "ERROR: this file was compressed with an experimental version of laszip\n", new Object[0]);
                Cstdio.fprintf(LASreaderLAS.stderr, "ERROR: please contact 'martin.isenburg@rapidlasso.com' for assistance.\n", new Object[0]);
                return Boolean.FALSE;
            }
            this.header.point_data_format = (byte)(this.header.point_data_format & 127);
        }
        this.reader = new LASreadPoint();
        if (this.header.laszip != null) {
            if (!this.point.init((LASquantizer)this.header, this.header.laszip.num_items, this.header.laszip.items, (LASattributer)this.header)) {
                return Boolean.FALSE;
            }
            if (!this.reader.setup(this.header.laszip.num_items, this.header.laszip.items, this.header.laszip)) {
                return Boolean.FALSE;
            }
        } else {
            if (!this.point.init((LASquantizer)this.header, this.header.point_data_format, this.header.point_data_record_length, (LASattributer)this.header)) {
                return Boolean.FALSE;
            }
            if (!this.reader.setup(this.point.num_items, this.point.items)) {
                return Boolean.FALSE;
            }
        }
        if (this.header.laszip != null && this.header.laszip.number_of_special_evlrs > 0L && this.header.laszip.offset_to_special_evlrs >= (long)this.header.offset_to_point_data && stream.isSeekable()) {
            here = stream.tell();
            try {
                number = this.header.laszip.number_of_special_evlrs;
                offset = this.header.laszip.offset_to_special_evlrs;
                for (count = 0L; count < number; ++count) {
                    stream.seek(offset + 2L);
                    user_id = new byte[16];
                    stream.getBytes(user_id, 16);
                    record_id = stream.get16bitsLE();
                    if (Cstring.strcmp(user_id, "LAStools") == 0 && record_id == '\u001e') {
                        stream.seek(offset + 60L);
                        this.index = new LASindex();
                        if (this.index != null && !this.index.read(stream)) {
                            this.index = null;
                        }
                        break;
                    }
                    record_length_after_header = stream.get64bitsLE();
                    offset += record_length_after_header + 60L;
                }
            }
            catch (Exception e) {
                Cstdio.fprintf(LASreaderLAS.stderr, "ERROR: trying to read %d internal EVLRs. ignoring ...\n", new Object[]{(int)this.header.laszip.number_of_special_evlrs});
            }
            stream.seek(here);
        }
        if (!this.reader.init(stream)) {
            return Boolean.FALSE;
        }
        this.checked_end = Boolean.FALSE;
        return Boolean.TRUE;
    }

    @Override
    public int get_format() {
        if (this.header.laszip != null) {
            return this.header.laszip.compressor == '\u0000' ? 1 : 2;
        }
        return 1;
    }

    @Override
    public boolean seek(long p_index) {
        if (this.reader != null && p_index < this.npoints && this.reader.seek((int)this.p_count, (int)p_index)) {
            this.p_count = p_index;
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    @Override
    protected boolean read_point_default() {
        if (this.p_count < this.npoints) {
            if (this.reader.read(this.point.point) == Boolean.FALSE.booleanValue()) {
                if (this.reader.error() != null) {
                    Cstdio.fprintf(stderr, "ERROR: '%s' after %d of %d points\n", this.reader.error(), (int)this.p_count, (int)this.npoints);
                } else {
                    Cstdio.fprintf(stderr, "WARNING: end-of-file after %d of %d points\n", (int)this.p_count, (int)this.npoints);
                }
                return Boolean.FALSE;
            }
            ++this.p_count;
            return Boolean.TRUE;
        }
        if (!this.checked_end) {
            if (this.reader.check_end() == Boolean.FALSE.booleanValue()) {
                Cstdio.fprintf(stderr, "ERROR: '%s' when reaching end of encoding\n", this.reader.error());
                --this.p_count;
            }
            if (this.reader.warning() != null) {
                Cstdio.fprintf(stderr, "WARNING: '%s'\n", this.reader.warning());
            }
            this.checked_end = Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    @Override
    public ByteStreamIn get_stream() {
        return this.stream;
    }

    @Override
    public void close(boolean close_stream) {
        if (this.reader != null) {
            this.reader.done();
            this.reader = null;
        }
        if (close_stream) {
            if (this.stream != null) {
                Cstdio.fclose(this.stream);
                this.stream = null;
            }
            if (this.file != null) {
                Cstdio.fclose(this.file);
                this.file = null;
            }
        }
    }

    LASreaderLAS() {
    }
}

