/*
 * Decompiled with CFR 0.152.
 */
package com.github.mreutegg.laszip4j.laslib;

import com.github.mreutegg.laszip4j.clib.Cstdio;
import com.github.mreutegg.laszip4j.clib.Cstring;
import com.github.mreutegg.laszip4j.laslib.LASvlr_wave_packet_descr;
import com.github.mreutegg.laszip4j.laslib.LASwaveformDescription;
import com.github.mreutegg.laszip4j.laszip.ArithmeticEncoder;
import com.github.mreutegg.laszip4j.laszip.ByteStreamOut;
import com.github.mreutegg.laszip4j.laszip.ByteStreamOutFile;
import com.github.mreutegg.laszip4j.laszip.IntegerCompressor;
import com.github.mreutegg.laszip4j.laszip.LASpoint;
import com.github.mreutegg.laszip4j.laszip.MyDefs;
import java.io.PrintStream;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public class LASwaveform13writer {
    private static final PrintStream stderr = System.err;
    private LASwaveformDescription[] waveforms = null;
    private RandomAccessFile file = null;
    private ByteStreamOut stream = null;
    private ArithmeticEncoder enc = null;
    private IntegerCompressor ic8 = null;
    private IntegerCompressor ic16 = null;

    LASwaveform13writer() {
    }

    boolean open(String file_name, LASvlr_wave_packet_descr[] wave_packet_descr) {
        int len;
        char i;
        if (file_name == null) {
            Cstdio.fprintf(stderr, "ERROR: file name pointer is zero\n", new Object[0]);
            return Boolean.FALSE;
        }
        if (wave_packet_descr == null) {
            Cstdio.fprintf(stderr, "ERROR: wave packet descriptor pointer is zero\n", new Object[0]);
            return Boolean.FALSE;
        }
        char number = '\u0000';
        boolean compressed = Boolean.FALSE;
        if (this.waveforms == null) {
            this.waveforms = new LASwaveformDescription[256];
        }
        for (i = '\u0000'; i < '\u0100'; i = (char)((char)(i + 1))) {
            if (wave_packet_descr[i] != null) {
                if (this.waveforms[i] == null) {
                    this.waveforms[i] = new LASwaveformDescription();
                }
                this.waveforms[i].compression = wave_packet_descr[i].getCompressionType();
                this.waveforms[i].nbits = wave_packet_descr[i].getBitsPerSample();
                this.waveforms[i].nsamples = (char)wave_packet_descr[i].getNumberOfSamples();
                compressed = compressed || this.waveforms[i].compression > 0;
                number = (char)(number + 1);
                continue;
            }
            if (this.waveforms[i] == null) continue;
            this.waveforms[i] = null;
        }
        char[] file_name_temp = file_name.toCharArray();
        if (file_name_temp[(len = Cstring.strlen(file_name_temp)) - 3] == 'L' || file_name_temp[len - 3] == 'W') {
            file_name_temp[len - 3] = 87;
            file_name_temp[len - 2] = 68;
            file_name_temp[len - 1] = compressed ? 90 : 80;
        } else {
            file_name_temp[len - 3] = 119;
            file_name_temp[len - 2] = 100;
            file_name_temp[len - 1] = compressed ? 122 : 112;
        }
        this.file = Cstdio.fopenRAF(file_name_temp, "wb");
        if (this.file == null) {
            Cstdio.fprintf(stderr, "ERROR: cannot open waveform file '%s'\n", new String(file_name_temp));
            return Boolean.FALSE;
        }
        this.stream = new ByteStreamOutFile(this.file);
        char reserved = '\uaabb';
        if (!this.stream.put16bitsLE(reserved)) {
            Cstdio.fprintf(stderr, "ERROR: writing EVLR reserved\n", new Object[0]);
            return Boolean.FALSE;
        }
        byte[] user_id = new byte[16];
        System.arraycopy(MyDefs.asByteArray("LASF_Spec"), 0, user_id, 0, "LASF_Spec".length());
        if (!this.stream.putBytes(user_id, 16)) {
            Cstdio.fprintf(stderr, "ERROR: writing EVLR user_id\n", new Object[0]);
            return Boolean.FALSE;
        }
        char record_id = '\uffff';
        if (!this.stream.put16bitsLE(record_id)) {
            Cstdio.fprintf(stderr, "ERROR: writing EVLR record_id\n", new Object[0]);
            return Boolean.FALSE;
        }
        long record_length_after_header = 0L;
        if (!this.stream.put64bitsLE(record_length_after_header)) {
            Cstdio.fprintf(stderr, "ERROR: writing EVLR record_length_after_header\n", new Object[0]);
            return Boolean.FALSE;
        }
        byte[] description = new byte[32];
        String desc = String.format("%s by LAStools (%d)", compressed ? "compressed" : "created", 160730);
        System.arraycopy(MyDefs.asByteArray(desc), 0, description, 0, desc.length());
        if (!this.stream.putBytes(description, 32)) {
            Cstdio.fprintf(stderr, "ERROR: writing EVLR description\n", new Object[0]);
            return Boolean.FALSE;
        }
        char[] magic = new char[25];
        Cstdio.sprintf(magic, "LAStools waveform %d", 160730);
        if (!this.stream.putBytes(MyDefs.asByteArray(new String(magic)), 24)) {
            Cstdio.fprintf(stderr, "ERROR: writing waveform descriptor cross-check\n", new Object[0]);
            return Boolean.FALSE;
        }
        if (!this.stream.put16bitsLE(number)) {
            Cstdio.fprintf(stderr, "ERROR: writing number of waveform descriptors\n", new Object[0]);
            return Boolean.FALSE;
        }
        for (i = '\u0000'; i < '\u0100'; i = (char)(i + 1)) {
            if (this.waveforms[i] == null) continue;
            if (!this.stream.put16bitsLE(i)) {
                Cstdio.fprintf(stderr, "ERROR: writing index of waveform descriptor %d\n", Character.valueOf(i));
                return Boolean.FALSE;
            }
            if (!this.stream.putByte(this.waveforms[i].compression)) {
                Cstdio.fprintf(stderr, "ERROR: writing compression of waveform descriptor %d\n", Character.valueOf(i));
                return Boolean.FALSE;
            }
            if (!this.stream.putByte(this.waveforms[i].nbits)) {
                Cstdio.fprintf(stderr, "ERROR: writing nbits of waveform descriptor %d\n", Character.valueOf(i));
                return Boolean.FALSE;
            }
            if (this.stream.put16bitsLE(this.waveforms[i].nsamples)) continue;
            Cstdio.fprintf(stderr, "ERROR: writing nsamples of waveform descriptor %d\n", Character.valueOf(i));
            return Boolean.FALSE;
        }
        if (compressed) {
            if (this.enc == null) {
                this.enc = new ArithmeticEncoder();
            }
            if (this.ic8 == null) {
                this.ic8 = new IntegerCompressor(this.enc, 8);
            }
            if (this.ic16 == null) {
                this.ic16 = new IntegerCompressor(this.enc, 16);
            }
        }
        return Boolean.TRUE;
    }

    public boolean write_waveform(LASpoint point, byte[] samples) {
        byte index = point.wavepacket.getIndex();
        if (index == 0) {
            return Boolean.FALSE;
        }
        byte nbits = this.waveforms[index].nbits;
        if (nbits != 8 && nbits != 16) {
            Cstdio.fprintf(stderr, "ERROR: waveform with %d bits per samples not supported yet\n", nbits);
            return Boolean.FALSE;
        }
        int nsamples = this.waveforms[index].nsamples;
        if (nsamples == 0) {
            Cstdio.fprintf(stderr, "ERROR: waveform has no samples\n", new Object[0]);
            return Boolean.FALSE;
        }
        long offset = this.stream.tell();
        point.wavepacket.setOffset(offset);
        if (this.waveforms[index].compression == 0) {
            int size = nbits / 8 * nsamples;
            if (!this.stream.putBytes(samples, size)) {
                Cstdio.fprintf(stderr, "ERROR: cannot write %d bytes for waveform with %d samples of %d bits\n", size, nsamples, nbits);
                return Boolean.FALSE;
            }
            point.wavepacket.setSize(size);
        } else {
            if (nbits == 8) {
                this.stream.putBytes(samples, 1);
                this.enc.init(this.stream);
                this.ic8.initCompressor();
                for (int s_count = 1; s_count < nsamples; ++s_count) {
                    this.ic8.compress(samples[s_count - '\u0001'], samples[s_count]);
                }
            } else {
                this.stream.putBytes(samples, 2);
                this.enc.init(this.stream);
                this.ic16.initCompressor();
                ByteBuffer bb = ByteBuffer.wrap(samples).order(ByteOrder.LITTLE_ENDIAN);
                for (int s_count = 1; s_count < nsamples; ++s_count) {
                    this.ic16.compress(bb.getChar((s_count - '\u0001') * 2), bb.getChar(s_count * 2));
                }
            }
            this.enc.done();
            int size = (int)(this.stream.tell() - offset);
            point.wavepacket.setSize(size);
        }
        return Boolean.TRUE;
    }

    void close() {
        if (this.stream.isSeekable()) {
            long record_length_after_header = this.stream.tell();
            this.stream.seek(18L);
            if (!this.stream.put64bitsLE(record_length_after_header -= 60L)) {
                Cstdio.fprintf(stderr, "ERROR: updating EVLR record_length_after_header\n", new Object[0]);
            }
            this.stream.seekEnd();
        }
        if (this.stream != null) {
            Cstdio.fclose(this.stream);
            this.stream = null;
        }
        if (this.file != null) {
            Cstdio.fclose(this.file);
            this.file = null;
        }
    }
}

