/*
 * Decompiled with CFR 0.152.
 */
package com.github.mreutegg.laszip4j.laszip;

import com.github.mreutegg.laszip4j.laszip.ByteStreamIn;
import com.github.mreutegg.laszip4j.laszip.UncheckedEOFException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public class ByteStreamInArray
extends ByteStreamIn {
    private ByteBuffer data;

    public ByteStreamInArray(byte[] bytes, long size) {
        if (size > Integer.MAX_VALUE) {
            throw new IllegalArgumentException();
        }
        this.data = ByteBuffer.wrap(bytes, 0, (int)size);
        this.data.order(ByteOrder.LITTLE_ENDIAN);
    }

    @Override
    public byte getByte() {
        if (!this.data.hasRemaining()) {
            throw new UncheckedEOFException();
        }
        return this.data.get();
    }

    @Override
    public void getBytes(byte[] bytes, int u_num_bytes) {
        if (this.data.remaining() < u_num_bytes) {
            throw new UncheckedEOFException();
        }
        this.data.get(bytes, 0, u_num_bytes);
    }

    @Override
    public char get16bitsLE() {
        return this.data.getChar();
    }

    @Override
    public int get32bitsLE() {
        return this.data.getInt();
    }

    @Override
    public long get64bitsLE() {
        return this.data.getLong();
    }

    @Override
    public char get16bitsBE() {
        this.data.order(ByteOrder.BIG_ENDIAN);
        try {
            char c = this.data.getChar();
            return c;
        }
        finally {
            this.data.order(ByteOrder.LITTLE_ENDIAN);
        }
    }

    @Override
    public int get32bitsBE() {
        this.data.order(ByteOrder.BIG_ENDIAN);
        try {
            int n = this.data.getInt();
            return n;
        }
        finally {
            this.data.order(ByteOrder.LITTLE_ENDIAN);
        }
    }

    @Override
    public long get64bitsBE() {
        this.data.order(ByteOrder.BIG_ENDIAN);
        try {
            long l = this.data.getLong();
            return l;
        }
        finally {
            this.data.order(ByteOrder.LITTLE_ENDIAN);
        }
    }

    @Override
    public boolean isSeekable() {
        return true;
    }

    @Override
    public long tell() {
        return this.data.position();
    }

    @Override
    public boolean seek(long position) {
        if (position > Integer.MAX_VALUE) {
            throw new IllegalArgumentException();
        }
        this.data.position((int)position);
        return true;
    }

    @Override
    public boolean seekEnd(long distance) {
        if (distance > Integer.MAX_VALUE) {
            throw new IllegalArgumentException();
        }
        if (0L <= distance && distance <= (long)this.data.capacity()) {
            this.data.position(this.data.capacity() - (int)distance);
            return true;
        }
        return false;
    }

    @Override
    public void close() {
    }
}

