/*
 * Decompiled with CFR 0.152.
 */
package com.github.mreutegg.laszip4j.laszip;

import com.github.mreutegg.laszip4j.laszip.MyDefs;
import com.github.mreutegg.laszip4j.laszip.U64I64F64;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public class LASattribute {
    private static final long UNSIGNED_MASK = Long.MAX_VALUE;
    public static final int LAS_ATTRIBUTE_U8 = 0;
    public static final int LAS_ATTRIBUTE_I8 = 1;
    public static final int LAS_ATTRIBUTE_U16 = 2;
    public static final int LAS_ATTRIBUTE_I16 = 3;
    public static final int LAS_ATTRIBUTE_U32 = 4;
    public static final int LAS_ATTRIBUTE_int = 5;
    public static final int LAS_ATTRIBUTE_U64 = 6;
    public static final int LAS_ATTRIBUTE_I64 = 7;
    public static final int LAS_ATTRIBUTE_F32 = 8;
    public static final int LAS_ATTRIBUTE_F64 = 9;
    public byte[] reserved = new byte[2];
    public byte data_type;
    public byte options;
    public byte[] name = new byte[32];
    public byte[] unused = new byte[4];
    public U64I64F64[] no_data = LASattribute.newU64I64F64(3);
    public U64I64F64[] min = LASattribute.newU64I64F64(3);
    public U64I64F64[] max = LASattribute.newU64I64F64(3);
    public double[] scale = new double[3];
    public double[] offset = new double[3];
    public byte[] description = new byte[32];

    private LASattribute() {
    }

    LASattribute(byte u_size) {
        if (u_size == 0) {
            throw new IllegalArgumentException();
        }
        this.scale[2] = 1.0;
        this.scale[1] = 1.0;
        this.scale[0] = 1.0;
        this.options = u_size;
    }

    LASattribute(int type, String name) {
        this(type, name, null, 1);
    }

    public LASattribute(int type, String name, String description) {
        this(type, name, description, 1);
    }

    LASattribute(int type, String name, String description, int dim) {
        if (type > 9) {
            throw new IllegalArgumentException();
        }
        if (dim < 1 || dim > 3) {
            throw new IllegalArgumentException();
        }
        if (name == null) {
            throw new NullPointerException();
        }
        this.scale[2] = 1.0;
        this.scale[1] = 1.0;
        this.scale[0] = 1.0;
        this.data_type = (byte)((dim - 1) * 10 + type + 1);
        System.arraycopy(MyDefs.asByteArray(name), 0, this.name, 0, name.length());
        this.name[name.length()] = 0;
        if (description != null) {
            System.arraycopy(MyDefs.asByteArray(description), 0, this.description, 0, description.length());
            this.description[description.length()] = 0;
        }
    }

    private static U64I64F64[] newU64I64F64(int size) {
        U64I64F64[] data = new U64I64F64[size];
        for (int i = 0; i < size; ++i) {
            data[i] = new U64I64F64();
        }
        return data;
    }

    public boolean set_no_dataU(byte no_data, int dim) {
        if (0 == this.get_type() && dim < this.get_dim()) {
            this.no_data[dim].setU64(Byte.toUnsignedLong(no_data));
            this.options = (byte)(this.options | 1);
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public boolean set_no_data(byte no_data, int dim) {
        if (1 == this.get_type() && dim < this.get_dim()) {
            this.no_data[dim].setI64(no_data);
            this.options = (byte)(this.options | 1);
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public boolean set_no_dataU(short no_data, int dim) {
        if (2 == this.get_type() && dim < this.get_dim()) {
            this.no_data[dim].setU64(Short.toUnsignedLong(no_data));
            this.options = (byte)(this.options | 1);
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public boolean set_no_data(short no_data, int dim) {
        if (3 == this.get_type() && dim < this.get_dim()) {
            this.no_data[dim].setI64(no_data);
            this.options = (byte)(this.options | 1);
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public boolean set_no_dataU(int no_data, int dim) {
        if (4 == this.get_type() && dim < this.get_dim()) {
            this.no_data[dim].setU64(Integer.toUnsignedLong(no_data));
            this.options = (byte)(this.options | 1);
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public boolean set_no_data(int no_data, int dim) {
        if (5 == this.get_type() && dim < this.get_dim()) {
            this.no_data[dim].setI64(no_data);
            this.options = (byte)(this.options | 1);
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public boolean set_no_dataU(long no_data, int dim) {
        if (6 == this.get_type() && dim < this.get_dim()) {
            this.no_data[dim].setU64(no_data);
            this.options = (byte)(this.options | 1);
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public boolean set_no_data(long no_data, int dim) {
        if (7 == this.get_type() && dim < this.get_dim()) {
            this.no_data[dim].setU64(no_data);
            this.options = (byte)(this.options | 1);
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public boolean set_no_data(float no_data, int dim) {
        if (8 == this.get_type() && dim < this.get_dim()) {
            this.no_data[dim].setF64(no_data);
            this.options = (byte)(this.options | 1);
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public boolean set_no_data(double no_data, int dim) {
        if (9 == this.get_type() && dim < this.get_dim()) {
            this.no_data[dim].setF64(no_data);
            this.options = (byte)(this.options | 1);
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public void set_min(byte[] min, int dim) {
        this.min[dim] = this.cast(min);
        this.options = (byte)(this.options | 2);
    }

    public void update_min(byte[] min, int dim) {
        this.min[dim] = this.smallest(this.cast(min), this.min[dim]);
    }

    public boolean set_minU(byte min, int dim) {
        if (0 == this.get_type() && dim < this.get_dim()) {
            this.min[dim].setU64(Byte.toUnsignedLong(min));
            this.options = (byte)(this.options | 2);
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public boolean set_min(byte min, int dim) {
        if (1 == this.get_type() && dim < this.get_dim()) {
            this.min[dim].setI64(min);
            this.options = (byte)(this.options | 2);
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public boolean set_minU(short min, int dim) {
        if (2 == this.get_type() && dim < this.get_dim()) {
            this.min[dim].setU64(Short.toUnsignedLong(min));
            this.options = (byte)(this.options | 2);
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public boolean set_min(short min, int dim) {
        if (3 == this.get_type() && dim < this.get_dim()) {
            this.min[dim].setI64(min);
            this.options = (byte)(this.options | 2);
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public boolean set_minU(int min, int dim) {
        if (4 == this.get_type() && dim < this.get_dim()) {
            this.min[dim].setU64(Integer.toUnsignedLong(min));
            this.options = (byte)(this.options | 2);
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public boolean set_min(int min, int dim) {
        if (5 == this.get_type() && dim < this.get_dim()) {
            this.min[dim].setI64(min);
            this.options = (byte)(this.options | 2);
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public boolean set_minU(long min, int dim) {
        if (6 == this.get_type() && dim < this.get_dim()) {
            this.min[dim].setU64(min);
            this.options = (byte)(this.options | 2);
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public boolean set_min(long min, int dim) {
        if (7 == this.get_type() && dim < this.get_dim()) {
            this.min[dim].setI64(min);
            this.options = (byte)(this.options | 2);
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public boolean set_min(float min, int dim) {
        if (8 == this.get_type() && dim < this.get_dim()) {
            this.min[dim].setF64(min);
            this.options = (byte)(this.options | 2);
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public boolean set_min(double min, int dim) {
        if (9 == this.get_type() && dim < this.get_dim()) {
            this.min[dim].setF64(min);
            this.options = (byte)(this.options | 2);
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public void set_max(byte[] max, int dim) {
        this.max[dim] = this.cast(max);
        this.options = (byte)(this.options | 4);
    }

    public void update_max(byte[] max, int dim) {
        this.max[dim] = this.biggest(this.cast(max), this.max[dim]);
    }

    public boolean set_maxU(byte max, int dim) {
        if (0 == this.get_type() && dim < this.get_dim()) {
            this.max[dim].setU64(Byte.toUnsignedLong(max));
            this.options = (byte)(this.options | 4);
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public boolean set_max(byte max, int dim) {
        if (1 == this.get_type() && dim < this.get_dim()) {
            this.max[dim].setI64(max);
            this.options = (byte)(this.options | 4);
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public boolean set_maxU(short max, int dim) {
        if (2 == this.get_type() && dim < this.get_dim()) {
            this.max[dim].setU64(Short.toUnsignedLong(max));
            this.options = (byte)(this.options | 4);
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public boolean set_max(short max, int dim) {
        if (3 == this.get_type() && dim < this.get_dim()) {
            this.max[dim].setI64(max);
            this.options = (byte)(this.options | 4);
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public boolean set_maxU(int max, int dim) {
        if (4 == this.get_type() && dim < this.get_dim()) {
            this.max[dim].setU64(Integer.toUnsignedLong(max));
            this.options = (byte)(this.options | 4);
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public boolean set_max(int max, int dim) {
        if (5 == this.get_type() && dim < this.get_dim()) {
            this.max[dim].setI64(max);
            this.options = (byte)(this.options | 4);
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public boolean set_maxU(long max, int dim) {
        if (6 == this.get_type() && dim < this.get_dim()) {
            this.max[dim].setU64(max);
            this.options = (byte)(this.options | 4);
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public boolean set_max(long max, int dim) {
        if (7 == this.get_type() && dim < this.get_dim()) {
            this.max[dim].setI64(max);
            this.options = (byte)(this.options | 4);
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public boolean set_max(float max, int dim) {
        if (8 == this.get_type() && dim < this.get_dim()) {
            this.max[dim].setF64(max);
            this.options = (byte)(this.options | 4);
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public boolean set_max(double max, int dim) {
        if (9 == this.get_type() && dim < this.get_dim()) {
            this.max[dim].setF64(max);
            this.options = (byte)(this.options | 4);
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public boolean set_scale(double scale, int dim) {
        if (this.data_type != 0) {
            this.scale[dim] = scale;
            this.options = (byte)(this.options | 8);
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public boolean set_offset(double offset, int dim) {
        if (this.data_type != 0) {
            this.offset[dim] = offset;
            this.options = (byte)(this.options | 0x10);
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public boolean has_no_data() {
        return (this.options & 1) != 0;
    }

    public boolean has_min() {
        return (this.options & 2) != 0;
    }

    public boolean has_max() {
        return (this.options & 4) != 0;
    }

    public boolean has_scale() {
        return (this.options & 8) != 0;
    }

    public boolean has_offset() {
        return (this.options & 0x10) != 0;
    }

    public int get_size() {
        if (this.data_type != 0) {
            int[] size_table = new int[]{1, 1, 2, 2, 4, 4, 8, 8, 4, 8};
            int type = this.get_type();
            int dim = this.get_dim();
            return size_table[type] * dim;
        }
        return this.options;
    }

    public double get_value_as_float(byte[] value) {
        ByteBuffer buffer = ByteBuffer.wrap(value).order(ByteOrder.LITTLE_ENDIAN);
        int type = this.get_type();
        double casted_value = type == 0 ? (double)Byte.toUnsignedInt(buffer.get()) : (type == 1 ? (double)buffer.get() : (type == 2 ? (double)Short.toUnsignedInt(buffer.getShort()) : (type == 3 ? (double)buffer.getShort() : (type == 4 ? (double)Integer.toUnsignedLong(buffer.getInt()) : (type == 5 ? (double)buffer.getInt() : (type == 6 ? LASattribute.unsignedLongAsDouble(buffer.getLong()) : (type == 7 ? (double)buffer.getLong() : (type == 8 ? (double)buffer.getFloat() : buffer.getDouble()))))))));
        return this.offset[0] + this.scale[0] * casted_value;
    }

    public static int getMemory() {
        return 192;
    }

    public byte[] asByteArray() {
        ByteBuffer bb = ByteBuffer.allocate(LASattribute.getMemory());
        bb.order(ByteOrder.LITTLE_ENDIAN);
        for (byte b : this.reserved) {
            bb.put(b);
        }
        bb.put(this.data_type);
        bb.put(this.options);
        bb.put(this.name);
        bb.position(36);
        bb.put(this.unused);
        for (U64I64F64 data : this.no_data) {
            bb.putLong(data.getI64());
        }
        for (U64I64F64 data : this.min) {
            bb.putLong(data.getI64());
        }
        for (U64I64F64 data : this.max) {
            bb.putLong(data.getI64());
        }
        for (double s : this.scale) {
            bb.putDouble(s);
        }
        for (double o : this.offset) {
            bb.putDouble(o);
        }
        bb.put(MyDefs.asByteArray(new String(this.description)));
        return bb.array();
    }

    private int get_type() {
        return (this.data_type - 1) % 10;
    }

    private int get_dim() {
        return 1 + (this.data_type - 1) / 10;
    }

    private U64I64F64 cast(byte[] value) {
        ByteBuffer buffer = ByteBuffer.wrap(value).order(ByteOrder.LITTLE_ENDIAN);
        int type = this.get_type();
        U64I64F64 casted_value = new U64I64F64();
        if (type == 0) {
            casted_value.setU64(Byte.toUnsignedInt(buffer.get()));
        } else if (type == 1) {
            casted_value.setI64(buffer.get());
        } else if (type == 2) {
            casted_value.setU64(Short.toUnsignedLong(buffer.getShort()));
        } else if (type == 3) {
            casted_value.setI64(buffer.getShort());
        } else if (type == 4) {
            casted_value.setU64(Integer.toUnsignedLong(buffer.getInt()));
        } else if (type == 5) {
            casted_value.setI64(buffer.getInt());
        } else if (type == 6) {
            casted_value.setU64(buffer.getLong());
        } else if (type == 7) {
            casted_value.setI64(buffer.getLong());
        } else if (type == 8) {
            casted_value.setF64(buffer.getFloat());
        } else {
            casted_value.setF64(buffer.getDouble());
        }
        return casted_value;
    }

    private U64I64F64 smallest(U64I64F64 a, U64I64F64 b) {
        int type = this.get_type();
        if (type >= 8) {
            if (a.getF64() < b.getF64()) {
                return a;
            }
            return b;
        }
        if ((type & 1) != 0) {
            if (a.getI64() < b.getI64()) {
                return a;
            }
            return b;
        }
        if (Long.compareUnsigned(a.getU64(), b.getU64()) < 0) {
            return a;
        }
        return b;
    }

    private U64I64F64 biggest(U64I64F64 a, U64I64F64 b) {
        int type = this.get_type();
        if (type >= 8) {
            if (a.getF64() > b.getF64()) {
                return a;
            }
            return b;
        }
        if ((type & 1) != 0) {
            if (a.getI64() > b.getI64()) {
                return a;
            }
            return b;
        }
        if (Long.compareUnsigned(a.getU64(), b.getU64()) > 0) {
            return a;
        }
        return b;
    }

    private static double unsignedLongAsDouble(long value) {
        double dValue = value & Long.MAX_VALUE;
        if (value < 0L) {
            dValue += 9.223372036854776E18;
        }
        return dValue;
    }

    public static LASattribute[] fromByteArray(byte[] data) {
        ByteBuffer bb = ByteBuffer.wrap(data).order(ByteOrder.LITTLE_ENDIAN);
        LASattribute[] attributes = new LASattribute[data.length / LASattribute.getMemory()];
        for (int i = 0; i < attributes.length; ++i) {
            attributes[i] = LASattribute.fromByteBuffer(bb);
        }
        return attributes;
    }

    private static LASattribute fromByteBuffer(ByteBuffer bb) {
        int i;
        LASattribute attr = new LASattribute();
        bb.get(attr.reserved);
        attr.data_type = bb.get();
        attr.options = bb.get();
        bb.get(attr.name);
        bb.get(attr.unused);
        for (U64I64F64 s : attr.no_data) {
            s.setI64(bb.getLong());
        }
        for (U64I64F64 s : attr.min) {
            s.setI64(bb.getLong());
        }
        for (U64I64F64 s : attr.max) {
            s.setI64(bb.getLong());
        }
        for (i = 0; i < attr.scale.length; ++i) {
            attr.scale[i] = bb.getDouble();
        }
        for (i = 0; i < attr.offset.length; ++i) {
            attr.offset[i] = bb.getDouble();
        }
        bb.get(attr.description);
        return attr;
    }
}

