/*
 * Decompiled with CFR 0.152.
 */
package com.github.mreutegg.laszip4j.laszip;

import com.github.mreutegg.laszip4j.clib.Cstdio;
import com.github.mreutegg.laszip4j.clib.Cstring;
import com.github.mreutegg.laszip4j.laslib.LASevlr;
import com.github.mreutegg.laszip4j.laslib.LASreadOpener;
import com.github.mreutegg.laszip4j.laslib.LASreader;
import com.github.mreutegg.laszip4j.laszip.ByteStreamIn;
import com.github.mreutegg.laszip4j.laszip.ByteStreamInFile;
import com.github.mreutegg.laszip4j.laszip.ByteStreamOut;
import com.github.mreutegg.laszip4j.laszip.ByteStreamOutFile;
import com.github.mreutegg.laszip4j.laszip.LASinterval;
import com.github.mreutegg.laszip4j.laszip.LASquadtree;
import com.github.mreutegg.laszip4j.laszip.MyDefs;
import java.io.PrintStream;
import java.io.RandomAccessFile;
import java.util.HashMap;
import java.util.Map;

public class LASindex {
    private static final PrintStream stderr = System.err;
    public int start = 0;
    public int end = 0;
    public int full = 0;
    public int total = 0;
    public int cells = 0;
    private LASquadtree spatial = null;
    private LASinterval interval = null;
    private boolean have_interval = Boolean.FALSE;

    public void prepare(LASquadtree spatial, int threshold) {
        this.spatial = spatial;
        this.interval = new LASinterval(threshold);
    }

    public boolean add(double x, double y, int p_index) {
        int cell = this.spatial.get_cell_index(x, y);
        return this.interval.add(p_index, cell);
    }

    public void complete(int u_minimum_points, int maximum_intervals) {
        this.complete(u_minimum_points, maximum_intervals, true);
    }

    void complete(int u_minimum_points, int maximum_intervals, boolean verbose) {
        if (verbose) {
            Cstdio.fprintf(stderr, "before complete %d %d\n", u_minimum_points, maximum_intervals);
            this.print(Boolean.FALSE);
        }
        if (u_minimum_points != 0) {
            int hash1 = 0;
            my_cell_hash[] cell_hash = new my_cell_hash[2];
            for (int i = 0; i < cell_hash.length; ++i) {
                cell_hash[i] = new my_cell_hash();
            }
            this.interval.get_cells();
            while (this.interval.has_cells()) {
                cell_hash[hash1].put(this.interval.index, this.interval.full);
            }
            while (cell_hash[hash1].size() != 0) {
                int hash2 = (hash1 + 1) % 2;
                cell_hash[hash2].clear();
                boolean coarsened = Boolean.FALSE;
                int[] coarser_index = new int[1];
                int[] num_indices = new int[1];
                int[][] indices = new int[1][];
                for (Map.Entry hash_element_outer : cell_hash[hash1].entrySet()) {
                    if ((Integer)hash_element_outer.getValue() == 0 || !this.spatial.coarsen((Integer)hash_element_outer.getKey(), coarser_index, num_indices, indices)) continue;
                    int full = 0;
                    int num_filled = 0;
                    for (int i = 0; i < num_indices[0]; ++i) {
                        Integer value;
                        Integer key;
                        if ((Integer)hash_element_outer.getKey() == indices[0][i]) {
                            key = (Integer)hash_element_outer.getKey();
                            value = (Integer)hash_element_outer.getValue();
                        } else {
                            key = indices[0][i];
                            value = (Integer)cell_hash[hash1].get(indices[0][i]);
                        }
                        if (value == null) continue;
                        full += value.intValue();
                        cell_hash[hash1].put(key, 0);
                        ++num_filled;
                    }
                    if (Integer.compareUnsigned(full, u_minimum_points) >= 0 || num_filled != num_indices[0]) continue;
                    this.interval.merge_cells(num_indices[0], indices[0], coarser_index[0]);
                    coarsened = Boolean.TRUE;
                    cell_hash[hash2].put(coarser_index[0], full);
                }
                if (!coarsened) break;
                hash1 = (hash1 + 1) % 2;
            }
            this.interval.get_cells();
            while (this.interval.has_cells()) {
                this.spatial.manage_cell(this.interval.index);
            }
            if (verbose) {
                Cstdio.fprintf(stderr, "after minimum_points %d\n", u_minimum_points);
                this.print(Boolean.FALSE);
            }
        }
        if (maximum_intervals < 0) {
            maximum_intervals = -maximum_intervals * this.interval.get_number_cells();
        }
        if (maximum_intervals != 0) {
            this.interval.merge_intervals(maximum_intervals, verbose);
            if (verbose) {
                Cstdio.fprintf(stderr, "after maximum_intervals %d\n", maximum_intervals);
                this.print(Boolean.FALSE);
            }
        }
    }

    void print(boolean verbose) {
        int total_cells = 0;
        int total_full = 0;
        int total_total = 0;
        int total_intervals = 0;
        this.interval.get_cells();
        while (this.interval.has_cells()) {
            int total_check = 0;
            int intervals = 0;
            while (this.interval.has_intervals()) {
                total_check += this.interval.end - this.interval.start + 1;
                ++intervals;
            }
            if (total_check != this.interval.total) {
                Cstdio.fprintf(stderr, "ERROR: total_check %d != interval.total %d\n", total_check, this.interval.total);
            }
            if (verbose) {
                Cstdio.fprintf(stderr, "cell %d intervals %d full %d total %d (%.2f)\n", this.interval.index, intervals, this.interval.full, this.interval.total, Float.valueOf(100.0f * (float)this.interval.full / (float)this.interval.total));
            }
            ++total_cells;
            total_full += this.interval.full;
            total_total += this.interval.total;
            total_intervals += intervals;
        }
        if (verbose) {
            Cstdio.fprintf(stderr, "total cells/intervals %d/%d full %d (%.2f)\n", total_cells, total_intervals, total_full, Float.valueOf(100.0f * (float)total_full / (float)total_total));
        }
    }

    LASquadtree get_spatial() {
        return this.spatial;
    }

    LASinterval get_interval() {
        return this.interval;
    }

    public boolean intersect_rectangle(double r_min_x, double r_min_y, double r_max_x, double r_max_y) {
        this.have_interval = Boolean.FALSE;
        this.cells = this.spatial.intersect_rectangle(r_min_x, r_min_y, r_max_x, r_max_y);
        if (this.cells != 0) {
            return this.merge_intervals();
        }
        return Boolean.FALSE;
    }

    public boolean intersect_tile(float ll_x, float ll_y, float size) {
        this.have_interval = Boolean.FALSE;
        this.cells = this.spatial.intersect_tile(ll_x, ll_y, size);
        if (this.cells != 0) {
            return this.merge_intervals();
        }
        return Boolean.FALSE;
    }

    public boolean intersect_circle(double center_x, double center_y, double radius) {
        this.have_interval = Boolean.FALSE;
        this.cells = this.spatial.intersect_circle(center_x, center_y, radius);
        if (this.cells != 0) {
            return this.merge_intervals();
        }
        return Boolean.FALSE;
    }

    boolean get_intervals() {
        this.have_interval = Boolean.FALSE;
        return this.interval.get_merged_cell();
    }

    boolean has_intervals() {
        if (this.interval.has_intervals()) {
            this.start = this.interval.start;
            this.end = this.interval.end;
            this.full = this.interval.full;
            this.have_interval = Boolean.TRUE;
            return Boolean.TRUE;
        }
        this.have_interval = Boolean.FALSE;
        return Boolean.FALSE;
    }

    public boolean read(String file_name) {
        if (file_name == null) {
            return Boolean.FALSE;
        }
        char[] name = file_name.toCharArray();
        if (LASindex.strstr(file_name, ".las") || LASindex.strstr(file_name, ".laz")) {
            name[Cstring.strlen((char[])name) - 1] = 120;
        } else if (LASindex.strstr(file_name, ".LAS") || LASindex.strstr(file_name, ".LAZ")) {
            name[Cstring.strlen((char[])name) - 1] = 88;
        } else {
            name[Cstring.strlen((char[])name) - 3] = 108;
            name[Cstring.strlen((char[])name) - 2] = 97;
            name[Cstring.strlen((char[])name) - 1] = 120;
        }
        RandomAccessFile file = Cstdio.fopenRAF(name, "rb");
        if (file == null) {
            return Boolean.FALSE;
        }
        ByteStreamInFile stream = new ByteStreamInFile(file);
        if (!this.read(stream)) {
            Cstdio.fprintf(stderr, "ERROR (LASindex): cannot read '%s'\n", new String(name));
            Cstdio.fclose(file);
            return Boolean.FALSE;
        }
        Cstdio.fclose(file);
        return Boolean.TRUE;
    }

    public boolean append(String file_name) {
        LASreadOpener lasreadopener = new LASreadOpener();
        if (file_name == null) {
            return Boolean.FALSE;
        }
        LASreader lasreader = lasreadopener.open(file_name);
        if (lasreader == null) {
            return Boolean.FALSE;
        }
        if (lasreader.header.laszip == null) {
            return Boolean.FALSE;
        }
        lasreader.close();
        RandomAccessFile file = Cstdio.fopenRAF(file_name.toCharArray(), "rb");
        ByteStreamInFile bytestreamin = new ByteStreamInFile(file);
        long offset_laz_vlr = -1L;
        long number_of_special_evlrs = lasreader.header.laszip.number_of_special_evlrs;
        long offset_to_special_evlrs = lasreader.header.laszip.offset_to_special_evlrs;
        if (number_of_special_evlrs == -1L && offset_to_special_evlrs == -1L) {
            bytestreamin.seekEnd();
            number_of_special_evlrs = 1L;
            offset_to_special_evlrs = ((ByteStreamIn)bytestreamin).tell();
            long total = lasreader.header.header_size + 2;
            int number_of_variable_length_records = lasreader.header.number_of_variable_length_records + 1 + LASindex.asInt(lasreader.header.vlr_lastiling != null) + LASindex.asInt(lasreader.header.vlr_lasoriginal != null);
            for (int u = 0; u < number_of_variable_length_records; ++u) {
                char record_length_after_header;
                ((ByteStreamIn)bytestreamin).seek(total);
                byte[] user_id = new byte[16];
                try {
                    ((ByteStreamIn)bytestreamin).getBytes(user_id, 16);
                }
                catch (Exception e) {
                    Cstdio.fprintf(stderr, "ERROR: reading header.vlrs[%d].user_id\n", u);
                    return Boolean.FALSE;
                }
                if (MyDefs.stringFromByteArray(user_id).startsWith("laszip encoded")) {
                    offset_laz_vlr = ((ByteStreamIn)bytestreamin).tell() - 18L;
                    break;
                }
                try {
                    char record_id = ((ByteStreamIn)bytestreamin).get16bitsLE();
                }
                catch (Exception e) {
                    Cstdio.fprintf(stderr, "ERROR: reading header.vlrs[%d].record_id\n", u);
                    return Boolean.FALSE;
                }
                try {
                    record_length_after_header = ((ByteStreamIn)bytestreamin).get16bitsLE();
                }
                catch (Exception e) {
                    Cstdio.fprintf(stderr, "ERROR: reading header.vlrs[%d].record_length_after_header\n", u);
                    return Boolean.FALSE;
                }
                total += (long)(54 + record_length_after_header);
            }
            if (number_of_special_evlrs == -1L) {
                return Boolean.FALSE;
            }
        }
        Cstdio.fclose(file);
        file = Cstdio.fopenRAF(file_name.toCharArray(), "rb+");
        ByteStreamOutFile bytestreamout = new ByteStreamOutFile(file);
        ((ByteStreamOut)bytestreamout).seek(offset_to_special_evlrs);
        LASevlr lax_evlr = new LASevlr();
        Cstdio.sprintf(lax_evlr.user_id, "LAStools", new Object[0]);
        lax_evlr.record_id = (char)30;
        Cstdio.sprintf(lax_evlr.description, "LAX spatial indexing (LASindex)", new Object[0]);
        ((ByteStreamOut)bytestreamout).put16bitsLE(lax_evlr.reserved);
        ((ByteStreamOut)bytestreamout).putBytes(lax_evlr.user_id, 16);
        ((ByteStreamOut)bytestreamout).put16bitsLE(lax_evlr.record_id);
        ((ByteStreamOut)bytestreamout).put64bitsLE(lax_evlr.record_length_after_header);
        ((ByteStreamOut)bytestreamout).putBytes(lax_evlr.description, 32);
        if (!this.write(bytestreamout)) {
            Cstdio.fprintf(stderr, "ERROR (LASindex): cannot append LAX to '%s'\n", file_name);
            Cstdio.fclose(file);
            return Boolean.FALSE;
        }
        lax_evlr.record_length_after_header = ((ByteStreamOut)bytestreamout).tell() - offset_to_special_evlrs - 60L;
        ((ByteStreamOut)bytestreamout).seek(offset_to_special_evlrs + 20L);
        ((ByteStreamOut)bytestreamout).put64bitsLE(lax_evlr.record_length_after_header);
        if (number_of_special_evlrs != -1L) {
            ((ByteStreamOut)bytestreamout).seek(offset_laz_vlr + 54L + 16L);
            ((ByteStreamOut)bytestreamout).put64bitsLE(number_of_special_evlrs);
            ((ByteStreamOut)bytestreamout).put64bitsLE(offset_to_special_evlrs);
        }
        ((ByteStreamOut)bytestreamout).seekEnd();
        Cstdio.fclose(file);
        return Boolean.TRUE;
    }

    public boolean write(String file_name) {
        if (file_name == null) {
            return Boolean.FALSE;
        }
        char[] name = file_name.toCharArray();
        if (LASindex.strstr(file_name, ".las") || LASindex.strstr(file_name, ".laz")) {
            name[Cstring.strlen((char[])name) - 1] = 120;
        } else if (LASindex.strstr(file_name, ".LAS") || LASindex.strstr(file_name, ".LAZ")) {
            name[Cstring.strlen((char[])name) - 1] = 88;
        } else {
            name[Cstring.strlen((char[])name) - 3] = 108;
            name[Cstring.strlen((char[])name) - 2] = 97;
            name[Cstring.strlen((char[])name) - 1] = 120;
        }
        RandomAccessFile file = Cstdio.fopenRAF(name, "wb");
        if (file == null) {
            Cstdio.fprintf(stderr, "ERROR (LASindex): cannot open '%s' for write\n", new String(name));
            return Boolean.FALSE;
        }
        ByteStreamOutFile stream = new ByteStreamOutFile(file);
        if (!this.write(stream)) {
            Cstdio.fprintf(stderr, "ERROR (LASindex): cannot write '%s'\n", new String(name));
            Cstdio.fclose(file);
            return Boolean.FALSE;
        }
        Cstdio.fclose(file);
        return Boolean.TRUE;
    }

    public boolean read(ByteStreamIn stream) {
        if (this.spatial != null) {
            this.spatial = null;
        }
        if (this.interval != null) {
            this.interval = null;
        }
        byte[] signature = new byte[4];
        try {
            stream.getBytes(signature, 4);
        }
        catch (Exception e) {
            Cstdio.fprintf(stderr, "ERROR (LASindex): reading signature\n", new Object[0]);
            return Boolean.FALSE;
        }
        if (Cstring.strncmp(MyDefs.stringFromByteArray(signature), "LASX", 4) != 0) {
            Cstdio.fprintf(stderr, "ERROR (LASindex): wrong signature %4s instead of 'LASX'\n", MyDefs.stringFromByteArray(signature));
            return Boolean.FALSE;
        }
        try {
            int version = stream.get32bitsLE();
        }
        catch (Exception e) {
            Cstdio.fprintf(stderr, "ERROR (LASindex): reading version\n", new Object[0]);
            return Boolean.FALSE;
        }
        this.spatial = new LASquadtree();
        if (!this.spatial.read(stream)) {
            Cstdio.fprintf(stderr, "ERROR (LASindex): cannot read LASspatial (LASquadtree)\n", new Object[0]);
            return Boolean.FALSE;
        }
        this.interval = new LASinterval();
        if (!this.interval.read(stream)) {
            Cstdio.fprintf(stderr, "ERROR (LASindex): reading LASinterval\n", new Object[0]);
            return Boolean.FALSE;
        }
        this.interval.get_cells();
        while (this.interval.has_cells()) {
            this.spatial.manage_cell(this.interval.index);
        }
        return Boolean.TRUE;
    }

    boolean write(ByteStreamOut stream) {
        if (!stream.putBytes(MyDefs.asByteArray("LASX"), 4)) {
            Cstdio.fprintf(stderr, "ERROR (LASindex): writing signature\n", new Object[0]);
            return Boolean.FALSE;
        }
        int version = 0;
        if (!stream.put32bitsLE(version)) {
            Cstdio.fprintf(stderr, "ERROR (LASindex): writing version\n", new Object[0]);
            return Boolean.FALSE;
        }
        if (!this.spatial.write(stream)) {
            Cstdio.fprintf(stderr, "ERROR (LASindex): cannot write LASspatial (LASquadtree)\n", new Object[0]);
            return Boolean.FALSE;
        }
        if (!this.interval.write(stream)) {
            Cstdio.fprintf(stderr, "ERROR (LASindex): writing LASinterval\n", new Object[0]);
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    public boolean seek_next(LASreader lasreader) {
        if (!this.have_interval) {
            if (!this.has_intervals()) {
                return Boolean.FALSE;
            }
            lasreader.seek(this.start);
        }
        if (lasreader.p_count == (long)this.end) {
            this.have_interval = Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    boolean merge_intervals() {
        if (this.spatial.get_intersected_cells()) {
            int used_cells = 0;
            while (this.spatial.has_more_cells()) {
                if (!this.interval.get_cell(this.spatial.current_cell)) continue;
                this.interval.add_current_cell_to_merge_cell_set();
                ++used_cells;
            }
            if (used_cells != 0) {
                boolean r = this.interval.merge();
                this.full = this.interval.full;
                this.total = this.interval.total;
                this.interval.clear_merge_cell_set();
                return r;
            }
        }
        return Boolean.FALSE;
    }

    private static boolean strstr(String s1, String s2) {
        return s1.contains(s2);
    }

    private static int asInt(boolean b) {
        return b ? 1 : 0;
    }

    private static class my_cell_hash
    extends HashMap<Integer, Integer> {
        private my_cell_hash() {
        }
    }
}

