/*
 * Decompiled with CFR 0.152.
 */
package com.github.mreutegg.laszip4j.laszip;

import java.nio.ByteBuffer;
import java.util.Arrays;

public class LASwavepacket {
    private byte index;
    private long u_offset;
    private int u_size;
    private float location;
    private float x;
    private float y;
    private float z;
    private final ByteBuffer data = ByteBuffer.allocate(29);

    public LASwavepacket() {
        this.zero();
    }

    public void zero() {
        Arrays.fill(this.data.array(), (byte)0);
    }

    public byte getIndex() {
        return this.data.get(0);
    }

    public long getOffset() {
        return this.data.getLong(1);
    }

    public int getSize() {
        return this.data.getInt(9);
    }

    public float getLocation() {
        return this.data.getFloat(13);
    }

    public float getXt() {
        return this.data.getFloat(17);
    }

    public float getYt() {
        return this.data.getFloat(21);
    }

    public float getZt() {
        return this.data.getFloat(25);
    }

    public void setIndex(byte index) {
        this.data.put(0, index);
    }

    public void setOffset(long u_offset) {
        this.data.putLong(1, u_offset);
    }

    public void setSize(int u_size) {
        this.data.putInt(9, u_size);
    }

    public void setLocation(float location) {
        this.data.putFloat(13, location);
    }

    public void setXt(float xt) {
        this.data.putFloat(17, xt);
    }

    public void setYt(float yt) {
        this.data.putFloat(21, yt);
    }

    public void setZt(float zt) {
        this.data.putFloat(25, zt);
    }

    public void flipDirection() {
        this.setXt(this.getXt() * -1.0f);
        this.setYt(this.getYt() * -1.0f);
        this.setZt(this.getZt() * -1.0f);
    }

    public byte[] asByteArray() {
        return this.data.array();
    }
}

