/*
 * Decompiled with CFR 0.152.
 */
package org.tinfour.common;

import java.util.ArrayList;
import java.util.List;
import org.tinfour.common.IConstraint;
import org.tinfour.common.PolyLineConstraintAdapter;
import org.tinfour.common.Vertex;

public class LinearConstraint
extends PolyLineConstraintAdapter
implements IConstraint {
    public LinearConstraint() {
    }

    public LinearConstraint(Vertex v0, Vertex v1) {
        this.add(v0);
        this.add(v1);
        this.complete();
    }

    public LinearConstraint(List<Vertex> vList) {
        super(vList);
    }

    @Override
    public final void complete() {
        this.isComplete = true;
    }

    @Override
    public boolean isPolygon() {
        return false;
    }

    @Override
    public boolean definesConstrainedRegion() {
        return false;
    }

    @Override
    public double getNominalPointSpacing() {
        if (this.list.size() < 2) {
            return Double.NaN;
        }
        return this.length / (double)(this.list.size() - 1);
    }

    @Override
    public LinearConstraint getConstraintWithNewGeometry(List<Vertex> geometry) {
        LinearConstraint c = new LinearConstraint(geometry);
        c.applicationData = this.applicationData;
        c.constraintIndex = this.constraintIndex;
        c.maintainingTin = this.maintainingTin;
        c.constraintLinkingEdge = this.constraintLinkingEdge;
        c.complete();
        return c;
    }

    @Override
    public LinearConstraint refactor(Iterable<Vertex> geometry) {
        ArrayList<Vertex> gList = new ArrayList<Vertex>();
        for (Vertex v : geometry) {
            gList.add(v);
        }
        return this.getConstraintWithNewGeometry(gList);
    }

    @Override
    public boolean isValid() {
        return this.list.size() >= 2;
    }
}

