/*
 * Decompiled with CFR 0.152.
 */
package org.tinfour.demo.development.cdt;

import java.awt.Dimension;
import java.io.PrintStream;
import java.util.List;
import org.tinfour.common.IConstraint;
import org.tinfour.common.IIncrementalTin;
import org.tinfour.common.IIntegrityCheck;
import org.tinfour.common.LinearConstraint;
import org.tinfour.common.Vertex;
import org.tinfour.demo.development.cdt.RandomConstraintTestOptions;
import org.tinfour.demo.development.cdt.TestPanelForCdt;
import org.tinfour.interpolation.IInterpolatorOverTin;

public class RandomConstraintTestView {
    IIncrementalTin tin;
    TestPanelForCdt testPanel;
    IInterpolatorOverTin interpolator;
    LinearConstraint linCon = new LinearConstraint();
    boolean cavitationPerformed;
    int nClicks;

    public static void main(String[] args) {
        RandomConstraintTestView test = new RandomConstraintTestView();
        test.process(System.out, args);
    }

    private void process(PrintStream ps, String[] args) {
        boolean[] argsRecognized = new boolean[args.length];
        RandomConstraintTestOptions options = new RandomConstraintTestOptions(args, argsRecognized);
        options.printSummary(ps);
        List<Vertex> vertices = options.makeRandomVertices(0);
        List<IConstraint> constraints = options.makeConstraints(0);
        this.tin = options.makeNewInstanceOfTestTin();
        this.tin.add(vertices, null);
        this.tin.addConstraints(constraints, options.restoreConformity);
        int vertexSeed = options.getVertexSeed(0);
        int constraintSeed = options.getConstraintSeed(0);
        this.testPanel = TestPanelForCdt.plot(this.tin, "View constraints from random vertexSeed " + vertexSeed + ", constraintSeed " + constraintSeed);
        this.testPanel.setSize(new Dimension(800, 800));
        this.testPanel.setValueLabelEnabled(false);
        this.testPanel.setValueLabelFormat("%1.0f");
        this.testPanel.setIndexLabelEnabled(true);
        for (IConstraint con : constraints) {
            List<Vertex> vList = con.getVertices();
            Vertex[] vArray = vList.toArray(new Vertex[vList.size()]);
            this.testPanel.addChainToSpecialList(vArray);
        }
        IIntegrityCheck iCheck = this.tin.getIntegrityCheck();
        boolean inspect = iCheck.inspect();
        System.out.println("Integrity check status=" + inspect);
        iCheck.printSummary(ps);
    }
}

