/*
 * Decompiled with CFR 0.152.
 */
package org.tinfour.demo.utils;

import org.tinfour.common.IIncrementalTin;
import org.tinfour.gwr.GwrTinInterpolator;
import org.tinfour.interpolation.IInterpolatorOverTin;
import org.tinfour.interpolation.NaturalNeighborInterpolator;
import org.tinfour.interpolation.TriangularFacetInterpolator;

public enum InterpolationMethod {
    NaturalNeighbor,
    TriangularFacet,
    GeographicallyWeightedRegression;


    public static InterpolationMethod lenientValue(String target) {
        if (target != null) {
            String s = target.trim().toLowerCase();
            if (s.startsWith("nat")) {
                return NaturalNeighbor;
            }
            if (s.startsWith("tri")) {
                return TriangularFacet;
            }
            if (s.contains("regress") || s.startsWith("gwr")) {
                return GeographicallyWeightedRegression;
            }
        }
        return null;
    }

    public IInterpolatorOverTin getInterpolator(IIncrementalTin tin) {
        switch (this) {
            case TriangularFacet: {
                return new TriangularFacetInterpolator(tin);
            }
            case GeographicallyWeightedRegression: {
                return new GwrTinInterpolator(tin);
            }
        }
        return new NaturalNeighborInterpolator(tin);
    }
}

