/*
 * Decompiled with CFR 0.152.
 */
package org.tinfour.demo.utils;

import java.text.ParseException;

public class TextCoordCartesian {
    private static final double LN10 = Math.log(10.0);

    private int iLog10(double test) {
        if (test == 0.0 || Double.isNaN(test)) {
            return 0;
        }
        if (Double.isInfinite(test)) {
            return 306;
        }
        return (int)Math.floor(Math.log(Math.abs(test)) / LN10 + 1.0E-9);
    }

    public double[] parse(String text) throws ParseException {
        StringBuilder numStr = new StringBuilder(256);
        if (text == null) {
            throw new ParseException("Null input", 0);
        }
        int i0 = -1;
        for (int i = 0; i < text.length(); ++i) {
            char c = text.charAt(i);
            if (Character.isWhitespace(c)) continue;
            i0 = i;
            break;
        }
        if (i0 == -1) {
            throw new ParseException("Empty input", 0);
        }
        int nV = 0;
        double[] v = new double[2];
        for (int i = i0; i < text.length(); ++i) {
            char c = text.charAt(i);
            if (Character.isWhitespace(c) || c == ',') {
                if (numStr.length() <= 0) continue;
                try {
                    double test = Double.parseDouble(numStr.toString());
                    if (nV == 2) {
                        throw new ParseException("Too many values", i);
                    }
                    v[nV++] = test;
                    numStr.setLength(0);
                    continue;
                }
                catch (NumberFormatException nex) {
                    throw new ParseException("Invalid numeric " + numStr.toString(), i);
                }
            }
            numStr.append(c);
        }
        if (numStr.length() > 0 && nV < 2) {
            try {
                double test = Double.parseDouble(numStr.toString());
                v[nV++] = test;
                numStr.setLength(0);
            }
            catch (NumberFormatException nex) {
                throw new ParseException("Invalid numeric " + numStr.toString(), text.length() - 1);
            }
        }
        if (nV < 2) {
            throw new ParseException("Incomplete specification", text.length());
        }
        return v;
    }

    public String format(double x, double y) {
        String sx = this.formatV(x);
        String sy = this.formatV(y);
        return sx + ", " + sy;
    }

    private String formatV(double v) {
        int test = this.iLog10(v);
        if (test > 5) {
            return String.format("%5.3f", v);
        }
        if (test >= 1) {
            return String.format("%6.4f", v);
        }
        if (test > -3) {
            return String.format("%8.6f", v);
        }
        return Double.toString(v);
    }
}

