/*
 * Decompiled with CFR 0.152.
 */
package org.tinfour.gis.utils;

import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.tinfour.common.IConstraint;
import org.tinfour.common.LinearConstraint;
import org.tinfour.common.PolyLineConstraintAdapter;
import org.tinfour.common.PolygonConstraint;
import org.tinfour.common.Vertex;
import org.tinfour.gis.shapefile.DbfField;
import org.tinfour.gis.shapefile.DbfFileReader;
import org.tinfour.gis.shapefile.ShapefileReader;
import org.tinfour.gis.shapefile.ShapefileRecord;
import org.tinfour.gis.shapefile.ShapefileType;
import org.tinfour.gis.utils.ConstraintVertex;
import org.tinfour.gis.utils.IVerticalCoordinateTransform;
import org.tinfour.utils.loaders.CoordinatePair;
import org.tinfour.utils.loaders.ICoordinateTransform;
import org.tinfour.utils.loaders.SimpleGeographicTransform;

public class ConstraintReaderShapefile
implements Closeable {
    private final ShapefileReader reader;
    private int nPointsTotal;
    boolean isSourceInGeographicCoordinates;
    boolean geographicCoordinates;
    ICoordinateTransform coordinateTransform;
    IVerticalCoordinateTransform verticalCoordinateTransform;
    String dbfFieldForZ;
    String dbfFieldForAppData;

    private ConstraintReaderShapefile() {
        this.reader = null;
    }

    public ConstraintReaderShapefile(File file) throws IOException {
        this.reader = new ShapefileReader(file);
    }

    public List<IConstraint> read() throws IOException {
        ArrayList<IConstraint> conList = new ArrayList<IConstraint>();
        try (DbfFileReader dbfReader = this.reader.getDbfFileReader();){
            DbfField zField = null;
            DbfField appField = null;
            ShapefileType shapefileType = this.reader.getShapefileType();
            if (!(this.dbfFieldForZ == null || (zField = dbfReader.getFieldByName(this.dbfFieldForZ)) != null && zField.isNumeric())) {
                throw new IOException("Specified field for Z coordinates, " + this.dbfFieldForZ + " is not found or not numeric");
            }
            if (this.dbfFieldForAppData != null && (appField = dbfReader.getFieldByName(this.dbfFieldForAppData)) == null) {
                throw new IOException("Specified field for application data, " + this.dbfFieldForAppData + " not found");
            }
            CoordinatePair scratch = new CoordinatePair();
            int vertexID = 0;
            ShapefileRecord record = null;
            block12: while (this.reader.hasNext()) {
                record = this.reader.readNextRecord(record);
                boolean useShapefileZ = true;
                double dbfZ = 0.0;
                Object dbfA = null;
                if (zField != null) {
                    dbfReader.readField(record.recordNumber, zField);
                    dbfZ = zField.getDouble();
                    useShapefileZ = false;
                }
                if (appField != null) {
                    dbfReader.readField(record.recordNumber, appField);
                    dbfA = appField.getApplicationData();
                }
                switch (shapefileType) {
                    case PolyLineZ: 
                    case PolygonZ: 
                    case Polygon: 
                    case PolyLine: {
                        this.nPointsTotal += record.nPoints;
                        int k = 0;
                        for (int iPart = 0; iPart < record.nParts; ++iPart) {
                            ConstraintVertex v;
                            double z;
                            double y;
                            double x;
                            int i;
                            int n;
                            PolyLineConstraintAdapter con;
                            if (shapefileType.isPolygon()) {
                                con = new PolygonConstraint();
                                n = record.partStart[iPart + 1] - record.partStart[iPart];
                                for (i = n - 1; i >= 0; --i) {
                                    k = (record.partStart[iPart] + i) * 3;
                                    x = record.xyz[k];
                                    y = record.xyz[k + 1];
                                    z = useShapefileZ ? record.xyz[k + 2] : dbfZ;
                                    if (this.verticalCoordinateTransform != null) {
                                        z = this.verticalCoordinateTransform.transform(record.recordNumber, z);
                                    }
                                    if (this.coordinateTransform != null) {
                                        this.coordinateTransform.forward(x, y, scratch);
                                        x = scratch.x;
                                        y = scratch.y;
                                    }
                                    v = new ConstraintVertex(x, y, z, vertexID++);
                                    con.add(v);
                                }
                            } else {
                                con = new LinearConstraint();
                                n = record.partStart[iPart + 1] - record.partStart[iPart];
                                for (i = 0; i < n; ++i) {
                                    x = record.xyz[k++];
                                    y = record.xyz[k++];
                                    if (useShapefileZ) {
                                        z = record.xyz[k++];
                                    } else {
                                        z = dbfZ;
                                        ++k;
                                    }
                                    if (this.verticalCoordinateTransform != null) {
                                        z = this.verticalCoordinateTransform.transform(record.recordNumber, z);
                                    }
                                    if (this.coordinateTransform != null) {
                                        this.coordinateTransform.forward(x, y, scratch);
                                        x = scratch.x;
                                        y = scratch.y;
                                    }
                                    v = new ConstraintVertex(x, y, z, vertexID++);
                                    con.add(v);
                                }
                            }
                            if (appField == null) {
                                con.setApplicationData(record.recordNumber);
                            } else {
                                con.setApplicationData(dbfA);
                            }
                            con.complete();
                            conList.add(con);
                        }
                        continue block12;
                    }
                }
            }
        }
        return conList;
    }

    public int getTotalPointCount() {
        return this.nPointsTotal;
    }

    public static void writeConstraintFile(File file, List<IConstraint> list) throws IOException {
        Path path = file.toPath();
        ConstraintReaderShapefile.writeConstraintFile(path, list);
    }

    public static void writeConstraintFile(Path path, List<IConstraint> list) throws IOException {
        try (BufferedWriter w = Files.newBufferedWriter(path, new OpenOption[0]);){
            for (IConstraint constraint : list) {
                List<Vertex> vertices = constraint.getVertices();
                String conType = "";
                if (constraint instanceof PolygonConstraint) {
                    conType = ", polygon";
                } else if (constraint instanceof LinearConstraint) {
                    conType = ", linear";
                }
                w.write(String.format(Locale.ENGLISH, "%d%s%n", vertices.size(), conType));
                for (Vertex vertex : vertices) {
                    w.write(String.format(Locale.ENGLISH, "%s,%s,%s%n", vertex.x, vertex.y, vertex.getZ()));
                }
            }
        }
    }

    public ICoordinateTransform getCoordinateTransform() {
        return this.coordinateTransform;
    }

    public void setCoordinateTransform(ICoordinateTransform transform) {
        this.coordinateTransform = transform;
        this.geographicCoordinates = transform instanceof SimpleGeographicTransform;
    }

    public void setVerticalCoordinateTransform(IVerticalCoordinateTransform verticalTransform) {
        this.verticalCoordinateTransform = verticalTransform;
    }

    public void setDbfFieldForZ(String dbfFieldForZ) {
        if (dbfFieldForZ != null) {
            this.dbfFieldForZ = dbfFieldForZ.trim();
            if (this.dbfFieldForZ.isEmpty()) {
                this.dbfFieldForZ = null;
            }
        } else {
            this.dbfFieldForZ = null;
        }
    }

    public void setDbfFieldForAppData(String dbfFieldForAppData) {
        if (dbfFieldForAppData != null) {
            this.dbfFieldForAppData = dbfFieldForAppData.trim();
            if (this.dbfFieldForAppData.isEmpty()) {
                this.dbfFieldForAppData = null;
            }
        } else {
            this.dbfFieldForAppData = null;
        }
    }

    @Override
    public void close() throws IOException {
        this.reader.close();
    }
}

