/*
 * Decompiled with CFR 0.152.
 */
package org.tinfour.test.performance;

import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Random;
import java.util.SimpleTimeZone;
import org.tinfour.common.IIncrementalTin;
import org.tinfour.common.Vertex;
import org.tinfour.demo.utils.IDevelopmentTest;
import org.tinfour.demo.utils.TestOptions;
import org.tinfour.demo.utils.VertexLoader;
import org.tinfour.gis.las.ILasRecordFilter;
import org.tinfour.gis.las.LasPoint;

public class TimeDueToSampleSize
implements IDevelopmentTest {
    private static final String[] usage = new String[]{"usage: TimeDueToSampleSize", "   Mandatory Arguments:", "       -in <valid LAS file or sample-point text file>", "   Optional Arguments:", "       -tinClass <class>  the full path of the class to be tested", "                          for example: tinfour.standard.IncrementalTin", "       -lidarClass <int> value in the range 0 to 255, default: not applied", "       -preallocate, -noPreallocate  boolean, default noPreAlloc", "                                     preallocation permits a test to", "                                     separate the cost of object creation", "                                     from the algorithm-based", "                                     cost of processing", "       -preSort,  -noPreSort         boolean, dfault noPreSort", "       -randomSize <float> randomly select a subset of points. If supplied", "                           the thinning factor must be greater than zero", "                           and less than or equal to 1.0. The most", "                           common value is 1.0, though smaller values may", "                           be used when an input file is so large that", "                           it becomes unweildy.", "                           The thinning factor is used to randomly ", "                           select a subset of points so that the effect", "                           of relative sample sizes can be assessed.", "                           When not supplied, the full set of vertices is", "                           processed by each iteration."};

    public static void main(String[] args) {
        PrintStream ps = System.out;
        TimeDueToSampleSize test = new TimeDueToSampleSize();
        try {
            test.runTest(ps, args);
        }
        catch (IOException | IllegalArgumentException ex) {
            ps.println("Exception caught performing test " + ex.getMessage());
            ex.printStackTrace(ps);
        }
    }

    @Override
    public void runTest(PrintStream ps, String[] args) throws IOException {
        if (args.length == 0) {
            for (String s : usage) {
                ps.println(s);
            }
            return;
        }
        TestOptions options = new TestOptions();
        boolean[] recognized = options.argumentScan(args);
        File target = options.getInputFile();
        Class<?> tinClass = options.getTinClass();
        Double randomSize = options.scanDoubleOption(args, "-randomSize", recognized);
        if (randomSize != null && (randomSize <= 0.0 || randomSize > 1.0)) {
            throw new IllegalArgumentException("Random size " + randomSize + " is not in valid range >0 to 1.0");
        }
        options.checkForUnrecognizedArgument(args, recognized);
        long seed = options.getRandomSeed(0L);
        Random random = new Random(seed);
        int classification = options.getLidarClass();
        int nTests = options.getTestCount(10);
        boolean prealloc = options.isPreAllocateEnabled(false);
        boolean presort = options.isPreSortEnabled(false);
        VertexLoader loader = new VertexLoader();
        loader.setPreSortEnabed(true);
        List<Vertex> masterList = loader.readInputFile(options);
        int nMasterVertices = masterList.size();
        Date date = new Date();
        SimpleDateFormat sdFormat = new SimpleDateFormat("dd MMM yyyy HH:mm", Locale.getDefault());
        sdFormat.setTimeZone(new SimpleTimeZone(0, "UTC"));
        String dateString = sdFormat.format(date);
        ps.println("Date of test:     " + dateString);
        ps.println("TIN Class:        " + tinClass.getName());
        ps.println("File:             " + options.getInputFile().getCanonicalPath());
        ps.println("Random size:      " + (randomSize == null ? "Unspecified, Use full size" : "0 to " + Double.toString(randomSize)));
        ps.println("Lidar class:      " + classification);
        ps.println("Pre-allocate:     " + prealloc);
        ps.println("Pre-sort:         " + presort);
        ps.println("Seed:             " + seed);
        ps.println("N Tests:          " + nTests);
        ps.println("Max Samples:      " + nMasterVertices);
        ps.println("");
        for (int iPretest = 0; iPretest < 3; ++iPretest) {
            ps.println("Running Pre-Test " + iPretest);
            IIncrementalTin tin = options.getNewInstanceOfTestTin();
            if (tin == null) {
                return;
            }
            tin.add(masterList, null);
            tin.dispose();
            this.getUsedMemory();
        }
        long mem0 = this.getUsedMemory();
        ps.println("Pre-test complete, memory=" + (double)mem0 / 1024.0 / 1024.0);
        ArrayList<Result> resultList = new ArrayList<Result>();
        ps.println("   n_vertices,   m_vertices, time_ms,    used_mb,     total_mb,  used_bytes");
        for (int iThin = 1; iThin <= nTests; ++iThin) {
            mem0 = this.getUsedMemory();
            double thinningFactor = 1.0;
            if (randomSize != null && randomSize > 0.0) {
                thinningFactor = randomSize * random.nextDouble();
            }
            if (thinningFactor < 0.025) {
                thinningFactor = 0.025;
            }
            ArrayList<Vertex> vertexList = new ArrayList<Vertex>();
            int skip = (int)Math.ceil(1.0 / thinningFactor);
            for (int i = 0; i < nMasterVertices; i += skip) {
                vertexList.add(masterList.get(i));
            }
            int nVertices = vertexList.size();
            IIncrementalTin tin = options.getNewInstanceOfTestTin();
            if (prealloc) {
                tin.preAllocateEdges(nVertices);
            }
            long time0 = System.nanoTime();
            tin.add(vertexList, null);
            long time1 = System.nanoTime();
            long deltaBuild = time1 - time0;
            long totalMem = Runtime.getRuntime().totalMemory();
            vertexList.clear();
            vertexList = null;
            long usedMem = this.getUsedMemory() - mem0;
            tin.dispose();
            tin = null;
            this.getUsedMemory();
            double buildTime = (double)deltaBuild / 1000000.0;
            resultList.add(new Result(buildTime, nVertices));
            ps.format("%10d,  %10.7f, %10.2f,  %10.2f, %10.2f, %12d%n", nVertices, (double)nVertices / 1000000.0, (double)deltaBuild / 1000000.0, (double)usedMem / 1024.0 / 1024.0, (double)totalMem / 1024.0 / 1024.0, usedMem);
            ps.flush();
        }
        Collections.sort(resultList);
        ps.format("%nn_vertices,    m_vertices,    time_ms,     million_per_sec%n", new Object[0]);
        for (Result r : resultList) {
            ps.format("%10d, %10.3f, %10.3f, %10.3f\n", r.nVertices, (double)r.nVertices / 1000000.0, r.timeMS, (double)r.nVertices / 1000000.0 / (r.timeMS / 1000.0));
        }
    }

    private long getUsedMemory() {
        Runtime runtime = Runtime.getRuntime();
        runtime.gc();
        try {
            Thread.sleep(2000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return runtime.totalMemory() - runtime.freeMemory();
    }

    private static class Result
    implements Comparable<Result> {
        double timeMS;
        long nVertices;

        Result(double timeMS, long nVertices) {
            this.timeMS = timeMS;
            this.nVertices = nVertices;
        }

        @Override
        public int compareTo(Result o) {
            int test = Long.compare(this.nVertices, o.nVertices);
            if (test != 0) {
                return test;
            }
            return Double.compare(this.timeMS, o.timeMS);
        }
    }

    private static class RecordFilter
    implements ILasRecordFilter {
        int classification;
        double thinningFactor;
        Random random = new Random();

        public RecordFilter(int classification, double thinningFactor) {
            this.classification = classification;
            this.thinningFactor = thinningFactor;
        }

        @Override
        public boolean accept(LasPoint record) {
            if (record.withheld) {
                return false;
            }
            if (this.classification >= 0 && record.classification != this.classification) {
                return false;
            }
            if (this.thinningFactor == 1.0) {
                return true;
            }
            double test = this.random.nextDouble();
            return test < this.thinningFactor;
        }
    }
}

