/*
 * Decompiled with CFR 0.152.
 */
package com.github.mreutegg.laszip4j;

import com.github.mreutegg.laszip4j.LASHeader;
import com.github.mreutegg.laszip4j.LASPoint;
import com.github.mreutegg.laszip4j.laslib.LASreadOpener;
import com.github.mreutegg.laszip4j.laslib.LASreader;
import com.github.mreutegg.laszip4j.laszip.LASpoint;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.UncheckedIOException;
import java.util.Iterator;
import java.util.NoSuchElementException;

public final class LASReader {
    private final File file;
    private Constraint constraint = new None();

    public LASReader(File file) {
        this.file = file;
    }

    public LASReader insideTile(float ll_x, float ll_y, float size) {
        this.constraint = reader -> reader.inside_tile(ll_x, ll_y, size);
        return this;
    }

    public LASReader insideCircle(double center_x, double center_y, double radius) {
        this.constraint = reader -> reader.inside_circle(center_x, center_y, radius);
        return this;
    }

    public LASReader insideRectangle(double min_x, double min_y, double max_x, double max_y) {
        this.constraint = reader -> reader.inside_rectangle(min_x, min_y, max_x, max_y);
        return this;
    }

    public Iterable<LASPoint> getPoints() {
        return () -> new LASPointIterator();
    }

    public LASHeader getHeader() {
        try (LASreader r = this.openReader();){
            LASHeader lASHeader = new LASHeader(r.header);
            return lASHeader;
        }
    }

    private LASreader openReader() {
        if (!this.file.exists() || !this.file.isFile()) {
            throw new UncheckedIOException(new FileNotFoundException(this.file.getAbsolutePath()));
        }
        LASreader reader = new LASreadOpener().open(this.file.getAbsolutePath());
        this.constraint.apply(reader);
        return reader;
    }

    static /* synthetic */ LASreader access$100(LASReader x0) {
        return x0.openReader();
    }

    private final class None
    implements Constraint {
        private None() {
        }

        @Override
        public boolean apply(LASreader reader) {
            return reader.inside_none();
        }
    }

    private static interface Constraint {
        public boolean apply(LASreader var1);
    }

    private class LASPointIterator
    implements Iterator<LASPoint> {
        private final LASPoint end = new LASPoint(new LASpoint());
        private final LASreader r = LASReader.access$100(LASReader.this);
        private LASPoint next = null;

        private LASPointIterator() {
        }

        @Override
        public boolean hasNext() {
            if (this.next == this.end) {
                return false;
            }
            if (this.next != null) {
                return true;
            }
            this.next = this.readNext();
            return this.next != this.end;
        }

        @Override
        public LASPoint next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            LASPoint p = this.next;
            this.next = null;
            return p;
        }

        private LASPoint readNext() {
            LASPoint p;
            LASPoint lASPoint = p = this.r.read_point() ? new LASPoint(this.r.point) : null;
            if (p == null) {
                this.r.close();
                p = this.end;
            }
            return p;
        }
    }
}

