/*
 * Decompiled with CFR 0.152.
 */
package com.github.mreutegg.laszip4j.laslib;

import com.github.mreutegg.laszip4j.clib.Cstdio;
import com.github.mreutegg.laszip4j.clib.Cstring;
import com.github.mreutegg.laszip4j.laslib.LASevlr;
import com.github.mreutegg.laszip4j.laslib.LASvlr;
import com.github.mreutegg.laszip4j.laslib.LASvlr_classification;
import com.github.mreutegg.laszip4j.laslib.LASvlr_geo_keys;
import com.github.mreutegg.laszip4j.laslib.LASvlr_key_entry;
import com.github.mreutegg.laszip4j.laslib.LASvlr_lasoriginal;
import com.github.mreutegg.laszip4j.laslib.LASvlr_lastiling;
import com.github.mreutegg.laszip4j.laslib.LASvlr_wave_packet_descr;
import com.github.mreutegg.laszip4j.laszip.LASattribute;
import com.github.mreutegg.laszip4j.laszip.LASattributer;
import com.github.mreutegg.laszip4j.laszip.LASquantizer;
import com.github.mreutegg.laszip4j.laszip.LASzip;
import com.github.mreutegg.laszip4j.laszip.MyDefs;
import java.io.PrintStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public class LASheader
extends LASattributer {
    private static final PrintStream stderr = System.err;
    public byte[] file_signature = new byte[4];
    public char file_source_ID;
    public char global_encoding;
    public int project_ID_GUID_data_1;
    public char project_ID_GUID_data_2;
    public char project_ID_GUID_data_3;
    public byte[] project_ID_GUID_data_4 = new byte[8];
    public byte version_major;
    public byte version_minor;
    public byte[] system_identifier = new byte[32];
    public byte[] generating_software = new byte[32];
    public char file_creation_day;
    public char file_creation_year;
    public char header_size;
    public int offset_to_point_data;
    public int number_of_variable_length_records;
    public byte point_data_format;
    public char point_data_record_length;
    public int number_of_point_records;
    public int[] number_of_points_by_return = new int[5];
    public double max_x;
    public double min_x;
    public double max_y;
    public double min_y;
    public double max_z;
    public double min_z;
    public long start_of_waveform_data_packet_record;
    public long start_of_first_extended_variable_length_record;
    public int number_of_extended_variable_length_records;
    public long extended_number_of_point_records;
    public long[] extended_number_of_points_by_return = new long[15];
    public int user_data_in_header_size;
    public byte[] user_data_in_header;
    public LASvlr[] vlrs;
    public LASevlr[] evlrs;
    public LASvlr_geo_keys vlr_geo_keys;
    public LASvlr_key_entry[] vlr_geo_key_entries;
    public double[] vlr_geo_double_params;
    public String vlr_geo_ascii_params;
    public String vlr_geo_wkt_ogc_math;
    public String vlr_geo_wkt_ogc_cs;
    public LASvlr_classification vlr_classification;
    public LASvlr_wave_packet_descr[] vlr_wave_packet_descr;
    public LASzip laszip;
    public LASvlr_lastiling vlr_lastiling;
    public LASvlr_lasoriginal vlr_lasoriginal;
    public int user_data_after_header_size;
    public byte[] user_data_after_header;

    LASheader() {
        this.clean_las_header();
    }

    void set_bounding_box(double min_x, double min_y, double min_z, double max_x, double max_y, double max_z) {
        this.set_bounding_box(min_x, min_y, min_z, max_x, max_y, max_z, true, true);
    }

    void set_bounding_box(double min_x, double min_y, double min_z, double max_x, double max_y, double max_z, boolean auto_scale) {
        this.set_bounding_box(min_x, min_y, min_z, max_x, max_y, max_z, auto_scale, true);
    }

    void set_bounding_box(double min_x, double min_y, double min_z, double max_x, double max_y, double max_z, boolean auto_scale, boolean auto_offset) {
        if (auto_scale) {
            if (-360.0 < min_x && -360.0 < min_y && max_x < 360.0 && max_y < 360.0) {
                this.x_scale_factor = 1.0E-7;
                this.y_scale_factor = 1.0E-7;
            } else {
                this.x_scale_factor = 0.01;
                this.y_scale_factor = 0.01;
            }
            this.z_scale_factor = 0.01;
        }
        if (auto_offset) {
            if (-360.0 < min_x && -360.0 < min_y && max_x < 360.0 && max_y < 360.0) {
                this.x_offset = 0.0;
                this.y_offset = 0.0;
                this.z_offset = 0.0;
            } else {
                this.x_offset = (int)((min_x + max_x) / 200000.0) * 100000;
                this.y_offset = (int)((min_y + max_y) / 200000.0) * 100000;
                this.z_offset = (int)((min_z + max_z) / 200000.0) * 100000;
            }
        }
        this.min_x = this.x_offset + this.x_scale_factor * (double)MyDefs.I32_QUANTIZE((min_x - this.x_offset) / this.x_scale_factor);
        this.min_y = this.y_offset + this.y_scale_factor * (double)MyDefs.I32_QUANTIZE((min_y - this.y_offset) / this.y_scale_factor);
        this.min_z = this.z_offset + this.z_scale_factor * (double)MyDefs.I32_QUANTIZE((min_z - this.z_offset) / this.z_scale_factor);
        this.max_x = this.x_offset + this.x_scale_factor * (double)MyDefs.I32_QUANTIZE((max_x - this.x_offset) / this.x_scale_factor);
        this.max_y = this.y_offset + this.y_scale_factor * (double)MyDefs.I32_QUANTIZE((max_y - this.y_offset) / this.y_scale_factor);
        this.max_z = this.z_offset + this.z_scale_factor * (double)MyDefs.I32_QUANTIZE((max_z - this.z_offset) / this.z_scale_factor);
    }

    void set_global_encoding_bit(int bit) {
        this.global_encoding = (char)(this.global_encoding | 1 << bit);
    }

    boolean get_global_encoding_bit(int bit) {
        return (this.global_encoding & 1 << bit) != 0;
    }

    void clean_las_header() {
        this.file_signature[0] = 76;
        this.file_signature[1] = 65;
        this.file_signature[2] = 83;
        this.file_signature[3] = 70;
        this.version_major = 1;
        this.version_minor = (byte)2;
        this.header_size = (char)227;
        this.offset_to_point_data = 227;
        this.point_data_record_length = (char)20;
        this.x_scale_factor = 0.01;
        this.y_scale_factor = 0.01;
        this.z_scale_factor = 0.01;
    }

    void clean_user_data_in_header() {
        if (this.user_data_in_header != null) {
            this.header_size = (char)(this.header_size - this.user_data_in_header_size);
            this.offset_to_point_data -= this.user_data_in_header_size;
            this.user_data_in_header = null;
            this.user_data_in_header_size = 0;
        }
    }

    void clean_vlrs() {
        if (this.vlrs != null) {
            for (int i = 0; i < this.number_of_variable_length_records; ++i) {
                this.offset_to_point_data -= 54 + this.vlrs[i].record_length_after_header;
            }
            this.vlrs = null;
            this.vlr_geo_keys = null;
            this.vlr_geo_key_entries = null;
            this.vlr_geo_double_params = null;
            this.vlr_geo_ascii_params = null;
            this.vlr_geo_wkt_ogc_math = null;
            this.vlr_geo_wkt_ogc_cs = null;
            this.vlr_classification = null;
            this.vlr_wave_packet_descr = null;
            this.number_of_variable_length_records = 0;
        }
    }

    void clean_evlrs() {
        if (this.evlrs != null) {
            this.evlrs = null;
            this.start_of_first_extended_variable_length_record = 0L;
            this.number_of_extended_variable_length_records = 0;
        }
    }

    void clean_laszip() {
        this.laszip = null;
    }

    void clean_lastiling() {
        this.vlr_lastiling = null;
    }

    void clean_lasoriginal() {
        this.vlr_lasoriginal = null;
    }

    void clean_user_data_after_header() {
        if (this.user_data_after_header != null) {
            this.offset_to_point_data -= this.user_data_after_header_size;
            this.user_data_after_header = null;
            this.user_data_after_header_size = 0;
        }
    }

    void clean() {
        this.clean_user_data_in_header();
        this.clean_vlrs();
        this.clean_evlrs();
        this.clean_laszip();
        this.clean_lastiling();
        this.clean_lasoriginal();
        this.clean_user_data_after_header();
        this.clean_attributes();
        this.clean_las_header();
    }

    void unlink() {
        this.user_data_in_header_size = 0;
        this.user_data_in_header = null;
        this.vlrs = null;
        this.number_of_variable_length_records = 0;
        this.evlrs = null;
        this.start_of_first_extended_variable_length_record = 0L;
        this.number_of_extended_variable_length_records = 0;
        this.laszip = null;
        this.vlr_lastiling = null;
        this.vlr_lasoriginal = null;
        this.user_data_after_header_size = 0;
        this.user_data_after_header = null;
        this.number_attributes = 0;
        this.offset_to_point_data = this.header_size;
    }

    LASheader operatorAssign(LASquantizer quantizer) {
        this.x_scale_factor = quantizer.x_scale_factor;
        this.y_scale_factor = quantizer.y_scale_factor;
        this.z_scale_factor = quantizer.z_scale_factor;
        this.x_offset = quantizer.x_offset;
        this.y_offset = quantizer.y_offset;
        this.z_offset = quantizer.z_offset;
        return this;
    }

    boolean check() {
        if (Cstring.strncmp(new String(this.file_signature), "LASF", 4) != 0) {
            Cstdio.fprintf(stderr, "ERROR: wrong file signature '%4s'\n", new String(this.file_signature));
            return Boolean.FALSE;
        }
        if (this.version_major != 1 || this.version_minor > 4) {
            Cstdio.fprintf(stderr, "WARNING: unknown version %d.%d (should be 1.0 or 1.1 or 1.2 or 1.3 or 1.4)\n", this.version_major, this.version_minor);
        }
        if (this.header_size < '\u00e3') {
            Cstdio.fprintf(stderr, "ERROR: header size is %d but should be at least 227\n", Character.valueOf(this.header_size));
            return Boolean.FALSE;
        }
        if (this.offset_to_point_data < this.header_size) {
            Cstdio.fprintf(stderr, "ERROR: offset to point data %d is smaller than header size %d\n", this.offset_to_point_data, Character.valueOf(this.header_size));
            return Boolean.FALSE;
        }
        if (this.x_scale_factor == 0.0) {
            Cstdio.fprintf(stderr, "WARNING: x scale factor is zero.\n", new Object[0]);
        }
        if (this.y_scale_factor == 0.0) {
            Cstdio.fprintf(stderr, "WARNING: y scale factor is zero.\n", new Object[0]);
        }
        if (this.z_scale_factor == 0.0) {
            Cstdio.fprintf(stderr, "WARNING: z scale factor is zero.\n", new Object[0]);
        }
        if (this.max_x < this.min_x || this.max_y < this.min_y || this.max_z < this.min_z) {
            Cstdio.fprintf(stderr, "WARNING: invalid bounding box [ %g %g %g / %g %g %g ]\n", this.min_x, this.min_y, this.min_z, this.max_x, this.max_y, this.max_z);
        }
        return Boolean.TRUE;
    }

    boolean is_compressed() {
        if (this.laszip != null && this.laszip.compressor != '\u0000') {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    boolean is_lonlat() {
        if (-360.0 <= this.min_x && -90.0 <= this.min_y && this.max_x <= 360.0 && this.max_y <= 90.0) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    void add_vlr(String user_id, char record_id, char record_length_after_header, byte[] data) {
        this.add_vlr(user_id, record_id, record_length_after_header, data, false, null, false);
    }

    void add_vlr(String user_id, char record_id, char record_length_after_header, byte[] data, boolean keep_description) {
        this.add_vlr(user_id, record_id, record_length_after_header, data, keep_description, null, false);
    }

    void add_vlr(String user_id, char record_id, char record_length_after_header, byte[] data, boolean keep_description, String description) {
        this.add_vlr(user_id, record_id, record_length_after_header, data, keep_description, description, false);
    }

    void add_vlr(String user_id, char record_id, char record_length_after_header, byte[] data, boolean keep_description, String description, boolean keep_existing) {
        int i = 0;
        boolean found_description = Boolean.FALSE;
        if (this.vlrs != null) {
            if (keep_existing) {
                i = this.number_of_variable_length_records;
            } else {
                for (i = 0; i < this.number_of_variable_length_records; ++i) {
                    if (Cstring.strcmp(this.vlrs[i].user_id, user_id) != 0 || this.vlrs[i].record_id != record_id) continue;
                    if (this.vlrs[i].record_length_after_header != '\u0000') {
                        this.offset_to_point_data -= this.vlrs[i].record_length_after_header;
                        this.vlrs[i].data = null;
                    }
                    found_description = Boolean.TRUE;
                    break;
                }
            }
            if (i == this.number_of_variable_length_records) {
                ++this.number_of_variable_length_records;
                this.offset_to_point_data += 54;
                this.vlrs = LASheader.realloc(this.vlrs, this.number_of_variable_length_records);
            }
        } else {
            this.number_of_variable_length_records = 1;
            this.offset_to_point_data += 54;
            this.vlrs = new LASvlr[this.number_of_variable_length_records];
        }
        this.vlrs[i].reserved = '\u0000';
        this.vlrs[i].user_id = MyDefs.asByteArray(user_id);
        this.vlrs[i].record_id = record_id;
        this.vlrs[i].record_length_after_header = record_length_after_header;
        if (!keep_description || !found_description) {
            if (description != null) {
                Cstdio.sprintf(this.vlrs[i].description, "%.31s", description);
            } else {
                Cstdio.sprintf(this.vlrs[i].description, "by LAStools of rapidlasso GmbH", new Object[0]);
            }
        }
        if (record_length_after_header != '\u0000') {
            this.offset_to_point_data += record_length_after_header;
            this.vlrs[i].data = data;
        } else {
            this.vlrs[i].data = null;
        }
    }

    public LASvlr get_vlr(String user_id, int record_id) {
        return this.get_vlr(user_id, (char)record_id);
    }

    LASvlr get_vlr(String user_id, char record_id) {
        for (int i = 0; i < this.number_of_variable_length_records; ++i) {
            if (Cstring.strcmp(this.vlrs[i].user_id, user_id) != 0 || this.vlrs[i].record_id != record_id) continue;
            return this.vlrs[i];
        }
        return null;
    }

    boolean remove_vlr(int i) {
        if (this.vlrs != null) {
            if (i < this.number_of_variable_length_records) {
                this.offset_to_point_data -= 54 + this.vlrs[i].record_length_after_header;
                --this.number_of_variable_length_records;
                if (this.number_of_variable_length_records != 0) {
                    this.vlrs[i] = this.vlrs[this.number_of_variable_length_records];
                    this.vlrs = LASheader.realloc(this.vlrs, this.number_of_variable_length_records);
                } else {
                    this.vlrs = null;
                }
            }
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    boolean remove_vlr(String user_id, int record_id) {
        return this.remove_vlr(user_id, (char)record_id);
    }

    boolean remove_vlr(String user_id, char record_id) {
        for (int i = 0; i < this.number_of_variable_length_records; ++i) {
            if (Cstring.strcmp(this.vlrs[i].user_id, user_id) != 0 || this.vlrs[i].record_id != record_id) continue;
            return this.remove_vlr(i);
        }
        return Boolean.FALSE;
    }

    void set_lastiling(int level, int level_index, int implicit_levels, boolean buffer, boolean reversible, float min_x, float max_x, float min_y, float max_y) {
        this.clean_lastiling();
        this.vlr_lastiling = new LASvlr_lastiling();
        this.vlr_lastiling.level = level;
        this.vlr_lastiling.level_index = level_index;
        this.vlr_lastiling.implicit_levels = implicit_levels;
        this.vlr_lastiling.buffer = buffer ? 1 : 0;
        this.vlr_lastiling.reversible = reversible ? 1 : 0;
        this.vlr_lastiling.min_x = min_x;
        this.vlr_lastiling.max_x = max_x;
        this.vlr_lastiling.min_y = min_y;
        this.vlr_lastiling.max_y = max_y;
    }

    void set_lasoriginal() {
        this.clean_lasoriginal();
        this.vlr_lasoriginal = new LASvlr_lasoriginal();
        if (this.version_minor >= 4) {
            this.vlr_lasoriginal.number_of_point_records = this.extended_number_of_point_records;
            this.vlr_lasoriginal.number_of_points_by_return[0] = this.extended_number_of_points_by_return[0];
            this.vlr_lasoriginal.number_of_points_by_return[1] = this.extended_number_of_points_by_return[1];
            this.vlr_lasoriginal.number_of_points_by_return[2] = this.extended_number_of_points_by_return[2];
            this.vlr_lasoriginal.number_of_points_by_return[3] = this.extended_number_of_points_by_return[3];
            this.vlr_lasoriginal.number_of_points_by_return[4] = this.extended_number_of_points_by_return[4];
            this.vlr_lasoriginal.number_of_points_by_return[5] = this.extended_number_of_points_by_return[5];
            this.vlr_lasoriginal.number_of_points_by_return[6] = this.extended_number_of_points_by_return[6];
            this.vlr_lasoriginal.number_of_points_by_return[7] = this.extended_number_of_points_by_return[7];
            this.vlr_lasoriginal.number_of_points_by_return[8] = this.extended_number_of_points_by_return[8];
            this.vlr_lasoriginal.number_of_points_by_return[9] = this.extended_number_of_points_by_return[9];
            this.vlr_lasoriginal.number_of_points_by_return[10] = this.extended_number_of_points_by_return[10];
            this.vlr_lasoriginal.number_of_points_by_return[11] = this.extended_number_of_points_by_return[11];
            this.vlr_lasoriginal.number_of_points_by_return[12] = this.extended_number_of_points_by_return[12];
            this.vlr_lasoriginal.number_of_points_by_return[13] = this.extended_number_of_points_by_return[13];
            this.vlr_lasoriginal.number_of_points_by_return[14] = this.extended_number_of_points_by_return[14];
        } else {
            this.vlr_lasoriginal.number_of_point_records = this.number_of_point_records;
            this.vlr_lasoriginal.number_of_points_by_return[0] = this.number_of_points_by_return[0];
            this.vlr_lasoriginal.number_of_points_by_return[1] = this.number_of_points_by_return[1];
            this.vlr_lasoriginal.number_of_points_by_return[2] = this.number_of_points_by_return[2];
            this.vlr_lasoriginal.number_of_points_by_return[3] = this.number_of_points_by_return[3];
            this.vlr_lasoriginal.number_of_points_by_return[4] = this.number_of_points_by_return[4];
        }
        this.vlr_lasoriginal.max_x = this.max_x;
        this.vlr_lasoriginal.min_x = this.min_x;
        this.vlr_lasoriginal.max_y = this.max_y;
        this.vlr_lasoriginal.min_y = this.min_y;
        this.vlr_lasoriginal.max_z = this.max_z;
        this.vlr_lasoriginal.min_z = this.min_z;
    }

    boolean restore_lasoriginal() {
        if (this.vlr_lasoriginal != null) {
            if (this.version_minor >= 4) {
                this.extended_number_of_point_records = this.vlr_lasoriginal.number_of_point_records;
                this.extended_number_of_points_by_return[0] = this.vlr_lasoriginal.number_of_points_by_return[0];
                this.extended_number_of_points_by_return[1] = this.vlr_lasoriginal.number_of_points_by_return[1];
                this.extended_number_of_points_by_return[2] = this.vlr_lasoriginal.number_of_points_by_return[2];
                this.extended_number_of_points_by_return[3] = this.vlr_lasoriginal.number_of_points_by_return[3];
                this.extended_number_of_points_by_return[4] = this.vlr_lasoriginal.number_of_points_by_return[4];
                this.extended_number_of_points_by_return[5] = this.vlr_lasoriginal.number_of_points_by_return[5];
                this.extended_number_of_points_by_return[6] = this.vlr_lasoriginal.number_of_points_by_return[6];
                this.extended_number_of_points_by_return[7] = this.vlr_lasoriginal.number_of_points_by_return[7];
                this.extended_number_of_points_by_return[8] = this.vlr_lasoriginal.number_of_points_by_return[8];
                this.extended_number_of_points_by_return[9] = this.vlr_lasoriginal.number_of_points_by_return[9];
                this.extended_number_of_points_by_return[10] = this.vlr_lasoriginal.number_of_points_by_return[10];
                this.extended_number_of_points_by_return[11] = this.vlr_lasoriginal.number_of_points_by_return[11];
                this.extended_number_of_points_by_return[12] = this.vlr_lasoriginal.number_of_points_by_return[12];
                this.extended_number_of_points_by_return[13] = this.vlr_lasoriginal.number_of_points_by_return[13];
                this.extended_number_of_points_by_return[14] = this.vlr_lasoriginal.number_of_points_by_return[14];
            } else {
                this.number_of_point_records = (int)this.vlr_lasoriginal.number_of_point_records;
                this.number_of_points_by_return[0] = (int)this.vlr_lasoriginal.number_of_points_by_return[0];
                this.number_of_points_by_return[1] = (int)this.vlr_lasoriginal.number_of_points_by_return[1];
                this.number_of_points_by_return[2] = (int)this.vlr_lasoriginal.number_of_points_by_return[2];
                this.number_of_points_by_return[3] = (int)this.vlr_lasoriginal.number_of_points_by_return[3];
                this.number_of_points_by_return[4] = (int)this.vlr_lasoriginal.number_of_points_by_return[4];
            }
            this.max_x = this.vlr_lasoriginal.max_x;
            this.min_x = this.vlr_lasoriginal.min_x;
            this.max_y = this.vlr_lasoriginal.max_y;
            this.min_y = this.vlr_lasoriginal.min_y;
            this.max_z = this.vlr_lasoriginal.max_z;
            this.min_z = this.vlr_lasoriginal.min_z;
            this.vlr_lasoriginal = null;
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public void set_geo_keys(int number_of_keys, LASvlr_key_entry[] geo_keys) {
        this.vlr_geo_keys = new LASvlr_geo_keys();
        this.vlr_geo_keys.key_directory_version = '\u0001';
        this.vlr_geo_keys.key_revision = '\u0001';
        this.vlr_geo_keys.minor_revision = '\u0000';
        this.vlr_geo_keys.number_of_keys = (char)number_of_keys;
        this.vlr_geo_key_entries = new LASvlr_key_entry[number_of_keys];
        ByteBuffer buffer = ByteBuffer.allocate((number_of_keys + 1) * 8);
        buffer.order(ByteOrder.LITTLE_ENDIAN);
        this.vlr_geo_keys.writeTo(buffer);
        for (int i = 0; i < number_of_keys; ++i) {
            this.vlr_geo_key_entries[i] = new LASvlr_key_entry(geo_keys[i]);
            this.vlr_geo_key_entries[i].writeTo(buffer);
        }
        this.add_vlr("LASF_Projection", '\u87af', (char)buffer.capacity(), buffer.array());
    }

    public void set_geo_double_params(int num_geo_double_params, double[] geo_double_params) {
        this.vlr_geo_double_params = new double[num_geo_double_params];
        System.arraycopy(geo_double_params, 0, this.vlr_geo_double_params, 0, geo_double_params.length);
        this.add_vlr("LASF_Projection", '\u87b0', (char)num_geo_double_params, LASheader.asByteArray(this.vlr_geo_double_params));
    }

    public void del_geo_double_params() {
        if (this.vlr_geo_double_params != null) {
            this.remove_vlr("LASF_Projection", 34736);
            this.vlr_geo_double_params = null;
        }
    }

    void set_geo_ascii_params(int num_geo_ascii_params, String geo_ascii_params) {
        this.vlr_geo_ascii_params = geo_ascii_params;
        this.add_vlr("LASF_Projection", '\u87b1', (char)num_geo_ascii_params, MyDefs.asByteArray(this.vlr_geo_ascii_params));
    }

    public void del_geo_ascii_params() {
        if (this.vlr_geo_ascii_params != null) {
            this.remove_vlr("LASF_Projection", 34737);
            this.vlr_geo_ascii_params = null;
        }
    }

    void set_geo_wkt_ogc_math(int num_geo_wkt_ogc_math, String geo_wkt_ogc_math) {
        this.vlr_geo_wkt_ogc_math = geo_wkt_ogc_math;
        this.add_vlr("LASF_Projection", '\u083f', (char)num_geo_wkt_ogc_math, MyDefs.asByteArray(this.vlr_geo_wkt_ogc_math));
    }

    void del_geo_wkt_ogc_math() {
        if (this.vlr_geo_wkt_ogc_math != null) {
            this.remove_vlr("LASF_Projection", 2111);
            this.vlr_geo_wkt_ogc_math = null;
        }
    }

    void set_geo_wkt_ogc_cs(int num_geo_wkt_ogc_cs, String geo_wkt_ogc_cs) {
        this.vlr_geo_wkt_ogc_cs = geo_wkt_ogc_cs;
        this.add_vlr("LASF_Projection", '\u0840', (char)num_geo_wkt_ogc_cs, MyDefs.asByteArray(this.vlr_geo_wkt_ogc_cs));
    }

    void del_geo_wkt_ogc_cs() {
        if (this.vlr_geo_wkt_ogc_cs != null) {
            this.remove_vlr("LASF_Projection", 2112);
            this.vlr_geo_wkt_ogc_cs = null;
        }
    }

    void update_extra_bytes_vlr() {
        this.update_extra_bytes_vlr(false);
    }

    void update_extra_bytes_vlr(boolean keep_description) {
        if (this.number_attributes != 0) {
            char record_length_after_header = (char)(MyDefs.sizeof(LASattribute.class) * this.number_attributes);
            byte[] data = new byte[record_length_after_header];
            ByteBuffer bb = ByteBuffer.wrap(data);
            bb.order(ByteOrder.LITTLE_ENDIAN);
            for (int i = 0; i < this.number_attributes; ++i) {
                bb.position(i * MyDefs.sizeof(LASattribute.class));
                bb.put(((LASattribute)this.attributes.get(i)).asByteArray());
            }
            this.add_vlr("LASF_Spec", '\u0004', record_length_after_header, data, keep_description);
        } else {
            this.remove_vlr("LASF_Spec", 4);
        }
    }

    private static LASvlr[] realloc(LASvlr[] vlrs, int size) {
        int numElements = Math.min(vlrs.length, size);
        LASvlr[] newVlrs = new LASvlr[size];
        System.arraycopy(vlrs, 0, newVlrs, 0, numElements);
        return newVlrs;
    }

    private static byte[] asByteArray(double[] values) {
        ByteBuffer bb = ByteBuffer.allocate(values.length * 8);
        bb.order(ByteOrder.LITTLE_ENDIAN);
        for (double d : values) {
            bb.putDouble(d);
        }
        return bb.array();
    }

    public static double[] doublesFromByteArray(byte[] data) {
        double[] values = new double[data.length / 8];
        ByteBuffer bb = ByteBuffer.wrap(data).order(ByteOrder.LITTLE_ENDIAN);
        int i = 0;
        while (bb.hasRemaining()) {
            values[i++] = bb.getDouble();
        }
        return values;
    }
}

