/*
 * Decompiled with CFR 0.152.
 */
package com.github.mreutegg.laszip4j.laslib;

import com.github.mreutegg.laszip4j.clib.Cstdio;
import com.github.mreutegg.laszip4j.clib.Cstdlib;
import com.github.mreutegg.laszip4j.clib.Cstring;
import com.github.mreutegg.laszip4j.laslib.LASfilter;
import com.github.mreutegg.laszip4j.laslib.LASheader;
import com.github.mreutegg.laszip4j.laslib.LASreader;
import com.github.mreutegg.laszip4j.laslib.LASreaderASC;
import com.github.mreutegg.laszip4j.laslib.LASreaderASCreoffset;
import com.github.mreutegg.laszip4j.laslib.LASreaderASCrescale;
import com.github.mreutegg.laszip4j.laslib.LASreaderASCrescalereoffset;
import com.github.mreutegg.laszip4j.laslib.LASreaderBIL;
import com.github.mreutegg.laszip4j.laslib.LASreaderBILreoffset;
import com.github.mreutegg.laszip4j.laslib.LASreaderBILrescale;
import com.github.mreutegg.laszip4j.laslib.LASreaderBILrescalereoffset;
import com.github.mreutegg.laszip4j.laslib.LASreaderBIN;
import com.github.mreutegg.laszip4j.laslib.LASreaderBINreoffset;
import com.github.mreutegg.laszip4j.laslib.LASreaderBINrescale;
import com.github.mreutegg.laszip4j.laslib.LASreaderBINrescalereoffset;
import com.github.mreutegg.laszip4j.laslib.LASreaderBuffered;
import com.github.mreutegg.laszip4j.laslib.LASreaderDTM;
import com.github.mreutegg.laszip4j.laslib.LASreaderDTMreoffset;
import com.github.mreutegg.laszip4j.laslib.LASreaderDTMrescale;
import com.github.mreutegg.laszip4j.laslib.LASreaderDTMrescalereoffset;
import com.github.mreutegg.laszip4j.laslib.LASreaderLAS;
import com.github.mreutegg.laszip4j.laslib.LASreaderLASreoffset;
import com.github.mreutegg.laszip4j.laslib.LASreaderLASrescale;
import com.github.mreutegg.laszip4j.laslib.LASreaderLASrescalereoffset;
import com.github.mreutegg.laszip4j.laslib.LASreaderMerged;
import com.github.mreutegg.laszip4j.laslib.LASreaderPipeOn;
import com.github.mreutegg.laszip4j.laslib.LASreaderQFIT;
import com.github.mreutegg.laszip4j.laslib.LASreaderQFITreoffset;
import com.github.mreutegg.laszip4j.laslib.LASreaderQFITrescale;
import com.github.mreutegg.laszip4j.laslib.LASreaderQFITrescalereoffset;
import com.github.mreutegg.laszip4j.laslib.LASreaderSHP;
import com.github.mreutegg.laszip4j.laslib.LASreaderSHPreoffset;
import com.github.mreutegg.laszip4j.laslib.LASreaderSHPrescale;
import com.github.mreutegg.laszip4j.laslib.LASreaderSHPrescalereoffset;
import com.github.mreutegg.laszip4j.laslib.LASreaderTXT;
import com.github.mreutegg.laszip4j.laslib.LAStransform;
import com.github.mreutegg.laszip4j.laslib.LASwaveform13reader;
import com.github.mreutegg.laszip4j.laszip.LASindex;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;

public class LASreadOpener {
    private static final PrintStream stderr = System.err;
    private int io_ibuffer_size = 262144;
    private final List<String> file_names = new ArrayList<String>();
    private String file_name = null;
    private boolean merged;
    private int file_name_current;
    private float buffer_size = 0.0f;
    private String temp_file_base;
    private final List<String> neighbor_file_names = new ArrayList<String>();
    private boolean comma_not_point;
    private double[] scale_factor = null;
    private double[] offset = null;
    private boolean auto_reoffset;
    private boolean files_are_flightlines;
    private boolean apply_file_source_ID;
    private boolean itxt;
    private boolean ipts;
    private boolean iptx;
    private float translate_intensity = 0.0f;
    private float scale_intensity = 1.0f;
    private float translate_scan_angle = 0.0f;
    private float scale_scan_angle = 1.0f;
    private int number_attributes = 0;
    private int[] attribute_data_types = new int[10];
    private String[] attribute_names = new String[10];
    private String[] attribute_descriptions = new String[10];
    private double[] attribute_scales = new double[10];
    private double[] attribute_offsets = new double[10];
    private double[] attribute_pre_scales = new double[10];
    private double[] attribute_pre_offsets = new double[10];
    private String parse_string;
    private int skip_lines;
    private boolean populate_header;
    private boolean keep_lastiling;
    private boolean pipe_on;
    private boolean use_stdin;
    private boolean unique;
    private LASindex index;
    private LASfilter filter;
    private LAStransform transform;
    private float[] inside_tile;
    private double[] inside_circle;
    private double[] inside_rectangle;

    boolean is_piped() {
        return this.file_names.isEmpty() && this.use_stdin;
    }

    boolean is_inside() {
        return this.inside_tile != null || this.inside_circle != null || this.inside_rectangle != null;
    }

    int unparse(char[] string) {
        int n = 0;
        if (this.inside_tile != null) {
            n = Cstdio.sprintf(string, "-inside_tile %g %g %g ", Float.valueOf(this.inside_tile[0]), Float.valueOf(this.inside_tile[1]), Float.valueOf(this.inside_tile[2]));
        } else if (this.inside_circle != null) {
            n = Cstdio.sprintf(string, "-inside_circle %lf %lf %lf ", this.inside_circle[0], this.inside_circle[1], this.inside_circle[2]);
        } else if (this.inside_rectangle != null) {
            n = Cstdio.sprintf(string, "-inside_rectangle %lf %lf %lf %lf ", this.inside_rectangle[0], this.inside_rectangle[1], this.inside_rectangle[2], this.inside_rectangle[3]);
        }
        if (this.apply_file_source_ID) {
            n += Cstdio.sprintf(string, n, "-apply_file_source_ID ", new Object[0]);
        }
        if (this.scale_factor != null) {
            if (this.scale_factor[2] == 0.0) {
                if (this.scale_factor[0] != 0.0 && this.scale_factor[1] != 0.0) {
                    n += Cstdio.sprintf(string, n, "-rescale_xy %g %g ", this.scale_factor[0], this.scale_factor[1]);
                }
            } else {
                n = this.scale_factor[0] == 0.0 && this.scale_factor[1] == 0.0 ? (n += Cstdio.sprintf(string, n, "-rescale_z %g ", this.scale_factor[2])) : (n += Cstdio.sprintf(string, n, "-rescale %g %g %g ", this.scale_factor[0], this.scale_factor[1], this.scale_factor[2]));
            }
        }
        if (this.offset != null) {
            n += Cstdio.sprintf(string, n, "-reoffset %g %g %g ", this.offset[0], this.offset[1], this.offset[2]);
        } else if (this.auto_reoffset) {
            n += Cstdio.sprintf(string, n, "-auto_reoffset ", new Object[0]);
        }
        if (this.populate_header) {
            n += Cstdio.sprintf(string, n, "-populate ", new Object[0]);
        }
        if (this.io_ibuffer_size != 262144) {
            n += Cstdio.sprintf(string, n, "-io_ibuffer %d ", this.io_ibuffer_size);
        }
        if (this.temp_file_base != null) {
            n += Cstdio.sprintf(string, n, "-temp_files \"%s\" ", this.temp_file_base);
        }
        return n;
    }

    boolean is_buffered() {
        return this.buffer_size > 0.0f && (this.file_names.size() > 1 || this.neighbor_file_names.size() > 0);
    }

    public boolean is_header_populated() {
        return this.populate_header || this.file_name != null && (LASreadOpener.strstr(this.file_name, ".las") || LASreadOpener.strstr(this.file_name, ".laz") || LASreadOpener.strstr(this.file_name, ".LAS") || LASreadOpener.strstr(this.file_name, ".LAZ"));
    }

    void reset() {
        this.file_name_current = 0;
        this.file_name = null;
    }

    public LASreader open() {
        return this.open(null, true);
    }

    public LASreader open(String other_file_name) {
        return this.open(other_file_name, true);
    }

    public LASreader open(String other_file_name, boolean reset_after_other) {
        if (this.filter != null) {
            this.filter.reset();
        }
        if (this.transform != null) {
            this.transform.reset();
        }
        if (!this.file_names.isEmpty() || other_file_name != null) {
            this.use_stdin = Boolean.FALSE;
            if (this.file_names.size() > 1 && this.merged) {
                LASreaderMerged lasreadermerged = new LASreaderMerged();
                lasreadermerged.set_scale_factor(this.scale_factor);
                lasreadermerged.set_offset(this.offset);
                lasreadermerged.set_parse_string(this.parse_string);
                lasreadermerged.set_skip_lines(this.skip_lines);
                lasreadermerged.set_populate_header(this.populate_header);
                lasreadermerged.set_keep_lastiling(this.keep_lastiling);
                lasreadermerged.set_translate_intensity(this.translate_intensity);
                lasreadermerged.set_scale_intensity(this.scale_intensity);
                lasreadermerged.set_translate_scan_angle(this.translate_scan_angle);
                lasreadermerged.set_scale_scan_angle(this.scale_scan_angle);
                lasreadermerged.set_io_ibuffer_size(this.io_ibuffer_size);
                this.file_name_current = 0;
                while (this.file_name_current < this.file_names.size()) {
                    lasreadermerged.add_file_name(this.file_names.get(this.file_name_current));
                    ++this.file_name_current;
                }
                if (!lasreadermerged.open()) {
                    Cstdio.fprintf(stderr, "ERROR: cannot open lasreadermerged with %d file names\n", this.file_names.size());
                    return null;
                }
                if (this.files_are_flightlines) {
                    lasreadermerged.set_files_are_flightlines(Boolean.TRUE);
                }
                if (this.apply_file_source_ID) {
                    lasreadermerged.set_apply_file_source_ID(Boolean.TRUE);
                }
                if (this.filter != null) {
                    lasreadermerged.set_filter(this.filter);
                }
                if (this.transform != null) {
                    lasreadermerged.set_transform(this.transform);
                }
                if (this.inside_tile != null) {
                    lasreadermerged.inside_tile(this.inside_tile[0], this.inside_tile[1], this.inside_tile[2]);
                }
                if (this.inside_circle != null) {
                    lasreadermerged.inside_circle(this.inside_circle[0], this.inside_circle[1], this.inside_circle[2]);
                }
                if (this.inside_rectangle != null) {
                    lasreadermerged.inside_rectangle(this.inside_rectangle[0], this.inside_rectangle[1], this.inside_rectangle[2], this.inside_rectangle[3]);
                }
                if (this.pipe_on) {
                    LASreaderPipeOn lasreaderpipeon = new LASreaderPipeOn();
                    if (!lasreaderpipeon.open(lasreadermerged)) {
                        Cstdio.fprintf(stderr, "ERROR: cannot open lasreaderpipeon with lasreadermerged\n", new Object[0]);
                        return null;
                    }
                    return lasreaderpipeon;
                }
                return lasreadermerged;
            }
            if (this.buffer_size > 0.0f && (this.file_names.size() > 1 || this.neighbor_file_names.size() > 0)) {
                int i;
                if (other_file_name != null) {
                    this.file_name = other_file_name;
                    if (reset_after_other) {
                        this.file_name_current = 0;
                    }
                } else {
                    this.file_name = this.file_names.get(this.file_name_current);
                    ++this.file_name_current;
                }
                LASreaderBuffered lasreaderbuffered = new LASreaderBuffered();
                lasreaderbuffered.set_buffer_size(this.buffer_size);
                lasreaderbuffered.set_scale_factor(this.scale_factor);
                lasreaderbuffered.set_offset(this.offset);
                lasreaderbuffered.set_parse_string(this.parse_string);
                lasreaderbuffered.set_skip_lines(this.skip_lines);
                lasreaderbuffered.set_populate_header(this.populate_header);
                lasreaderbuffered.set_translate_intensity(this.translate_intensity);
                lasreaderbuffered.set_scale_intensity(this.scale_intensity);
                lasreaderbuffered.set_translate_scan_angle(this.translate_scan_angle);
                lasreaderbuffered.set_scale_scan_angle(this.scale_scan_angle);
                lasreaderbuffered.set_file_name(this.file_name);
                for (i = 0; i < this.file_names.size(); ++i) {
                    if (this.file_name.equals(this.file_names.get(i))) continue;
                    lasreaderbuffered.add_neighbor_file_name(this.file_names.get(i));
                }
                for (i = 0; i < this.neighbor_file_names.size(); ++i) {
                    if (Cstring.strcmp(this.file_name, this.neighbor_file_names.get(i)) == 0) continue;
                    lasreaderbuffered.add_neighbor_file_name(this.neighbor_file_names.get(i));
                }
                if (this.filter != null) {
                    lasreaderbuffered.set_filter(this.filter);
                }
                if (this.transform != null) {
                    lasreaderbuffered.set_transform(this.transform);
                }
                if (!lasreaderbuffered.open()) {
                    Cstdio.fprintf(stderr, "ERROR: cannot open lasreaderbuffered with %d file names\n", this.file_names.size() + this.neighbor_file_names.size());
                    return null;
                }
                if (this.inside_tile != null) {
                    lasreaderbuffered.inside_tile(this.inside_tile[0], this.inside_tile[1], this.inside_tile[2]);
                }
                if (this.inside_circle != null) {
                    lasreaderbuffered.inside_circle(this.inside_circle[0], this.inside_circle[1], this.inside_circle[2]);
                }
                if (this.inside_rectangle != null) {
                    lasreaderbuffered.inside_rectangle(this.inside_rectangle[0], this.inside_rectangle[1], this.inside_rectangle[2], this.inside_rectangle[3]);
                }
                if (this.pipe_on) {
                    LASreaderPipeOn lasreaderpipeon = new LASreaderPipeOn();
                    if (!lasreaderpipeon.open(lasreaderbuffered)) {
                        Cstdio.fprintf(stderr, "ERROR: cannot open lasreaderpipeon with lasreaderbuffered\n", new Object[0]);
                        return null;
                    }
                    return lasreaderpipeon;
                }
                return lasreaderbuffered;
            }
            if (other_file_name != null) {
                this.file_name = other_file_name;
                if (reset_after_other) {
                    this.file_name_current = 0;
                }
            } else {
                this.file_name = this.file_names.get(this.file_name_current);
                ++this.file_name_current;
            }
            if (this.files_are_flightlines) {
                this.transform.setPointSource(this.file_name_current);
            }
            if (LASreadOpener.strstr(this.file_name, ".las") || LASreadOpener.strstr(this.file_name, ".laz") || LASreadOpener.strstr(this.file_name, ".LAS") || LASreadOpener.strstr(this.file_name, ".LAZ")) {
                LASreaderLAS lasreaderlas = this.scale_factor == null && this.offset == null ? (this.auto_reoffset ? new LASreaderLASreoffset() : new LASreaderLAS()) : (this.scale_factor != null && this.offset == null ? (this.auto_reoffset ? new LASreaderLASrescalereoffset(this.scale_factor[0], this.scale_factor[1], this.scale_factor[2]) : new LASreaderLASrescale(this.scale_factor[0], this.scale_factor[1], this.scale_factor[2])) : (this.scale_factor == null && this.offset != null ? new LASreaderLASreoffset(this.offset[0], this.offset[1], this.offset[2]) : new LASreaderLASrescalereoffset(this.scale_factor[0], this.scale_factor[1], this.scale_factor[2], this.offset[0], this.offset[1], this.offset[2])));
                if (!lasreaderlas.open(this.file_name, this.io_ibuffer_size)) {
                    Cstdio.fprintf(stderr, "ERROR: cannot open lasreaderlas with file name '%s'\n", this.file_name);
                    return null;
                }
                LASindex index = new LASindex();
                if (index.read(this.file_name)) {
                    lasreaderlas.set_index(index);
                }
                if (this.files_are_flightlines) {
                    lasreaderlas.header.file_source_ID = (char)this.file_name_current;
                } else if (this.apply_file_source_ID) {
                    this.transform.setPointSource(lasreaderlas.header.file_source_ID);
                }
                if (this.filter != null) {
                    lasreaderlas.set_filter(this.filter);
                }
                if (this.transform != null) {
                    lasreaderlas.set_transform(this.transform);
                }
                if (this.inside_tile != null) {
                    lasreaderlas.inside_tile(this.inside_tile[0], this.inside_tile[1], this.inside_tile[2]);
                }
                if (this.inside_circle != null) {
                    lasreaderlas.inside_circle(this.inside_circle[0], this.inside_circle[1], this.inside_circle[2]);
                }
                if (this.inside_rectangle != null) {
                    lasreaderlas.inside_rectangle(this.inside_rectangle[0], this.inside_rectangle[1], this.inside_rectangle[2], this.inside_rectangle[3]);
                }
                if (this.pipe_on) {
                    LASreaderPipeOn lasreaderpipeon = new LASreaderPipeOn();
                    if (!lasreaderpipeon.open(lasreaderlas)) {
                        Cstdio.fprintf(stderr, "ERROR: cannot open lasreaderpipeon with lasreaderlas\n", new Object[0]);
                        return null;
                    }
                    return lasreaderpipeon;
                }
                return lasreaderlas;
            }
            if (LASreadOpener.strstr(this.file_name, ".bin") || LASreadOpener.strstr(this.file_name, ".BIN")) {
                LASreaderBIN lasreaderbin = this.scale_factor == null && this.offset == null ? new LASreaderBIN() : (this.scale_factor != null && this.offset == null ? new LASreaderBINrescale(this.scale_factor[0], this.scale_factor[1], this.scale_factor[2]) : (this.scale_factor == null && this.offset != null ? new LASreaderBINreoffset(this.offset[0], this.offset[1], this.offset[2]) : new LASreaderBINrescalereoffset(this.scale_factor[0], this.scale_factor[1], this.scale_factor[2], this.offset[0], this.offset[1], this.offset[2])));
                if (!lasreaderbin.open(this.file_name)) {
                    Cstdio.fprintf(stderr, "ERROR: cannot open lasreaderbin with file name '%s'\n", this.file_name);
                    return null;
                }
                LASindex index = new LASindex();
                if (index.read(this.file_name)) {
                    lasreaderbin.set_index(index);
                }
                if (this.files_are_flightlines) {
                    lasreaderbin.header.file_source_ID = (char)this.file_name_current;
                }
                if (this.filter != null) {
                    lasreaderbin.set_filter(this.filter);
                }
                if (this.transform != null) {
                    lasreaderbin.set_transform(this.transform);
                }
                if (this.inside_tile != null) {
                    lasreaderbin.inside_tile(this.inside_tile[0], this.inside_tile[1], this.inside_tile[2]);
                }
                if (this.inside_circle != null) {
                    lasreaderbin.inside_circle(this.inside_circle[0], this.inside_circle[1], this.inside_circle[2]);
                }
                if (this.inside_rectangle != null) {
                    lasreaderbin.inside_rectangle(this.inside_rectangle[0], this.inside_rectangle[1], this.inside_rectangle[2], this.inside_rectangle[3]);
                }
                if (this.pipe_on) {
                    LASreaderPipeOn lasreaderpipeon = new LASreaderPipeOn();
                    if (!lasreaderpipeon.open(lasreaderbin)) {
                        Cstdio.fprintf(stderr, "ERROR: cannot open lasreaderpipeon with lasreaderbin\n", new Object[0]);
                        return null;
                    }
                    return lasreaderpipeon;
                }
                return lasreaderbin;
            }
            if (LASreadOpener.strstr(this.file_name, ".shp") || LASreadOpener.strstr(this.file_name, ".SHP")) {
                LASreaderSHP lasreadershp = this.scale_factor == null && this.offset == null ? new LASreaderSHP() : (this.scale_factor != null && this.offset == null ? new LASreaderSHPrescale(this.scale_factor[0], this.scale_factor[1], this.scale_factor[2]) : (this.scale_factor == null && this.offset != null ? new LASreaderSHPreoffset(this.offset[0], this.offset[1], this.offset[2]) : new LASreaderSHPrescalereoffset(this.scale_factor[0], this.scale_factor[1], this.scale_factor[2], this.offset[0], this.offset[1], this.offset[2])));
                if (!lasreadershp.open(this.file_name)) {
                    Cstdio.fprintf(stderr, "ERROR: cannot open lasreadershp with file name '%s'\n", this.file_name);
                    return null;
                }
                if (this.files_are_flightlines) {
                    lasreadershp.header.file_source_ID = (char)this.file_name_current;
                }
                if (this.filter != null) {
                    lasreadershp.set_filter(this.filter);
                }
                if (this.transform != null) {
                    lasreadershp.set_transform(this.transform);
                }
                if (this.inside_tile != null) {
                    lasreadershp.inside_tile(this.inside_tile[0], this.inside_tile[1], this.inside_tile[2]);
                }
                if (this.inside_circle != null) {
                    lasreadershp.inside_circle(this.inside_circle[0], this.inside_circle[1], this.inside_circle[2]);
                }
                if (this.inside_rectangle != null) {
                    lasreadershp.inside_rectangle(this.inside_rectangle[0], this.inside_rectangle[1], this.inside_rectangle[2], this.inside_rectangle[3]);
                }
                if (this.pipe_on) {
                    LASreaderPipeOn lasreaderpipeon = new LASreaderPipeOn();
                    if (!lasreaderpipeon.open(lasreadershp)) {
                        Cstdio.fprintf(stderr, "ERROR: cannot open lasreaderpipeon with lasreadershp\n", new Object[0]);
                        return null;
                    }
                    return lasreaderpipeon;
                }
                return lasreadershp;
            }
            if (LASreadOpener.strstr(this.file_name, ".qi") || LASreadOpener.strstr(this.file_name, ".QI")) {
                LASreaderQFIT lasreaderqfit = this.scale_factor == null && this.offset == null ? new LASreaderQFIT() : (this.scale_factor != null && this.offset == null ? new LASreaderQFITrescale(this.scale_factor[0], this.scale_factor[1], this.scale_factor[2]) : (this.scale_factor == null && this.offset != null ? new LASreaderQFITreoffset(this.offset[0], this.offset[1], this.offset[2]) : new LASreaderQFITrescalereoffset(this.scale_factor[0], this.scale_factor[1], this.scale_factor[2], this.offset[0], this.offset[1], this.offset[2])));
                if (!lasreaderqfit.open(this.file_name)) {
                    Cstdio.fprintf(stderr, "ERROR: cannot open lasreaderqfit with file name '%s'\n", this.file_name);
                    return null;
                }
                LASindex index = new LASindex();
                if (index.read(this.file_name)) {
                    lasreaderqfit.set_index(index);
                }
                if (this.files_are_flightlines) {
                    lasreaderqfit.header.file_source_ID = (char)this.file_name_current;
                }
                if (this.filter != null) {
                    lasreaderqfit.set_filter(this.filter);
                }
                if (this.transform != null) {
                    lasreaderqfit.set_transform(this.transform);
                }
                if (this.inside_tile != null) {
                    lasreaderqfit.inside_tile(this.inside_tile[0], this.inside_tile[1], this.inside_tile[2]);
                }
                if (this.inside_circle != null) {
                    lasreaderqfit.inside_circle(this.inside_circle[0], this.inside_circle[1], this.inside_circle[2]);
                }
                if (this.inside_rectangle != null) {
                    lasreaderqfit.inside_rectangle(this.inside_rectangle[0], this.inside_rectangle[1], this.inside_rectangle[2], this.inside_rectangle[3]);
                }
                if (this.pipe_on) {
                    LASreaderPipeOn lasreaderpipeon = new LASreaderPipeOn();
                    if (!lasreaderpipeon.open(lasreaderqfit)) {
                        Cstdio.fprintf(stderr, "ERROR: cannot open lasreaderpipeon with lasreaderqfit\n", new Object[0]);
                        return null;
                    }
                    return lasreaderpipeon;
                }
                return lasreaderqfit;
            }
            if (LASreadOpener.strstr(this.file_name, ".asc") || LASreadOpener.strstr(this.file_name, ".ASC")) {
                LASreaderASC lasreaderasc = this.scale_factor == null && this.offset == null ? new LASreaderASC() : (this.scale_factor != null && this.offset == null ? new LASreaderASCrescale(this.scale_factor[0], this.scale_factor[1], this.scale_factor[2]) : (this.scale_factor == null && this.offset != null ? new LASreaderASCreoffset(this.offset[0], this.offset[1], this.offset[2]) : new LASreaderASCrescalereoffset(this.scale_factor[0], this.scale_factor[1], this.scale_factor[2], this.offset[0], this.offset[1], this.offset[2])));
                if (!lasreaderasc.open(this.file_name, this.comma_not_point)) {
                    Cstdio.fprintf(stderr, "ERROR: cannot open lasreaderasc with file name '%s'\n", this.file_name);
                    return null;
                }
                if (this.files_are_flightlines) {
                    lasreaderasc.header.file_source_ID = (char)this.file_name_current;
                }
                if (this.filter != null) {
                    lasreaderasc.set_filter(this.filter);
                }
                if (this.transform != null) {
                    lasreaderasc.set_transform(this.transform);
                }
                if (this.inside_tile != null) {
                    lasreaderasc.inside_tile(this.inside_tile[0], this.inside_tile[1], this.inside_tile[2]);
                }
                if (this.inside_circle != null) {
                    lasreaderasc.inside_circle(this.inside_circle[0], this.inside_circle[1], this.inside_circle[2]);
                }
                if (this.inside_rectangle != null) {
                    lasreaderasc.inside_rectangle(this.inside_rectangle[0], this.inside_rectangle[1], this.inside_rectangle[2], this.inside_rectangle[3]);
                }
                if (this.pipe_on) {
                    LASreaderPipeOn lasreaderpipeon = new LASreaderPipeOn();
                    if (!lasreaderpipeon.open(lasreaderasc)) {
                        Cstdio.fprintf(stderr, "ERROR: cannot open lasreaderpipeon with lasreaderasc\n", new Object[0]);
                        return null;
                    }
                    return lasreaderpipeon;
                }
                return lasreaderasc;
            }
            if (LASreadOpener.strstr(this.file_name, ".bil") || LASreadOpener.strstr(this.file_name, ".BIL")) {
                LASreaderBIL lasreaderbil = this.scale_factor == null && this.offset == null ? new LASreaderBIL() : (this.scale_factor != null && this.offset == null ? new LASreaderBILrescale(this.scale_factor[0], this.scale_factor[1], this.scale_factor[2]) : (this.scale_factor == null && this.offset != null ? new LASreaderBILreoffset(this.offset[0], this.offset[1], this.offset[2]) : new LASreaderBILrescalereoffset(this.scale_factor[0], this.scale_factor[1], this.scale_factor[2], this.offset[0], this.offset[1], this.offset[2])));
                if (!lasreaderbil.open(this.file_name)) {
                    Cstdio.fprintf(stderr, "ERROR: cannot open lasreaderbil with file name '%s'\n", this.file_name);
                    return null;
                }
                if (this.files_are_flightlines) {
                    lasreaderbil.header.file_source_ID = (char)this.file_name_current;
                }
                if (this.filter != null) {
                    lasreaderbil.set_filter(this.filter);
                }
                if (this.transform != null) {
                    lasreaderbil.set_transform(this.transform);
                }
                if (this.inside_tile != null) {
                    lasreaderbil.inside_tile(this.inside_tile[0], this.inside_tile[1], this.inside_tile[2]);
                }
                if (this.inside_circle != null) {
                    lasreaderbil.inside_circle(this.inside_circle[0], this.inside_circle[1], this.inside_circle[2]);
                }
                if (this.inside_rectangle != null) {
                    lasreaderbil.inside_rectangle(this.inside_rectangle[0], this.inside_rectangle[1], this.inside_rectangle[2], this.inside_rectangle[3]);
                }
                if (this.pipe_on) {
                    LASreaderPipeOn lasreaderpipeon = new LASreaderPipeOn();
                    if (!lasreaderpipeon.open(lasreaderbil)) {
                        Cstdio.fprintf(stderr, "ERROR: cannot open lasreaderpipeon with lasreaderbil\n", new Object[0]);
                        return null;
                    }
                    return lasreaderpipeon;
                }
                return lasreaderbil;
            }
            if (LASreadOpener.strstr(this.file_name, ".dtm") || LASreadOpener.strstr(this.file_name, ".DTM")) {
                LASreaderDTM lasreaderdtm = this.scale_factor == null && this.offset == null ? new LASreaderDTM() : (this.scale_factor != null && this.offset == null ? new LASreaderDTMrescale(this.scale_factor[0], this.scale_factor[1], this.scale_factor[2]) : (this.scale_factor == null && this.offset != null ? new LASreaderDTMreoffset(this.offset[0], this.offset[1], this.offset[2]) : new LASreaderDTMrescalereoffset(this.scale_factor[0], this.scale_factor[1], this.scale_factor[2], this.offset[0], this.offset[1], this.offset[2])));
                if (!lasreaderdtm.open(this.file_name)) {
                    Cstdio.fprintf(stderr, "ERROR: cannot open lasreaderdtm with file name '%s'\n", this.file_name);
                    return null;
                }
                if (this.files_are_flightlines) {
                    lasreaderdtm.header.file_source_ID = (char)this.file_name_current;
                }
                if (this.filter != null) {
                    lasreaderdtm.set_filter(this.filter);
                }
                if (this.transform != null) {
                    lasreaderdtm.set_transform(this.transform);
                }
                if (this.inside_tile != null) {
                    lasreaderdtm.inside_tile(this.inside_tile[0], this.inside_tile[1], this.inside_tile[2]);
                }
                if (this.inside_circle != null) {
                    lasreaderdtm.inside_circle(this.inside_circle[0], this.inside_circle[1], this.inside_circle[2]);
                }
                if (this.inside_rectangle != null) {
                    lasreaderdtm.inside_rectangle(this.inside_rectangle[0], this.inside_rectangle[1], this.inside_rectangle[2], this.inside_rectangle[3]);
                }
                if (this.pipe_on) {
                    LASreaderPipeOn lasreaderpipeon = new LASreaderPipeOn();
                    if (!lasreaderpipeon.open(lasreaderdtm)) {
                        Cstdio.fprintf(stderr, "ERROR: cannot open lasreaderpipeon with lasreaderdtm\n", new Object[0]);
                        return null;
                    }
                    return lasreaderpipeon;
                }
                return lasreaderdtm;
            }
            LASreaderTXT lasreadertxt = new LASreaderTXT();
            if (this.ipts) {
                lasreadertxt.set_pts(Boolean.TRUE);
            } else if (this.iptx) {
                lasreadertxt.set_ptx(Boolean.TRUE);
            }
            if (this.translate_intensity != 0.0f) {
                lasreadertxt.set_translate_intensity(this.translate_intensity);
            }
            if (this.scale_intensity != 1.0f) {
                lasreadertxt.set_scale_intensity(this.scale_intensity);
            }
            if (this.translate_scan_angle != 0.0f) {
                lasreadertxt.set_translate_scan_angle(this.translate_scan_angle);
            }
            if (this.scale_scan_angle != 1.0f) {
                lasreadertxt.set_scale_scan_angle(this.scale_scan_angle);
            }
            lasreadertxt.set_scale_factor(this.scale_factor);
            lasreadertxt.set_offset(this.offset);
            if (this.number_attributes != 0) {
                for (int i = 0; i < this.number_attributes; ++i) {
                    lasreadertxt.add_attribute(this.attribute_data_types[i], this.attribute_names[i], this.attribute_descriptions[i], this.attribute_scales[i], this.attribute_offsets[i], this.attribute_pre_scales[i], this.attribute_pre_offsets[i]);
                }
            }
            if (!lasreadertxt.open(this.file_name, this.parse_string, this.skip_lines, this.populate_header)) {
                Cstdio.fprintf(stderr, "ERROR: cannot open lasreadertxt with file name '%s'\n", this.file_name);
                return null;
            }
            if (this.files_are_flightlines) {
                lasreadertxt.header.file_source_ID = (char)this.file_name_current;
            }
            if (this.filter != null) {
                lasreadertxt.set_filter(this.filter);
            }
            if (this.transform != null) {
                lasreadertxt.set_transform(this.transform);
            }
            if (this.inside_tile != null) {
                lasreadertxt.inside_tile(this.inside_tile[0], this.inside_tile[1], this.inside_tile[2]);
            }
            if (this.inside_circle != null) {
                lasreadertxt.inside_circle(this.inside_circle[0], this.inside_circle[1], this.inside_circle[2]);
            }
            if (this.inside_rectangle != null) {
                lasreadertxt.inside_rectangle(this.inside_rectangle[0], this.inside_rectangle[1], this.inside_rectangle[2], this.inside_rectangle[3]);
            }
            if (this.pipe_on) {
                LASreaderPipeOn lasreaderpipeon = new LASreaderPipeOn();
                if (!lasreaderpipeon.open(lasreadertxt)) {
                    Cstdio.fprintf(stderr, "ERROR: cannot open lasreaderpipeon with lasreadertxt\n", new Object[0]);
                    return null;
                }
                return lasreaderpipeon;
            }
            return lasreadertxt;
        }
        if (this.use_stdin) {
            this.use_stdin = Boolean.FALSE;
            this.populate_header = Boolean.TRUE;
            if (this.itxt) {
                LASreaderTXT lasreadertxt = new LASreaderTXT();
                if (this.ipts) {
                    lasreadertxt.set_pts(Boolean.TRUE);
                } else if (this.iptx) {
                    lasreadertxt.set_ptx(Boolean.TRUE);
                }
                if (this.translate_intensity != 0.0f) {
                    lasreadertxt.set_translate_intensity(this.translate_intensity);
                }
                if (this.scale_intensity != 1.0f) {
                    lasreadertxt.set_scale_intensity(this.scale_intensity);
                }
                if (this.translate_scan_angle != 0.0f) {
                    lasreadertxt.set_translate_scan_angle(this.translate_scan_angle);
                }
                if (this.scale_scan_angle != 1.0f) {
                    lasreadertxt.set_scale_scan_angle(this.scale_scan_angle);
                }
                lasreadertxt.set_scale_factor(this.scale_factor);
                lasreadertxt.set_offset(this.offset);
                if (this.number_attributes != 0) {
                    for (int i = 0; i < this.number_attributes; ++i) {
                        lasreadertxt.add_attribute(this.attribute_data_types[i], this.attribute_names[i], this.attribute_descriptions[i], this.attribute_scales[i], this.attribute_offsets[i], this.attribute_pre_scales[i], this.attribute_pre_offsets[i]);
                    }
                }
                if (!lasreadertxt.open(System.in, 0, this.parse_string, this.skip_lines, Boolean.FALSE)) {
                    Cstdio.fprintf(stderr, "ERROR: cannot open lasreadertxt with file name '%s'\n", this.file_name);
                    return null;
                }
                if (this.files_are_flightlines) {
                    lasreadertxt.header.file_source_ID = (char)this.file_name_current;
                }
                if (this.filter != null) {
                    lasreadertxt.set_filter(this.filter);
                }
                if (this.transform != null) {
                    lasreadertxt.set_transform(this.transform);
                }
                if (this.inside_tile != null) {
                    lasreadertxt.inside_tile(this.inside_tile[0], this.inside_tile[1], this.inside_tile[2]);
                }
                if (this.inside_circle != null) {
                    lasreadertxt.inside_circle(this.inside_circle[0], this.inside_circle[1], this.inside_circle[2]);
                }
                if (this.inside_rectangle != null) {
                    lasreadertxt.inside_rectangle(this.inside_rectangle[0], this.inside_rectangle[1], this.inside_rectangle[2], this.inside_rectangle[3]);
                }
                if (this.pipe_on) {
                    LASreaderPipeOn lasreaderpipeon = new LASreaderPipeOn();
                    if (!lasreaderpipeon.open(lasreadertxt)) {
                        Cstdio.fprintf(stderr, "ERROR: cannot open lasreaderpipeon with lasreadertxt\n", new Object[0]);
                        return null;
                    }
                    return lasreaderpipeon;
                }
                return lasreadertxt;
            }
            LASreaderLAS lasreaderlas = this.scale_factor == null && this.offset == null ? new LASreaderLAS() : (this.scale_factor != null && this.offset == null ? new LASreaderLASrescale(this.scale_factor[0], this.scale_factor[1], this.scale_factor[2]) : (this.scale_factor == null && this.offset != null ? new LASreaderLASreoffset(this.offset[0], this.offset[1], this.offset[2]) : new LASreaderLASrescalereoffset(this.scale_factor[0], this.scale_factor[1], this.scale_factor[2], this.offset[0], this.offset[1], this.offset[2])));
            if (!lasreaderlas.open(System.in)) {
                Cstdio.fprintf(stderr, "ERROR: cannot open lasreaderlas from stdin \n", new Object[0]);
                return null;
            }
            if (this.filter != null) {
                lasreaderlas.set_filter(this.filter);
            }
            if (this.transform != null) {
                lasreaderlas.set_transform(this.transform);
            }
            if (this.inside_tile != null) {
                lasreaderlas.inside_tile(this.inside_tile[0], this.inside_tile[1], this.inside_tile[2]);
            }
            if (this.inside_circle != null) {
                lasreaderlas.inside_circle(this.inside_circle[0], this.inside_circle[1], this.inside_circle[2]);
            }
            if (this.inside_rectangle != null) {
                lasreaderlas.inside_rectangle(this.inside_rectangle[0], this.inside_rectangle[1], this.inside_rectangle[2], this.inside_rectangle[3]);
            }
            if (this.pipe_on) {
                LASreaderPipeOn lasreaderpipeon = new LASreaderPipeOn();
                if (!lasreaderpipeon.open(lasreaderlas)) {
                    Cstdio.fprintf(stderr, "ERROR: cannot open lasreaderpipeon with lasreaderlas from stdin\n", new Object[0]);
                    return null;
                }
                return lasreaderpipeon;
            }
            return lasreaderlas;
        }
        return null;
    }

    boolean reopen(LASreader lasreader, boolean remain_buffered) {
        if (lasreader == null) {
            Cstdio.fprintf(stderr, "ERROR: pointer to LASreader is NULL\n", new Object[0]);
        }
        lasreader.close();
        if (this.filter != null) {
            this.filter.reset();
        }
        if (this.transform != null) {
            this.transform.reset();
        }
        if (this.pipe_on) {
            LASreaderPipeOn lasreaderpipeon = (LASreaderPipeOn)lasreader;
            lasreaderpipeon.p_count = 0L;
            lasreader = lasreaderpipeon.get_lasreader();
        }
        if (!this.file_names.isEmpty()) {
            if (this.file_names.size() > 1 && this.merged) {
                LASreaderMerged lasreadermerged = (LASreaderMerged)lasreader;
                if (!lasreadermerged.reopen()) {
                    Cstdio.fprintf(stderr, "ERROR: cannot reopen lasreadermerged\n", new Object[0]);
                    return Boolean.FALSE;
                }
                if (this.inside_rectangle != null || this.inside_tile != null || this.inside_circle != null) {
                    lasreadermerged.inside_none();
                    if (this.inside_rectangle != null) {
                        lasreadermerged.inside_rectangle(this.inside_rectangle[0], this.inside_rectangle[1], this.inside_rectangle[2], this.inside_rectangle[3]);
                    } else if (this.inside_tile != null) {
                        lasreadermerged.inside_tile(this.inside_tile[0], this.inside_tile[1], this.inside_tile[2]);
                    } else {
                        lasreadermerged.inside_circle(this.inside_circle[0], this.inside_circle[1], this.inside_circle[2]);
                    }
                }
                return Boolean.TRUE;
            }
            if (this.buffer_size > 0.0f && (this.file_names.size() > 1 || this.neighbor_file_names.size() > 0)) {
                LASreaderBuffered lasreaderbuffered = (LASreaderBuffered)lasreader;
                if (!lasreaderbuffered.reopen()) {
                    Cstdio.fprintf(stderr, "ERROR: cannot reopen lasreaderbuffered\n", new Object[0]);
                    return Boolean.FALSE;
                }
                if (this.inside_rectangle != null || this.inside_tile != null || this.inside_circle != null) {
                    lasreaderbuffered.inside_none();
                    if (this.inside_rectangle != null) {
                        lasreaderbuffered.inside_rectangle(this.inside_rectangle[0], this.inside_rectangle[1], this.inside_rectangle[2], this.inside_rectangle[3]);
                    } else if (this.inside_tile != null) {
                        lasreaderbuffered.inside_tile(this.inside_tile[0], this.inside_tile[1], this.inside_tile[2]);
                    } else {
                        lasreaderbuffered.inside_circle(this.inside_circle[0], this.inside_circle[1], this.inside_circle[2]);
                    }
                }
                if (!remain_buffered) {
                    lasreaderbuffered.remove_buffer();
                }
                return Boolean.TRUE;
            }
            if (this.file_name == null) {
                return Boolean.FALSE;
            }
            if (LASreadOpener.strstr(this.file_name, ".las") || LASreadOpener.strstr(this.file_name, ".laz") || LASreadOpener.strstr(this.file_name, ".LAS") || LASreadOpener.strstr(this.file_name, ".LAZ")) {
                LASreaderLAS lasreaderlas = (LASreaderLAS)lasreader;
                if (!lasreaderlas.open(this.file_name, this.io_ibuffer_size)) {
                    Cstdio.fprintf(stderr, "ERROR: cannot reopen lasreaderlas with file name '%s'\n", this.file_name);
                    return Boolean.FALSE;
                }
                if (!remain_buffered) {
                    if (lasreaderlas.header.vlr_lasoriginal != null) {
                        lasreaderlas.npoints = lasreaderlas.header.vlr_lasoriginal.number_of_point_records;
                    }
                    lasreaderlas.header.restore_lasoriginal();
                }
                if (this.inside_rectangle != null || this.inside_tile != null || this.inside_circle != null) {
                    lasreaderlas.inside_none();
                    if (this.inside_rectangle != null) {
                        lasreaderlas.inside_rectangle(this.inside_rectangle[0], this.inside_rectangle[1], this.inside_rectangle[2], this.inside_rectangle[3]);
                    } else if (this.inside_tile != null) {
                        lasreaderlas.inside_tile(this.inside_tile[0], this.inside_tile[1], this.inside_tile[2]);
                    } else {
                        lasreaderlas.inside_circle(this.inside_circle[0], this.inside_circle[1], this.inside_circle[2]);
                    }
                }
                return Boolean.TRUE;
            }
            if (LASreadOpener.strstr(this.file_name, ".bin") || LASreadOpener.strstr(this.file_name, ".BIN")) {
                LASreaderBIN lasreaderbin = (LASreaderBIN)lasreader;
                if (!lasreaderbin.open(this.file_name)) {
                    Cstdio.fprintf(stderr, "ERROR: cannot reopen lasreaderbin with file name '%s'\n", this.file_name);
                    return Boolean.FALSE;
                }
                if (this.inside_rectangle != null || this.inside_tile != null || this.inside_circle != null) {
                    lasreaderbin.inside_none();
                    if (this.inside_rectangle != null) {
                        lasreaderbin.inside_rectangle(this.inside_rectangle[0], this.inside_rectangle[1], this.inside_rectangle[2], this.inside_rectangle[3]);
                    } else if (this.inside_tile != null) {
                        lasreaderbin.inside_tile(this.inside_tile[0], this.inside_tile[1], this.inside_tile[2]);
                    } else {
                        lasreaderbin.inside_circle(this.inside_circle[0], this.inside_circle[1], this.inside_circle[2]);
                    }
                }
                return Boolean.TRUE;
            }
            if (LASreadOpener.strstr(this.file_name, ".shp") || LASreadOpener.strstr(this.file_name, ".SHP")) {
                LASreaderSHP lasreadershp = (LASreaderSHP)lasreader;
                if (!lasreadershp.reopen(this.file_name)) {
                    Cstdio.fprintf(stderr, "ERROR: cannot reopen lasreadershp with file name '%s'\n", this.file_name);
                    return Boolean.FALSE;
                }
                if (this.inside_rectangle != null || this.inside_tile != null || this.inside_circle != null) {
                    lasreadershp.inside_none();
                    if (this.inside_rectangle != null) {
                        lasreadershp.inside_rectangle(this.inside_rectangle[0], this.inside_rectangle[1], this.inside_rectangle[2], this.inside_rectangle[3]);
                    } else if (this.inside_tile != null) {
                        lasreadershp.inside_tile(this.inside_tile[0], this.inside_tile[1], this.inside_tile[2]);
                    } else {
                        lasreadershp.inside_circle(this.inside_circle[0], this.inside_circle[1], this.inside_circle[2]);
                    }
                }
                return Boolean.TRUE;
            }
            if (LASreadOpener.strstr(this.file_name, ".qi") || LASreadOpener.strstr(this.file_name, ".QI")) {
                LASreaderQFIT lasreaderqfit = (LASreaderQFIT)lasreader;
                if (!lasreaderqfit.reopen(this.file_name)) {
                    Cstdio.fprintf(stderr, "ERROR: cannot reopen lasreaderqfit with file name '%s'\n", this.file_name);
                    return Boolean.FALSE;
                }
                if (this.inside_rectangle != null || this.inside_tile != null || this.inside_circle != null) {
                    lasreaderqfit.inside_none();
                    if (this.inside_rectangle != null) {
                        lasreaderqfit.inside_rectangle(this.inside_rectangle[0], this.inside_rectangle[1], this.inside_rectangle[2], this.inside_rectangle[3]);
                    } else if (this.inside_tile != null) {
                        lasreaderqfit.inside_tile(this.inside_tile[0], this.inside_tile[1], this.inside_tile[2]);
                    } else {
                        lasreaderqfit.inside_circle(this.inside_circle[0], this.inside_circle[1], this.inside_circle[2]);
                    }
                }
                return Boolean.TRUE;
            }
            if (LASreadOpener.strstr(this.file_name, ".asc") || LASreadOpener.strstr(this.file_name, ".ASC")) {
                LASreaderASC lasreaderasc = (LASreaderASC)lasreader;
                if (!lasreaderasc.reopen(this.file_name)) {
                    Cstdio.fprintf(stderr, "ERROR: cannot reopen lasreaderasc with file name '%s'\n", this.file_name);
                    return Boolean.FALSE;
                }
                if (this.inside_rectangle != null || this.inside_tile != null || this.inside_circle != null) {
                    lasreaderasc.inside_none();
                    if (this.inside_rectangle != null) {
                        lasreaderasc.inside_rectangle(this.inside_rectangle[0], this.inside_rectangle[1], this.inside_rectangle[2], this.inside_rectangle[3]);
                    } else if (this.inside_tile != null) {
                        lasreaderasc.inside_tile(this.inside_tile[0], this.inside_tile[1], this.inside_tile[2]);
                    } else {
                        lasreaderasc.inside_circle(this.inside_circle[0], this.inside_circle[1], this.inside_circle[2]);
                    }
                }
                return Boolean.TRUE;
            }
            if (LASreadOpener.strstr(this.file_name, ".bil") || LASreadOpener.strstr(this.file_name, ".BIL")) {
                LASreaderBIL lasreaderbil = (LASreaderBIL)lasreader;
                if (!lasreaderbil.reopen(this.file_name)) {
                    Cstdio.fprintf(stderr, "ERROR: cannot reopen lasreaderbil with file name '%s'\n", this.file_name);
                    return Boolean.FALSE;
                }
                if (this.inside_rectangle != null || this.inside_tile != null || this.inside_circle != null) {
                    lasreaderbil.inside_none();
                    if (this.inside_rectangle != null) {
                        lasreaderbil.inside_rectangle(this.inside_rectangle[0], this.inside_rectangle[1], this.inside_rectangle[2], this.inside_rectangle[3]);
                    } else if (this.inside_tile != null) {
                        lasreaderbil.inside_tile(this.inside_tile[0], this.inside_tile[1], this.inside_tile[2]);
                    } else {
                        lasreaderbil.inside_circle(this.inside_circle[0], this.inside_circle[1], this.inside_circle[2]);
                    }
                }
                return Boolean.TRUE;
            }
            if (LASreadOpener.strstr(this.file_name, ".dtm") || LASreadOpener.strstr(this.file_name, ".DTM")) {
                LASreaderDTM lasreaderdtm = (LASreaderDTM)lasreader;
                if (!lasreaderdtm.reopen(this.file_name)) {
                    Cstdio.fprintf(stderr, "ERROR: cannot reopen lasreaderdtm with file name '%s'\n", this.file_name);
                    return Boolean.FALSE;
                }
                if (this.inside_rectangle != null || this.inside_tile != null || this.inside_circle != null) {
                    lasreaderdtm.inside_none();
                    if (this.inside_rectangle != null) {
                        lasreaderdtm.inside_rectangle(this.inside_rectangle[0], this.inside_rectangle[1], this.inside_rectangle[2], this.inside_rectangle[3]);
                    } else if (this.inside_tile != null) {
                        lasreaderdtm.inside_tile(this.inside_tile[0], this.inside_tile[1], this.inside_tile[2]);
                    } else {
                        lasreaderdtm.inside_circle(this.inside_circle[0], this.inside_circle[1], this.inside_circle[2]);
                    }
                }
                return Boolean.TRUE;
            }
            LASreaderTXT lasreadertxt = (LASreaderTXT)lasreader;
            if (!lasreadertxt.reopen(this.file_name)) {
                Cstdio.fprintf(stderr, "ERROR: cannot reopen lasreadertxt with file name '%s'\n", this.file_name);
                return Boolean.FALSE;
            }
            if (this.inside_rectangle != null || this.inside_tile != null || this.inside_circle != null) {
                lasreadertxt.inside_none();
                if (this.inside_rectangle != null) {
                    lasreadertxt.inside_rectangle(this.inside_rectangle[0], this.inside_rectangle[1], this.inside_rectangle[2], this.inside_rectangle[3]);
                } else if (this.inside_tile != null) {
                    lasreadertxt.inside_tile(this.inside_tile[0], this.inside_tile[1], this.inside_tile[2]);
                } else {
                    lasreadertxt.inside_circle(this.inside_circle[0], this.inside_circle[1], this.inside_circle[2]);
                }
            }
            return Boolean.TRUE;
        }
        Cstdio.fprintf(stderr, "ERROR: no lasreader input specified\n", new Object[0]);
        return Boolean.FALSE;
    }

    public LASwaveform13reader open_waveform13(LASheader lasheader) {
        if (lasheader.point_data_format < 4) {
            return null;
        }
        if (lasheader.point_data_format > 5 && lasheader.point_data_format < 9) {
            return null;
        }
        if (lasheader.vlr_wave_packet_descr == null) {
            return null;
        }
        if (this.get_file_name() == null) {
            return null;
        }
        LASwaveform13reader waveform13reader = new LASwaveform13reader();
        if ((lasheader.global_encoding & 2) != 0 && lasheader.start_of_waveform_data_packet_record > (long)lasheader.offset_to_point_data ? waveform13reader.open(this.get_file_name(), lasheader.start_of_waveform_data_packet_record, lasheader.vlr_wave_packet_descr) : waveform13reader.open(this.get_file_name(), 0L, lasheader.vlr_wave_packet_descr)) {
            return waveform13reader;
        }
        return null;
    }

    static void usage() {
        Cstdio.fprintf(stderr, "Supported LAS Inputs\n", new Object[0]);
        Cstdio.fprintf(stderr, "  -i lidar.las\n", new Object[0]);
        Cstdio.fprintf(stderr, "  -i lidar.laz\n", new Object[0]);
        Cstdio.fprintf(stderr, "  -i lidar1.las lidar2.las lidar3.las -merged\n", new Object[0]);
        Cstdio.fprintf(stderr, "  -i *.las - merged\n", new Object[0]);
        Cstdio.fprintf(stderr, "  -i flight0??.laz flight1??.laz\n", new Object[0]);
        Cstdio.fprintf(stderr, "  -i terrasolid.bin\n", new Object[0]);
        Cstdio.fprintf(stderr, "  -i esri.shp\n", new Object[0]);
        Cstdio.fprintf(stderr, "  -i nasa.qi\n", new Object[0]);
        Cstdio.fprintf(stderr, "  -i lidar.txt -iparse xyzti -iskip 2 (on-the-fly from ASCII)\n", new Object[0]);
        Cstdio.fprintf(stderr, "  -i lidar.txt -iparse xyzi -itranslate_intensity 1024\n", new Object[0]);
        Cstdio.fprintf(stderr, "  -lof file_list.txt\n", new Object[0]);
        Cstdio.fprintf(stderr, "  -stdin (pipe from stdin)\n", new Object[0]);
        Cstdio.fprintf(stderr, "  -rescale 0.01 0.01 0.001\n", new Object[0]);
        Cstdio.fprintf(stderr, "  -rescale_xy 0.01 0.01\n", new Object[0]);
        Cstdio.fprintf(stderr, "  -rescale_z 0.01\n", new Object[0]);
        Cstdio.fprintf(stderr, "  -reoffset 600000 4000000 0\n", new Object[0]);
        Cstdio.fprintf(stderr, "Fast AOI Queries for LAS/LAZ with spatial indexing LAX files\n", new Object[0]);
        Cstdio.fprintf(stderr, "  -inside min_x min_y max_x max_y\n", new Object[0]);
        Cstdio.fprintf(stderr, "  -inside_tile ll_x ll_y size\n", new Object[0]);
        Cstdio.fprintf(stderr, "  -inside_circle center_x center_y radius\n", new Object[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean parse(int argc, String[] argv) {
        for (int i = 1; i < argc; ++i) {
            double[] scale_factor;
            if (argv[i].isEmpty() || argv[i].startsWith("\u0000")) continue;
            if (Cstring.strcmp(argv[i], "-h") == 0) {
                LASfilter.usage();
                LAStransform.usage();
                LASreadOpener.usage();
                return Boolean.TRUE;
            }
            if (Cstring.strcmp(argv[i], "-i") == 0) {
                if (i + 1 >= argc) {
                    Cstdio.fprintf(stderr, "ERROR: '%s' needs at least 1 argument: file_name or wild_card\n", argv[i]);
                    return Boolean.FALSE;
                }
                argv[i] = "\u0000";
                ++i;
                do {
                    this.add_file_name(argv[i], this.unique);
                    argv[i] = "\u0000";
                } while (++i < argc && !argv[i].startsWith("-"));
                --i;
                continue;
            }
            if (Cstring.strcmp(argv[i], "-unique") == 0) {
                this.unique = Boolean.TRUE;
                argv[i] = "\u0000";
                continue;
            }
            if (Cstring.strncmp(argv[i], "-inside", 7) == 0) {
                if (Cstring.strcmp(argv[i], "-inside_tile") == 0) {
                    if (i + 3 >= argc) {
                        Cstdio.fprintf(stderr, "ERROR: '%s' needs 3 arguments: ll_x, ll_y, size\n", argv[i]);
                        return Boolean.FALSE;
                    }
                    this.set_inside_tile((float)Cstdlib.atof(argv[i + 1]), (float)Cstdlib.atof(argv[i + 2]), (float)Cstdlib.atof(argv[i + 3]));
                    argv[i] = "\u0000";
                    argv[i + 1] = "\u0000";
                    argv[i + 2] = "\u0000";
                    argv[i + 3] = "\u0000";
                    i += 3;
                    continue;
                }
                if (Cstring.strcmp(argv[i], "-inside_circle") == 0) {
                    if (i + 3 >= argc) {
                        Cstdio.fprintf(stderr, "ERROR: '%s' needs 3 arguments: center_x, center_y, radius\n", argv[i]);
                        return Boolean.FALSE;
                    }
                    this.set_inside_circle(Cstdlib.atof(argv[i + 1]), Cstdlib.atof(argv[i + 2]), Cstdlib.atof(argv[i + 3]));
                    argv[i] = "\u0000";
                    argv[i + 1] = "\u0000";
                    argv[i + 2] = "\u0000";
                    argv[i + 3] = "\u0000";
                    i += 3;
                    continue;
                }
                if (Cstring.strcmp(argv[i], "-inside") == 0 || Cstring.strcmp(argv[i], "-inside_rectangle") == 0) {
                    if (i + 4 >= argc) {
                        Cstdio.fprintf(stderr, "ERROR: '%s' needs 4 arguments: min_x, min_y, max_x, max_y\n", argv[i]);
                        return Boolean.FALSE;
                    }
                    this.set_inside_rectangle(Cstdlib.atof(argv[i + 1]), Cstdlib.atof(argv[i + 2]), Cstdlib.atof(argv[i + 3]), Cstdlib.atof(argv[i + 4]));
                    argv[i] = "\u0000";
                    argv[i + 1] = "\u0000";
                    argv[i + 2] = "\u0000";
                    argv[i + 3] = "\u0000";
                    argv[i + 4] = "\u0000";
                    i += 4;
                    continue;
                }
                Cstdio.fprintf(stderr, "ERROR: unknown '-inside' option '%s'\n", argv[i]);
                return Boolean.FALSE;
            }
            if (Cstring.strcmp(argv[i], "-comma_not_point") == 0) {
                this.comma_not_point = Boolean.TRUE;
                argv[i] = "\u0000";
                continue;
            }
            if (Cstring.strcmp(argv[i], "-stdin") == 0) {
                this.use_stdin = Boolean.TRUE;
                argv[i] = "\u0000";
                continue;
            }
            if (Cstring.strcmp(argv[i], "-lof") == 0) {
                if (i + 1 >= argc) {
                    Cstdio.fprintf(stderr, "ERROR: '%s' needs 1 argument: list_of_files\n", argv[i]);
                    return Boolean.FALSE;
                }
                if (!this.add_list_of_files(argv[i + 1], this.unique)) {
                    Cstdio.fprintf(stderr, "ERROR: cannot load list of files '%s'\n", argv[i + 1]);
                    return Boolean.FALSE;
                }
                argv[i] = "\u0000";
                argv[i + 1] = "\u0000";
                ++i;
                continue;
            }
            if (Cstring.strcmp(argv[i], "-rescale") == 0) {
                if (i + 3 >= argc) {
                    Cstdio.fprintf(stderr, "ERROR: '%s' needs 3 arguments: rescale_x rescale_y rescale_z\n", argv[i]);
                    return Boolean.FALSE;
                }
                scale_factor = new double[]{Cstdlib.atof(argv[i + 1]), Cstdlib.atof(argv[i + 2]), Cstdlib.atof(argv[i + 3])};
                this.set_scale_factor(scale_factor);
                argv[i] = "\u0000";
                argv[i + 1] = "\u0000";
                argv[i + 2] = "\u0000";
                argv[i + 3] = "\u0000";
                i += 3;
                continue;
            }
            if (Cstring.strcmp(argv[i], "-rescale_xy") == 0) {
                if (i + 2 >= argc) {
                    Cstdio.fprintf(stderr, "ERROR: '%s' needs 2 argument: rescale_x rescale_y\n", argv[i]);
                    return Boolean.FALSE;
                }
                scale_factor = new double[]{Cstdlib.atof(argv[i + 1]), Cstdlib.atof(argv[i + 2]), 0.0};
                this.set_scale_factor(scale_factor);
                argv[i] = "\u0000";
                argv[i + 1] = "\u0000";
                argv[i + 2] = "\u0000";
                i += 2;
                continue;
            }
            if (Cstring.strcmp(argv[i], "-rescale_z") == 0) {
                if (i + 1 >= argc) {
                    Cstdio.fprintf(stderr, "ERROR: '%s' needs 1 argument: scale\n", argv[i]);
                    return Boolean.FALSE;
                }
                scale_factor = new double[]{0.0, 0.0, Cstdlib.atof(argv[i + 1])};
                this.set_scale_factor(scale_factor);
                argv[i] = "\u0000";
                argv[i + 1] = "\u0000";
                ++i;
                continue;
            }
            if (Cstring.strcmp(argv[i], "-reoffset") == 0) {
                if (i + 3 >= argc) {
                    Cstdio.fprintf(stderr, "ERROR: '%s' needs 3 arguments: reoffset_x, reoffset_y, reoffset_z\n", argv[i]);
                    return Boolean.FALSE;
                }
                double[] offset = new double[]{Cstdlib.atof(argv[i + 1]), Cstdlib.atof(argv[i + 2]), Cstdlib.atof(argv[i + 3])};
                this.set_offset(offset);
                argv[i] = "\u0000";
                argv[i + 1] = "\u0000";
                argv[i + 2] = "\u0000";
                argv[i + 3] = "\u0000";
                i += 3;
                continue;
            }
            if (Cstring.strcmp(argv[i], "-auto_reoffset") == 0) {
                this.set_auto_reoffset(Boolean.TRUE);
                argv[i] = "\u0000";
                continue;
            }
            if (Cstring.strcmp(argv[i], "-files_are_flightlines") == 0 || Cstring.strcmp(argv[i], "-faf") == 0) {
                this.set_files_are_flightlines(Boolean.TRUE);
                argv[i] = "\u0000";
                continue;
            }
            if (Cstring.strcmp(argv[i], "-apply_file_source_ID") == 0) {
                this.set_apply_file_source_ID(Boolean.TRUE);
                argv[i] = "\u0000";
                continue;
            }
            if (Cstring.strcmp(argv[i], "-itranslate_intensity") == 0) {
                if (i + 1 >= argc) {
                    Cstdio.fprintf(stderr, "ERROR: '%s' needs 1 argument: offset\n", argv[i]);
                    return Boolean.FALSE;
                }
                this.set_translate_intensity((float)Cstdlib.atof(argv[i + 1]));
                argv[i] = "\u0000";
                argv[i + 1] = "\u0000";
                ++i;
                continue;
            }
            if (Cstring.strcmp(argv[i], "-iscale_intensity") == 0) {
                if (i + 1 >= argc) {
                    Cstdio.fprintf(stderr, "ERROR: '%s' needs 1 argument: scale\n", argv[i]);
                    return Boolean.FALSE;
                }
                this.set_scale_intensity((float)Cstdlib.atof(argv[i + 1]));
                argv[i] = "\u0000";
                argv[i + 1] = "\u0000";
                ++i;
                continue;
            }
            if (Cstring.strcmp(argv[i], "-itranslate_scan_angle") == 0) {
                if (i + 1 >= argc) {
                    Cstdio.fprintf(stderr, "ERROR: '%s' needs 1 argument: offset\n", argv[i]);
                    return Boolean.FALSE;
                }
                this.set_translate_scan_angle((float)Cstdlib.atof(argv[i + 1]));
                argv[i] = "\u0000";
                argv[i + 1] = "\u0000";
                ++i;
                continue;
            }
            if (Cstring.strcmp(argv[i], "-iscale_scan_angle") == 0) {
                if (i + 1 >= argc) {
                    Cstdio.fprintf(stderr, "ERROR: '%s' needs 1 argument: scale\n", argv[i]);
                    return Boolean.FALSE;
                }
                this.set_scale_scan_angle((float)Cstdlib.atof(argv[i + 1]));
                argv[i] = "\u0000";
                argv[i + 1] = "\u0000";
                ++i;
                continue;
            }
            if (Cstring.strcmp(argv[i], "-iadd_extra") == 0 || Cstring.strcmp(argv[i], "-iadd_attribute") == 0) {
                if (i + 3 >= argc) {
                    Cstdio.fprintf(stderr, "ERROR: '%s' needs 3 arguments: data_type name description\n", argv[i]);
                    return Boolean.FALSE;
                }
                if (i + 4 < argc && Cstdlib.atof(argv[i + 4]) != 0.0) {
                    if (i + 5 < argc && (Cstdlib.atof(argv[i + 5]) != 0.0 || Cstring.strcmp(argv[i + 5], "0") == 0 || Cstring.strcmp(argv[i + 5], "0.0") == 0)) {
                        if (i + 6 < argc && Cstdlib.atof(argv[i + 6]) != 0.0) {
                            if (i + 7 < argc && (Cstdlib.atof(argv[i + 7]) != 0.0 || Cstring.strcmp(argv[i + 7], "0") == 0 || Cstring.strcmp(argv[i + 7], "0.0") == 0)) {
                                this.add_attribute(Cstdlib.atoi(argv[i + 1]), argv[i + 2], argv[i + 3], Cstdlib.atof(argv[i + 4]), Cstdlib.atof(argv[i + 5]), Cstdlib.atof(argv[i + 6]), Cstdlib.atof(argv[i + 7]));
                                argv[i] = "\u0000";
                                argv[i + 1] = "\u0000";
                                argv[i + 2] = "\u0000";
                                argv[i + 3] = "\u0000";
                                argv[i + 4] = "\u0000";
                                argv[i + 5] = "\u0000";
                                argv[i + 6] = "\u0000";
                                argv[i + 7] = "\u0000";
                                i += 7;
                                continue;
                            }
                            this.add_attribute(Cstdlib.atoi(argv[i + 1]), argv[i + 2], argv[i + 3], Cstdlib.atof(argv[i + 4]), Cstdlib.atof(argv[i + 5]), Cstdlib.atof(argv[i + 6]));
                            argv[i] = "\u0000";
                            argv[i + 1] = "\u0000";
                            argv[i + 2] = "\u0000";
                            argv[i + 3] = "\u0000";
                            argv[i + 4] = "\u0000";
                            argv[i + 5] = "\u0000";
                            argv[i + 6] = "\u0000";
                            i += 6;
                            continue;
                        }
                        this.add_attribute(Cstdlib.atoi(argv[i + 1]), argv[i + 2], argv[i + 3], Cstdlib.atof(argv[i + 4]), Cstdlib.atof(argv[i + 5]));
                        argv[i] = "\u0000";
                        argv[i + 1] = "\u0000";
                        argv[i + 2] = "\u0000";
                        argv[i + 3] = "\u0000";
                        argv[i + 4] = "\u0000";
                        argv[i + 5] = "\u0000";
                        i += 5;
                        continue;
                    }
                    this.add_attribute(Cstdlib.atoi(argv[i + 1]), argv[i + 2], argv[i + 3], Cstdlib.atof(argv[i + 4]));
                    argv[i] = "\u0000";
                    argv[i + 1] = "\u0000";
                    argv[i + 2] = "\u0000";
                    argv[i + 3] = "\u0000";
                    argv[i + 4] = "\u0000";
                    i += 4;
                    continue;
                }
                this.add_attribute(Cstdlib.atoi(argv[i + 1]), argv[i + 2], argv[i + 3]);
                argv[i] = "\u0000";
                argv[i + 1] = "\u0000";
                argv[i + 2] = "\u0000";
                argv[i + 3] = "\u0000";
                i += 3;
                continue;
            }
            if (Cstring.strcmp(argv[i], "-iparse") == 0) {
                if (i + 1 >= argc) {
                    Cstdio.fprintf(stderr, "ERROR: '%s' needs 1 argument: string\n", argv[i]);
                    return Boolean.FALSE;
                }
                this.set_parse_string(argv[i + 1]);
                argv[i] = "\u0000";
                argv[i + 1] = "\u0000";
                ++i;
                continue;
            }
            if (Cstring.strcmp(argv[i], "-iskip") == 0) {
                if (i + 1 >= argc) {
                    Cstdio.fprintf(stderr, "ERROR: '%s' needs 1 argument: number_of_lines\n", argv[i]);
                    return Boolean.FALSE;
                }
                this.set_skip_lines(Cstdlib.atoi(argv[i + 1]));
                argv[i] = "\u0000";
                argv[i + 1] = "\u0000";
                ++i;
                continue;
            }
            if (Cstring.strcmp(argv[i], "-merged") == 0) {
                this.set_merged(Boolean.TRUE);
                argv[i] = "\u0000";
                continue;
            }
            if (Cstring.strcmp(argv[i], "-buffered") == 0) {
                if (i + 1 >= argc) {
                    Cstdio.fprintf(stderr, "ERROR: '%s' needs 1 argument: size\n", argv[i]);
                    return Boolean.FALSE;
                }
                this.set_buffer_size((float)Cstdlib.atof(argv[i + 1]));
                argv[i] = "\u0000";
                argv[i + 1] = "\u0000";
                ++i;
                continue;
            }
            if (Cstring.strcmp(argv[i], "-temp_files") == 0) {
                if (i + 1 >= argc) {
                    Cstdio.fprintf(stderr, "ERROR: '%s' needs 1 argument: base name\n", argv[i]);
                    return Boolean.FALSE;
                }
                this.temp_file_base = argv[++i];
                continue;
            }
            if (Cstring.strcmp(argv[i], "-neighbors") == 0) {
                if (i + 1 >= argc) {
                    Cstdio.fprintf(stderr, "ERROR: '%s' needs at least 1 argument: file_name or wild_card\n", argv[i]);
                    return Boolean.FALSE;
                }
                argv[i] = "\u0000";
                ++i;
                do {
                    this.add_neighbor_file_name(argv[i]);
                    argv[i] = "\u0000";
                } while (++i < argc && !argv[i].equals("-"));
                --i;
                continue;
            }
            if (Cstring.strcmp(argv[i], "-neighbors_lof") == 0) {
                if (i + 1 >= argc) {
                    Cstdio.fprintf(stderr, "ERROR: '%s' needs at least 1 argument: file_name\n", argv[i]);
                    return Boolean.FALSE;
                }
                InputStream file = Cstdio.fopenR(argv[i + 1], "r");
                if (file == null) {
                    Cstdio.fprintf(stderr, "ERROR: cannot open '%s'\n", argv[i + 1]);
                    return Boolean.FALSE;
                }
                try {
                    BufferedReader reader = new BufferedReader(new InputStreamReader(file));
                    try {
                        String line;
                        while ((line = reader.readLine()) != null) {
                            this.add_neighbor_file_name(line.trim());
                        }
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                finally {
                    Cstdio.fclose(file);
                }
                argv[i] = "\u0000";
                argv[i + 1] = "\u0000";
                ++i;
                continue;
            }
            if (Cstring.strcmp(argv[i], "-pipe_on") == 0) {
                this.set_pipe_on(Boolean.TRUE);
                argv[i] = "\u0000";
                continue;
            }
            if (Cstring.strcmp(argv[i], "-populate") == 0) {
                this.set_populate_header(Boolean.TRUE);
                argv[i] = "\u0000";
                continue;
            }
            if (Cstring.strcmp(argv[i], "-io_ibuffer") == 0) {
                if (i + 1 >= argc) {
                    Cstdio.fprintf(stderr, "ERROR: '%s' needs 1 argument: size\n", argv[i]);
                    return Boolean.FALSE;
                }
                this.set_io_ibuffer_size(Cstdlib.atoi(argv[i + 1]));
                argv[i] = "\u0000";
                argv[i + 1] = "\u0000";
                ++i;
                continue;
            }
            if (Cstring.strcmp(argv[i], "-do_not_populate") == 0) {
                this.set_populate_header(Boolean.FALSE);
                argv[i] = "\u0000";
                continue;
            }
            if (Cstring.strcmp(argv[i], "-ipts") == 0) {
                this.itxt = Boolean.TRUE;
                this.ipts = Boolean.TRUE;
                argv[i] = "\u0000";
                continue;
            }
            if (Cstring.strcmp(argv[i], "-iptx") == 0) {
                this.itxt = Boolean.TRUE;
                this.iptx = Boolean.TRUE;
                argv[i] = "\u0000";
                continue;
            }
            if (Cstring.strcmp(argv[i], "-itxt") != 0) continue;
            this.itxt = Boolean.TRUE;
            argv[i] = "\u0000";
        }
        if (!this.neighbor_file_names.isEmpty()) {
            if (this.file_names.size() > 1) {
                Cstdio.fprintf(stderr, "ERROR: neighbors only supported for one buffered input file, not for %d\n", this.file_names.size());
                return Boolean.FALSE;
            }
            if (this.buffer_size == 0.0f) {
                Cstdio.fprintf(stderr, "ERROR: neighbors only make sense when used with '-buffered 50' or similar\n", new Object[0]);
                return Boolean.FALSE;
            }
        }
        if (this.filter != null) {
            this.filter.clean();
        } else {
            this.filter = new LASfilter();
        }
        if (!this.filter.parse(argc, argv)) {
            return Boolean.FALSE;
        }
        if (!this.filter.active()) {
            this.filter = null;
        }
        if (this.transform != null) {
            this.transform.clean();
        } else {
            this.transform = new LAStransform();
        }
        if (!this.transform.parse(argc, argv)) {
            return Boolean.FALSE;
        }
        if (!this.transform.active()) {
            this.transform = null;
        } else if (this.transform.filtered()) {
            this.transform.setFilter(this.filter);
            this.filter = null;
        }
        if (this.files_are_flightlines || this.apply_file_source_ID) {
            if (this.transform == null) {
                this.transform = new LAStransform();
            }
            this.transform.setPointSource(0);
        }
        return Boolean.TRUE;
    }

    public int get_file_name_number() {
        return this.file_names.size();
    }

    public int get_file_name_current() {
        return this.file_name_current;
    }

    public String get_file_name() {
        if (this.file_name != null) {
            return this.file_name;
        }
        if (!this.file_names.isEmpty()) {
            return this.file_names.get(0);
        }
        return null;
    }

    String get_file_name(int number) {
        return this.file_names.get(number);
    }

    int get_file_format(int number) {
        if (LASreadOpener.strstr(this.file_names.get(number), ".las") || LASreadOpener.strstr(this.file_names.get(number), ".LAS")) {
            return 1;
        }
        if (LASreadOpener.strstr(this.file_names.get(number), ".laz") || LASreadOpener.strstr(this.file_names.get(number), ".LAZ")) {
            return 2;
        }
        if (LASreadOpener.strstr(this.file_names.get(number), ".bin") || LASreadOpener.strstr(this.file_names.get(number), ".BIN")) {
            return 3;
        }
        if (LASreadOpener.strstr(this.file_names.get(number), ".shp") || LASreadOpener.strstr(this.file_names.get(number), ".SHP")) {
            return 7;
        }
        if (LASreadOpener.strstr(this.file_names.get(number), ".qi") || LASreadOpener.strstr(this.file_names.get(number), ".QI")) {
            return 4;
        }
        if (LASreadOpener.strstr(this.file_names.get(number), ".asc") || LASreadOpener.strstr(this.file_names.get(number), ".ASC")) {
            return 8;
        }
        if (LASreadOpener.strstr(this.file_names.get(number), ".bil") || LASreadOpener.strstr(this.file_names.get(number), ".BIL")) {
            return 9;
        }
        if (LASreadOpener.strstr(this.file_names.get(number), ".dtm") || LASreadOpener.strstr(this.file_names.get(number), ".DTM")) {
            return 11;
        }
        return 6;
    }

    void set_merged(boolean merged) {
        this.merged = merged;
    }

    void set_buffer_size(float buffer_size) {
        this.buffer_size = buffer_size;
    }

    float get_buffer_size() {
        return this.buffer_size;
    }

    void set_filter(LASfilter filter) {
        this.filter = filter;
    }

    void set_transform(LAStransform transform) {
        this.transform = transform;
    }

    void set_auto_reoffset(boolean auto_reoffset) {
        this.auto_reoffset = auto_reoffset;
    }

    void set_files_are_flightlines(boolean files_are_flightlines) {
        this.files_are_flightlines = files_are_flightlines;
    }

    void set_apply_file_source_ID(boolean apply_file_source_ID) {
        this.apply_file_source_ID = apply_file_source_ID;
    }

    void set_io_ibuffer_size(int io_ibuffer_size) {
        this.io_ibuffer_size = io_ibuffer_size;
    }

    void set_file_name(String file_name, boolean unique) {
        this.add_file_name(file_name, unique);
    }

    public boolean add_file_name(String file_name) {
        return this.add_file_name(file_name, false);
    }

    public boolean add_file_name(String file_name, boolean unique) {
        if (unique && this.file_names.contains(file_name)) {
            return Boolean.FALSE;
        }
        this.file_names.add(file_name);
        return Boolean.TRUE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean add_list_of_files(String list_of_files, boolean unique) {
        InputStream file = Cstdio.fopenR(list_of_files, "r");
        if (file == null) {
            Cstdio.fprintf(stderr, "ERROR: cannot open '%s'\n", list_of_files);
            return Boolean.FALSE;
        }
        try {
            String line;
            BufferedReader reader = new BufferedReader(new InputStreamReader(file));
            while ((line = reader.readLine()) != null) {
                this.add_file_name(line.trim(), unique);
            }
        }
        catch (IOException e) {
            boolean bl = Boolean.FALSE;
            return bl;
        }
        finally {
            Cstdio.fclose(file);
        }
        return Boolean.TRUE;
    }

    void delete_file_name(int file_name_id) {
        this.file_names.remove(file_name_id);
    }

    boolean set_file_name_current(int file_name_id) {
        if (file_name_id < this.file_names.size()) {
            this.file_name_current = file_name_id;
            this.file_name = this.file_names.get(this.file_name_current);
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    boolean add_neighbor_file_name(String neighbor_file_name) {
        return this.add_neighbor_file_name(neighbor_file_name, false);
    }

    boolean add_neighbor_file_name(String neighbor_file_name, boolean unique) {
        if (unique && this.neighbor_file_names.contains(neighbor_file_name)) {
            return Boolean.FALSE;
        }
        this.neighbor_file_names.add(neighbor_file_name);
        return Boolean.TRUE;
    }

    void set_parse_string(String parse_string) {
        this.parse_string = parse_string;
    }

    String get_parse_string() {
        return this.parse_string;
    }

    void set_scale_factor(double[] scale_factor) {
        if (scale_factor != null) {
            if (this.scale_factor == null) {
                this.scale_factor = new double[3];
            }
            this.scale_factor[0] = scale_factor[0];
            this.scale_factor[1] = scale_factor[1];
            this.scale_factor[2] = scale_factor[2];
        } else if (this.scale_factor != null) {
            this.scale_factor = null;
        }
    }

    void set_offset(double[] offset) {
        if (offset != null) {
            if (this.offset == null) {
                this.offset = new double[3];
            }
            this.offset[0] = offset[0];
            this.offset[1] = offset[1];
            this.offset[2] = offset[2];
        } else if (this.offset != null) {
            this.offset = null;
        }
    }

    void set_translate_intensity(float translate_intensity) {
        this.translate_intensity = translate_intensity;
    }

    void set_scale_intensity(float scale_intensity) {
        this.scale_intensity = scale_intensity;
    }

    void set_translate_scan_angle(float translate_scan_angle) {
        this.translate_scan_angle = translate_scan_angle;
    }

    void set_scale_scan_angle(float scale_scan_angle) {
        this.scale_scan_angle = scale_scan_angle;
    }

    void add_attribute(int data_type, String name) {
        this.add_attribute(data_type, name, null, 1.0, 0.0, 1.0, 0.0);
    }

    void add_attribute(int data_type, String name, String description) {
        this.add_attribute(data_type, name, description, 1.0, 0.0, 1.0, 0.0);
    }

    void add_attribute(int data_type, String name, String description, double scale) {
        this.add_attribute(data_type, name, description, scale, 0.0, 1.0, 0.0);
    }

    void add_attribute(int data_type, String name, String description, double scale, double offset) {
        this.add_attribute(data_type, name, description, scale, offset, 1.0, 0.0);
    }

    void add_attribute(int data_type, String name, String description, double scale, double offset, double pre_scale) {
        this.add_attribute(data_type, name, description, scale, offset, pre_scale, 0.0);
    }

    void add_attribute(int data_type, String name, String description, double scale, double offset, double pre_scale, double pre_offset) {
        this.attribute_data_types[this.number_attributes] = data_type;
        this.attribute_names[this.number_attributes] = name;
        this.attribute_descriptions[this.number_attributes] = description;
        this.attribute_scales[this.number_attributes] = scale;
        this.attribute_offsets[this.number_attributes] = offset;
        this.attribute_pre_scales[this.number_attributes] = pre_scale;
        this.attribute_pre_offsets[this.number_attributes] = pre_offset;
        ++this.number_attributes;
    }

    void set_skip_lines(int skip_lines) {
        this.skip_lines = skip_lines;
    }

    void set_populate_header(boolean populate_header) {
        this.populate_header = populate_header;
    }

    void set_keep_lastiling(boolean keep_lastiling) {
        this.keep_lastiling = keep_lastiling;
    }

    void set_pipe_on(boolean pipe_on) {
        this.pipe_on = pipe_on;
    }

    void set_inside_tile(float ll_x, float ll_y, float size) {
        if (this.inside_tile == null) {
            this.inside_tile = new float[3];
        }
        this.inside_tile[0] = ll_x;
        this.inside_tile[1] = ll_y;
        this.inside_tile[2] = size;
    }

    void set_inside_circle(double center_x, double center_y, double radius) {
        if (this.inside_circle == null) {
            this.inside_circle = new double[3];
        }
        this.inside_circle[0] = center_x;
        this.inside_circle[1] = center_y;
        this.inside_circle[2] = radius;
    }

    void set_inside_rectangle(double min_x, double min_y, double max_x, double max_y) {
        if (this.inside_rectangle == null) {
            this.inside_rectangle = new double[4];
        }
        this.inside_rectangle[0] = min_x;
        this.inside_rectangle[1] = min_y;
        this.inside_rectangle[2] = max_x;
        this.inside_rectangle[3] = max_y;
    }

    public boolean active() {
        return this.file_name_current < this.file_names.size() || this.use_stdin;
    }

    public LASreadOpener() {
        this.merged = Boolean.FALSE;
        this.use_stdin = Boolean.FALSE;
        this.comma_not_point = Boolean.FALSE;
        this.auto_reoffset = Boolean.FALSE;
        this.files_are_flightlines = Boolean.FALSE;
        this.apply_file_source_ID = Boolean.FALSE;
        this.itxt = Boolean.FALSE;
        this.ipts = Boolean.FALSE;
        this.iptx = Boolean.FALSE;
        for (int i = 0; i < 10; ++i) {
            this.attribute_data_types[i] = 0;
            this.attribute_names[i] = null;
            this.attribute_descriptions[i] = null;
            this.attribute_scales[i] = 1.0;
            this.attribute_offsets[i] = 0.0;
            this.attribute_pre_scales[i] = 1.0;
            this.attribute_pre_offsets[i] = 0.0;
        }
        this.parse_string = null;
        this.skip_lines = 0;
        this.populate_header = Boolean.FALSE;
        this.keep_lastiling = Boolean.FALSE;
        this.pipe_on = Boolean.FALSE;
        this.unique = Boolean.FALSE;
        this.file_name_current = 0;
        this.inside_tile = null;
        this.inside_circle = null;
        this.inside_rectangle = null;
        this.filter = null;
        this.transform = null;
        this.temp_file_base = null;
    }

    private static boolean strstr(String s1, String s2) {
        return s1.contains(s2);
    }
}

